/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.ide.FrameStateListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.settingsSync.SettingsSyncEnabledStateListener;
import com.intellij.settingsSync.SettingsSyncMain;
import com.intellij.settingsSync.SettingsSyncMainKt;
import com.intellij.settingsSync.SettingsSynchronizer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\f\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\fH\u0003J\b\u0010\u0019\u001a\u00020\u000eH\u0003R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/settingsSync/SettingsSynchronizer;", "Lcom/intellij/ide/FrameStateListener;", "Lcom/intellij/settingsSync/SettingsSyncEnabledStateListener;", "()V", "autoSyncDelay", "", "getAutoSyncDelay", "()J", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "scheduledFuture", "Ljava/util/concurrent/ScheduledFuture;", "enabledStateChanged", "", "syncEnabled", "", "initializeSyncing", "Ljava/lang/Runnable;", "onFrameActivated", "onFrameDeactivated", "scheduleSyncing", "logMessage", "", "setupSyncingByTimer", "stopSyncingByTimer", "Companion", "intellij.settingsSync"})
public final class SettingsSynchronizer
implements FrameStateListener,
SettingsSyncEnabledStateListener {
    private final ScheduledExecutorService executorService;
    private ScheduledFuture<?> scheduledFuture;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    private final long getAutoSyncDelay() {
        return Registry.intValue((String)"settingsSync.autoSync.frequency.sec", (int)60);
    }

    public void onFrameActivated() {
        if (!SettingsSyncMainKt.isSettingsSyncEnabledByKey() || !SettingsSyncMainKt.isSettingsSyncEnabledInSettings()) {
            return;
        }
        if (!SettingsSyncMain.Companion.isAvailable()) {
            this.executorService.schedule(this.initializeSyncing(), 0L, TimeUnit.SECONDS);
            return;
        }
        if (this.getAutoSyncDelay() > 0L && this.scheduledFuture == null) {
            this.scheduledFuture = this.setupSyncingByTimer();
        }
        if (Registry.is((String)"settingsSync.autoSync.on.focus", (boolean)true)) {
            this.scheduleSyncing("Syncing settings on app focus");
        }
    }

    public void onFrameDeactivated() {
        this.stopSyncingByTimer();
    }

    private final Runnable initializeSyncing() {
        return initializeSyncing.1.INSTANCE;
    }

    @Override
    public void enabledStateChanged(boolean syncEnabled) {
        if (syncEnabled) {
            if (!SettingsSyncMain.Companion.isAvailable()) {
                this.executorService.schedule(this.initializeSyncing(), 0L, TimeUnit.SECONDS);
            } else {
                SettingsSyncMain.Companion.getInstance().enableSyncing();
                this.scheduleSyncing("Syncing settings after enabling");
            }
        } else {
            this.stopSyncingByTimer();
            SettingsSyncMain.Companion.getInstance().disableSyncing();
        }
    }

    private final void scheduleSyncing(String logMessage) {
        this.executorService.schedule(new Runnable(logMessage){
            final /* synthetic */ String $logMessage;

            public final void run() {
                SettingsSynchronizer.Companion.getLOG().info(this.$logMessage);
                SettingsSyncMain.Companion.getInstance().syncSettings$intellij_settingsSync();
            }
            {
                this.$logMessage = string;
            }
        }, 0L, TimeUnit.SECONDS);
    }

    @RequiresEdt
    private final ScheduledFuture<?> setupSyncingByTimer() {
        long delay = this.getAutoSyncDelay();
        ScheduledFuture<?> scheduledFuture = this.executorService.scheduleWithFixedDelay(setupSyncingByTimer.1.INSTANCE, delay, delay, TimeUnit.SECONDS);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"executorService.schedule\u2026 delay, TimeUnit.SECONDS)");
        return scheduledFuture;
    }

    @RequiresEdt
    private final void stopSyncingByTimer() {
        if (this.scheduledFuture != null) {
            ScheduledFuture<?> scheduledFuture = this.scheduledFuture;
            Intrinsics.checkNotNull(scheduledFuture);
            scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        }
    }

    public SettingsSynchronizer() {
        ScheduledExecutorService scheduledExecutorService = AppExecutorUtil.createBoundedScheduledExecutorService((String)"Settings Sync Update", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"AppExecutorUtil.createBo\u2026Settings Sync Update\", 1)");
        this.executorService = scheduledExecutorService;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SettingsSynchronizer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/settingsSync/SettingsSynchronizer$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.settingsSync"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

