/*
 * Decompiled with CFR 0.152.
 */
package training.dsl;

import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.impl.FocusManagerImpl;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.DocumentUtil;
import java.awt.Component;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.dsl.LearningDsl;
import training.dsl.LearningDslBase;
import training.dsl.LessonSample;
import training.dsl.LessonSamplePosition;
import training.dsl.PreviousTaskInfo;
import training.dsl.impl.LessonExecutor;
import training.learn.ActionsRecorder;

@LearningDsl
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0003B3\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0002\u0010\rJ\u000e\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020-J\u0016\u0010+\u001a\u00020\n2\u0006\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u00020-J\u0018\u0010+\u001a\u00020\n2\u0006\u00100\u001a\u0002012\b\b\u0002\u00102\u001a\u000203J\u000e\u0010+\u001a\u00020\n2\u0006\u00104\u001a\u000205J\u0010\u00106\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0017\u00107\u001a\u0004\u0018\u00010-2\u0006\u00100\u001a\u000201H\u0002\u00a2\u0006\u0002\u00108J\u0014\u00109\u001a\u00020\n2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0006\u0010;\u001a\u00020\nJ&\u00102\u001a\u00020\n2\u0006\u0010<\u001a\u00020-2\u0006\u0010=\u001a\u00020-2\u0006\u0010>\u001a\u00020-2\u0006\u0010?\u001a\u00020-J\u0010\u0010@\u001a\u00020\n2\u0006\u00104\u001a\u000205H\u0002J\u0010\u0010A\u001a\u00020\n2\u0006\u0010B\u001a\u000201H\u0002J\u000e\u0010C\u001a\u00020\n2\u0006\u0010D\u001a\u00020EJ \u0010F\u001a\u00020\n2\n\b\u0002\u0010G\u001a\u0004\u0018\u00010H2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0010\u0010I\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001bR\u0011\u0010'\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u0006J"}, d2={"Ltraining/dsl/TaskRuntimeContext;", "Ltraining/dsl/LearningDslBase;", "base", "(Ltraining/dsl/TaskRuntimeContext;)V", "lessonExecutor", "Ltraining/dsl/impl/LessonExecutor;", "actionsRecorder", "Ltraining/learn/ActionsRecorder;", "restorePreviousTaskCallback", "Lkotlin/Function0;", "", "previousGetter", "Ltraining/dsl/PreviousTaskInfo;", "(Ltraining/dsl/impl/LessonExecutor;Ltraining/learn/ActionsRecorder;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "getActionsRecorder$intellij_featuresTrainer", "()Ltraining/learn/ActionsRecorder;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "focusOwner", "Ljava/awt/Component;", "getFocusOwner", "()Ljava/awt/Component;", "lessonDisposable", "Lcom/intellij/openapi/Disposable;", "getLessonDisposable", "()Lcom/intellij/openapi/Disposable;", "previous", "getPrevious", "()Ltraining/dsl/PreviousTaskInfo;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRestorePreviousTaskCallback", "()Lkotlin/jvm/functions/Function0;", "taskDisposable", "getTaskDisposable", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "caret", "offset", "", "line", "column", "text", "", "select", "", "position", "Ltraining/dsl/LessonSamplePosition;", "doUndoableAction", "getStartOffsetForText", "(Ljava/lang/String;)Ljava/lang/Integer;", "invokeInBackground", "runnable", "requestEditorFocus", "startLine", "startColumn", "endLine", "endColumn", "setCaret", "setDocumentCode", "code", "setSample", "sample", "Ltraining/dsl/LessonSample;", "taskInvokeLater", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "updateGutter", "intellij.featuresTrainer"})
public class TaskRuntimeContext
implements LearningDslBase {
    @NotNull
    private final Disposable taskDisposable;
    private final LessonExecutor lessonExecutor;
    @NotNull
    private final ActionsRecorder actionsRecorder;
    @NotNull
    private final Function0<Unit> restorePreviousTaskCallback;
    private final Function0<PreviousTaskInfo> previousGetter;

    @NotNull
    public final Disposable getTaskDisposable() {
        return this.taskDisposable;
    }

    @NotNull
    public final Editor getEditor() {
        return this.lessonExecutor.getEditor();
    }

    @NotNull
    public final Project getProject() {
        return this.lessonExecutor.getProject();
    }

    @NotNull
    public final Disposable getLessonDisposable() {
        return this.lessonExecutor;
    }

    @Nullable
    public final Component getFocusOwner() {
        IdeFocusManager ideFocusManager = IdeFocusManager.getInstance((Project)this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)ideFocusManager, (String)"IdeFocusManager.getInstance(project)");
        return ideFocusManager.getFocusOwner();
    }

    @NotNull
    public final PreviousTaskInfo getPrevious() {
        return (PreviousTaskInfo)this.previousGetter.invoke();
    }

    @NotNull
    public final VirtualFile getVirtualFile() {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(this.getEditor().getDocument());
        if (virtualFile == null) {
            String string = "No virtual file for " + this.getEditor().getDocument();
            throw new IllegalStateException(string.toString());
        }
        return virtualFile;
    }

    public final void taskInvokeLater(@Nullable ModalityState modalityState, @NotNull Function0<Unit> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        LessonExecutor this_$iv = this.lessonExecutor;
        boolean $i$f$taskInvokeLater = false;
        boolean $i$f$invokeLater = false;
        Application application = ApplicationManager.getApplication();
        Runnable runnable2 = new Runnable(this_$iv, runnable){
            final /* synthetic */ LessonExecutor this$0;
            final /* synthetic */ Function0 $runnable$inlined;
            {
                this.this$0 = lessonExecutor;
                this.$runnable$inlined = function0;
            }

            public final void run() {
                boolean bl = false;
                try {
                    this.$runnable$inlined.invoke();
                }
                catch (Throwable e) {
                    LessonExecutor $this$thisLogger$iv = this.this$0;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(LessonExecutor.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                    logger.error(this.this$0.getLessonInfoString(), e);
                }
            }
        };
        ModalityState modalityState2 = modalityState;
        if (modalityState2 == null) {
            ModalityState modalityState3 = ModalityState.defaultModalityState();
            modalityState2 = modalityState3;
            Intrinsics.checkNotNullExpressionValue((Object)modalityState3, (String)"ModalityState.defaultModalityState()");
        }
        application.invokeLater(runnable2, modalityState2);
    }

    public static /* synthetic */ void taskInvokeLater$default(TaskRuntimeContext taskRuntimeContext, ModalityState modalityState, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: taskInvokeLater");
        }
        if ((n & 1) != 0) {
            modalityState = null;
        }
        taskRuntimeContext.taskInvokeLater(modalityState, (Function0<Unit>)function0);
    }

    public final void invokeInBackground(@NotNull Function0<Unit> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        LessonExecutor this_$iv = this.lessonExecutor;
        boolean $i$f$invokeInBackground = false;
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this_$iv, runnable){
            final /* synthetic */ LessonExecutor this$0;
            final /* synthetic */ Function0 $runnable;

            public final void run() {
                try {
                    this.$runnable.invoke();
                }
                catch (Throwable e) {
                    LessonExecutor $this$thisLogger$iv = this.this$0;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(LessonExecutor.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                    logger.error(this.this$0.getLessonInfoString(), e);
                }
            }
            {
                this.this$0 = lessonExecutor;
                this.$runnable = function0;
            }
        });
    }

    public final void setSample(@NotNull LessonSample sample) {
        Intrinsics.checkNotNullParameter((Object)sample, (String)"sample");
        this.taskInvokeLater(ModalityState.NON_MODAL, (Function0<Unit>)((Function0)new Function0<Unit>(this, sample){
            final /* synthetic */ TaskRuntimeContext this$0;
            final /* synthetic */ LessonSample $sample;

            public final void invoke() {
                Editor editor;
                TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)this.this$0.getEditor());
                if (templateState != null) {
                    templateState.gotoEnd();
                }
                if (!((editor = this.this$0.getEditor()) instanceof EditorEx)) {
                    editor = null;
                }
                EditorEx editorEx = (EditorEx)editor;
                if (editorEx != null) {
                    editorEx.setViewer(false);
                }
                this.this$0.getEditor().getCaretModel().removeSecondaryCarets();
                TaskRuntimeContext.access$setDocumentCode(this.this$0, this.$sample.getText());
                TaskRuntimeContext.access$setCaret(this.this$0, this.$sample.getPosition(0));
            }
            {
                this.this$0 = taskRuntimeContext;
                this.$sample = lessonSample;
                super(0);
            }
        }));
    }

    public final void select(int startLine, int startColumn, int endLine, int endColumn) {
        LogicalPosition blockStart = new LogicalPosition(startLine - 1, startColumn - 1);
        LogicalPosition blockEnd = new LogicalPosition(endLine - 1, endColumn - 1);
        int startPosition = this.getEditor().logicalPositionToOffset(blockStart);
        int endPosition = this.getEditor().logicalPositionToOffset(blockEnd);
        this.getEditor().getCaretModel().moveToOffset(startPosition);
        this.getEditor().getSelectionModel().setSelection(startPosition, endPosition);
        this.requestEditorFocus();
    }

    public final void caret(@NotNull String text2, boolean select2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Integer n = this.getStartOffsetForText(text2);
        if (n == null) {
            return;
        }
        int start = n;
        this.getEditor().getCaretModel().moveToOffset(start);
        if (select2) {
            this.getEditor().getSelectionModel().setSelection(start, start + text2.length());
        }
        this.requestEditorFocus();
    }

    public static /* synthetic */ void caret$default(TaskRuntimeContext taskRuntimeContext, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: caret");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        taskRuntimeContext.caret(string, bl);
    }

    public final void caret(int line, int column) {
        new OpenFileDescriptor(this.getProject(), this.getVirtualFile(), line - 1, column - 1).navigateIn(this.getEditor());
        this.requestEditorFocus();
    }

    public final void caret(int offset) {
        new OpenFileDescriptor(this.getProject(), this.getVirtualFile(), offset).navigateIn(this.getEditor());
        this.requestEditorFocus();
    }

    public final void caret(@NotNull LessonSamplePosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.setCaret(position);
    }

    public final void requestEditorFocus() {
        FocusManagerImpl.getInstance((Project)this.getProject()).requestFocus((Component)this.getEditor().getContentComponent(), false);
    }

    private final void setDocumentCode(String code) {
        Document document = this.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        DocumentUtil.writeInRunUndoTransparentAction((Runnable)new Runnable(this, document2, code){
            final /* synthetic */ TaskRuntimeContext this$0;
            final /* synthetic */ Document $document;
            final /* synthetic */ String $code;

            public final void run() {
                DocumentReference documentReference = DocumentReferenceManager.getInstance().create(this.$document);
                Intrinsics.checkNotNullExpressionValue((Object)documentReference, (String)"DocumentReferenceManager\u2026stance().create(document)");
                DocumentReference documentReference2 = documentReference;
                UndoManager.getInstance((Project)this.this$0.getProject()).nonundoableActionPerformed(documentReference2, false);
                this.$document.replaceString(0, this.$document.getTextLength(), (CharSequence)this.$code);
            }
            {
                this.this$0 = taskRuntimeContext;
                this.$document = document;
                this.$code = string;
            }
        });
        PsiDocumentManager.getInstance((Project)this.getProject()).commitDocument(document2);
        this.doUndoableAction(this.getProject());
        this.updateGutter(this.getEditor());
    }

    private final void doUndoableAction(Project project) {
        CommandProcessor.getInstance().executeCommand(project, new Runnable(project){
            final /* synthetic */ Project $project;

            public final void run() {
                UndoManager.getInstance((Project)this.$project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(){

                    public void undo() {
                    }

                    public void redo() {
                    }
                });
            }
            {
                this.$project = project;
            }
        }, null, null);
    }

    private final void updateGutter(Editor editor) {
        EditorGutter editorGutter = editor.getGutter();
        if (editorGutter == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorGutterComponentEx");
        }
        EditorGutterComponentEx editorGutterComponentEx = (EditorGutterComponentEx)editorGutter;
        editorGutterComponentEx.revalidateMarkup();
    }

    private final void setCaret(LessonSamplePosition position) {
        Pair<Integer, Integer> pair = position.getSelection();
        if (pair != null) {
            Pair<Integer, Integer> pair2;
            Pair<Integer, Integer> it = pair2 = pair;
            boolean bl = false;
            this.getEditor().getSelectionModel().setSelection(((Number)it.getFirst()).intValue(), ((Number)it.getSecond()).intValue());
        }
        this.getEditor().getCaretModel().moveToOffset(position.getStartOffset());
        this.requestEditorFocus();
    }

    private final Integer getStartOffsetForText(String text2) {
        Document document = this.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        CharSequence charSequence = document2.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"document.charsSequence");
        int indexOf = StringsKt.indexOf$default((CharSequence)charSequence, (String)text2, (int)0, (boolean)false, (int)6, null);
        if (indexOf != -1) {
            return indexOf;
        }
        return null;
    }

    @NotNull
    public final ActionsRecorder getActionsRecorder$intellij_featuresTrainer() {
        return this.actionsRecorder;
    }

    @NotNull
    public final Function0<Unit> getRestorePreviousTaskCallback() {
        return this.restorePreviousTaskCallback;
    }

    public TaskRuntimeContext(@NotNull LessonExecutor lessonExecutor, @NotNull ActionsRecorder actionsRecorder, @NotNull Function0<Unit> restorePreviousTaskCallback, @NotNull Function0<? extends PreviousTaskInfo> previousGetter) {
        Intrinsics.checkNotNullParameter((Object)lessonExecutor, (String)"lessonExecutor");
        Intrinsics.checkNotNullParameter((Object)actionsRecorder, (String)"actionsRecorder");
        Intrinsics.checkNotNullParameter(restorePreviousTaskCallback, (String)"restorePreviousTaskCallback");
        Intrinsics.checkNotNullParameter(previousGetter, (String)"previousGetter");
        this.lessonExecutor = lessonExecutor;
        this.actionsRecorder = actionsRecorder;
        this.restorePreviousTaskCallback = restorePreviousTaskCallback;
        this.previousGetter = previousGetter;
        this.taskDisposable = this.actionsRecorder;
    }

    public TaskRuntimeContext(@NotNull TaskRuntimeContext base) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        this(base.lessonExecutor, base.actionsRecorder, base.restorePreviousTaskCallback, base.previousGetter);
    }

    @Override
    @NotNull
    public String action(@NotNull String actionId) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        return LearningDslBase.DefaultImpls.action(this, actionId);
    }

    @Override
    @NotNull
    public String code(@NotNull String sourceSample) {
        Intrinsics.checkNotNullParameter((Object)sourceSample, (String)"sourceSample");
        return LearningDslBase.DefaultImpls.code(this, sourceSample);
    }

    @Override
    @NotNull
    public String strong(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return LearningDslBase.DefaultImpls.strong(this, text2);
    }

    @Override
    @NotNull
    public String icon(@NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        return LearningDslBase.DefaultImpls.icon(this, icon);
    }

    @Override
    @NotNull
    public String shortcut(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return LearningDslBase.DefaultImpls.shortcut(this, key);
    }

    public static final /* synthetic */ void access$setDocumentCode(TaskRuntimeContext $this, String code) {
        $this.setDocumentCode(code);
    }

    public static final /* synthetic */ void access$setCaret(TaskRuntimeContext $this, LessonSamplePosition position) {
        $this.setCaret(position);
    }
}

