/*
 * Decompiled with CFR 0.152.
 */
package training.featuresSuggester;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.featuresSuggester.FeatureSuggestersManager;
import training.featuresSuggester.TextFragment;
import training.featuresSuggester.actions.Action;
import training.featuresSuggester.settings.FeatureSuggesterSettings;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\f\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u0017J\f\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\u001aR$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Ltraining/featuresSuggester/SuggestingUtils;", "", "()V", "value", "", "forceShowSuggestions", "getForceShowSuggestions", "()Z", "setForceShowSuggestions", "(Z)V", "findBreakpointOnPosition", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "project", "Lcom/intellij/openapi/project/Project;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "handleAction", "", "action", "Ltraining/featuresSuggester/actions/Action;", "isActionsProcessingEnabled", "asString", "", "Ljava/awt/datatransfer/Transferable;", "getSelection", "Ltraining/featuresSuggester/TextFragment;", "Lcom/intellij/openapi/editor/Editor;", "intellij.featuresTrainer"})
public final class SuggestingUtils {
    @NotNull
    public static final SuggestingUtils INSTANCE;

    public final boolean getForceShowSuggestions() {
        return Registry.is((String)"feature.suggester.force.show.suggestions", (boolean)false);
    }

    public final void setForceShowSuggestions(boolean value) {
        Registry.get((String)"feature.suggester.force.show.suggestions").setValue(value);
    }

    public final boolean isActionsProcessingEnabled(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return !project.isDisposed() && !DumbService.isDumb((Project)project) && FeatureSuggesterSettings.Companion.instance().isAnySuggesterEnabled();
    }

    public final void handleAction(@NotNull Project project, @NotNull Action action2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            if (!this.isActionsProcessingEnabled(project)) break block1;
            FeatureSuggestersManager featureSuggestersManager = (FeatureSuggestersManager)project.getService(FeatureSuggestersManager.class);
            if (featureSuggestersManager != null) {
                featureSuggestersManager.actionPerformed(action2);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final XBreakpoint<?> findBreakpointOnPosition(@NotNull Project project, @NotNull XSourcePosition position) {
        XBreakpoint xBreakpoint;
        boolean bl;
        XBreakpoint[] xBreakpointArray;
        XBreakpoint[] xBreakpointArray2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        XDebuggerManager xDebuggerManager = XDebuggerManager.getInstance((Project)project);
        XDebuggerManager xDebuggerManager2 = xDebuggerManager;
        if (xDebuggerManager == null) return null;
        XBreakpointManager xBreakpointManager = xDebuggerManager2.getBreakpointManager();
        xDebuggerManager2 = xBreakpointManager;
        if (xBreakpointManager == null) return null;
        Intrinsics.checkNotNullExpressionValue((Object)xDebuggerManager2, (String)"XDebuggerManager.getInst\u2026intManager ?: return null");
        XDebuggerManager breakpointManager = xDebuggerManager2;
        XBreakpoint[] xBreakpointArray3 = breakpointManager.getAllBreakpoints();
        Intrinsics.checkNotNullExpressionValue((Object)xBreakpointArray3, (String)"breakpointManager.allBreakpoints");
        XBreakpoint[] xBreakpointArray4 = xBreakpointArray2 = (xBreakpointArray = xBreakpointArray3);
        int n = 0;
        int n2 = xBreakpointArray4.length;
        do {
            if (n >= n2) return null;
            xBreakpoint = xBreakpointArray4[n];
            ++n;
            XBreakpoint b = xBreakpoint;
            boolean bl2 = false;
            if (b instanceof XLineBreakpoint) {
                String string = ((XLineBreakpoint)b).getFileUrl();
                VirtualFile virtualFile = position.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"position.file");
                if (Intrinsics.areEqual((Object)string, (Object)virtualFile.getUrl()) && ((XLineBreakpoint)b).getLine() == position.getLine()) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        XBreakpoint xBreakpoint2 = xBreakpoint;
        return xBreakpoint2;
    }

    @Nullable
    public final String asString(@NotNull Transferable $this$asString) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$asString, (String)"$this$asString");
        try {
            Object object = $this$asString.getTransferData(DataFlavor.stringFlavor);
            if (!(object instanceof String)) {
                object = null;
            }
            string = (String)object;
        }
        catch (IOException ex) {
            string = null;
        }
        catch (UnsupportedFlavorException ex) {
            string = null;
        }
        return string;
    }

    @Nullable
    public final TextFragment getSelection(@NotNull Editor $this$getSelection) {
        TextFragment textFragment;
        SelectionModel selectionModel;
        Intrinsics.checkNotNullParameter((Object)$this$getSelection, (String)"$this$getSelection");
        SelectionModel $this$with = selectionModel = $this$getSelection.getSelectionModel();
        boolean bl = false;
        if ($this$with.getSelectedText() != null) {
            int n = $this$with.getSelectionStart();
            int n2 = $this$with.getSelectionEnd();
            String string = $this$with.getSelectedText();
            Intrinsics.checkNotNull((Object)string);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"selectedText!!");
            textFragment = new TextFragment(n, n2, string);
        } else {
            textFragment = null;
        }
        return textFragment;
    }

    private SuggestingUtils() {
    }

    static {
        SuggestingUtils suggestingUtils;
        INSTANCE = suggestingUtils = new SuggestingUtils();
    }
}

