/*
 * Decompiled with CFR 0.152.
 */
package training.learn.lesson.general;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import training.dsl.LessonContext;
import training.dsl.LessonSample;
import training.dsl.LessonSampleKt;
import training.dsl.LessonUtil;
import training.dsl.TaskContext;
import training.dsl.TaskRuntimeContext;
import training.learn.LessonsBundle;
import training.learn.course.KLesson;
import training.learn.lesson.general.MultipleSelectionHtmlLesson;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0018H\u0002R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR%\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\n\u00a8\u0006\u0019"}, d2={"Ltraining/learn/lesson/general/MultipleSelectionHtmlLesson;", "Ltraining/learn/course/KLesson;", "()V", "helpLinks", "", "", "getHelpLinks", "()Ljava/util/Map;", "languageId", "getLanguageId", "()Ljava/lang/String;", "lessonContent", "Lkotlin/Function1;", "Ltraining/dsl/LessonContext;", "", "Lkotlin/ExtensionFunctionType;", "getLessonContent", "()Lkotlin/jvm/functions/Function1;", "sample", "Ltraining/dsl/LessonSample;", "sampleFilePath", "getSampleFilePath", "checkMultiChange", "", "Ltraining/dsl/TaskRuntimeContext;", "intellij.featuresTrainer"})
public final class MultipleSelectionHtmlLesson
extends KLesson {
    @NotNull
    private final String languageId;
    @NotNull
    private final String sampleFilePath;
    private final LessonSample sample = LessonSampleKt.parseLessonSample("<!doctype html>\n<html lang=\"en\">\n    <head>\n        <meta charset=\"UTF-8\">\n        <title>Multiple selections</title>\n    </head>\n    <body>\n        <table>\n            <tr>\n                <<caret>th>Firstname</th>\n                <th>Lastname</th>\n                <th>Points</th>\n            </tr>\n            <tr>\n                <td>Eve</td>\n                <td>Jackson</td>\n                <td>94</td>\n            </tr>\n        </table>\n    </body>\n</html>");

    @Override
    @NotNull
    public String getLanguageId() {
        return this.languageId;
    }

    @Override
    @NotNull
    public String getSampleFilePath() {
        return this.sampleFilePath;
    }

    @Override
    @NotNull
    public Function1<LessonContext, Unit> getLessonContent() {
        return (Function1)new Function1<LessonContext, Unit>(this){
            final /* synthetic */ MultipleSelectionHtmlLesson this$0;

            public final void invoke(@NotNull LessonContext $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                $receiver.prepareSample(MultipleSelectionHtmlLesson.access$getSample$p(this.this$0));
                $receiver.actionTask("SelectNextOccurrence", (Function2<? super TaskContext, ? super String, String>)((Function2)lessonContent.1.INSTANCE));
                $receiver.actionTask("SelectNextOccurrence", (Function2<? super TaskContext, ? super String, String>)((Function2)new Function2<TaskContext, String, String>(this){
                    final /* synthetic */ lessonContent.1 this$0;

                    @NotNull
                    public final String invoke(@NotNull TaskContext $this$actionTask, @NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)$this$actionTask, (String)"$receiver");
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        TaskContext.restoreState$default($this$actionTask, null, 0, null, (Function1)new Function1<TaskRuntimeContext, Boolean>(this){
                            final /* synthetic */ lessonContent.2 this$0;

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final boolean invoke(@NotNull TaskRuntimeContext $this$restoreState) {
                                Intrinsics.checkNotNullParameter((Object)$this$restoreState, (String)"$receiver");
                                String string = MultipleSelectionHtmlLesson.access$getSample$p(this.this$0.this$0.this$0).getText();
                                Document document = $this$restoreState.getEditor().getDocument();
                                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
                                if (Intrinsics.areEqual((Object)string, (Object)document.getText()) ^ true) return true;
                                SelectionModel selectionModel = $this$restoreState.getEditor().getSelectionModel();
                                Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"editor.selectionModel");
                                if (!(Intrinsics.areEqual((Object)selectionModel.getSelectedText(), (Object)"th") ^ true)) return false;
                                return true;
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }, 7, null);
                        return LessonsBundle.INSTANCE.message("multiple.selections.select.next.symbol", $this$actionTask.action(it));
                    }
                    {
                        this.this$0 = var1_1;
                        super(2);
                    }
                }));
                $receiver.actionTask("UnselectPreviousOccurrence", (Function2<? super TaskContext, ? super String, String>)((Function2)new Function2<TaskContext, String, String>(this){
                    final /* synthetic */ lessonContent.1 this$0;

                    @NotNull
                    public final String invoke(@NotNull TaskContext $this$actionTask, @NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)$this$actionTask, (String)"$receiver");
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        TaskContext.restoreState$default($this$actionTask, null, 0, null, (Function1)new Function1<TaskRuntimeContext, Boolean>(this){
                            final /* synthetic */ lessonContent.3 this$0;

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final boolean invoke(@NotNull TaskRuntimeContext $this$restoreState) {
                                Intrinsics.checkNotNullParameter((Object)$this$restoreState, (String)"$receiver");
                                String string = MultipleSelectionHtmlLesson.access$getSample$p(this.this$0.this$0.this$0).getText();
                                Document document = $this$restoreState.getEditor().getDocument();
                                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
                                if (Intrinsics.areEqual((Object)string, (Object)document.getText()) ^ true) return true;
                                CaretModel caretModel = $this$restoreState.getEditor().getCaretModel();
                                Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
                                if (caretModel.getCaretCount() >= 2) return false;
                                return true;
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }, 7, null);
                        return LessonsBundle.INSTANCE.message("multiple.selections.deselect.symbol", $this$actionTask.action(it));
                    }
                    {
                        this.this$0 = var1_1;
                        super(2);
                    }
                }));
                $receiver.actionTask("SelectAllOccurrences", (Function2<? super TaskContext, ? super String, String>)((Function2)lessonContent.4.INSTANCE));
                $receiver.task((Function1<? super TaskContext, Unit>)((Function1)new Function1<TaskContext, Unit>(this){
                    final /* synthetic */ lessonContent.1 this$0;

                    public final void invoke(@NotNull TaskContext $this$task) {
                        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$receiver");
                        TaskContext.text$default($this$task, LessonsBundle.INSTANCE.message("multiple.selections.replace", $this$task.code("td"), $this$task.code("th")), null, 2, null);
                        TaskContext.restoreState$default($this$task, null, 0, null, lessonContent.1.INSTANCE, 7, null);
                        $this$task.stateCheck((Function1<? super TaskRuntimeContext, Boolean>)((Function1)new Function1<TaskRuntimeContext, Boolean>(this){
                            final /* synthetic */ lessonContent.5 this$0;

                            public final boolean invoke(@NotNull TaskRuntimeContext $this$stateCheck) {
                                Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$receiver");
                                return MultipleSelectionHtmlLesson.access$checkMultiChange(this.this$0.this$0.this$0, $this$stateCheck);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }));
                        TaskContext.test$default($this$task, false, lessonContent.3.INSTANCE, 1, null);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
                $receiver.task("EditorEscape", (Function2<? super TaskContext, ? super String, Unit>)((Function2)lessonContent.6.INSTANCE));
            }
            {
                this.this$0 = multipleSelectionHtmlLesson;
                super(1);
            }
        };
    }

    private final boolean checkMultiChange(TaskRuntimeContext $this$checkMultiChange) {
        PsiFile psiFile2 = PsiDocumentManager.getInstance((Project)$this$checkMultiChange.getProject()).getPsiFile($this$checkMultiChange.getEditor().getDocument());
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)((PsiElement)psiFile2), HtmlTag.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"PsiTreeUtil.findChildren\u2026ile, HtmlTag::class.java)");
        Collection childrenOfType1 = collection;
        int count = 0;
        Iterator iterator = childrenOfType1.iterator();
        while (iterator.hasNext()) {
            HtmlTag htmlTag;
            HtmlTag htmlTag2 = htmlTag = (HtmlTag)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)htmlTag2, (String)"htmlTag");
            if (Intrinsics.areEqual((Object)htmlTag2.getName(), (Object)"th")) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)htmlTag.getName(), (Object)"td")) continue;
            ++count;
        }
        return count == 6;
    }

    @Override
    @NotNull
    public Map<String, String> getHelpLinks() {
        return MapsKt.mapOf((Pair)new Pair((Object)LessonsBundle.INSTANCE.message("multiple.selections.help.multiple.carets", new Object[0]), (Object)LessonUtil.INSTANCE.getHelpLink("multicursor.html")));
    }

    public MultipleSelectionHtmlLesson() {
        super("Multiple selections", LessonsBundle.INSTANCE.message("multiple.selections.lesson.name", new Object[0]));
        this.languageId = "HTML";
        this.sampleFilePath = "Learning.html";
    }

    public static final /* synthetic */ LessonSample access$getSample$p(MultipleSelectionHtmlLesson $this) {
        return $this.sample;
    }

    public static final /* synthetic */ boolean access$checkMultiChange(MultipleSelectionHtmlLesson $this, TaskRuntimeContext $this$access_u24checkMultiChange) {
        return $this.checkMultiChange($this$access_u24checkMultiChange);
    }
}

