/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.StringPattern;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class StringMatcher<T> {
    protected final T myTarget;
    public static final StringMatcher NONE = new Any("<none>", false);
    public static final StringMatcher ANY = new Any("", true);
    public static final StringMatcher ANY_PATTERN = new Any(".*", true);

    protected StringMatcher(T target) {
        this.myTarget = target;
    }

    public abstract boolean matches(@NotNull String var1);

    public abstract String getPattern();

    public static StringMatcher create(String target) {
        if (target.length() == 0) {
            return ANY;
        }
        if (target.equals(".*")) {
            return ANY_PATTERN;
        }
        if (target.equals(NONE.getPattern())) {
            return NONE;
        }
        List branches = StringUtil.split((String)target, (String)"|");
        LinkedHashSet<StringMatcher> matchers = new LinkedHashSet<StringMatcher>();
        for (String branch : branches) {
            boolean m;
            boolean startsWith = false;
            boolean endsWith = false;
            boolean ignoreCase = false;
            if (branch.startsWith("(?i)")) {
                ignoreCase = true;
                branch = StringUtil.toLowerCase((String)branch.substring(2));
            }
            if (branch.endsWith(".*")) {
                startsWith = true;
                branch = branch.substring(0, branch.length() - 2);
            }
            if (branch.startsWith(".*")) {
                endsWith = true;
                branch = branch.substring(2);
            }
            if (!(m = StringMatcher.analyseBranch(branch))) {
                try {
                    return new Cache(new Pattern(target));
                }
                catch (Exception e) {
                    return new Any(target, false);
                }
            }
            Simple matcher = startsWith && endsWith ? new Contains(branch) : (startsWith ? new StartsWith(branch) : (endsWith ? new EndsWith(branch) : new Equals(branch)));
            matchers.add(ignoreCase ? new IgnoreCase(matcher) : matcher);
        }
        return matchers.size() == 1 ? (StringMatcher)matchers.iterator().next() : MatcherSet.create(matchers);
    }

    private static boolean analyseBranch(String target) {
        for (int i = 0; i < target.length(); ++i) {
            char c = target.charAt(i);
            if (c == '_' || c == '-' || Character.isLetterOrDigit(c)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.myTarget.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        return ((StringMatcher)obj).myTarget.equals(this.myTarget);
    }

    public static final class MatcherSet
    extends StringMatcher<Set<StringMatcher>> {
        private final String myPattern;

        private MatcherSet(Set<StringMatcher> target) {
            super(target);
            this.myPattern = StringUtil.join(target, s -> s.getPattern(), (String)"|");
        }

        public static StringMatcher create(Set<StringMatcher> matchers) {
            MatcherSet m = new MatcherSet(matchers);
            return matchers.size() > 3 ? new Cache(m) : m;
        }

        @Override
        public boolean matches(@NotNull String what) {
            if (what == null) {
                MatcherSet.$$$reportNull$$$0(0);
            }
            for (StringMatcher matcher : (Set)this.myTarget) {
                if (!matcher.matches(what)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getPattern() {
            return this.myPattern;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "org/intellij/plugins/intelliLang/util/StringMatcher$MatcherSet", "matches"));
        }
    }

    private static final class Cache
    extends StringMatcher<StringMatcher> {
        private final Map<String, Boolean> myCache = ContainerUtil.createWeakMap();

        Cache(StringMatcher target) {
            super(target);
        }

        @Override
        public String getPattern() {
            return ((StringMatcher)this.myTarget).getPattern();
        }

        @Override
        public synchronized boolean matches(@NotNull String what) {
            Boolean o;
            if (what == null) {
                Cache.$$$reportNull$$$0(0);
            }
            if ((o = this.myCache.get(what)) != null) {
                return o;
            }
            boolean b = ((StringMatcher)this.myTarget).matches(what);
            this.myCache.put(what, b);
            return b;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "org/intellij/plugins/intelliLang/util/StringMatcher$Cache", "matches"));
        }
    }

    private static final class IgnoreCase
    extends StringMatcher<StringMatcher> {
        IgnoreCase(StringMatcher target) {
            super(target);
        }

        @Override
        public boolean matches(@NotNull String what) {
            if (what == null) {
                IgnoreCase.$$$reportNull$$$0(0);
            }
            return ((StringMatcher)this.myTarget).matches(StringUtil.toLowerCase((String)what));
        }

        @Override
        public String getPattern() {
            return "(?i)" + ((StringMatcher)this.myTarget).getPattern();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "org/intellij/plugins/intelliLang/util/StringMatcher$IgnoreCase", "matches"));
        }
    }

    private static final class Any
    extends Simple {
        private final boolean myMatches;

        Any(String target, boolean matches) {
            super(target);
            this.myMatches = matches;
        }

        @Override
        public boolean matches(@NotNull String what) {
            if (what == null) {
                Any.$$$reportNull$$$0(0);
            }
            return this.myMatches;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "org/intellij/plugins/intelliLang/util/StringMatcher$Any", "matches"));
        }
    }

    private static final class Contains
    extends Simple {
        Contains(String target) {
            super(target);
        }

        @Override
        public boolean matches(@NotNull String what) {
            if (what == null) {
                Contains.$$$reportNull$$$0(0);
            }
            return what.contains((CharSequence)this.myTarget);
        }

        @Override
        public String getPattern() {
            return ".*" + super.getPattern() + ".*";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "org/intellij/plugins/intelliLang/util/StringMatcher$Contains", "matches"));
        }
    }

    private static final class EndsWith
    extends Simple {
        EndsWith(String target) {
            super(target);
        }

        @Override
        public boolean matches(@NotNull String what) {
            if (what == null) {
                EndsWith.$$$reportNull$$$0(0);
            }
            return what.endsWith((String)this.myTarget);
        }

        @Override
        public String getPattern() {
            return ".*" + super.getPattern();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "org/intellij/plugins/intelliLang/util/StringMatcher$EndsWith", "matches"));
        }
    }

    private static final class StartsWith
    extends Simple {
        StartsWith(String target) {
            super(target);
        }

        @Override
        public boolean matches(@NotNull String what) {
            if (what == null) {
                StartsWith.$$$reportNull$$$0(0);
            }
            return what.startsWith((String)this.myTarget);
        }

        @Override
        public String getPattern() {
            return super.getPattern() + ".*";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "org/intellij/plugins/intelliLang/util/StringMatcher$StartsWith", "matches"));
        }
    }

    private static final class Equals
    extends Simple {
        Equals(String target) {
            super(target);
        }

        @Override
        public boolean matches(@NotNull String what) {
            if (what == null) {
                Equals.$$$reportNull$$$0(0);
            }
            return ((String)this.myTarget).equals(what);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "org/intellij/plugins/intelliLang/util/StringMatcher$Equals", "matches"));
        }
    }

    private static final class Pattern
    extends StringMatcher<java.util.regex.Pattern> {
        Pattern(String target) {
            super(java.util.regex.Pattern.compile(target));
        }

        @Override
        public boolean matches(@NotNull String what) {
            if (what == null) {
                Pattern.$$$reportNull$$$0(0);
            }
            return ((java.util.regex.Pattern)this.myTarget).matcher(StringPattern.newBombedCharSequence((CharSequence)what)).matches();
        }

        @Override
        public String getPattern() {
            return ((java.util.regex.Pattern)this.myTarget).pattern();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "org/intellij/plugins/intelliLang/util/StringMatcher$Pattern", "matches"));
        }
    }

    private static abstract class Simple
    extends StringMatcher<String> {
        Simple(String target) {
            super(target);
        }

        @Override
        public String getPattern() {
            return (String)this.myTarget;
        }
    }
}

