/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.model.SingleTargetReference;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiCompletableReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.resolve.GradleProjectReference;
import org.jetbrains.plugins.gradle.service.resolve.GradleRootProjectSymbol;
import org.jetbrains.plugins.gradle.service.resolve.GradleSubprojectSymbol;
import org.jetbrains.plugins.gradle.settings.GradleExtensionsSettings;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0006H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleProjectReference;", "Lcom/intellij/model/SingleTargetReference;", "Lcom/intellij/model/psi/PsiCompletableReference;", "myElement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/literals/GrLiteral;", "myRange", "Lcom/intellij/openapi/util/TextRange;", "myQualifiedName", "", "", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/literals/GrLiteral;Lcom/intellij/openapi/util/TextRange;Ljava/util/List;)V", "getCompletionVariants", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "getElement", "Lcom/intellij/psi/PsiElement;", "getRangeInElement", "resolveSingleTarget", "Lcom/intellij/model/Symbol;", "intellij.gradle.java"})
@ApiStatus.Internal
public final class GradleProjectReference
extends SingleTargetReference
implements PsiCompletableReference {
    private final GrLiteral myElement;
    private final TextRange myRange;
    private final List<String> myQualifiedName;

    @NotNull
    public PsiElement getElement() {
        return (PsiElement)this.myElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return this.myRange;
    }

    @Nullable
    protected Symbol resolveSingleTarget() {
        GradleExtensionsSettings.GradleProject gradleProject = GradleExtensionsSettings.getRootProject((PsiElement)((PsiElement)this.myElement));
        if (gradleProject == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)gradleProject, (String)"GradleExtensionsSettings\u2026myElement) ?: return null");
        GradleExtensionsSettings.GradleProject gradleProject2 = gradleProject;
        String string = GradleExtensionsSettings.getRootProjectPath((PsiElement)((PsiElement)this.myElement));
        if (string == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GradleExtensionsSettings\u2026myElement) ?: return null");
        String rootProjectPath = string;
        if (this.myQualifiedName.isEmpty()) {
            return (Symbol)new GradleRootProjectSymbol(rootProjectPath);
        }
        Map map = gradleProject2.extensions;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"gradleProject.extensions");
        Map map2 = map;
        String string2 = GradleSubprojectSymbol.Companion.qualifiedNameString(this.myQualifiedName);
        Map map3 = map2;
        if (map3.containsKey(string2)) {
            return (Symbol)new GradleSubprojectSymbol(this.myQualifiedName, rootProjectPath);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<LookupElement> getCompletionVariants() {
        void $this$mapTo$iv$iv;
        Object relativeFqn;
        GradleExtensionsSettings.GradleProject gradleProject = GradleExtensionsSettings.getRootProject((PsiElement)((PsiElement)this.myElement));
        if (gradleProject == null) {
            return CollectionsKt.emptyList();
        }
        GradleExtensionsSettings.GradleProject gradleProject2 = gradleProject;
        List parentProjectFqn = CollectionsKt.dropLast(this.myQualifiedName, (int)1);
        String parentProjectPrefix2 = CollectionsKt.joinToString$default((Iterable)parentProjectFqn, (CharSequence)"", null, (CharSequence)":", (int)0, null, (Function1)getCompletionVariants.parentProjectPrefix.1.INSTANCE, (int)26, null);
        LinkedHashSet result = new LinkedHashSet();
        Iterator iterator = gradleProject2.extensions.keySet().iterator();
        while (iterator.hasNext()) {
            String projectFqn;
            String string = projectFqn = (String)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"projectFqn");
            if (!StringsKt.startsWith$default((String)string, (String)parentProjectPrefix2, (boolean)false, (int)2, null)) continue;
            relativeFqn = StringsKt.removePrefix((String)projectFqn, (CharSequence)parentProjectPrefix2);
            String childProjectName = (String)CollectionsKt.firstOrNull((List)StringsKt.split$default((CharSequence)((CharSequence)relativeFqn), (char[])new char[]{':'}, (boolean)false, (int)0, (int)6, null));
            Object object = childProjectName;
            if (object == null || object.length() == 0) continue;
            object = result;
            object.add(childProjectName);
        }
        Iterable $this$map$iv = result;
        boolean $i$f$map = false;
        relativeFqn = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)p1);
            collection.add(lookupElementBuilder);
        }
        return (List)destination$iv$iv;
    }

    public GradleProjectReference(@NotNull GrLiteral myElement, @NotNull TextRange myRange, @NotNull List<String> myQualifiedName) {
        Intrinsics.checkNotNullParameter((Object)myElement, (String)"myElement");
        Intrinsics.checkNotNullParameter((Object)myRange, (String)"myRange");
        Intrinsics.checkNotNullParameter(myQualifiedName, (String)"myQualifiedName");
        this.myElement = myElement;
        this.myRange = myRange;
        this.myQualifiedName = myQualifiedName;
    }
}

