/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Month;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeParseException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.DateTimeFormatException;
import kotlinx.datetime.MonthKt;
import kotlinx.datetime.serializers.LocalDateIso8601Serializer;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=LocalDateIso8601Serializer.class)
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001%B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nB\u000f\b\u0000\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0011\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u001f\u001a\u00020 2\b\u0010\u001e\u001a\u0004\u0018\u00010!H\u0096\u0002J\b\u0010\"\u001a\u00020\u0003H\u0016J\b\u0010#\u001a\u00020$H\u0016R\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0015\u0010\u0010\u001a\u00060\u0011j\u0002`\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000fR\u0015\u0010\u0007\u001a\u00060\bj\u0002`\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000fR\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000f\u00a8\u0006&"}, d2={"Lkotlinx/datetime/LocalDate;", "", "year", "", "monthNumber", "dayOfMonth", "(III)V", "month", "Ljava/time/Month;", "Lkotlinx/datetime/Month;", "(ILjava/time/Month;I)V", "value", "Ljava/time/LocalDate;", "(Ljava/time/LocalDate;)V", "getDayOfMonth", "()I", "dayOfWeek", "Ljava/time/DayOfWeek;", "Lkotlinx/datetime/DayOfWeek;", "getDayOfWeek", "()Ljava/time/DayOfWeek;", "dayOfYear", "getDayOfYear", "getMonth", "()Ljava/time/Month;", "getMonthNumber", "getValue$kotlinx_datetime", "()Ljava/time/LocalDate;", "getYear", "compareTo", "other", "equals", "", "", "hashCode", "toString", "", "Companion", "kotlinx-datetime"})
public final class LocalDate
implements Comparable<LocalDate> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final java.time.LocalDate value;
    @NotNull
    private static final LocalDate MIN;
    @NotNull
    private static final LocalDate MAX;

    public LocalDate(@NotNull java.time.LocalDate value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.value = value;
    }

    @NotNull
    public final java.time.LocalDate getValue$kotlinx_datetime() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    public LocalDate(int year, int monthNumber, int dayOfMonth) {
        java.time.LocalDate localDate;
        LocalDate localDate2;
        LocalDate localDate3 = this;
        try {
            localDate2 = localDate3;
            localDate = java.time.LocalDate.of(year, monthNumber, dayOfMonth);
        }
        catch (DateTimeException dateTimeException) {
            void e;
            LocalDate localDate4 = localDate3;
            throw new IllegalArgumentException((Throwable)e);
        }
        java.time.LocalDate localDate5 = localDate;
        Intrinsics.checkNotNullExpressionValue(localDate5, "try {\n                jt\u2026xception(e)\n            }");
        localDate2(localDate5);
    }

    public LocalDate(int year, @NotNull Month month, int dayOfMonth) {
        Intrinsics.checkNotNullParameter(month, "month");
        this(year, MonthKt.getNumber(month), dayOfMonth);
    }

    public final int getYear() {
        return this.value.getYear();
    }

    public final int getMonthNumber() {
        return this.value.getMonthValue();
    }

    @NotNull
    public final Month getMonth() {
        Month month = this.value.getMonth();
        Intrinsics.checkNotNullExpressionValue(month, "value.month");
        return month;
    }

    public final int getDayOfMonth() {
        return this.value.getDayOfMonth();
    }

    @NotNull
    public final DayOfWeek getDayOfWeek() {
        DayOfWeek dayOfWeek = this.value.getDayOfWeek();
        Intrinsics.checkNotNullExpressionValue(dayOfWeek, "value.dayOfWeek");
        return dayOfWeek;
    }

    public final int getDayOfYear() {
        return this.value.getDayOfYear();
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof LocalDate && Intrinsics.areEqual(this.value, ((LocalDate)other).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @NotNull
    public String toString() {
        String string = this.value.toString();
        Intrinsics.checkNotNullExpressionValue(string, "value.toString()");
        return string;
    }

    @Override
    public int compareTo(@NotNull LocalDate other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.value.compareTo(other.value);
    }

    static {
        java.time.LocalDate localDate = java.time.LocalDate.MIN;
        Intrinsics.checkNotNullExpressionValue(localDate, "MIN");
        MIN = new LocalDate(localDate);
        localDate = java.time.LocalDate.MAX;
        Intrinsics.checkNotNullExpressionValue(localDate, "MAX");
        MAX = new LocalDate(localDate);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rH\u00c6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lkotlinx/datetime/LocalDate$Companion;", "", "()V", "MAX", "Lkotlinx/datetime/LocalDate;", "getMAX$kotlinx_datetime", "()Lkotlinx/datetime/LocalDate;", "MIN", "getMIN$kotlinx_datetime", "parse", "isoString", "", "serializer", "Lkotlinx/serialization/KSerializer;", "kotlinx-datetime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LocalDate parse(@NotNull String isoString) {
            Comparable<ChronoLocalDate> comparable;
            Intrinsics.checkNotNullParameter(isoString, "isoString");
            try {
                comparable = java.time.LocalDate.parse(isoString);
                boolean bl = false;
                boolean bl2 = false;
                java.time.LocalDate p0 = comparable;
                boolean bl3 = false;
                comparable = new LocalDate(p0);
            }
            catch (DateTimeParseException e) {
                throw new DateTimeFormatException(e);
            }
            return comparable;
        }

        @NotNull
        public final LocalDate getMIN$kotlinx_datetime() {
            return MIN;
        }

        @NotNull
        public final LocalDate getMAX$kotlinx_datetime() {
            return MAX;
        }

        @NotNull
        public final KSerializer<LocalDate> serializer() {
            return LocalDateIso8601Serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

