/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.api.BuildModelNotification;
import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.api.util.GradleNameElementUtil;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.notifications.NotificationTypeReference;
import com.android.tools.idea.gradle.dsl.parser.ExternalNameInfo;
import com.android.tools.idea.gradle.dsl.parser.GradleDslNameConverter;
import com.android.tools.idea.gradle.dsl.parser.GradleDslParser;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.ModificationAware;
import com.android.tools.idea.gradle.dsl.parser.build.BuildScriptDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslClosure;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.dsl.parser.semantics.DescribedGradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelEffectDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.SurfaceSyntaxDescription;
import com.android.tools.idea.gradle.dsl.parser.settings.ProjectPropertiesDslElement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GradleDslElementImpl
implements GradleDslElement,
ModificationAware {
    @NotNull
    private static final String SINGLE_QUOTES = "'";
    @NotNull
    private static final String DOUBLE_QUOTES = "\"";
    @NotNull
    protected GradleNameElement myName;
    @Nullable
    protected GradleDslElement myParent;
    @NotNull
    protected List<GradlePropertiesDslElement> myHolders;
    @NotNull
    private final GradleDslFile myDslFile;
    @Nullable
    private PsiElement myPsiElement;
    @Nullable
    private GradleDslClosure myClosureElement;
    @Nullable
    private GradleDslClosure myUnsavedClosure;
    private long myLastCommittedModificationCount;
    private long myModificationCount;
    @NotNull
    protected ExternalNameInfo.ExternalNameSyntax mySyntax;
    @NotNull
    private PropertyType myElementType;
    @NotNull
    protected final List<GradleReferenceInjection> myDependencies;
    @NotNull
    protected final List<GradleReferenceInjection> myDependents;
    @Nullable
    private ModelEffectDescription myModelEffectDescription;

    protected GradleDslElementImpl(@Nullable GradleDslElement parent, @Nullable PsiElement psiElement, @NotNull GradleNameElement name) {
        if (name == null) {
            GradleDslElementImpl.$$$reportNull$$$0(0);
        }
        this.myHolders = new ArrayList<GradlePropertiesDslElement>();
        this.myDependencies = new ArrayList<GradleReferenceInjection>();
        this.myDependents = new ArrayList<GradleReferenceInjection>();
        assert (parent != null || this instanceof GradleDslFile);
        this.myParent = parent;
        this.myPsiElement = psiElement;
        this.myName = name;
        this.myDslFile = parent == null ? (GradleDslFile)this : parent.getDslFile();
        this.mySyntax = ExternalNameInfo.ExternalNameSyntax.METHOD;
        this.myElementType = PropertyType.DERIVED;
    }

    @Override
    public void setParsedClosureElement(@NotNull GradleDslClosure closureElement) {
        if (closureElement == null) {
            GradleDslElementImpl.$$$reportNull$$$0(1);
        }
        this.myClosureElement = closureElement;
    }

    @Override
    public void setNewClosureElement(@Nullable GradleDslClosure closureElement) {
        this.myUnsavedClosure = closureElement;
        this.setModified();
    }

    @Override
    @Nullable
    public GradleDslClosure getUnsavedClosure() {
        return this.myUnsavedClosure;
    }

    @Override
    @Nullable
    public GradleDslClosure getClosureElement() {
        return this.myUnsavedClosure == null ? this.myClosureElement : this.myUnsavedClosure;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myModelEffectDescription == null ? this.myName.name() : this.myModelEffectDescription.property.name;
        if (string == null) {
            GradleDslElementImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        if (this.myParent == null || this.myParent instanceof GradleDslFile) {
            String string = GradleNameElementUtil.escape(this.getName());
            if (string == null) {
                GradleDslElementImpl.$$$reportNull$$$0(3);
            }
            return string;
        }
        String ourName = this.getName();
        String string = this.myParent.getQualifiedName() + (String)(ourName.isEmpty() ? "" : "." + GradleNameElementUtil.escape(ourName));
        if (string == null) {
            GradleDslElementImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFullName() {
        if (this.myModelEffectDescription == null) {
            String string = this.myName.fullName();
            if (string == null) {
                GradleDslElementImpl.$$$reportNull$$$0(5);
            }
            return string;
        }
        List<String> parts = this.myName.qualifyingParts();
        parts.add(this.getName());
        String string = GradleNameElement.createNameFromParts(parts);
        if (string == null) {
            GradleDslElementImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public GradleNameElement getNameElement() {
        GradleNameElement gradleNameElement = this.myName;
        if (gradleNameElement == null) {
            GradleDslElementImpl.$$$reportNull$$$0(7);
        }
        return gradleNameElement;
    }

    @Override
    public void rename(@NotNull String newName) {
        if (newName == null) {
            GradleDslElementImpl.$$$reportNull$$$0(8);
        }
        this.rename(Arrays.asList(newName));
    }

    @Override
    public void rename(@NotNull List<String> hierarchicalName) {
        if (hierarchicalName == null) {
            GradleDslElementImpl.$$$reportNull$$$0(9);
        }
        this.myName.rename(hierarchicalName);
        this.setModified();
        if (!(this instanceof GradleDslSimpleExpression)) {
            return;
        }
        List<GradleReferenceInjection> dependents = this.getDependents();
        this.unregisterAllDependants();
        this.reorder();
        dependents.forEach(e -> e.getOriginElement().resolve());
        this.getDslFile().getContext().getDependencyManager().resolveWith(this);
    }

    @Override
    @Nullable
    public GradleDslElement getParent() {
        return this.myParent;
    }

    @Override
    public void setParent(@NotNull GradleDslElement parent) {
        if (parent == null) {
            GradleDslElementImpl.$$$reportNull$$$0(10);
        }
        this.myParent = parent;
    }

    @Override
    @NotNull
    public List<GradlePropertiesDslElement> getHolders() {
        List<GradlePropertiesDslElement> list = this.myHolders;
        if (list == null) {
            GradleDslElementImpl.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Override
    public void addHolder(@NotNull GradlePropertiesDslElement holder) {
        if (holder == null) {
            GradleDslElementImpl.$$$reportNull$$$0(12);
        }
        this.myHolders.add(holder);
    }

    @Override
    @Nullable
    public PsiElement getPsiElement() {
        return this.myPsiElement;
    }

    @Override
    public void setPsiElement(@Nullable PsiElement psiElement) {
        this.myPsiElement = psiElement;
    }

    @Override
    @NotNull
    public ExternalNameInfo.ExternalNameSyntax getExternalSyntax() {
        ExternalNameInfo.ExternalNameSyntax externalNameSyntax = this.mySyntax;
        if (externalNameSyntax == null) {
            GradleDslElementImpl.$$$reportNull$$$0(13);
        }
        return externalNameSyntax;
    }

    @Override
    public void setExternalSyntax(@NotNull ExternalNameInfo.ExternalNameSyntax syntax) {
        if (syntax == null) {
            GradleDslElementImpl.$$$reportNull$$$0(14);
        }
        this.mySyntax = syntax;
    }

    @Override
    @NotNull
    public PropertyType getElementType() {
        PropertyType propertyType = this.myElementType;
        if (propertyType == null) {
            GradleDslElementImpl.$$$reportNull$$$0(15);
        }
        return propertyType;
    }

    @Override
    public void setElementType(@NotNull PropertyType propertyType) {
        if (propertyType == null) {
            GradleDslElementImpl.$$$reportNull$$$0(16);
        }
        this.myElementType = propertyType;
    }

    @Override
    @NotNull
    public GradleDslFile getDslFile() {
        GradleDslFile gradleDslFile = this.myDslFile;
        if (gradleDslFile == null) {
            GradleDslElementImpl.$$$reportNull$$$0(17);
        }
        return gradleDslFile;
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getResolvedVariables() {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (GradleDslElement child : this.getChildren()) {
            resultBuilder.addAll(child.getResolvedVariables());
        }
        ImmutableList immutableList = resultBuilder.build();
        if (immutableList == null) {
            GradleDslElementImpl.$$$reportNull$$$0(18);
        }
        return immutableList;
    }

    @Override
    @Nullable
    public GradleDslElement requestAnchor(@NotNull GradleDslElement element) {
        if (element == null) {
            GradleDslElementImpl.$$$reportNull$$$0(19);
        }
        return null;
    }

    @Override
    @Nullable
    public GradleDslElement getAnchor() {
        return this.myParent == null ? null : this.myParent.requestAnchor(this);
    }

    @Override
    @Nullable
    public PsiElement create() {
        return this.myDslFile.getWriter().createDslElement(this);
    }

    @Override
    @Nullable
    public PsiElement move() {
        return this.myDslFile.getWriter().moveDslElement(this);
    }

    @Override
    public void delete() {
        this.getDslFile().getWriter().deleteDslElement(this);
    }

    @Override
    public void setModified() {
        this.modify();
        if (this.myParent != null) {
            this.myParent.setModified();
            if (this instanceof DescribedGradlePropertiesDslElement && this.myParent instanceof GradlePropertiesDslElement) {
                ((GradlePropertiesDslElement)this.myParent).updateAppliedState(this);
            }
        }
    }

    @Override
    public boolean isModified() {
        return this.getLastCommittedModificationCount() != this.getModificationCount();
    }

    @Override
    public boolean isBlockElement() {
        return false;
    }

    @Override
    public boolean isInsignificantIfEmpty() {
        return true;
    }

    @Override
    @NotNull
    public abstract Collection<GradleDslElement> getChildren();

    @Override
    public final void applyChanges() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.apply();
        this.commit();
    }

    protected abstract void apply();

    @Override
    public final void resetState() {
        this.reset();
        this.commit();
    }

    protected abstract void reset();

    @Override
    @NotNull
    public List<GradleDslElement> getContainedElements(boolean includeProperties) {
        List<GradleDslElement> list = Collections.emptyList();
        if (list == null) {
            GradleDslElementImpl.$$$reportNull$$$0(20);
        }
        return list;
    }

    @Override
    @NotNull
    public Map<String, GradleDslElement> getInScopeElements() {
        LinkedHashMap<String, GradleDslElement> results = new LinkedHashMap<String, GradleDslElement>();
        if (PropertyUtil.isNonExpressionPropertiesElement(this)) {
            GradlePropertiesDslElement thisElement = (GradlePropertiesDslElement)this;
            results.putAll(thisElement.getVariableElements());
        }
        GradleDslElement currentElement = this;
        while (currentElement != null && currentElement.getParent() != null) {
            if (!PropertyUtil.isNonExpressionPropertiesElement(currentElement = currentElement.getParent())) continue;
            GradlePropertiesDslElement element = (GradlePropertiesDslElement)currentElement;
            results.putAll(element.getVariableElements());
        }
        if (currentElement instanceof GradleDslFile) {
            for (GradleDslFile file = (GradleDslFile)currentElement; file != null; file = file.getParentModuleDslFile()) {
                ExtDslElement buildScriptExt;
                BuildScriptDslElement buildScriptElement;
                GradleDslFile propertiesFile;
                ExtDslElement ext = file.getPropertyElement(ExtDslElement.EXT);
                if (ext != null) {
                    results.putAll(ext.getPropertyElements());
                }
                if ((propertiesFile = file.getSiblingDslFile()) != null) {
                    Map<String, GradleDslElement> filteredProperties = propertiesFile.getPropertyElements().entrySet().stream().filter(entry -> !((String)entry.getKey()).contains(".")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    results.putAll(filteredProperties);
                }
                if ((buildScriptElement = file.getPropertyElement(BuildScriptDslElement.BUILDSCRIPT)) == null || (buildScriptExt = buildScriptElement.getPropertyElement(ExtDslElement.EXT)) == null) continue;
                results.putAll(buildScriptExt.getPropertyElements());
            }
        }
        LinkedHashMap<String, GradleDslElement> linkedHashMap = results;
        if (linkedHashMap == null) {
            GradleDslElementImpl.$$$reportNull$$$0(21);
        }
        return linkedHashMap;
    }

    @Override
    @NotNull
    public <T extends BuildModelNotification> T notification(@NotNull NotificationTypeReference<T> type) {
        if (type == null) {
            GradleDslElementImpl.$$$reportNull$$$0(22);
        }
        T t = this.getDslFile().getContext().getNotificationForType(this.myDslFile, type);
        if (t == null) {
            GradleDslElementImpl.$$$reportNull$$$0(23);
        }
        return t;
    }

    @Override
    public void registerDependent(@NotNull GradleReferenceInjection injection) {
        if (injection == null) {
            GradleDslElementImpl.$$$reportNull$$$0(24);
        }
        assert (injection.isResolved() && injection.getToBeInjected() == this);
        this.myDependents.add(injection);
    }

    @Override
    public void unregisterDependent(@NotNull GradleReferenceInjection injection) {
        if (injection == null) {
            GradleDslElementImpl.$$$reportNull$$$0(25);
        }
        assert (injection.isResolved() && injection.getToBeInjected() == this);
        assert (this.myDependents.contains(injection));
        this.myDependents.remove(injection);
    }

    @Override
    public void unregisterAllDependants() {
        this.myDependents.forEach(e -> {
            e.resolveWith(null);
            this.getDslFile().getContext().getDependencyManager().registerUnresolvedReference((GradleReferenceInjection)e);
        });
        this.myDependents.clear();
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getDependents() {
        return new ArrayList<GradleReferenceInjection>(this.myDependents);
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getDependencies() {
        return new ArrayList<GradleReferenceInjection>(this.myDependencies);
    }

    @Override
    public void updateDependenciesOnAddElement(@NotNull GradleDslElement newElement) {
        if (newElement == null) {
            GradleDslElementImpl.$$$reportNull$$$0(26);
        }
        newElement.resolve();
        newElement.getDslFile().getContext().getDependencyManager().resolveWith(newElement);
    }

    @Override
    public void updateDependenciesOnReplaceElement(@NotNull GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
        if (oldElement == null) {
            GradleDslElementImpl.$$$reportNull$$$0(27);
        }
        if (newElement == null) {
            GradleDslElementImpl.$$$reportNull$$$0(28);
        }
        List<GradleReferenceInjection> injections = oldElement.getDependents();
        oldElement.unregisterAllDependants();
        injections.forEach(e -> e.resolveWith(newElement));
        injections.forEach(newElement::registerDependent);
        oldElement.getResolvedVariables().forEach(e -> {
            GradleDslElement toBeInjected = e.getToBeInjected();
            if (toBeInjected != null) {
                toBeInjected.unregisterDependent((GradleReferenceInjection)e);
            }
        });
    }

    @Override
    public void updateDependenciesOnRemoveElement(@NotNull GradleDslElement oldElement) {
        if (oldElement == null) {
            GradleDslElementImpl.$$$reportNull$$$0(29);
        }
        List<GradleReferenceInjection> dependents = oldElement.getDependents();
        oldElement.unregisterAllDependants();
        dependents.forEach(e -> e.getOriginElement().resolve());
        oldElement.getResolvedVariables().forEach(e -> {
            GradleDslElement toBeInjected = e.getToBeInjected();
            if (toBeInjected != null) {
                toBeInjected.unregisterDependent((GradleReferenceInjection)e);
            }
        });
    }

    @Override
    public void resolve() {
    }

    protected void reorder() {
        if (this.myParent instanceof ExtDslElement) {
            ((ExtDslElement)this.myParent).reorderAndMaybeGetNewIndex(this);
        }
    }

    @Override
    public long getModificationCount() {
        return this.myModificationCount;
    }

    public long getLastCommittedModificationCount() {
        return this.myLastCommittedModificationCount;
    }

    @Override
    public void modify() {
        HashSet<GradleDslElement> visited = new HashSet<GradleDslElement>();
        this.modify(visited);
    }

    protected void modify(Set<GradleDslElement> visited) {
        ++this.myModificationCount;
        visited.add(this);
        this.myDependents.forEach(e -> {
            if (!visited.contains(e.getOriginElement())) {
                e.getOriginElement().modify(visited);
            }
        });
    }

    public void commit() {
        this.myLastCommittedModificationCount = this.myModificationCount;
    }

    @Nullable
    public static String getPsiText(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            GradleDslElementImpl.$$$reportNull$$$0(30);
        }
        return (String)ApplicationManager.getApplication().runReadAction(() -> psiElement.getText());
    }

    @Override
    public boolean isNewEmptyBlockElement() {
        if (this.myPsiElement != null) {
            return false;
        }
        if (!this.isBlockElement() || !this.isInsignificantIfEmpty()) {
            return false;
        }
        List<GradleDslElement> children = this.getContainedElements(true);
        if (children.isEmpty()) {
            return true;
        }
        for (GradleDslElement child : children) {
            if (child.isNewEmptyBlockElement()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public ImmutableMap<SurfaceSyntaxDescription, ModelEffectDescription> getExternalToModelMap(@NotNull GradleDslNameConverter converter) {
        if (converter == null) {
            GradleDslElementImpl.$$$reportNull$$$0(31);
        }
        ImmutableMap immutableMap = ImmutableMap.of();
        if (immutableMap == null) {
            GradleDslElementImpl.$$$reportNull$$$0(32);
        }
        return immutableMap;
    }

    @Override
    @Nullable
    public ModelEffectDescription getModelEffect() {
        return this.myModelEffectDescription;
    }

    @Override
    public void setModelEffect(@Nullable ModelEffectDescription effect) {
        this.myModelEffectDescription = effect;
    }

    @Override
    @Nullable
    public ModelPropertyDescription getModelProperty() {
        return this.myModelEffectDescription == null ? null : this.myModelEffectDescription.property;
    }

    @Nullable
    public static GradleDslElement dereference(@NotNull GradleDslElement element, @NotNull String index) {
        if (element == null) {
            GradleDslElementImpl.$$$reportNull$$$0(33);
        }
        if (index == null) {
            GradleDslElementImpl.$$$reportNull$$$0(34);
        }
        if (element instanceof GradleDslExpressionList) {
            int offset;
            try {
                offset = Integer.parseInt(index);
            }
            catch (NumberFormatException e) {
                return null;
            }
            GradleDslExpressionList list = (GradleDslExpressionList)element;
            if (list.getExpressions().size() <= offset) {
                return null;
            }
            return list.getExpressions().get(offset);
        }
        if (element instanceof GradleDslExpressionMap) {
            GradleDslExpressionMap map = (GradleDslExpressionMap)element;
            index = GradleDslElementImpl.stripQuotes(index);
            return map.getPropertyElement(index);
        }
        if (element instanceof GradleDslLiteral && ((GradleDslLiteral)element).isReference()) {
            GradleDslElement value = PropertyUtil.followElement((GradleDslLiteral)element);
            if (value == null) {
                return null;
            }
            return GradleDslElementImpl.dereference(value, index);
        }
        return null;
    }

    @Nullable
    private static GradleDslElement extractElementFromProperties(@NotNull GradlePropertiesDslElement properties, @NotNull String name, GradleDslNameConverter converter, boolean sameScope, @Nullable GradleDslElement childElement, boolean includeSelf) {
        Matcher indexMatcher;
        if (properties == null) {
            GradleDslElementImpl.$$$reportNull$$$0(35);
        }
        if (name == null) {
            GradleDslElementImpl.$$$reportNull$$$0(36);
        }
        if (!(indexMatcher = GradleNameElement.INDEX_PATTERN.matcher(name)).find()) {
            ModelPropertyDescription property = converter.modelDescriptionForParent(name, properties);
            String modelName = property == null ? name : property.name;
            return sameScope ? properties.getElementBefore(childElement, modelName, includeSelf) : properties.getPropertyElementBefore(childElement, modelName, includeSelf);
        }
        String elementName = indexMatcher.group(0);
        if (elementName == null || elementName.equals("")) {
            return null;
        }
        ModelPropertyDescription property = converter.modelDescriptionForParent(elementName, properties);
        String modelName = property == null ? elementName : property.name;
        GradleDslElement element = sameScope ? properties.getElementBefore(childElement, modelName, includeSelf) : properties.getPropertyElementBefore(childElement, modelName, includeSelf);
        ArrayDeque<String> indexParts = new ArrayDeque<String>();
        while (indexMatcher.find()) {
            String match = indexMatcher.group(1);
            if (match == null) {
                return null;
            }
            indexParts.add(match);
        }
        while (!indexParts.isEmpty()) {
            String index = (String)indexParts.pop();
            if (element == null) {
                return null;
            }
            element = GradleDslElementImpl.dereference(element, index);
        }
        return element;
    }

    @Nullable
    private static GradleDslFile findDslFile(GradleDslFile rootModuleDslFile, File moduleDirectory) {
        if (FileUtil.filesEqual((File)rootModuleDslFile.getDirectoryPath(), (File)moduleDirectory)) {
            return rootModuleDslFile;
        }
        for (GradleDslFile dslFile : rootModuleDslFile.getChildModuleDslFiles()) {
            if (FileUtil.filesEqual((File)dslFile.getDirectoryPath(), (File)moduleDirectory)) {
                return dslFile;
            }
            GradleDslFile childDslFile = GradleDslElementImpl.findDslFile(dslFile, moduleDirectory);
            if (childDslFile == null) continue;
            return dslFile;
        }
        return null;
    }

    @Nullable
    private static GradleDslElement resolveReferenceOnPropertiesElement(@NotNull GradlePropertiesDslElement properties, @NotNull List<String> nameParts, GradleDslNameConverter converter, @NotNull List<GradleDslElement> trace) {
        if (properties == null) {
            GradleDslElementImpl.$$$reportNull$$$0(37);
        }
        if (nameParts == null) {
            GradleDslElementImpl.$$$reportNull$$$0(38);
        }
        if (trace == null) {
            GradleDslElementImpl.$$$reportNull$$$0(39);
        }
        int traceIndex = trace.size() - 1;
        for (int i = 0; i < nameParts.size() - 1; ++i) {
            GradleDslElement element = GradleDslElementImpl.extractElementFromProperties(properties, nameParts.get(i), converter, i == 0, traceIndex < 0 ? null : trace.get(traceIndex--), traceIndex >= 0);
            if (element instanceof GradleDslLiteral && ((GradleDslLiteral)element).isReference()) {
                element = PropertyUtil.followElement((GradleDslLiteral)element);
            }
            if (!PropertyUtil.isPropertiesElementOrMap(element)) {
                return null;
            }
            properties = (GradlePropertiesDslElement)element;
        }
        return GradleDslElementImpl.extractElementFromProperties(properties, nameParts.get(nameParts.size() - 1), converter, nameParts.size() == 1, traceIndex < 0 ? null : trace.get(traceIndex--), traceIndex >= 0);
    }

    @Nullable
    private static GradleDslElement resolveReferenceOnElement(@NotNull GradleDslElement element, @NotNull List<String> nameParts, GradleDslNameConverter converter, boolean resolveWithOrder, boolean checkExt, int ignoreParentNumber) {
        if (element == null) {
            GradleDslElementImpl.$$$reportNull$$$0(40);
        }
        if (nameParts == null) {
            GradleDslElementImpl.$$$reportNull$$$0(41);
        }
        Stack<GradleDslElement> elementTrace = new Stack<GradleDslElement>();
        if (resolveWithOrder) {
            elementTrace.push(element);
        }
        while (ignoreParentNumber-- > 0 && element != null && !(element instanceof GradleDslFile) && !(element instanceof BuildScriptDslElement)) {
            element = element.getParent();
        }
        while (element != null) {
            GradleDslElement lastElement;
            GradleDslElement gradleDslElement = lastElement = elementTrace.isEmpty() ? null : (GradleDslElement)elementTrace.peek();
            if (PropertyUtil.isPropertiesElementOrMap(element)) {
                GradleDslElement bsElement;
                GradleDslElement bsDslElement;
                GradleDslElement extPropertyElement;
                GradleDslElement extElement;
                GradleDslElement propertyElement = GradleDslElementImpl.resolveReferenceOnPropertiesElement((GradlePropertiesDslElement)element, nameParts, converter, elementTrace);
                if (propertyElement != null) {
                    return propertyElement;
                }
                if (!(lastElement instanceof ExtDslElement) && checkExt && (extElement = ((GradlePropertiesDslElement)element).getPropertyElementBefore(lastElement, ExtDslElement.EXT.name, false)) instanceof ExtDslElement && (extPropertyElement = GradleDslElementImpl.resolveReferenceOnPropertiesElement((ExtDslElement)extElement, nameParts, converter, elementTrace)) != null) {
                    return extPropertyElement;
                }
                if (!(lastElement instanceof BuildScriptDslElement) && (bsDslElement = ((GradlePropertiesDslElement)element).getPropertyElementBefore(element, BuildScriptDslElement.BUILDSCRIPT.name, false)) instanceof BuildScriptDslElement && (bsElement = GradleDslElementImpl.resolveReferenceOnElement(bsDslElement, nameParts, converter, true, false, -1)) != null) {
                    return bsElement;
                }
            }
            if (resolveWithOrder) {
                elementTrace.push(element);
            }
            if (element instanceof BuildScriptDslElement) {
                return null;
            }
            element = element.getParent();
        }
        return null;
    }

    @Nullable
    private static GradleDslElement resolveReferenceInPropertiesFile(@NotNull GradleDslFile buildDslFile, @NotNull String referenceText) {
        GradleDslFile propertiesDslFile;
        if (buildDslFile == null) {
            GradleDslElementImpl.$$$reportNull$$$0(42);
        }
        if (referenceText == null) {
            GradleDslElementImpl.$$$reportNull$$$0(43);
        }
        return (propertiesDslFile = buildDslFile.getSiblingDslFile()) != null ? propertiesDslFile.getPropertyElement(referenceText) : null;
    }

    @Nullable
    private static GradleDslElement resolveReferenceInParentModules(@NotNull GradleDslFile dslFile, @NotNull List<String> referenceText, GradleDslNameConverter converter) {
        if (dslFile == null) {
            GradleDslElementImpl.$$$reportNull$$$0(44);
        }
        if (referenceText == null) {
            GradleDslElementImpl.$$$reportNull$$$0(45);
        }
        for (GradleDslFile parentDslFile = dslFile.getParentModuleDslFile(); parentDslFile != null; parentDslFile = parentDslFile.getParentModuleDslFile()) {
            GradleDslElement bsElement;
            GradleDslElement extPropertyElement;
            ExtDslElement extDslElement = parentDslFile.getPropertyElement(ExtDslElement.EXT);
            if (extDslElement != null && (extPropertyElement = GradleDslElementImpl.resolveReferenceOnPropertiesElement(extDslElement, referenceText, converter, new Stack<GradleDslElement>())) != null) {
                return extPropertyElement;
            }
            BuildScriptDslElement bsDslElement = parentDslFile.getPropertyElement(BuildScriptDslElement.BUILDSCRIPT);
            if (bsDslElement != null && (bsElement = GradleDslElementImpl.resolveReferenceOnElement(bsDslElement, referenceText, converter, false, true, -1)) != null) {
                return bsElement;
            }
            if (parentDslFile.getParentModuleDslFile() == null) {
                return null;
            }
            GradleDslElement propertyElement = GradleDslElementImpl.resolveReferenceInPropertiesFile(parentDslFile, String.join((CharSequence)".", referenceText));
            if (propertyElement == null) continue;
            return propertyElement;
        }
        return null;
    }

    @Nullable
    private static GradleDslElement resolveReferenceInSameModule(@NotNull GradleDslElement startElement, @NotNull List<String> referenceText, GradleDslNameConverter converter, boolean resolveWithOrder) {
        GradleDslFile parentModuleDslFile;
        GradleDslElement bsElement;
        GradleDslElement element;
        if (startElement == null) {
            GradleDslElementImpl.$$$reportNull$$$0(46);
        }
        if (referenceText == null) {
            GradleDslElementImpl.$$$reportNull$$$0(47);
        }
        if ((element = GradleDslElementImpl.resolveReferenceOnElement(startElement, referenceText, converter, resolveWithOrder, true, startElement.getNameElement().fullNameParts().size())) != null) {
            return element;
        }
        String text = String.join((CharSequence)".", referenceText);
        GradleDslFile dslFile = startElement.getDslFile();
        GradleDslElement propertyElement = GradleDslElementImpl.resolveReferenceInPropertiesFile(dslFile, text);
        if (propertyElement != null) {
            return propertyElement;
        }
        BuildScriptDslElement bsDslElement = dslFile.getPropertyElement(BuildScriptDslElement.BUILDSCRIPT);
        if (bsDslElement != null && (bsElement = GradleDslElementImpl.resolveReferenceOnElement(bsDslElement, referenceText, converter, false, true, -1)) != null) {
            return bsElement;
        }
        if (dslFile.getParentModuleDslFile() == null) {
            return null;
        }
        GradleDslFile rootProjectDslFile = dslFile;
        while ((parentModuleDslFile = rootProjectDslFile.getParentModuleDslFile()) != null) {
            rootProjectDslFile = parentModuleDslFile;
        }
        return GradleDslElementImpl.resolveReferenceInPropertiesFile(rootProjectDslFile, text);
    }

    @Override
    @Nullable
    public GradleDslElement resolveExternalSyntaxReference(@NotNull String referenceText, boolean resolveWithOrder) {
        if (referenceText == null) {
            GradleDslElementImpl.$$$reportNull$$$0(48);
        }
        GradleDslElementImpl searchStartElement = this;
        GradleDslParser parser = this.getDslFile().getParser();
        referenceText = parser.convertReferenceText(searchStartElement, referenceText);
        return this.resolveInternalSyntaxReference(referenceText, resolveWithOrder);
    }

    @Override
    @Nullable
    public GradleDslElement resolveInternalSyntaxReference(@NotNull String referenceText, boolean resolveWithOrder) {
        GradleDslFile dslFile;
        int index;
        if (referenceText == null) {
            GradleDslElementImpl.$$$reportNull$$$0(49);
        }
        GradleDslElementImpl searchStartElement = this;
        GradleDslParser parser = this.getDslFile().getParser();
        boolean withinBuildscript = false;
        GradleDslElement element = this;
        while (element != null) {
            if (!((element = element.getParent()) instanceof BuildScriptDslElement)) continue;
            withinBuildscript = true;
            break;
        }
        List<String> referenceTextSegments = GradleNameElementUtil.split(referenceText);
        int segmentCount = referenceTextSegments.size();
        for (index = 0; index < segmentCount && (dslFile = GradleDslElementImpl.resolveProjectReference(searchStartElement, referenceTextSegments.get(index))) != null; ++index) {
            searchStartElement = dslFile;
        }
        GradleDslElement resolvedElement = null;
        GradleDslFile dslFile2 = searchStartElement.getDslFile();
        if (index >= segmentCount) {
            resolvedElement = searchStartElement;
        } else {
            referenceTextSegments = referenceTextSegments.subList(index, segmentCount);
            if (dslFile2 == searchStartElement && withinBuildscript) {
                searchStartElement = dslFile2.getPropertyElement(BuildScriptDslElement.BUILDSCRIPT);
            }
            if (searchStartElement != null) {
                resolvedElement = GradleDslElementImpl.resolveReferenceInSameModule(searchStartElement, referenceTextSegments, parser, resolveWithOrder);
            }
        }
        if (resolvedElement == null) {
            resolvedElement = GradleDslElementImpl.resolveReferenceInParentModules(dslFile2, referenceTextSegments, parser);
        }
        return resolvedElement;
    }

    @Nullable
    private static GradleDslFile resolveProjectReference(GradleDslElement startElement, @NotNull String projectReference) {
        GradleDslFile dslFile;
        if (projectReference == null) {
            GradleDslElementImpl.$$$reportNull$$$0(50);
        }
        if ("project".equals(projectReference)) {
            return dslFile;
        }
        if ("parent".equals(projectReference)) {
            return dslFile.getParentModuleDslFile();
        }
        if ("rootProject".equals(projectReference)) {
            for (dslFile = startElement.getDslFile(); dslFile != null && !FileUtil.filesEqual((File)dslFile.getDirectoryPath(), (File)VfsUtilCore.virtualToIoFile((VirtualFile)dslFile.getProject().getBaseDir())); dslFile = dslFile.getParentModuleDslFile()) {
            }
            return dslFile;
        }
        String standardProjectKey = ProjectPropertiesDslElement.getStandardProjectKey(projectReference);
        if (standardProjectKey != null) {
            String modulePath = standardProjectKey.substring(standardProjectKey.indexOf(39) + 1, standardProjectKey.lastIndexOf(39));
            VirtualFile settingFile = dslFile.tryToFindSettingsFile();
            if (settingFile == null) {
                return null;
            }
            GradleSettingsFile file = dslFile.getContext().getOrCreateSettingsFile(settingFile);
            GradleSettingsModelImpl model = new GradleSettingsModelImpl(file);
            File moduleDirectory = model.moduleDirectory(modulePath);
            if (moduleDirectory == null) {
                return null;
            }
            while (dslFile != null && !FileUtil.filesEqual((File)dslFile.getDirectoryPath(), (File)VfsUtilCore.virtualToIoFile((VirtualFile)dslFile.getProject().getBaseDir()))) {
                dslFile = dslFile.getParentModuleDslFile();
            }
            if (dslFile == null) {
                return null;
            }
            return GradleDslElementImpl.findDslFile(dslFile, moduleDirectory);
        }
        return null;
    }

    @NotNull
    private static String stripQuotes(@NotNull String index) {
        if (index == null) {
            GradleDslElementImpl.$$$reportNull$$$0(51);
        }
        if (index.startsWith(SINGLE_QUOTES) && index.endsWith(SINGLE_QUOTES) || index.startsWith(DOUBLE_QUOTES) && index.endsWith(DOUBLE_QUOTES)) {
            String string = index.substring(1, index.length() - 1);
            if (string == null) {
                GradleDslElementImpl.$$$reportNull$$$0(52);
            }
            return string;
        }
        String string = index;
        if (string == null) {
            GradleDslElementImpl.$$$reportNull$$$0(53);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 32: 
            case 52: 
            case 53: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 32: 
            case 52: 
            case 53: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closureElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 32: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslElementImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchicalName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntax";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyType";
                break;
            }
            case 19: 
            case 33: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injection";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldElement";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 34: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameParts";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildDslFile";
                break;
            }
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceText";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dslFile";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslElementImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameElement";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getHolders";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalSyntax";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDslFile";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedVariables";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainedElements";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getInScopeElements";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "notification";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalToModelMap";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "stripQuotes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setParsedClosureElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 32: 
            case 52: 
            case 53: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setParent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addHolder";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setExternalSyntax";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setElementType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "requestAnchor";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "notification";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "registerDependent";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "unregisterDependent";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "updateDependenciesOnAddElement";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "updateDependenciesOnReplaceElement";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "updateDependenciesOnRemoveElement";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getPsiText";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getExternalToModelMap";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "dereference";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "extractElementFromProperties";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceOnPropertiesElement";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceOnElement";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceInPropertiesFile";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceInParentModules";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceInSameModule";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "resolveExternalSyntaxReference";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "resolveInternalSyntaxReference";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "resolveProjectReference";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "stripQuotes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 32: 
            case 52: 
            case 53: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

