/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.configure;

import com.android.tools.idea.gradle.model.IdeDependencies;
import com.android.tools.idea.gradle.model.IdeModuleLibrary;
import com.android.tools.idea.gradle.model.java.JavaModuleDependency;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.util.ContentEntries;
import com.android.tools.idea.io.FilePaths;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.android.common.configure.AbstractKotlinAndroidGradleMPPModuleDataService;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tH\u0016J\u001f\u0010\n\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\f2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000eH\u0002J<\u0010\u0010\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e0\u00112\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u001f\u0010\u0018\u001a\t\u0018\u00010\u0019\u00a2\u0006\u0002\b\f2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000eH\u0002J\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0018\u0010\u001d\u001a\u00020\u00172\u000e\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000eH\u0016J\u0015\u0010\u001e\u001a\u00070\u001b\u00a2\u0006\u0002\b\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/android/configure/KotlinAndroidGradleMPPModuleDataService;", "Lorg/jetbrains/kotlin/android/common/configure/AbstractKotlinAndroidGradleMPPModuleDataService;", "()V", "findParentContentEntry", "Lcom/intellij/openapi/roots/ContentEntry;", "Lorg/jetbrains/annotations/Nullable;", "path", "Ljava/io/File;", "contentEntries", "Ljava/util/stream/Stream;", "getAndroidModuleModel", "Lcom/android/tools/idea/gradle/project/model/AndroidModuleModel;", "Lorg/jetbrains/annotations/NotNull;", "moduleNode", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "getDependencyModuleNodes", "", "indexedModules", "Lorg/jetbrains/kotlin/android/common/configure/AbstractKotlinAndroidGradleMPPModuleDataService$IndexedModules;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "testScope", "", "getJavaModuleModel", "Lcom/android/tools/idea/gradle/project/model/JavaModuleModel;", "getVariantName", "", "node", "isAndroidModule", "pathToIdeaUrl", "intellij.android.kotlin.idea"})
public final class KotlinAndroidGradleMPPModuleDataService
extends AbstractKotlinAndroidGradleMPPModuleDataService {
    @Override
    @Nullable
    public String getVariantName(@NotNull DataNode<ModuleData> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        AndroidModuleModel androidModuleModel = this.getAndroidModuleModel(node);
        return androidModuleModel != null && (androidModuleModel = androidModuleModel.getSelectedVariant()) != null ? androidModuleModel.getName() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<DataNode<? extends ModuleData>> getDependencyModuleNodes(@NotNull DataNode<ModuleData> moduleNode, @NotNull AbstractKotlinAndroidGradleMPPModuleDataService.IndexedModules indexedModules, @NotNull IdeModifiableModelsProvider modelsProvider, boolean testScope) {
        Intrinsics.checkNotNullParameter(moduleNode, (String)"moduleNode");
        Intrinsics.checkNotNullParameter((Object)indexedModules, (String)"indexedModules");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        AndroidModuleModel androidModel = this.getAndroidModuleModel(moduleNode);
        if (androidModel != null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            IdeDependencies ideDependencies = testScope ? androidModel.getSelectedAndroidTestCompileDependencies() : androidModel.getSelectedMainCompileLevel2Dependencies();
            if (ideDependencies == null) {
                return CollectionsKt.emptyList();
            }
            Intrinsics.checkNotNullExpressionValue((Object)ideDependencies, (String)"if (testScope) {\n       \u2026  } ?: return emptyList()");
            IdeDependencies dependencies = ideDependencies;
            Iterable iterable = dependencies.getModuleDependencies();
            boolean $i$f$mapNotNull = false;
            void var9_12 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                DataNode<ModuleData> dataNode;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                IdeModuleLibrary it = (IdeModuleLibrary)element$iv$iv;
                boolean bl2 = false;
                Map<String, DataNode<ModuleData>> map = indexedModules.getById();
                String string = it.getProjectPath();
                Intrinsics.checkNotNull((Object)string);
                DataNode<ModuleData> dataNode2 = map.get(string);
                if (dataNode2 == null) continue;
                DataNode<ModuleData> it$iv$iv = dataNode = dataNode2;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        JavaModuleModel javaModel = this.getJavaModuleModel(moduleNode);
        if (javaModel != null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            JavaModuleDependency it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            String scope = testScope ? DependencyScope.TEST.name() : DependencyScope.COMPILE.name();
            Collection collection = javaModel.getJavaModuleDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"javaModel\n                .javaModuleDependencies");
            Iterable $i$f$mapNotNull = collection;
            boolean $i$f$filter = false;
            void destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (JavaModuleDependency)element$iv$iv;
                boolean bl = false;
                JavaModuleDependency javaModuleDependency = it;
                Intrinsics.checkNotNullExpressionValue((Object)javaModuleDependency, (String)"it");
                String string = javaModuleDependency.getScope();
                if (string == null) {
                    string = DependencyScope.COMPILE.name();
                }
                if (!Intrinsics.areEqual((Object)scope, (Object)string)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (JavaModuleDependency)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl = false;
                JavaModuleDependency javaModuleDependency = it;
                Intrinsics.checkNotNullExpressionValue((Object)javaModuleDependency, (String)"it");
                String string = javaModuleDependency.getModuleName();
                collection2.add(string);
            }
            $this$map$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv2));
            boolean $i$f$mapNotNull2 = false;
            $this$mapTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                DataNode<ModuleData> dataNode;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it2 = (String)element$iv$iv;
                boolean bl4 = false;
                DataNode<ModuleData> dataNode3 = indexedModules.getByIdeName().get(it2);
                if (dataNode3 == null) continue;
                DataNode<ModuleData> it$iv$iv = dataNode = dataNode3;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            return (List)destination$iv$iv2;
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean isAndroidModule(@NotNull DataNode<? extends ModuleData> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        return this.getAndroidModuleModel(node) != null;
    }

    private final AndroidModuleModel getAndroidModuleModel(DataNode<? extends ModuleData> moduleNode) {
        Collection collection = ExternalSystemApiUtil.getChildren(moduleNode, (Key)AndroidProjectKeys.ANDROID_MODEL);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"ExternalSystemApiUtil.ge\u2026rojectKeys.ANDROID_MODEL)");
        DataNode dataNode = (DataNode)CollectionsKt.firstOrNull((Iterable)collection);
        return dataNode != null ? (AndroidModuleModel)dataNode.getData() : null;
    }

    private final JavaModuleModel getJavaModuleModel(DataNode<? extends ModuleData> moduleNode) {
        Collection collection = ExternalSystemApiUtil.getChildren(moduleNode, (Key)AndroidProjectKeys.JAVA_MODULE_MODEL);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"ExternalSystemApiUtil.ge\u2026ctKeys.JAVA_MODULE_MODEL)");
        DataNode dataNode = (DataNode)CollectionsKt.firstOrNull((Iterable)collection);
        return dataNode != null ? (JavaModuleModel)dataNode.getData() : null;
    }

    @Override
    @Nullable
    public ContentEntry findParentContentEntry(@NotNull File path, @NotNull Stream<ContentEntry> contentEntries) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(contentEntries, (String)"contentEntries");
        return ContentEntries.findParentContentEntry((File)path, contentEntries);
    }

    @Override
    @NotNull
    public String pathToIdeaUrl(@NotNull File path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = FilePaths.pathToIdeaUrl((File)path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FilePaths.pathToIdeaUrl(path)");
        return string;
    }
}

