/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.fragments.loginFragment.src.app_package.ui.login;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"loginViewModelKt", "", "packageName", "useAndroidX", "", "intellij.android.wizardTemplate.impl"})
public final class LoginViewModelKtKt {
    @NotNull
    public static final String loginViewModelKt(@NotNull String packageName, boolean useAndroidX) {
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        return "\npackage " + TemplateHelpersKt.escapeKotlinIdentifier(packageName) + ".ui.login\n\nimport " + TemplateHelpersKt.getMaterialComponentName("android.arch.lifecycle.LiveData", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.arch.lifecycle.MutableLiveData", useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName("android.arch.lifecycle.ViewModel", useAndroidX) + "\nimport android.util.Patterns\nimport " + TemplateHelpersKt.escapeKotlinIdentifier(packageName) + ".data.LoginRepository\nimport " + TemplateHelpersKt.escapeKotlinIdentifier(packageName) + ".data.Result\n\nimport " + packageName + ".R\n\nclass LoginViewModel(private val loginRepository: LoginRepository) : ViewModel() {\n\n    private val _loginForm = MutableLiveData<LoginFormState>()\n    val loginFormState: LiveData<LoginFormState> = _loginForm\n\n    private val _loginResult = MutableLiveData<LoginResult>()\n    val loginResult: LiveData<LoginResult> = _loginResult\n\n    fun login(username: String, password: String) {\n        // can be launched in a separate asynchronous job\n        val result = loginRepository.login(username, password)\n\n        if (result is Result.Success) {\n            _loginResult.value = LoginResult(success = LoggedInUserView(displayName = result.data.displayName))\n        } else {\n            _loginResult.value = LoginResult(error = R.string.login_failed)\n        }\n    }\n\n    fun loginDataChanged(username: String, password: String) {\n        if (!isUserNameValid(username)) {\n            _loginForm.value = LoginFormState(usernameError = R.string.invalid_username)\n        } else if (!isPasswordValid(password)) {\n            _loginForm.value = LoginFormState(passwordError = R.string.invalid_password)\n        } else {\n            _loginForm.value = LoginFormState(isDataValid = true)\n        }\n    }\n\n    // A placeholder username validation check\n    private fun isUserNameValid(username: String): Boolean {\n        return if (username.contains(\"@\")) {\n            Patterns.EMAIL_ADDRESS.matcher(username).matches()\n        } else {\n            username.isNotBlank()\n        }\n    }\n\n    // A placeholder password validation check\n    private fun isPasswordValid(password: String): Boolean {\n        return password.length > 5\n    }\n}\n";
    }
}

