/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.actions.column;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.editor.tables.actions.TableActionKeys;
import org.intellij.plugins.markdown.editor.tables.actions.column.ColumnBasedTableAction;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b \u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001f\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J0\u0010\u0010\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\bH$J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J)\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\bH\u0014\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/ColumnBasedTableAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "findColumnIndex", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;)Ljava/lang/Integer;", "findTable", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;", "findTableAndIndex", "Lkotlin/Pair;", "performAction", "table", "columnIndex", "update", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;Ljava/lang/Integer;)V", "Companion", "intellij.markdown.core"})
public abstract class ColumnBasedTableAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent event) {
        void table;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = event.getRequiredData(CommonDataKeys.EDITOR);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"event.getRequiredData(CommonDataKeys.EDITOR)");
        Editor editor2 = (Editor)object;
        Object object2 = event.getRequiredData(CommonDataKeys.PSI_FILE);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"event.getRequiredData(CommonDataKeys.PSI_FILE)");
        PsiFile file = (PsiFile)object2;
        Object object3 = this.findTableAndIndex(event, file, editor2);
        MarkdownTable markdownTable = (MarkdownTable)object3.component1();
        Integer columnIndex = (Integer)object3.component2();
        if (table == null) {
            object3 = "Required value was null.";
            throw new IllegalArgumentException(object3.toString());
        }
        if (columnIndex == null) {
            object3 = "Required value was null.";
            throw new IllegalArgumentException(object3.toString());
        }
        this.performAction(editor2, (MarkdownTable)table, columnIndex);
    }

    /*
     * WARNING - void declaration
     */
    public void update(@NotNull AnActionEvent event) {
        void table;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        Editor editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        if (project == null || editor2 == null || file == null) {
            Presentation presentation = event.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"event.presentation");
            presentation.setEnabledAndVisible(false);
            return;
        }
        Pair<MarkdownTable, Integer> pair = this.findTableAndIndex(event, file, editor2);
        MarkdownTable markdownTable = (MarkdownTable)pair.component1();
        Integer columnIndex = (Integer)pair.component2();
        Presentation presentation = event.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"event.presentation");
        presentation.setEnabledAndVisible(table != null && columnIndex != null);
        this.update(event, (MarkdownTable)table, columnIndex);
    }

    protected abstract void performAction(@NotNull Editor var1, @NotNull MarkdownTable var2, int var3);

    protected void update(@NotNull AnActionEvent event, @Nullable MarkdownTable table, @Nullable Integer columnIndex) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    private final Pair<MarkdownTable, Integer> findTableAndIndex(AnActionEvent event, PsiFile file, Editor editor2) {
        return Companion.findTableAndIndex(event, file, editor2, (Function2<? super PsiFile, ? super Editor, ? extends MarkdownTable>)((Function2)new Function2<PsiFile, Editor, MarkdownTable>(this){

            @Nullable
            public final MarkdownTable invoke(@NotNull PsiFile p1, @NotNull Editor p2) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                return ((ColumnBasedTableAction)((Object)this.receiver)).findTable(p1, p2);
            }
        }), (Function2<? super PsiFile, ? super Editor, Integer>)((Function2)new Function2<PsiFile, Editor, Integer>(this){

            @Nullable
            public final Integer invoke(@NotNull PsiFile p1, @NotNull Editor p2) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                return ((ColumnBasedTableAction)((Object)this.receiver)).findColumnIndex(p1, p2);
            }
        }));
    }

    @Nullable
    protected MarkdownTable findTable(@NotNull PsiFile file, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        Caret caret = caretModel.getCurrentCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"editor.caretModel.currentCaret");
        return TableUtils.findTable(file, caret.getOffset());
    }

    @Nullable
    protected Integer findColumnIndex(@NotNull PsiFile file, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        Caret caret = caretModel.getCurrentCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"editor.caretModel.currentCaret");
        return TableUtils.findCellIndex(file, caret.getOffset());
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJf\u0010\u0003\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u001a\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000e2\u001a\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u000e\u00a8\u0006\u0010"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/ColumnBasedTableAction$Companion;", "", "()V", "findTableAndIndex", "Lkotlin/Pair;", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "tableGetter", "Lkotlin/Function2;", "columnIndexGetter", "intellij.markdown.core"})
    public static final class Companion {
        @NotNull
        public final Pair<MarkdownTable, Integer> findTableAndIndex(@NotNull AnActionEvent event, @NotNull PsiFile file, @NotNull Editor editor2, @NotNull Function2<? super PsiFile, ? super Editor, ? extends MarkdownTable> tableGetter, @NotNull Function2<? super PsiFile, ? super Editor, Integer> columnIndexGetter) {
            MarkdownTable markdownTable;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter(tableGetter, (String)"tableGetter");
            Intrinsics.checkNotNullParameter(columnIndexGetter, (String)"columnIndexGetter");
            WeakReference weakReference = (WeakReference)event.getData(TableActionKeys.INSTANCE.getELEMENT());
            Object object = weakReference != null ? (PsiElement)weakReference.get() : null;
            if (!(object instanceof MarkdownTable)) {
                object = null;
            }
            MarkdownTable tableFromEvent = (MarkdownTable)object;
            Integer indexFromEvent = (Integer)event.getData(TableActionKeys.INSTANCE.getCOLUMN_INDEX());
            if (tableFromEvent != null && indexFromEvent != null) {
                return TuplesKt.to((Object)tableFromEvent, (Object)indexFromEvent);
            }
            MarkdownTable markdownTable2 = (MarkdownTable)tableGetter.invoke((Object)file, (Object)editor2);
            if (markdownTable2 != null) {
                MarkdownTable markdownTable3;
                MarkdownTable it = markdownTable3 = markdownTable2;
                boolean bl = false;
                markdownTable = it.isValid() ? markdownTable3 : null;
            } else {
                markdownTable = null;
            }
            MarkdownTable table = markdownTable;
            Integer index = (Integer)columnIndexGetter.invoke((Object)file, (Object)editor2);
            return TuplesKt.to((Object)table, (Object)index);
        }

        @NotNull
        public final Pair<MarkdownTable, Integer> findTableAndIndex(@NotNull AnActionEvent event, @NotNull PsiFile file, @NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            return this.findTableAndIndex(event, file, editor2, (Function2<? super PsiFile, ? super Editor, ? extends MarkdownTable>)((Function2)findTableAndIndex.1.INSTANCE), (Function2<? super PsiFile, ? super Editor, Integer>)((Function2)findTableAndIndex.2.INSTANCE));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

