/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.handlers;

import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.editor.tables.TableFormattingUtils;
import org.intellij.plugins.markdown.editor.tables.TableModificationUtils;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.editor.tables.handlers.MarkdownTableBackspaceHandler$charDeleted$;
import org.intellij.plugins.markdown.lang.MarkdownFileType;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.intellij.plugins.markdown.settings.MarkdownSettings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/handlers/MarkdownTableBackspaceHandler;", "Lcom/intellij/codeInsight/editorActions/BackspaceHandlerDelegate;", "()V", "beforeCharDeleted", "", "c", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "charDeleted", "", "char", "updateSeparator", "document", "Lcom/intellij/openapi/editor/Document;", "separatorRange", "Lcom/intellij/openapi/util/TextRange;", "width", "", "intellij.markdown.core"})
public final class MarkdownTableBackspaceHandler
extends BackspaceHandlerDelegate {
    public void beforeCharDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
    }

    public boolean charDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor2) {
        MarkdownTableSeparatorRow markdownTableSeparatorRow;
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                if (!Registry.is((String)"markdown.tables.editing.support.enable")) break block8;
                Project project = file.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
                if (MarkdownSettings.Companion.getInstance(project).isEnhancedEditingEnabled()) break block9;
            }
            return false;
        }
        if (Intrinsics.areEqual((Object)file.getFileType(), (Object)((Object)MarkdownFileType.INSTANCE)) ^ true) {
            return false;
        }
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        Caret caret = caretModel.getCurrentCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"editor.caretModel.currentCaret");
        int caretOffset = caret.getOffset();
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        if (!TableUtils.isProbablyInsideTableCell(document2, caretOffset)) {
            return false;
        }
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document2);
        MarkdownTable markdownTable = TableUtils.findTable(file, caretOffset);
        if (markdownTable == null) {
            return false;
        }
        MarkdownTable table = markdownTable;
        Integer n = TableUtils.findCellIndex(file, caretOffset);
        if (n == null) {
            return false;
        }
        int cellIndex = n;
        Object object = TableUtils.INSTANCE.getSeparatorRow(table);
        if (object == null || (object = object.getCellAlignment(cellIndex)) == null) {
            return false;
        }
        Object alignment = object;
        MarkdownTableCell markdownTableCell = TableUtils.findCell(file, caretOffset);
        Integer n2 = markdownTableCell != null && (markdownTableCell = markdownTableCell.getTextRange()) != null ? Integer.valueOf(markdownTableCell.getLength()) : ((markdownTableSeparatorRow = TableUtils.INSTANCE.getSeparatorRow(table)) != null && (markdownTableSeparatorRow = MarkdownTableSeparatorRow.getCellRange$default(markdownTableSeparatorRow, cellIndex, false, 2, null)) != null ? Integer.valueOf(markdownTableSeparatorRow.getLength()) : null);
        int width = n2 != null ? n2 : 0;
        CharSequence charSequence = document2.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"document.charsSequence");
        CharSequence text = charSequence;
        Project project$iv = table.getProject();
        String name$iv = null;
        String groupId$iv = null;
        boolean $i$f$executeCommand = false;
        CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(this, table, cellIndex, document2, width, text, (MarkdownTableSeparatorRow.CellAlignment)((Object)alignment), file, caretOffset, c, editor2){
            final /* synthetic */ MarkdownTableBackspaceHandler this$0;
            final /* synthetic */ MarkdownTable $table$inlined;
            final /* synthetic */ int $cellIndex$inlined;
            final /* synthetic */ Document $document$inlined;
            final /* synthetic */ int $width$inlined;
            final /* synthetic */ CharSequence $text$inlined;
            final /* synthetic */ MarkdownTableSeparatorRow.CellAlignment $alignment$inlined;
            final /* synthetic */ PsiFile $file$inlined;
            final /* synthetic */ int $caretOffset$inlined;
            final /* synthetic */ char $char$inlined;
            final /* synthetic */ Editor $editor$inlined;
            {
                this.this$0 = markdownTableBackspaceHandler;
                this.$table$inlined = markdownTable;
                this.$cellIndex$inlined = n;
                this.$document$inlined = document;
                this.$width$inlined = n2;
                this.$text$inlined = charSequence;
                this.$alignment$inlined = cellAlignment;
                this.$file$inlined = psiFile;
                this.$caretOffset$inlined = n3;
                this.$char$inlined = c;
                this.$editor$inlined = editor2;
            }

            /*
             * Unable to fully structure code
             */
            public final void run() {
                block2: {
                    $i$a$-executeCommand-MarkdownTableBackspaceHandler$charDeleted$1 = false;
                    TableModificationUtils.INSTANCE.modifyColumn(this.$table$inlined, this.$cellIndex$inlined, (Function1<? super TextRange, Unit>)((Function1)new Function1<TextRange, Unit>(this){
                        final /* synthetic */ charDeleted$$inlined$executeCommand$1 this$0;
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }

                        public final void invoke(@NotNull TextRange it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            MarkdownTableBackspaceHandler.access$updateSeparator(this.this$0.this$0, this.this$0.$document$inlined, it, this.this$0.$width$inlined);
                        }
                    }), (Function1<? super MarkdownTableCell, Unit>)((Function1)new Function1<MarkdownTableCell, Unit>(this){
                        final /* synthetic */ charDeleted$$inlined$executeCommand$1 this$0;
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }

                        public final void invoke(@NotNull MarkdownTableCell cell) {
                            TextRange range;
                            Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
                            TextRange textRange = range = cell.getTextRange();
                            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"range");
                            if (textRange.getLength() > this.this$0.$width$inlined && this.this$0.$text$inlined.charAt(range.getEndOffset() - 1) == ' ' && this.this$0.$text$inlined.charAt(range.getEndOffset() - 2) == ' ') {
                                this.this$0.$document$inlined.deleteString(range.getEndOffset() - 1, range.getEndOffset());
                            }
                        }
                    }));
                    if (this.$alignment$inlined == MarkdownTableSeparatorRow.CellAlignment.NONE) break block2;
                    PsiDocumentManager.getInstance((Project)this.$file$inlined.getProject()).commitDocument(this.$document$inlined);
                    reparsedTable = TableUtils.findTable(this.$file$inlined, this.$caretOffset$inlined);
                    v0 = TableUtils.findCell(this.$file$inlined, this.$caretOffset$inlined);
                    if (v0 == null || (v0 = v0.getTextRange()) == null) ** GOTO lbl-1000
                    it = var3_3 = v0;
                    $i$a$-let-MarkdownTableBackspaceHandler$charDeleted$1$isBlank$1 = false;
                    var6_7 = this.$text$inlined;
                    var7_8 = it.getStartOffset();
                    v0 = var6_7.subSequence(var7_8, var8_9 = it.getEndOffset()).toString();
                    if (v0 != null) {
                        v1 = StringsKt.isBlank((CharSequence)((CharSequence)v0));
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = true;
                    }
                    isBlank = v1;
                    shouldPreventExpand = isBlank != false && this.$char$inlined == ' ';
                    v2 = reparsedTable;
                    if (v2 == null) break block2;
                    v3 = this.$editor$inlined.getCaretModel();
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"editor.caretModel");
                    v4 = v3.getAllCarets();
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"editor.caretModel.allCarets");
                    TableFormattingUtils.INSTANCE.reformatColumnOnChange(v2, this.$document$inlined, v4, this.$cellIndex$inlined, false, shouldPreventExpand);
                }
            }
        }, name$iv, (Object)groupId$iv);
        return true;
    }

    private final void updateSeparator(Document document, TextRange separatorRange, int width) {
        CharSequence charSequence = document.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"document.charsSequence");
        CharSequence text = charSequence;
        if (separatorRange.getLength() > width) {
            int n;
            int endOffset = separatorRange.getEndOffset();
            if (text.charAt(endOffset - 1) == '-') {
                n = separatorRange.getEndOffset() - 1;
            } else if (text.charAt(endOffset - 2) == '-') {
                n = separatorRange.getEndOffset() - 2;
            } else {
                return;
            }
            int offset = n;
            document.deleteString(offset, offset + 1);
        }
    }

    public static final /* synthetic */ void access$updateSeparator(MarkdownTableBackspaceHandler $this, Document document, TextRange separatorRange, int width) {
        $this.updateSeparator(document, separatorRange, width);
    }
}

