/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.handlers;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.editor.tables.TableFormattingUtils;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.lang.MarkdownFileType;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.settings.MarkdownSettings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/handlers/MarkdownTableTypedHandler;", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate;", "()V", "charTyped", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "char", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "intellij.markdown.core"})
public final class MarkdownTableTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!Registry.is((String)"markdown.tables.editing.support.enable") || !MarkdownSettings.Companion.getInstance(project).isEnhancedEditingEnabled()) {
            TypedHandlerDelegate.Result result = super.charTyped(c, project, editor2, file);
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"super.charTyped(char, project, editor, file)");
            return result;
        }
        if (Intrinsics.areEqual((Object)file.getFileType(), (Object)((Object)MarkdownFileType.INSTANCE)) ^ true) {
            TypedHandlerDelegate.Result result = super.charTyped(c, project, editor2, file);
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"super.charTyped(char, project, editor, file)");
            return result;
        }
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        Caret caret = caretModel.getCurrentCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"editor.caretModel.currentCaret");
        int caretOffset = caret.getOffset();
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        if (!TableUtils.isProbablyInsideTableCell(document2, caretOffset)) {
            TypedHandlerDelegate.Result result = super.charTyped(c, project, editor2, file);
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"super.charTyped(char, project, editor, file)");
            return result;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document2);
        MarkdownTable table = TableUtils.findTable(file, caretOffset);
        Integer cellIndex = TableUtils.findCellIndex(file, caretOffset);
        if (table == null || cellIndex == null) {
            TypedHandlerDelegate.Result result = super.charTyped(c, project, editor2, file);
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"super.charTyped(char, project, editor, file)");
            return result;
        }
        String name$iv = null;
        String groupId$iv = null;
        boolean $i$f$executeCommand = false;
        CommandProcessor.getInstance().executeCommand(project, new Runnable(table, document2, editor2, cellIndex){
            final /* synthetic */ MarkdownTable $table$inlined;
            final /* synthetic */ Document $document$inlined;
            final /* synthetic */ Editor $editor$inlined;
            final /* synthetic */ Integer $cellIndex$inlined;
            {
                this.$table$inlined = markdownTable;
                this.$document$inlined = document;
                this.$editor$inlined = editor2;
                this.$cellIndex$inlined = n;
            }

            public final void run() {
                boolean bl = false;
                CaretModel caretModel = this.$editor$inlined.getCaretModel();
                Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
                List list2 = caretModel.getAllCarets();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"editor.caretModel.allCarets");
                TableFormattingUtils.reformatColumnOnChange$default(TableFormattingUtils.INSTANCE, this.$table$inlined, this.$document$inlined, list2, this.$cellIndex$inlined, true, false, 16, null);
            }
        }, name$iv, (Object)groupId$iv);
        return TypedHandlerDelegate.Result.STOP;
    }
}

