/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.google.accounts;

import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.collaboration.auth.AccountDetails;
import com.intellij.collaboration.auth.ui.LoadingAccountsDetailsProvider;
import com.intellij.collaboration.util.ProgressIndicatorsProvider;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.google.GoogleAuthorizedUserException;
import org.intellij.plugins.markdown.google.accounts.GoogleAccountManager;
import org.intellij.plugins.markdown.google.accounts.GoogleAccountsListModel;
import org.intellij.plugins.markdown.google.accounts.GoogleUserInfoService;
import org.intellij.plugins.markdown.google.accounts.data.GoogleAccount;
import org.intellij.plugins.markdown.google.accounts.data.GoogleUserDetailed;
import org.intellij.plugins.markdown.google.accounts.data.GoogleUserInfo;
import org.intellij.plugins.markdown.google.authorization.GoogleCredentials;
import org.intellij.plugins.markdown.google.authorization.GoogleOAuthService;
import org.intellij.plugins.markdown.google.utils.GoogleAccountsUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u001e2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u001eB-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0003J,\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00100\u00152\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0003J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0002J$\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00100\u00152\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0019H\u0017J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountsDetailsProvider;", "Lcom/intellij/collaboration/auth/ui/LoadingAccountsDetailsProvider;", "Lorg/intellij/plugins/markdown/google/accounts/data/GoogleAccount;", "Lorg/intellij/plugins/markdown/google/accounts/data/GoogleUserDetailed;", "progressIndicatorsProvider", "Lcom/intellij/collaboration/util/ProgressIndicatorsProvider;", "accountManager", "Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountManager;", "accountsListModel", "Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountsListModel;", "oAuthService", "Lorg/intellij/plugins/markdown/google/authorization/GoogleOAuthService;", "userInfoService", "Lorg/intellij/plugins/markdown/google/accounts/GoogleUserInfoService;", "(Lcom/intellij/collaboration/util/ProgressIndicatorsProvider;Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountManager;Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountsListModel;Lorg/intellij/plugins/markdown/google/authorization/GoogleOAuthService;Lorg/intellij/plugins/markdown/google/accounts/GoogleUserInfoService;)V", "failedToLoadInfo", "Lcom/intellij/collaboration/auth/ui/LoadingAccountsDetailsProvider$DetailsLoadingResult;", "getUserCredentials", "Lorg/intellij/plugins/markdown/google/authorization/GoogleCredentials;", "account", "loadDetails", "Ljava/util/concurrent/CompletableFuture;", "userInfo", "Lorg/intellij/plugins/markdown/google/accounts/data/GoogleUserInfo;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "noCredentials", "scheduleLoad", "indicator", "unauthenticatedUser", "Companion", "intellij.markdown.core"})
public final class GoogleAccountsDetailsProvider
extends LoadingAccountsDetailsProvider<GoogleAccount, GoogleUserDetailed> {
    private final GoogleAccountManager accountManager;
    private final GoogleAccountsListModel accountsListModel;
    private final GoogleOAuthService oAuthService;
    private final GoogleUserInfoService userInfoService;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @RequiresEdt
    @NotNull
    public CompletableFuture<LoadingAccountsDetailsProvider.DetailsLoadingResult<GoogleUserDetailed>> scheduleLoad(@NotNull GoogleAccount account, @NotNull ProgressIndicator indicator) {
        GoogleCredentials googleCredentials;
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        try {
            GoogleCredentials googleCredentials2 = this.getUserCredentials(account);
            if (googleCredentials2 == null) {
                CompletableFuture<LoadingAccountsDetailsProvider.DetailsLoadingResult<GoogleUserDetailed>> completableFuture = CompletableFuture.completedFuture(this.noCredentials());
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.completedFuture(noCredentials())");
                return completableFuture;
            }
            googleCredentials = googleCredentials2;
        }
        catch (TimeoutException e) {
            CompletableFuture<LoadingAccountsDetailsProvider.DetailsLoadingResult<GoogleUserDetailed>> completableFuture = CompletableFuture.completedFuture(this.failedToLoadInfo());
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.comple\u2026uture(failedToLoadInfo())");
            return completableFuture;
        }
        GoogleCredentials credentials = googleCredentials;
        CompletionStage completionStage = ((CompletableFuture)this.userInfoService.acquireUserInfo(credentials.getAccessToken(), indicator).thenCompose(new Function(this, account, indicator){
            final /* synthetic */ GoogleAccountsDetailsProvider this$0;
            final /* synthetic */ GoogleAccount $account;
            final /* synthetic */ ProgressIndicator $indicator;

            public final CompletionStage<LoadingAccountsDetailsProvider.DetailsLoadingResult<GoogleUserDetailed>> apply(GoogleUserInfo userInfo) {
                GoogleUserInfo googleUserInfo = userInfo;
                Intrinsics.checkNotNullExpressionValue((Object)googleUserInfo, (String)"userInfo");
                return GoogleAccountsDetailsProvider.access$loadDetails(this.this$0, this.$account, googleUserInfo, this.$indicator);
            }
            {
                this.this$0 = googleAccountsDetailsProvider;
                this.$account = googleAccount;
                this.$indicator = progressIndicator;
            }
        })).exceptionally(new Function(this){
            final /* synthetic */ GoogleAccountsDetailsProvider this$0;

            public final LoadingAccountsDetailsProvider.DetailsLoadingResult<GoogleUserDetailed> apply(Throwable it) {
                LoadingAccountsDetailsProvider.DetailsLoadingResult detailsLoadingResult;
                Throwable throwable = it.getCause();
                if (throwable instanceof GoogleAuthorizedUserException) {
                    detailsLoadingResult = GoogleAccountsDetailsProvider.access$unauthenticatedUser(this.this$0);
                } else if (throwable instanceof UnrecognizedPropertyException) {
                    Logger logger = GoogleAccountsDetailsProvider.access$getLOG$cp();
                    Throwable throwable2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)throwable2, (String)"it");
                    logger.debug(throwable2.getLocalizedMessage());
                    detailsLoadingResult = GoogleAccountsDetailsProvider.access$failedToLoadInfo(this.this$0);
                } else {
                    detailsLoadingResult = GoogleAccountsDetailsProvider.access$failedToLoadInfo(this.this$0);
                }
                return detailsLoadingResult;
            }
            {
                this.this$0 = googleAccountsDetailsProvider;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"userInfoService.acquireU\u2026oLoadInfo()\n      }\n    }");
        return completionStage;
    }

    @RequiresEdt
    private final CompletableFuture<LoadingAccountsDetailsProvider.DetailsLoadingResult<GoogleUserDetailed>> loadDetails(GoogleAccount account, GoogleUserInfo userInfo, ProgressIndicator progressIndicator) {
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
        return CompletableFutureUtil.INSTANCE.successOnEdt(CompletableFutureUtil.INSTANCE.submitIOTask(progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, LoadingAccountsDetailsProvider.DetailsLoadingResult<GoogleUserDetailed>>(userInfo){
            final /* synthetic */ GoogleUserInfo $userInfo;

            @NotNull
            public final LoadingAccountsDetailsProvider.DetailsLoadingResult<GoogleUserDetailed> invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                URL url = new URL(this.$userInfo.getPicture());
                BufferedImage image = ImageIO.read(url);
                GoogleUserDetailed details = new GoogleUserDetailed(this.$userInfo.getName(), this.$userInfo.getId(), this.$userInfo.getGivenName(), this.$userInfo.getFamilyName(), this.$userInfo.getLocale());
                return new LoadingAccountsDetailsProvider.DetailsLoadingResult((AccountDetails)details, (Image)image, null, false);
            }
            {
                this.$userInfo = googleUserInfo;
                super(1);
            }
        }), ModalityState.any(), (Function1)new Function1<LoadingAccountsDetailsProvider.DetailsLoadingResult<GoogleUserDetailed>, LoadingAccountsDetailsProvider.DetailsLoadingResult<GoogleUserDetailed>>(this, account){
            final /* synthetic */ GoogleAccountsDetailsProvider this$0;
            final /* synthetic */ GoogleAccount $account;

            @NotNull
            public final LoadingAccountsDetailsProvider.DetailsLoadingResult<GoogleUserDetailed> invoke(@NotNull LoadingAccountsDetailsProvider.DetailsLoadingResult<GoogleUserDetailed> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                GoogleAccountsDetailsProvider.access$getAccountsListModel$p(this.this$0).getAccountsListModel().contentsChanged((Object)((Object)this.$account));
                return it;
            }
            {
                this.this$0 = googleAccountsDetailsProvider;
                this.$account = googleAccount;
                super(1);
            }
        });
    }

    @RequiresEdt
    private final GoogleCredentials getUserCredentials(GoogleAccount account) {
        Object object;
        Map map = this.accountsListModel.getNewCredentials();
        Object v = map.get((Object)account);
        if (v == null) {
            boolean bl = false;
            object = GoogleAccountsUtils.INSTANCE.getOrUpdateUserCredentials(this.oAuthService, this.accountManager, account);
        } else {
            object = v;
        }
        return (GoogleCredentials)object;
    }

    private final LoadingAccountsDetailsProvider.DetailsLoadingResult<GoogleUserDetailed> noCredentials() {
        return new LoadingAccountsDetailsProvider.DetailsLoadingResult(null, null, MarkdownBundle.message("markdown.google.accounts.token.missing", new Object[0]), true);
    }

    private final LoadingAccountsDetailsProvider.DetailsLoadingResult<GoogleUserDetailed> failedToLoadInfo() {
        return new LoadingAccountsDetailsProvider.DetailsLoadingResult(null, null, MarkdownBundle.message("markdown.google.accounts.failed.load.user", new Object[0]), true);
    }

    private final LoadingAccountsDetailsProvider.DetailsLoadingResult<GoogleUserDetailed> unauthenticatedUser() {
        return new LoadingAccountsDetailsProvider.DetailsLoadingResult(null, null, MarkdownBundle.message("markdown.google.accounts.user.unauthenticated.error", new Object[0]), true);
    }

    public GoogleAccountsDetailsProvider(@NotNull ProgressIndicatorsProvider progressIndicatorsProvider, @NotNull GoogleAccountManager accountManager, @NotNull GoogleAccountsListModel accountsListModel, @NotNull GoogleOAuthService oAuthService, @NotNull GoogleUserInfoService userInfoService) {
        Intrinsics.checkNotNullParameter((Object)progressIndicatorsProvider, (String)"progressIndicatorsProvider");
        Intrinsics.checkNotNullParameter((Object)((Object)accountManager), (String)"accountManager");
        Intrinsics.checkNotNullParameter((Object)((Object)accountsListModel), (String)"accountsListModel");
        Intrinsics.checkNotNullParameter((Object)((Object)oAuthService), (String)"oAuthService");
        Intrinsics.checkNotNullParameter((Object)userInfoService, (String)"userInfoService");
        super(progressIndicatorsProvider);
        this.accountManager = accountManager;
        this.accountsListModel = accountsListModel;
        this.oAuthService = oAuthService;
        this.userInfoService = userInfoService;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GoogleAccountsDetailsProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ CompletableFuture access$loadDetails(GoogleAccountsDetailsProvider $this, GoogleAccount account, GoogleUserInfo userInfo, ProgressIndicator progressIndicator) {
        return $this.loadDetails(account, userInfo, progressIndicator);
    }

    public static final /* synthetic */ LoadingAccountsDetailsProvider.DetailsLoadingResult access$unauthenticatedUser(GoogleAccountsDetailsProvider $this) {
        return $this.unauthenticatedUser();
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ LoadingAccountsDetailsProvider.DetailsLoadingResult access$failedToLoadInfo(GoogleAccountsDetailsProvider $this) {
        return $this.failedToLoadInfo();
    }

    public static final /* synthetic */ GoogleAccountsListModel access$getAccountsListModel$p(GoogleAccountsDetailsProvider $this) {
        return $this.accountsListModel;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountsDetailsProvider$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

