/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.injection;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.injection.MarkdownCodeFenceErrorHighlightingIntention;
import org.intellij.plugins.markdown.lang.MarkdownFileType;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFence;
import org.intellij.plugins.markdown.settings.MarkdownSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J%\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\b\u0010\u0012\u001a\u00020\u000fH\u0016\u00a8\u0006\u0015"}, d2={"Lorg/intellij/plugins/markdown/injection/MarkdownCodeFenceErrorHighlightingIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "()V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "setHideErrors", "hideErrors", "startInWriteAction", "CodeAnalyzerRestartListener", "CodeFenceHighlightErrorFilter", "intellij.markdown.core"})
public final class MarkdownCodeFenceErrorHighlightingIntention
implements IntentionAction {
    @NotNull
    public String getText() {
        String string = MarkdownBundle.message("markdown.hide.errors.intention.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026e.errors.intention.text\")");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor2, @Nullable PsiFile file) {
        PsiFile psiFile;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                PsiFile psiFile2 = file;
                if (Intrinsics.areEqual((Object)(psiFile2 != null ? psiFile2.getFileType() : null), (Object)((Object)MarkdownFileType.INSTANCE)) ^ true || MarkdownSettings.Companion.getInstance(project).getHideErrorsInCodeBlocks()) {
                    return false;
                }
                psiFile = file;
                if (psiFile == null) break block5;
                Editor editor3 = editor2;
                if (editor3 == null || (editor3 = editor3.getCaretModel()) == null) {
                    return false;
                }
                if ((psiFile = psiFile.findElementAt(editor3.getOffset())) != null) break block6;
            }
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"file?.findElementAt(edit\u2026rn false) ?: return false");
        PsiFile element2 = psiFile;
        return PsiTreeUtil.getParentOfType((PsiElement)element2, MarkdownCodeFence.class) != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor2, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.setHideErrors(project, true);
        Notification notification = new Notification("Markdown", MarkdownBundle.message("markdown.hide.errors.notification.title", new Object[0]), MarkdownBundle.message("markdown.hide.errors.notification.content", new Object[0]), NotificationType.INFORMATION);
        notification.addAction((AnAction)new NotificationAction(this, project, MarkdownBundle.message("markdown.hide.errors.notification.rollback.action.text", new Object[0])){
            final /* synthetic */ MarkdownCodeFenceErrorHighlightingIntention this$0;
            final /* synthetic */ Project $project;

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                MarkdownCodeFenceErrorHighlightingIntention.access$setHideErrors(this.this$0, this.$project, false);
                notification.expire();
            }
            {
                this.this$0 = this$0;
                this.$project = $captured_local_variable$1;
                super($super_call_param$2);
            }
        });
        notification.notify(project);
    }

    private final void setHideErrors(Project project, boolean hideErrors) {
        MarkdownSettings.Companion.getInstance(project).update((Function1<? super MarkdownSettings, Unit>)((Function1)new Function1<MarkdownSettings, Unit>(hideErrors){
            final /* synthetic */ boolean $hideErrors;

            public final void invoke(@NotNull MarkdownSettings it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                it.setHideErrorsInCodeBlocks(this.$hideErrors);
            }
            {
                this.$hideErrors = bl;
                super(1);
            }
        }));
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static final /* synthetic */ void access$setHideErrors(MarkdownCodeFenceErrorHighlightingIntention $this, Project project, boolean hideErrors) {
        $this.setHideErrors(project, hideErrors);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/injection/MarkdownCodeFenceErrorHighlightingIntention$CodeAnalyzerRestartListener;", "Lorg/intellij/plugins/markdown/settings/MarkdownSettings$ChangeListener;", "()V", "settingsChanged", "", "settings", "Lorg/intellij/plugins/markdown/settings/MarkdownSettings;", "intellij.markdown.core"})
    public static final class CodeAnalyzerRestartListener
    implements MarkdownSettings.ChangeListener {
        /*
         * WARNING - void declaration
         */
        @Override
        public void settingsChanged(@NotNull MarkdownSettings settings) {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
            Project project = settings.getProject$intellij_markdown_core();
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            if (fileEditorManager == null) {
                return;
            }
            FileEditorManager editorManager = fileEditorManager;
            DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzerImpl.getInstance((Project)project);
            if (daemonCodeAnalyzer == null) {
                return;
            }
            DaemonCodeAnalyzer codeAnalyzer = daemonCodeAnalyzer;
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"PsiManager.getInstance(project)");
            PsiManager psiManager2 = psiManager;
            Object[] objectArray = editorManager.getOpenFiles();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"editorManager.openFiles");
            Sequence sequence = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)settingsChanged.1.INSTANCE), (Function1)((Function1)new Function1<VirtualFile, PsiFile>(psiManager2){

                @Nullable
                public final PsiFile invoke(@NotNull VirtualFile p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return ((PsiManager)this.receiver).findFile(p1);
                }
            }));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiFile p1 = (PsiFile)element$iv;
                boolean bl = false;
                codeAnalyzer.restart(p1);
            }
        }

        @Override
        public void beforeSettingsChanged(@NotNull MarkdownSettings settings) {
            Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
            MarkdownSettings.ChangeListener.DefaultImpls.beforeSettingsChanged(this, settings);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/injection/MarkdownCodeFenceErrorHighlightingIntention$CodeFenceHighlightErrorFilter;", "Lcom/intellij/codeInsight/highlighting/HighlightErrorFilter;", "()V", "shouldHighlightErrorElement", "", "element", "Lcom/intellij/psi/PsiErrorElement;", "intellij.markdown.core"})
    public static final class CodeFenceHighlightErrorFilter
    extends HighlightErrorFilter {
        public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement element2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)element2.getProject());
            PsiFile psiFile = injectedLanguageManager.getTopLevelFile((PsiElement)element2);
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"injectedLanguageManager.getTopLevelFile(element)");
            if (Intrinsics.areEqual((Object)psiFile.getFileType(), (Object)((Object)MarkdownFileType.INSTANCE)) && injectedLanguageManager.getInjectionHost((PsiElement)element2) instanceof MarkdownCodeFence) {
                Project project = element2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
                return !MarkdownSettings.Companion.getInstance(project).getHideErrorsInCodeBlocks();
            }
            return true;
        }
    }
}

