/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.intellij.plugins.markdown.editor.images.ImageUtils;
import org.intellij.plugins.markdown.editor.images.MarkdownImageData;
import org.intellij.plugins.markdown.lang.MarkdownLanguage;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElement;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFence;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkDefinition;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownList;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownParagraph;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableRow;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MarkdownPsiElementFactory {
    private MarkdownPsiElementFactory() {
    }

    @NotNull
    public static MarkdownFile createFile(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(0);
        }
        if (text == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(1);
        }
        LightVirtualFile virtualFile = new LightVirtualFile("temp.rb", (Language)MarkdownLanguage.INSTANCE, (CharSequence)text);
        PsiFile psiFile = ((PsiFileFactoryImpl)PsiFileFactory.getInstance((Project)project)).trySetupPsiForFile(virtualFile, (Language)MarkdownLanguage.INSTANCE, true, true);
        if (!(psiFile instanceof MarkdownFile)) {
            throw new RuntimeException("Cannot create a new markdown file. Text: " + text);
        }
        MarkdownFile markdownFile = (MarkdownFile)psiFile;
        if (markdownFile == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(2);
        }
        return markdownFile;
    }

    @NotNull
    public static MarkdownCodeFence createCodeFence(@NotNull Project project, @Nullable String language, @NotNull String text) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(3);
        }
        if (text == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(4);
        }
        return MarkdownPsiElementFactory.createCodeFence(project, language, text, null);
    }

    @NotNull
    public static MarkdownCodeFence createCodeFence(@NotNull Project project, @Nullable String language, @NotNull String text, @Nullable String indent) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(5);
        }
        if (text == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(6);
        }
        text = StringUtil.isEmpty((String)text) ? "" : "\n" + (String)text;
        String content2 = "```" + StringUtil.notNullize((String)language) + (String)text + "\n" + StringUtil.notNullize((String)indent) + "```";
        MarkdownFile file = MarkdownPsiElementFactory.createFile(project, content2);
        MarkdownCodeFence markdownCodeFence = (MarkdownCodeFence)file.getFirstChild().getFirstChild();
        if (markdownCodeFence == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(7);
        }
        return markdownCodeFence;
    }

    @NotNull
    public static PsiElement createImage(@NotNull Project project, @Nullable String description, @NotNull String path, @Nullable String title) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(8);
        }
        if (path == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(9);
        }
        String text = ImageUtils.createMarkdownImageText(Objects.requireNonNullElse(description, ""), path, Objects.requireNonNullElse(title, ""));
        PsiElement psiElement = MarkdownPsiElementFactory.createFile(project, text).getFirstChild().getFirstChild().getFirstChild();
        if (psiElement == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(10);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement createHtmlBlockWithImage(@NotNull Project project, @NotNull MarkdownImageData imageData) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(11);
        }
        if (imageData == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(12);
        }
        String text = ImageUtils.createHtmlImageText(imageData);
        PsiElement psiElement = MarkdownPsiElementFactory.createFile(project, text).getFirstChild().getFirstChild();
        if (psiElement == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(13);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement createHtmlImageTag(@NotNull Project project, @NotNull MarkdownImageData imageData) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(14);
        }
        if (imageData == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(15);
        }
        String text = ImageUtils.createHtmlImageText(imageData);
        PsiElement root = MarkdownPsiElementFactory.createFile(project, "Prefix text" + text).getFirstChild();
        PsiElement psiElement = root.getFirstChild().getFirstChild().getNextSibling();
        if (psiElement == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(16);
        }
        return psiElement;
    }

    @NotNull
    public static MarkdownPsiElement createTextElement(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(17);
        }
        if (text == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(18);
        }
        MarkdownPsiElement markdownPsiElement = (MarkdownPsiElement)MarkdownPsiElementFactory.createFile(project, text).getFirstChild().getFirstChild();
        if (markdownPsiElement == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(19);
        }
        return markdownPsiElement;
    }

    @NotNull
    public static MarkdownHeader createSetext(@NotNull Project project, @NotNull String text, @NotNull String symbol, int count) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(20);
        }
        if (text == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(21);
        }
        if (symbol == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(22);
        }
        MarkdownHeader markdownHeader = (MarkdownHeader)MarkdownPsiElementFactory.createFile(project, text + "\n" + StringUtil.repeat((String)symbol, (int)count)).getFirstChild().getFirstChild();
        if (markdownHeader == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(23);
        }
        return markdownHeader;
    }

    @NotNull
    public static MarkdownHeader createHeader(@NotNull Project project, @NotNull String text, int level) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(24);
        }
        if (text == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(25);
        }
        MarkdownHeader markdownHeader = (MarkdownHeader)MarkdownPsiElementFactory.createFile(project, StringUtil.repeat((String)"#", (int)level) + " " + text).getFirstChild().getFirstChild();
        if (markdownHeader == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(26);
        }
        return markdownHeader;
    }

    @NotNull
    public static PsiElement createNewLine(@NotNull Project project) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(27);
        }
        PsiElement psiElement = MarkdownPsiElementFactory.createFile(project, "\n").getFirstChild().getFirstChild();
        if (psiElement == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(28);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement createNewLines(@NotNull Project project, int num) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(29);
        }
        PsiElement psiElement = MarkdownPsiElementFactory.createFile(project, StringUtil.repeat((String)"\n", (int)num)).getFirstChild();
        if (psiElement == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(30);
        }
        return psiElement;
    }

    @NotNull
    public static Pair<PsiElement, PsiElement> createLinkDeclarationAndReference(@NotNull Project project, @NotNull String url, @NotNull String text, @Nullable String title, @NotNull String reference) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(31);
        }
        if (url == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(32);
        }
        if (text == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(33);
        }
        if (reference == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(34);
        }
        text = (String)ObjectUtils.notNull((Object)text, (Object)reference);
        title = title == null ? "" : " " + (String)title;
        String linkReference = "[" + text + "][" + reference + "]\n\n[" + reference + "]: " + url + (String)title;
        PsiElement linkReferenceElement = MarkdownPsiElementFactory.createFile(project, linkReference).getFirstChild();
        PsiElement ref = linkReferenceElement.getFirstChild();
        assert (ref instanceof MarkdownParagraph);
        PsiElement declaration = linkReferenceElement.getLastChild();
        assert (declaration instanceof MarkdownParagraph || declaration instanceof MarkdownLinkDefinition);
        Pair pair = Pair.create((Object)ref, (Object)declaration);
        if (pair == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(35);
        }
        return pair;
    }

    @ApiStatus.Experimental
    @NotNull
    public static MarkdownTableSeparatorRow createTableSeparatorRow(@NotNull Project project, @NotNull String text) {
        int columnsCount2;
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(36);
        }
        if (text == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(37);
        }
        if ((columnsCount2 = StringUtil.countChars((CharSequence)text, (char)'|') - 1) < 1) {
            throw new IllegalArgumentException("Passed separator text should be valid and contain at least one column.\n Text passed: [" + text + "]");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("|");
        for (int column = 0; column < columnsCount2; ++column) {
            builder.append("    |");
        }
        builder.append('\n');
        builder.append(text);
        MarkdownFile file = MarkdownPsiElementFactory.createFile(project, builder.toString());
        PsiElement table = Objects.requireNonNull(file.findElementAt(0)).getParent().getParent();
        MarkdownTableSeparatorRow markdownTableSeparatorRow = Objects.requireNonNull((MarkdownTableSeparatorRow)PsiTreeUtil.getChildOfType((PsiElement)table, MarkdownTableSeparatorRow.class));
        if (markdownTableSeparatorRow == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(38);
        }
        return markdownTableSeparatorRow;
    }

    @ApiStatus.Experimental
    @NotNull
    public static Pair<MarkdownTableCell, PsiElement> createTableCell(@NotNull Project project, @NotNull String text) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(39);
        }
        if (text == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(40);
        }
        String content2 = "|" + text + "|\n|----|";
        MarkdownFile file = MarkdownPsiElementFactory.createFile(project, content2);
        PsiElement contentElement = file.findElementAt(1);
        MarkdownTableCell cell = Objects.requireNonNull((MarkdownTableCell)PsiTreeUtil.getParentOfType((PsiElement)contentElement, MarkdownTableCell.class));
        PsiElement separator = cell.getNextSibling();
        return new Pair((Object)cell, (Object)separator);
    }

    @NotNull
    private static MarkdownTable findTable(@NotNull PsiElement element2) {
        if (element2 == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(41);
        }
        MarkdownTable markdownTable = Objects.requireNonNull((MarkdownTable)PsiTreeUtil.getParentOfType((PsiElement)element2, MarkdownTable.class));
        if (markdownTable == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(42);
        }
        return markdownTable;
    }

    @ApiStatus.Experimental
    @NotNull
    public static PsiElement createTableSeparator(@NotNull Project project) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(43);
        }
        String content2 = "|    |\n|----|";
        MarkdownFile file = MarkdownPsiElementFactory.createFile(project, "|    |\n|----|");
        PsiElement psiElement = Objects.requireNonNull(file.findElementAt(0));
        if (psiElement == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(44);
        }
        return psiElement;
    }

    @ApiStatus.Experimental
    @NotNull
    public static MarkdownTableRow createTableRow(@NotNull Project project, @NotNull Collection<String> contents2) {
        int count;
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(45);
        }
        if (contents2 == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(46);
        }
        StringBuilder builder = new StringBuilder();
        builder.append('|');
        for (count = 0; count < contents2.size(); ++count) {
            builder.append("     |");
        }
        builder.append('\n');
        builder.append('|');
        for (count = 0; count < contents2.size(); ++count) {
            builder.append("-----|");
        }
        builder.append('\n');
        builder.append('|');
        for (String content2 : contents2) {
            builder.append(content2);
            builder.append('|');
        }
        builder.append('\n');
        builder.append('|');
        for (int count2 = 0; count2 < contents2.size(); ++count2) {
            builder.append("     |");
        }
        builder.append('\n');
        MarkdownFile file = MarkdownPsiElementFactory.createFile(project, builder.toString());
        PsiElement element2 = Objects.requireNonNull(file.findElementAt(0));
        PsiElement row = Objects.requireNonNull(MarkdownPsiElementFactory.findTable(element2).getLastChild().getPrevSibling().getPrevSibling());
        if (row instanceof MarkdownTableRow) {
            MarkdownTableRow markdownTableRow = (MarkdownTableRow)row;
            if (markdownTableRow == null) {
                MarkdownPsiElementFactory.$$$reportNull$$$0(47);
            }
            return markdownTableRow;
        }
        throw new IllegalStateException("Failed to find row element");
    }

    @ApiStatus.Experimental
    @NotNull
    public static MarkdownTableRow createTableEmptyRow(@NotNull Project project, @NotNull Collection<Integer> widths) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(48);
        }
        if (widths == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(49);
        }
        List contents2 = ContainerUtil.map(widths, width -> " ".repeat((int)width));
        return MarkdownPsiElementFactory.createTableRow(project, contents2);
    }

    @ApiStatus.Experimental
    @NotNull
    public static PsiElement createBlockQuoteArrow(@NotNull Project project) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(50);
        }
        String contents2 = "> ";
        MarkdownFile file = MarkdownPsiElementFactory.createFile(project, "> ");
        PsiElement psiElement = Objects.requireNonNull(file.findElementAt(1));
        if (psiElement == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(51);
        }
        return psiElement;
    }

    @ApiStatus.Experimental
    @NotNull
    public static MarkdownHeader createHeader(@NotNull Project project, int level, @NotNull String text) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(52);
        }
        if (text == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(53);
        }
        String contents2 = StringUtil.repeat((String)"#", (int)level) + " " + text;
        MarkdownFile file = MarkdownPsiElementFactory.createFile(project, contents2);
        PsiElement element2 = Objects.requireNonNull(file.getFirstChild().getFirstChild());
        assert (element2 instanceof MarkdownHeader);
        MarkdownHeader markdownHeader = (MarkdownHeader)element2;
        if (markdownHeader == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(54);
        }
        return markdownHeader;
    }

    @ApiStatus.Experimental
    @NotNull
    public static PsiElement createListMarker(@NotNull Project project, @NotNull String markerText) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(55);
        }
        if (markerText == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(56);
        }
        String contents2 = markerText + " list item";
        MarkdownFile file = MarkdownPsiElementFactory.createFile(project, contents2);
        PsiElement psiElement = Objects.requireNonNull(file.getFirstChild().getFirstChild().getFirstChild().getFirstChild());
        if (psiElement == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(57);
        }
        return psiElement;
    }

    @ApiStatus.Experimental
    @NotNull
    public static Pair<PsiElement, PsiElement> createListMarkerWithCheckbox(@NotNull Project project, @NotNull String markerText, boolean checked) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(58);
        }
        if (markerText == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(59);
        }
        Object text = markerText;
        text = checked ? (String)text + " [x]" : (String)text + " [ ]";
        PsiElement marker2 = MarkdownPsiElementFactory.createListMarker(project, (String)text);
        PsiElement checkbox = Objects.requireNonNull(marker2.getNextSibling());
        return new Pair((Object)marker2, (Object)checkbox);
    }

    @ApiStatus.Experimental
    @NotNull
    public static MarkdownList createEmptyList(@NotNull Project project, boolean ordered) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(60);
        }
        String contents2 = ordered ? "1) list item" : "* list item";
        MarkdownFile file = MarkdownPsiElementFactory.createFile(project, contents2);
        PsiElement list2 = Objects.requireNonNull(file.getFirstChild().getFirstChild());
        assert (list2 instanceof MarkdownList);
        for (PsiElement child : list2.getChildren()) {
            child.delete();
        }
        MarkdownList markdownList = (MarkdownList)list2;
        if (markdownList == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(61);
        }
        return markdownList;
    }

    @ApiStatus.Experimental
    @NotNull
    public static MarkdownList createList(@NotNull Project project, @NotNull @NotNull Iterable<@NotNull String> items, @NotNull Function<Integer, String> markerSupplier) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(62);
        }
        if (items == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(63);
        }
        if (markerSupplier == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(64);
        }
        StringBuilder builder = new StringBuilder();
        int itemIndex = 0;
        for (String item : items) {
            builder.append(markerSupplier.apply(itemIndex));
            builder.append(" ");
            builder.append(item);
            builder.append("\n");
            ++itemIndex;
        }
        MarkdownFile file = MarkdownPsiElementFactory.createFile(project, builder.toString());
        PsiElement list2 = Objects.requireNonNull(file.getFirstChild().getFirstChild());
        assert (list2 instanceof MarkdownList);
        MarkdownList markdownList = (MarkdownList)list2;
        if (markdownList == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(65);
        }
        return markdownList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 35: 
            case 38: 
            case 42: 
            case 44: 
            case 47: 
            case 51: 
            case 54: 
            case 57: 
            case 61: 
            case 65: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 35: 
            case 38: 
            case 42: 
            case 44: 
            case 47: 
            case 51: 
            case 54: 
            case 57: 
            case 61: 
            case 65: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 18: 
            case 21: 
            case 25: 
            case 33: 
            case 37: 
            case 40: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 35: 
            case 38: 
            case 42: 
            case 44: 
            case 47: 
            case 51: 
            case 54: 
            case 57: 
            case 61: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/lang/psi/MarkdownPsiElementFactory";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageData";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widths";
                break;
            }
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markerText";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markerSupplier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/lang/psi/MarkdownPsiElementFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCodeFence";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createImage";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createHtmlBlockWithImage";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createHtmlImageTag";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextElement";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createSetext";
                break;
            }
            case 26: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "createHeader";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewLine";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewLines";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createLinkDeclarationAndReference";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "createTableSeparatorRow";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "findTable";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createTableSeparator";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "createTableRow";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "createBlockQuoteArrow";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "createListMarker";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyList";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "createList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 35: 
            case 38: 
            case 42: 
            case 44: 
            case 47: 
            case 51: 
            case 54: 
            case 57: 
            case 61: 
            case 65: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCodeFence";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createImage";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createHtmlBlockWithImage";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createHtmlImageTag";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createTextElement";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createSetext";
                break;
            }
            case 24: 
            case 25: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "createHeader";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createNewLine";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createNewLines";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createLinkDeclarationAndReference";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createTableSeparatorRow";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createTableCell";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "findTable";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createTableSeparator";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createTableRow";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createTableEmptyRow";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createBlockQuoteArrow";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "createListMarker";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "createListMarkerWithCheckbox";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyList";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "createList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 35: 
            case 38: 
            case 42: 
            case 44: 
            case 47: 
            case 51: 
            case 54: 
            case 57: 
            case 61: 
            case 65: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

