/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownBlockQuote;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeBlock;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFence;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownImage;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkDefinition;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkDestination;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkLabel;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownList;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItem;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownParagraph;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownShortReferenceLink;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableRow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/lang/psi/MarkdownPsiFactory;", "", "()V", "createElement", "Lcom/intellij/psi/PsiElement;", "node", "Lcom/intellij/lang/ASTNode;", "intellij.markdown.core"})
public final class MarkdownPsiFactory {
    @NotNull
    public static final MarkdownPsiFactory INSTANCE;

    @JvmStatic
    @NotNull
    public static final PsiElement createElement(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"node.elementType");
        IElementType elementType = iElementType;
        return Intrinsics.areEqual((Object)elementType, (Object)MarkdownElementTypes.PARAGRAPH) ? (PsiElement)new MarkdownParagraph(node) : (Intrinsics.areEqual((Object)elementType, (Object)MarkdownElementTypes.CODE_FENCE) ? (PsiElement)((MarkdownCodeFence)node) : (Intrinsics.areEqual((Object)elementType, (Object)MarkdownElementTypes.IMAGE) ? (PsiElement)new MarkdownImage(node) : (Intrinsics.areEqual((Object)elementType, (Object)MarkdownElementTypes.LIST_ITEM) ? (PsiElement)new MarkdownListItem(node) : (Intrinsics.areEqual((Object)elementType, (Object)MarkdownElementTypes.BLOCK_QUOTE) ? (PsiElement)new MarkdownBlockQuote(node) : (Intrinsics.areEqual((Object)elementType, (Object)MarkdownElementTypes.SHORT_REFERENCE_LINK) ? (PsiElement)new MarkdownShortReferenceLink(node) : (Intrinsics.areEqual((Object)elementType, (Object)MarkdownElementTypes.LINK_DEFINITION) ? (PsiElement)new MarkdownLinkDefinition(node) : (Intrinsics.areEqual((Object)elementType, (Object)MarkdownElementTypes.LINK_DESTINATION) ? (PsiElement)new MarkdownLinkDestination(node) : (Intrinsics.areEqual((Object)elementType, (Object)MarkdownElementTypes.LINK_LABEL) ? (PsiElement)new MarkdownLinkLabel(node) : (Intrinsics.areEqual((Object)elementType, (Object)MarkdownElementTypes.CODE_BLOCK) ? (PsiElement)new MarkdownCodeBlock(node) : (Intrinsics.areEqual((Object)elementType, (Object)MarkdownElementTypes.TABLE) ? (PsiElement)new MarkdownTable(node) : (Intrinsics.areEqual((Object)elementType, (Object)MarkdownElementTypes.TABLE_ROW) || Intrinsics.areEqual((Object)elementType, (Object)MarkdownElementTypes.TABLE_HEADER) ? (PsiElement)new MarkdownTableRow(node) : (Intrinsics.areEqual((Object)elementType, (Object)MarkdownElementTypes.TABLE_CELL) ? (PsiElement)new MarkdownTableCell(node) : (PsiElement)(MarkdownTokenTypeSets.HEADERS.contains(elementType) ? (ASTDelegatePsiElement)new MarkdownHeader(node) : (MarkdownTokenTypeSets.LISTS.contains(elementType) ? (ASTDelegatePsiElement)new MarkdownList(node) : (ASTDelegatePsiElement)new ASTWrapperPsiElement(node)))))))))))))));
    }

    private MarkdownPsiFactory() {
    }

    static {
        MarkdownPsiFactory markdownPsiFactory;
        INSTANCE = markdownPsiFactory = new MarkdownPsiFactory();
    }
}

