/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi.impl;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.injection.MarkdownCodeFenceUtils;
import org.intellij.plugins.markdown.lang.psi.MarkdownElementVisitor;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElement;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElementFactory;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFenceImpl;
import org.intellij.plugins.markdown.structureView.MarkdownBasePresentation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0003\u0013\u0014\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000b0\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0016"}, d2={"Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFence;", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFenceImpl;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "(Lcom/intellij/psi/tree/IElementType;)V", "accept", "", "visitor", "Lcom/intellij/psi/PsiElementVisitor;", "createLiteralTextEscaper", "Lcom/intellij/psi/LiteralTextEscaper;", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "isValidHost", "", "updateText", "text", "", "CodeFenceLiteralTextEscaper", "Companion", "Manipulator", "intellij.markdown.core"})
public final class MarkdownCodeFence
extends MarkdownCodeFenceImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void accept(@NotNull PsiElementVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        PsiElementVisitor psiElementVisitor = visitor;
        if (psiElementVisitor instanceof MarkdownElementVisitor) {
            ((MarkdownElementVisitor)visitor).visitCodeFence(this);
        } else {
            super.accept(visitor);
        }
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return new MarkdownBasePresentation(this){
            final /* synthetic */ MarkdownCodeFence this$0;

            @Nullable
            public String getPresentableText() {
                return !this.this$0.isValid() ? null : "Code Fence";
            }

            @Nullable
            public String getLocationString() {
                if (!this.this$0.isValid()) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                List<PsiElement> list2 = MarkdownCodeFence.Companion.obtainFenceContent(this.this$0, false);
                if (list2 == null) {
                    return "";
                }
                List<PsiElement> elements2 = list2;
                for (PsiElement element2 : elements2) {
                    CharSequence charSequence = sb;
                    if (charSequence.length() > 0) {
                        sb.append("\\n");
                    }
                    sb.append(element2.getText());
                    if (sb.length() < 50) continue;
                    break;
                }
                return sb.toString();
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    public boolean isValidHost() {
        return MarkdownCodeFenceUtils.isAbleToAcceptInjections(this);
    }

    @Nullable
    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return (PsiLanguageInjectionHost)ElementManipulators.handleContentChange((PsiElement)((PsiElement)this), (String)text);
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        return new CodeFenceLiteralTextEscaper(this);
    }

    public MarkdownCodeFence(@NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        super(elementType);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u000bj\u0002`\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\u0007H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFence$CodeFenceLiteralTextEscaper;", "Lcom/intellij/psi/LiteralTextEscaper;", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "host", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFence;", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFence;)V", "decode", "", "rangeInsideHost", "Lcom/intellij/openapi/util/TextRange;", "outChars", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getOffsetInHost", "", "offsetInDecoded", "getRelevantTextRange", "isOneLine", "intellij.markdown.core"})
    private static final class CodeFenceLiteralTextEscaper
    extends LiteralTextEscaper<PsiLanguageInjectionHost> {
        public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
            Intrinsics.checkNotNullParameter((Object)rangeInsideHost, (String)"rangeInsideHost");
            Intrinsics.checkNotNullParameter((Object)outChars, (String)"outChars");
            PsiLanguageInjectionHost psiLanguageInjectionHost = this.myHost;
            if (psiLanguageInjectionHost == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFence");
            }
            List<PsiElement> list2 = Companion.obtainFenceContent((MarkdownCodeFence)psiLanguageInjectionHost, false);
            if (list2 == null) {
                return true;
            }
            List<PsiElement> elements2 = list2;
            for (PsiElement element2 : elements2) {
                TextRange intersected;
                if (rangeInsideHost.intersection(element2.getTextRangeInParent()) == null) {
                    continue;
                }
                outChars.append(intersected.substring(((MarkdownCodeFence)this.myHost).getText()));
            }
            return true;
        }

        public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
            Intrinsics.checkNotNullParameter((Object)rangeInsideHost, (String)"rangeInsideHost");
            PsiLanguageInjectionHost psiLanguageInjectionHost = this.myHost;
            if (psiLanguageInjectionHost == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFence");
            }
            List<PsiElement> list2 = Companion.obtainFenceContent((MarkdownCodeFence)psiLanguageInjectionHost, false);
            if (list2 == null) {
                return -1;
            }
            List<PsiElement> elements2 = list2;
            int cur = 0;
            for (PsiElement element2 : elements2) {
                TextRange intersected = rangeInsideHost.intersection(element2.getTextRangeInParent());
                if (intersected == null || intersected.isEmpty()) continue;
                if (cur + intersected.getLength() == offsetInDecoded) {
                    return intersected.getStartOffset() + intersected.getLength();
                }
                if (cur == offsetInDecoded) {
                    return intersected.getStartOffset();
                }
                if (cur < offsetInDecoded && cur + intersected.getLength() > offsetInDecoded) {
                    return intersected.getStartOffset() + (offsetInDecoded - cur);
                }
                cur += intersected.getLength();
            }
            PsiElement last = elements2.get(elements2.size() - 1);
            TextRange intersected = rangeInsideHost.intersection(last.getTextRangeInParent());
            if (intersected == null || intersected.isEmpty()) {
                return -1;
            }
            int result = intersected.getStartOffset() + (offsetInDecoded - (cur - intersected.getLength()));
            return rangeInsideHost.getStartOffset() <= result && result <= rangeInsideHost.getEndOffset() ? result : -1;
        }

        @NotNull
        public TextRange getRelevantTextRange() {
            PsiLanguageInjectionHost psiLanguageInjectionHost = this.myHost;
            if (psiLanguageInjectionHost == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFence");
            }
            List<PsiElement> list2 = Companion.obtainFenceContent((MarkdownCodeFence)psiLanguageInjectionHost, true);
            if (list2 == null) {
                return MarkdownCodeFenceUtils.INSTANCE.getEmptyRange((MarkdownCodeFence)this.myHost);
            }
            List<PsiElement> elements2 = list2;
            PsiElement first = elements2.get(0);
            PsiElement last = elements2.get(elements2.size() - 1);
            TextRange textRange = TextRange.create((int)first.getStartOffsetInParent(), (int)(last.getStartOffsetInParent() + last.getTextLength()));
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"TextRange.create(first.s\u2026Parent + last.textLength)");
            return textRange;
        }

        public boolean isOneLine() {
            return false;
        }

        public CodeFenceLiteralTextEscaper(@NotNull MarkdownCodeFence host) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            super((PsiLanguageInjectionHost)host);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFence$Manipulator;", "Lcom/intellij/psi/AbstractElementManipulator;", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFence;", "()V", "handleContentChange", "element", "range", "Lcom/intellij/openapi/util/TextRange;", "content", "", "intellij.markdown.core"})
    public static final class Manipulator
    extends AbstractElementManipulator<MarkdownCodeFence> {
        @Nullable
        public MarkdownCodeFence handleContentChange(@NotNull MarkdownCodeFence element2, @NotNull TextRange range, @NotNull String content2) throws IncorrectOperationException {
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            Object actualContent = content2;
            if (StringsKt.contains$default((CharSequence)((CharSequence)actualContent), (CharSequence)"```", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)((CharSequence)actualContent), (CharSequence)"~~~", (boolean)false, (int)2, null)) {
                MarkdownCodeFence markdownCodeFence;
                MarkdownPsiElement markdownPsiElement = MarkdownPsiElementFactory.createTextElement(element2.getProject(), (String)actualContent);
                Intrinsics.checkNotNullExpressionValue((Object)markdownPsiElement, (String)"MarkdownPsiElementFactor\u2026t.project, actualContent)");
                MarkdownPsiElement textElement = markdownPsiElement;
                if (textElement instanceof MarkdownCodeFence) {
                    PsiElement psiElement = element2.replace((PsiElement)textElement);
                    if (psiElement == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFence");
                    }
                    markdownCodeFence = (MarkdownCodeFence)psiElement;
                } else {
                    markdownCodeFence = null;
                }
                return markdownCodeFence;
            }
            String indent = MarkdownCodeFenceUtils.getIndent(element2);
            if (indent != null && (charSequence = (CharSequence)indent).length() > 0) {
                Object[] objectArray = StringUtil.splitByLinesKeepSeparators((String)actualContent);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"StringUtil.splitByLinesK\u2026Separators(actualContent)");
                actualContent = ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(indent){
                    final /* synthetic */ String $indent;

                    @NotNull
                    public final CharSequence invoke(String it) {
                        return this.$indent + it;
                    }
                    {
                        this.$indent = string;
                        super(1);
                    }
                }), (int)30, null);
                if (StringUtil.endsWithLineBreak((CharSequence)((CharSequence)actualContent))) {
                    actualContent = (String)actualContent + indent;
                }
            }
            MarkdownCodeFence markdownCodeFence = MarkdownPsiElementFactory.createCodeFence(element2.getProject(), element2.getFenceLanguage(), (String)actualContent, indent);
            Intrinsics.checkNotNullExpressionValue((Object)markdownCodeFence, (String)"MarkdownPsiElementFactor\u2026e, actualContent, indent)");
            MarkdownCodeFence fenceElement = markdownCodeFence;
            PsiElement psiElement = element2.replace((PsiElement)fenceElement);
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFence");
            }
            return (MarkdownCodeFence)psiElement;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFence$Companion;", "", "()V", "obtainFenceContent", "", "Lcom/intellij/psi/PsiElement;", "element", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFence;", "withWhitespaces", "", "intellij.markdown.core"})
    public static final class Companion {
        @ApiStatus.Experimental
        @Nullable
        public final List<PsiElement> obtainFenceContent(@NotNull MarkdownCodeFence element2, boolean withWhitespaces) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            return withWhitespaces ? (List)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)element2), (CachedValueProvider)new CachedValueProvider(element2){
                final /* synthetic */ MarkdownCodeFence $element;

                @Nullable
                public final CachedValueProvider.Result<List<PsiElement>> compute() {
                    return CachedValueProvider.Result.create(MarkdownCodeFenceUtils.getContent(this.$element, true), (Object[])new Object[]{this.$element});
                }
                {
                    this.$element = markdownCodeFence;
                }
            }) : (List)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)element2), (CachedValueProvider)new CachedValueProvider(element2){
                final /* synthetic */ MarkdownCodeFence $element;

                @Nullable
                public final CachedValueProvider.Result<List<PsiElement>> compute() {
                    return CachedValueProvider.Result.create(MarkdownCodeFenceUtils.getContent(this.$element, false), (Object[])new Object[]{this.$element});
                }
                {
                    this.$element = markdownCodeFence;
                }
            });
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

