/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.settings;

import com.intellij.openapi.project.Project;
import com.intellij.util.ApplicationKt;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.extensions.ExtensionsExternalFilesPathManager;
import org.intellij.plugins.markdown.extensions.MarkdownExtensionWithDownloadableFiles;
import org.intellij.plugins.markdown.settings.MarkdownExtensionsSettings;
import org.intellij.plugins.markdown.ui.MarkdownNotifications;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\u0004J&\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a8\u0006\r"}, d2={"Lorg/intellij/plugins/markdown/settings/MarkdownSettingsUtil;", "", "()V", "downloadExtension", "", "extension", "Lorg/intellij/plugins/markdown/extensions/MarkdownExtensionWithDownloadableFiles;", "project", "Lcom/intellij/openapi/project/Project;", "enableAfterDownload", "downloadExtensionFiles", "parentComponent", "Ljavax/swing/JComponent;", "intellij.markdown.core"})
@ApiStatus.Internal
public final class MarkdownSettingsUtil {
    @NotNull
    public static final MarkdownSettingsUtil INSTANCE;

    /*
     * WARNING - void declaration
     */
    public final boolean downloadExtensionFiles(@NotNull MarkdownExtensionWithDownloadableFiles extension, @Nullable Project project, @Nullable JComponent parentComponent) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        DownloadableFileService downloader = DownloadableFileService.getInstance();
        Iterable<MarkdownExtensionWithDownloadableFiles.FileEntry> $this$mapNotNull$iv = extension.getFilesToDownload();
        boolean $i$f$mapNotNull = false;
        Iterable<MarkdownExtensionWithDownloadableFiles.FileEntry> iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DownloadableFileDescription downloadableFileDescription;
            DownloadableFileDescription downloadableFileDescription2;
            DownloadableFileDescription downloadableFileDescription3;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MarkdownExtensionWithDownloadableFiles.FileEntry entry = (MarkdownExtensionWithDownloadableFiles.FileEntry)element$iv$iv;
            boolean bl2 = false;
            if (entry.getLink().get() != null) {
                String string;
                String it = string;
                boolean bl3 = false;
                downloadableFileDescription3 = downloader.createFileDescription(it, entry.getFilePath());
            } else {
                downloadableFileDescription3 = downloadableFileDescription2 = null;
            }
            if (downloadableFileDescription2 == null) continue;
            DownloadableFileDescription it$iv$iv = downloadableFileDescription = downloadableFileDescription2;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List descriptions = (List)destination$iv$iv;
        ExtensionsExternalFilesPathManager.Companion.getInstance().cleanupExternalFiles(extension);
        Path directory = ExtensionsExternalFilesPathManager.Companion.obtainExternalFilesDirectoryPath(extension);
        FileDownloader fileDownloader = downloader.createDownloader(descriptions, "Downloading Extension Files");
        Intrinsics.checkNotNullExpressionValue((Object)fileDownloader, (String)"downloader.createDownloa\u2026loading Extension Files\")");
        FileDownloader actualDownloader = fileDownloader;
        Path path = directory;
        List files = actualDownloader.downloadFilesWithProgress(((Object)path.toAbsolutePath()).toString(), project, parentComponent);
        return files != null;
    }

    public static /* synthetic */ boolean downloadExtensionFiles$default(MarkdownSettingsUtil markdownSettingsUtil, MarkdownExtensionWithDownloadableFiles markdownExtensionWithDownloadableFiles, Project project, JComponent jComponent, int n, Object object) {
        if ((n & 2) != 0) {
            project = null;
        }
        if ((n & 4) != 0) {
            jComponent = null;
        }
        return markdownSettingsUtil.downloadExtensionFiles(markdownExtensionWithDownloadableFiles, project, jComponent);
    }

    public final boolean downloadExtension(@NotNull MarkdownExtensionWithDownloadableFiles extension, @Nullable Project project, boolean enableAfterDownload) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        if (extension.downloadFiles(project)) {
            if (enableAfterDownload) {
                MarkdownExtensionsSettings.Companion.getInstance().getExtensionsEnabledState().put(extension.getId(), true);
                ((MarkdownExtensionsSettings.ChangeListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(MarkdownExtensionsSettings.ChangeListener.TOPIC)).extensionsSettingsChanged(false);
            }
            String string = MarkdownBundle.message("markdown.settings.download.extension.notification.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026sion.notification.title\")");
            String string2 = MarkdownBundle.message("markdown.settings.download.extension.notification.success.content", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MarkdownBundle.message(\"\u2026ication.success.content\")");
            MarkdownNotifications.INSTANCE.showInfo(project, "markdown.extensions.download.success", string, string2);
            return true;
        }
        String string = MarkdownBundle.message("markdown.settings.download.extension.notification.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026sion.notification.title\")");
        String string3 = MarkdownBundle.message("markdown.settings.download.extension.notification.failure.content", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"MarkdownBundle.message(\"\u2026ication.failure.content\")");
        MarkdownNotifications.INSTANCE.showError(project, "markdown.extensions.download.failed", string, string3);
        return false;
    }

    public static /* synthetic */ boolean downloadExtension$default(MarkdownSettingsUtil markdownSettingsUtil, MarkdownExtensionWithDownloadableFiles markdownExtensionWithDownloadableFiles, Project project, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            project = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return markdownSettingsUtil.downloadExtension(markdownExtensionWithDownloadableFiles, project, bl);
    }

    private MarkdownSettingsUtil() {
    }

    static {
        MarkdownSettingsUtil markdownSettingsUtil;
        INSTANCE = markdownSettingsUtil = new MarkdownSettingsUtil();
    }
}

