/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.actions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ApplicationKt;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.lang.MarkdownLanguage;
import org.intellij.plugins.markdown.ui.preview.MarkdownEditorWithPreview;
import org.intellij.plugins.markdown.ui.preview.MarkdownPreviewFileEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0014\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\"\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\"\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J$\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J$\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000e2\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000e0 H\u0007\u00a8\u0006!"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/MarkdownActionUtil;", "", "()V", "findMarkdownPreviewEditor", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditor;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "findMarkdownTextEditor", "Lcom/intellij/openapi/editor/Editor;", "findSplitEditor", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownEditorWithPreview;", "editor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getCommonParentOfType", "Lcom/intellij/psi/PsiElement;", "left", "right", "elementType", "Lcom/intellij/psi/tree/IElementType;", "getCommonParentOfTypes", "tokenSet", "Lcom/intellij/psi/tree/TokenSet;", "getCommonTopmostParentOfTypes", "getElementsUnderCaretOrSelection", "Lkotlin/Pair;", "file", "Lcom/intellij/psi/PsiFile;", "caret", "Lcom/intellij/openapi/editor/Caret;", "getTopmostParentOfType", "element", "condition", "Lcom/intellij/openapi/util/Condition;", "intellij.markdown.core"})
public final class MarkdownActionUtil {
    @NotNull
    public static final MarkdownActionUtil INSTANCE;

    @JvmStatic
    @Nullable
    public static final MarkdownEditorWithPreview findSplitEditor(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        FileEditor editor2 = (FileEditor)event.getData(PlatformCoreDataKeys.FILE_EDITOR);
        return MarkdownActionUtil.findSplitEditor(editor2);
    }

    @JvmStatic
    @Nullable
    public static final MarkdownEditorWithPreview findSplitEditor(@Nullable FileEditor editor2) {
        MarkdownEditorWithPreview markdownEditorWithPreview;
        FileEditor fileEditor = editor2;
        if (fileEditor instanceof MarkdownEditorWithPreview) {
            markdownEditorWithPreview = (MarkdownEditorWithPreview)editor2;
        } else {
            FileEditor fileEditor2 = editor2;
            markdownEditorWithPreview = fileEditor2 != null ? (MarkdownEditorWithPreview)((Object)fileEditor2.getUserData(MarkdownEditorWithPreview.PARENT_SPLIT_EDITOR_KEY)) : null;
        }
        return markdownEditorWithPreview;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @Nullable
    public static final MarkdownPreviewFileEditor findMarkdownPreviewEditor(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MarkdownEditorWithPreview markdownEditorWithPreview = MarkdownActionUtil.findSplitEditor(event);
        if (markdownEditorWithPreview == null) return null;
        MarkdownEditorWithPreview splitEditor = markdownEditorWithPreview;
        FileEditor fileEditor = splitEditor.getPreviewEditor();
        Intrinsics.checkNotNullExpressionValue((Object)fileEditor, (String)"splitEditor.previewEditor");
        FileEditor editor2 = fileEditor;
        if (!(editor2 instanceof MarkdownPreviewFileEditor)) return null;
        JComponent jComponent = editor2.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"editor.getComponent()");
        if (!jComponent.isVisible()) {
            return null;
        }
        MarkdownPreviewFileEditor markdownPreviewFileEditor = (MarkdownPreviewFileEditor)editor2;
        return markdownPreviewFileEditor;
    }

    @JvmStatic
    @Nullable
    public static final Editor findMarkdownTextEditor(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MarkdownEditorWithPreview splitEditor = MarkdownActionUtil.findSplitEditor(event);
        if (splitEditor == null) {
            PsiFile psiFile = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
            if (psiFile == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"event.getData(CommonData\u2026.PSI_FILE) ?: return null");
            PsiFile psiFile2 = psiFile;
            return Intrinsics.areEqual((Object)psiFile2.getLanguage(), (Object)((Object)MarkdownLanguage.INSTANCE)) && ApplicationKt.getApplication().isUnitTestMode() ? (Editor)event.getData(CommonDataKeys.EDITOR) : null;
        }
        TextEditor textEditor = splitEditor.getTextEditor();
        Intrinsics.checkNotNullExpressionValue((Object)textEditor, (String)"splitEditor.textEditor");
        TextEditor mainEditor = textEditor;
        JComponent jComponent = mainEditor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"mainEditor.component");
        return !jComponent.isVisible() ? null : mainEditor.getEditor();
    }

    @JvmStatic
    @NotNull
    public static final Pair<PsiElement, PsiElement> getElementsUnderCaretOrSelection(@NotNull PsiFile file, @NotNull Caret caret) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        if (caret.getSelectionStart() == caret.getSelectionEnd()) {
            PsiElement psiElement = PsiUtilBase.getElementAtOffset((PsiFile)file, (int)caret.getSelectionStart());
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"PsiUtilBase.getElementAt\u2026le, caret.selectionStart)");
            PsiElement element2 = psiElement;
            return TuplesKt.to((Object)element2, (Object)element2);
        }
        PsiElement psiElement = PsiUtilBase.getElementAtOffset((PsiFile)file, (int)caret.getSelectionStart());
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"PsiUtilBase.getElementAt\u2026le, caret.selectionStart)");
        PsiElement startElement = psiElement;
        PsiElement psiElement2 = PsiUtilBase.getElementAtOffset((PsiFile)file, (int)caret.getSelectionEnd());
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"PsiUtilBase.getElementAt\u2026file, caret.selectionEnd)");
        PsiElement endElement = psiElement2;
        return TuplesKt.to((Object)startElement, (Object)endElement);
    }

    @JvmStatic
    @Nullable
    public static final PsiElement getCommonParentOfType(@NotNull PsiElement left, @NotNull PsiElement right, @NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{elementType});
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"TokenSet.create(elementType)");
        return MarkdownActionUtil.getCommonParentOfTypes(left, right, tokenSet);
    }

    @JvmStatic
    @Nullable
    public static final PsiElement getCommonTopmostParentOfTypes(@NotNull PsiElement left, @NotNull PsiElement right, @NotNull TokenSet tokenSet) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)tokenSet, (String)"tokenSet");
        PsiElement base = PsiTreeUtil.findCommonParent((PsiElement)left, (PsiElement)right);
        return MarkdownActionUtil.getTopmostParentOfType(base, (Condition<? super PsiElement>)new Condition(tokenSet){
            final /* synthetic */ TokenSet $tokenSet;

            public final boolean value(PsiElement it) {
                PsiElement psiElement = it;
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"it");
                ASTNode node = psiElement.getNode();
                return node != null && this.$tokenSet.contains(node.getElementType());
            }
            {
                this.$tokenSet = tokenSet;
            }
        });
    }

    @JvmStatic
    @Nullable
    public static final PsiElement getTopmostParentOfType(@Nullable PsiElement element2, @NotNull Condition<? super PsiElement> condition) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        PsiElement answer = PsiTreeUtil.findFirstParent((PsiElement)element2, (boolean)false, condition);
        while (PsiTreeUtil.findFirstParent((PsiElement)answer, (boolean)true, condition) != null) {
            PsiElement next;
            Intrinsics.checkNotNullExpressionValue((Object)next, (String)"PsiTreeUtil.findFirstPar\u2026true, condition) ?: break");
            answer = next;
        }
        return answer;
    }

    @JvmStatic
    @Nullable
    public static final PsiElement getCommonParentOfTypes(@NotNull PsiElement left, @NotNull PsiElement right, @NotNull TokenSet tokenSet) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)tokenSet, (String)"tokenSet");
        PsiElement base = PsiTreeUtil.findCommonParent((PsiElement)left, (PsiElement)right);
        return PsiTreeUtil.findFirstParent((PsiElement)base, (boolean)false, (Condition)new Condition(tokenSet){
            final /* synthetic */ TokenSet $tokenSet;

            public final boolean value(PsiElement it) {
                PsiElement psiElement = it;
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"it");
                ASTNode node = psiElement.getNode();
                return node != null && this.$tokenSet.contains(node.getElementType());
            }
            {
                this.$tokenSet = tokenSet;
            }
        });
    }

    private MarkdownActionUtil() {
    }

    static {
        MarkdownActionUtil markdownActionUtil;
        INSTANCE = markdownActionUtil = new MarkdownActionUtil();
    }
}

