/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.lang.MarkdownFileType;
import org.intellij.plugins.markdown.lang.MarkdownLanguage;
import org.intellij.plugins.markdown.ui.floating.FloatingToolbar;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\f"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/MarkdownTextEditorProvider;", "Lcom/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider;", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "shouldAcceptScratchFile", "intellij.markdown.core"})
@ApiStatus.Experimental
public final class MarkdownTextEditorProvider
extends PsiAwareTextEditorProvider {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!super.accept(project, file)) {
            return false;
        }
        return FileTypeRegistry.getInstance().isFileOfType(file, (FileType)MarkdownFileType.INSTANCE) || this.shouldAcceptScratchFile(project, file);
    }

    private final boolean shouldAcceptScratchFile(Project project, VirtualFile file) {
        return ScratchUtil.isScratch((VirtualFile)file) && Intrinsics.areEqual((Object)LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file, (FileType)file.getFileType()), (Object)((Object)MarkdownLanguage.INSTANCE));
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileEditor fileEditor = super.createEditor(project, file);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditor, (String)"super.createEditor(project, file)");
        FileEditor actualEditor = fileEditor;
        if (actualEditor instanceof TextEditor && !AdvancedSettings.Companion.getBoolean("markdown.hide.floating.toolbar")) {
            Editor editor2 = ((TextEditor)actualEditor).getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"actualEditor.editor");
            FloatingToolbar toolbar2 = new FloatingToolbar(editor2, "Markdown.Toolbar.Floating");
            Disposer.register((Disposable)((Disposable)actualEditor), (Disposable)toolbar2);
        }
        return actualEditor;
    }
}

