/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.util;

import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.util.UtilKt;
import com.intellij.indexing.shared.util.zipFs.Zip64Util;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.zip.JBZipEntry;
import com.intellij.util.io.zip.JBZipFile;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.Iterator;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a2\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u001a\u000e\u0010\n\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001e\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0003\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0003\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0011\u001a\n\u0010\u0012\u001a\u00020\u000f*\u00020\u0013\u00a8\u0006\u0014"}, d2={"compressSharedIndex", "", "file", "Ljava/nio/file/Path;", "output", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "compressorStream", "Lkotlin/Function1;", "Ljava/io/OutputStream;", "recreateDir", "uncompressedZip", "dir", "targetFile", "getFileOrDirectorySize", "", "sha256", "", "totalSize", "Ljava/io/File;", "intellij.indexing.shared"})
public final class UtilKt {
    @NotNull
    public static final String sha256(@NotNull Path $this$sha256) {
        Intrinsics.checkNotNullParameter((Object)$this$sha256, (String)"$this$sha256");
        MessageDigest digest = DigestUtil.sha256();
        DigestUtil.updateContentHash((MessageDigest)digest, (Path)$this$sha256);
        String string = StringUtil.toHexString((byte[])digest.digest());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.toHexString(digest.digest())");
        return string;
    }

    @NotNull
    public static final String sha256(@NotNull String $this$sha256) {
        Intrinsics.checkNotNullParameter((Object)$this$sha256, (String)"$this$sha256");
        MessageDigest digest = DigestUtil.sha256();
        String string = $this$sha256;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        digest.update(byArray);
        String string2 = StringUtil.toHexString((byte[])digest.digest());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringUtil.toHexString(digest.digest())");
        return string2;
    }

    @NotNull
    public static final Path recreateDir(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileUtil.delete((Path)file);
        Files.createDirectories(file, new FileAttribute[0]);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long totalSize(@NotNull File $this$totalSize) {
        Intrinsics.checkNotNullParameter((Object)$this$totalSize, (String)"$this$totalSize");
        if ($this$totalSize.isFile()) {
            return $this$totalSize.length();
        }
        if ($this$totalSize.isDirectory()) {
            long l;
            AutoCloseable autoCloseable = Files.walk($this$totalSize.toPath(), new FileVisitOption[0]);
            Throwable throwable = null;
            try {
                Stream stream = (Stream)autoCloseable;
                boolean bl = false;
                l = stream.mapToLong(totalSize.1.1.INSTANCE).sum();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            return l;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void uncompressedZip(@NotNull Path dir, @NotNull Path targetFile, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.pushState();
        indicator.setText(SharedIndexesBundle.message("progress.text.zipping.index.pack", new Object[0]));
        try {
            Closeable closeable = (Closeable)Zip64Util.openZip64File(targetFile, false);
            Throwable throwable = null;
            try {
                JBZipFile file = (JBZipFile)closeable;
                boolean bl = false;
                indicator.setText2(SharedIndexesBundle.message("progress.text2.scanning.files", new Object[0]));
                AutoCloseable autoCloseable = Files.walk(dir, new FileVisitOption[0]);
                Throwable throwable2 = null;
                try {
                    Object stream = (Stream)autoCloseable;
                    boolean bl2 = false;
                    Stream stream2 = stream.filter(uncompressedZip.1.allFiles.1.1.INSTANCE);
                    Intrinsics.checkNotNullExpressionValue(stream2, (String)"stream.filter { !Files.isDirectory(it) }");
                    stream = StreamsKt.toList(stream2);
                }
                catch (Throwable stream) {
                    throwable2 = stream;
                    throw stream;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
                }
                Object allFiles2 = stream;
                indicator.setIndeterminate(false);
                double count = 0.0;
                Iterator iterator = allFiles2.iterator();
                while (iterator.hasNext()) {
                    String relativePath;
                    Path p = (Path)iterator.next();
                    indicator.checkCanceled();
                    Intrinsics.checkNotNullExpressionValue((Object)FileUtil.toSystemIndependentName((String)((Object)dir.relativize(p)).toString()), (String)"FileUtil.toSystemIndepen\u2026relativize(p).toString())");
                    try {
                        JBZipEntry entry;
                        double d = count;
                        count = d + 1.0;
                        indicator.setFraction(d / (double)allFiles2.size());
                        JBZipEntry jBZipEntry = entry = file.getOrCreateEntry(relativePath);
                        Intrinsics.checkNotNullExpressionValue((Object)jBZipEntry, (String)"entry");
                        jBZipEntry.setMethod(0);
                        entry.setDataFromPath(p);
                    }
                    catch (Exception e) {
                        throw (Throwable)new RuntimeException("Failed to add " + relativePath + " entry to the target archive. " + e.getMessage(), e);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable e) {
            FileUtil.delete((Path)targetFile);
            if (e instanceof ControlFlowException) {
                throw e;
            }
            throw (Throwable)new RuntimeException("Failed to generate indexes archive at " + targetFile + ". " + e.getMessage(), e);
        }
        finally {
            indicator.popState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void compressSharedIndex(@NotNull Path file, @NotNull Path output, @NotNull ProgressIndicator indicator, @NotNull Function1<? super OutputStream, ? extends OutputStream> compressorStream) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(compressorStream, (String)"compressorStream");
        indicator.pushState();
        int bufferSize = 0x800000;
        indicator.setText(SharedIndexesBundle.message("packing.to.xz", new Object[0]));
        indicator.setIndeterminate(false);
        long total = Files.size(file);
        long completed = 0L;
        try {
            Closeable closeable = PathKt.outputStream$default((Path)output, (boolean)false, (int)1, null);
            closeable = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, bufferSize);
            Throwable throwable = null;
            try {
                BufferedOutputStream outputStream = (BufferedOutputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = (Closeable)compressorStream.invoke((Object)outputStream);
                Throwable throwable2 = null;
                try {
                    OutputStream output2 = (OutputStream)closeable2;
                    boolean bl2 = false;
                    Closeable closeable3 = PathKt.inputStream((Path)file);
                    Throwable throwable3 = null;
                    try {
                        int sz;
                        InputStream inputStream = (InputStream)closeable3;
                        boolean bl3 = false;
                        byte[] buffer = new byte[bufferSize];
                        while ((sz = inputStream.read(buffer)) > 0) {
                            output2.write(buffer, 0, sz);
                            indicator.setFraction((double)(completed += (long)sz) / (double)total);
                            indicator.checkCanceled();
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable e) {
            FileUtil.delete((Path)output);
            if (e instanceof ControlFlowException) {
                throw e;
            }
            throw (Throwable)new RuntimeException("Failed to generate compressed shared index from " + file + " to " + output + ". " + e.getMessage(), e);
        }
        finally {
            indicator.popState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long getFileOrDirectorySize(@NotNull Path $this$getFileOrDirectorySize) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$getFileOrDirectorySize, (String)"$this$getFileOrDirectorySize");
        if (!Files.exists($this$getFileOrDirectorySize, new LinkOption[0])) {
            return 0L;
        }
        if (!Files.isDirectory($this$getFileOrDirectorySize, new LinkOption[0])) {
            l = Files.size($this$getFileOrDirectorySize);
        } else {
            AutoCloseable autoCloseable = Files.walk($this$getFileOrDirectorySize, new FileVisitOption[0]);
            Throwable throwable = null;
            try {
                Stream it = (Stream)autoCloseable;
                boolean bl = false;
                long l2 = it.filter(getFileOrDirectorySize.1.1.INSTANCE).mapToLong(getFileOrDirectorySize.1.2.INSTANCE).sum();
                l = l2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        return l;
    }
}

