/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.writer;

import java.io.File;
import java.util.Comparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.ArtifactVerificationOperation;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;

abstract class VerificationEntry
implements Comparable<VerificationEntry> {
    private static final Comparator<VerificationEntry> ENTRY_COMPARATOR = Comparator.comparing(VerificationEntry::getGroup).thenComparing(VerificationEntry::getModule).thenComparing(VerificationEntry::getVersion).thenComparing(VerificationEntry::getFile).thenComparing(VerificationEntry::getArtifactKind).thenComparing(VerificationEntry::getOrder);
    protected final ModuleComponentArtifactIdentifier id;
    protected final ArtifactVerificationOperation.ArtifactKind artifactKind;
    protected final File file;

    protected VerificationEntry(ModuleComponentArtifactIdentifier id, ArtifactVerificationOperation.ArtifactKind artifactKind, File file) {
        this.id = id;
        this.artifactKind = artifactKind;
        this.file = file;
    }

    public ModuleComponentArtifactIdentifier getId() {
        return this.id;
    }

    String getGroup() {
        return this.id.getComponentIdentifier().getGroup();
    }

    String getModule() {
        return this.id.getComponentIdentifier().getModule();
    }

    String getVersion() {
        return this.id.getComponentIdentifier().getVersion();
    }

    public ArtifactVerificationOperation.ArtifactKind getArtifactKind() {
        return this.artifactKind;
    }

    public File getFile() {
        return this.file;
    }

    abstract int getOrder();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerificationEntry that = (VerificationEntry)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (this.artifactKind != that.artifactKind) {
            return false;
        }
        return this.file.equals(that.file);
    }

    public int hashCode() {
        int result2 = this.id.hashCode();
        result2 = 31 * result2 + this.artifactKind.hashCode();
        result2 = 31 * result2 + this.file.hashCode();
        return result2;
    }

    @Override
    public int compareTo(VerificationEntry other) {
        return ENTRY_COMPARATOR.compare(this, other);
    }
}

