/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.bundling;

import org.gradle.api.internal.file.archive.TarCopyAction;
import org.gradle.api.internal.file.archive.compression.ArchiveOutputStreamFactory;
import org.gradle.api.internal.file.archive.compression.Bzip2Archiver;
import org.gradle.api.internal.file.archive.compression.GzipArchiver;
import org.gradle.api.internal.file.archive.compression.SimpleCompressor;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Compression;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not worth caching")
public class Tar
extends AbstractArchiveTask {
    private Compression compression = Compression.NONE;

    public Tar() {
        this.getArchiveExtension().set(this.getProject().provider(() -> this.getCompression().getDefaultExtension()));
    }

    @Override
    protected CopyAction createCopyAction() {
        return new TarCopyAction(this.getArchiveFile().get().getAsFile(), this.getCompressor(), this.isPreserveFileTimestamps());
    }

    private ArchiveOutputStreamFactory getCompressor() {
        switch (this.compression) {
            case BZIP2: {
                return Bzip2Archiver.getCompressor();
            }
            case GZIP: {
                return GzipArchiver.getCompressor();
            }
        }
        return new SimpleCompressor();
    }

    @Input
    public Compression getCompression() {
        return this.compression;
    }

    public void setCompression(Compression compression) {
        this.compression = compression;
    }
}

