/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal;

import java.util.ArrayList;
import javax.annotation.Nullable;
import org.gradle.api.IllegalDependencyNotation;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.org.apache.commons.lang.ObjectUtils;
import org.gradle.platform.base.DependencySpec;
import org.gradle.platform.base.ProjectDependencySpec;
import org.gradle.platform.base.ProjectDependencySpecBuilder;

public class DefaultProjectDependencySpec
implements ProjectDependencySpec {
    private final String projectPath;
    private final String libraryName;

    public DefaultProjectDependencySpec(String libraryName, String projectPath) {
        if (libraryName == null && projectPath == null) {
            throw new IllegalDependencyNotation("A project dependency must have at least a project or library name specified.");
        }
        this.libraryName = libraryName;
        this.projectPath = projectPath;
    }

    @Override
    public String getProjectPath() {
        return this.projectPath;
    }

    @Override
    @Nullable
    public String getLibraryName() {
        return this.libraryName;
    }

    @Override
    public String getDisplayName() {
        ArrayList parts = Lists.newArrayList();
        if (this.getProjectPath() != null) {
            parts.add("project '" + this.getProjectPath() + "'");
        }
        if (this.getLibraryName() != null) {
            parts.add("library '" + this.getLibraryName() + "'");
        }
        return Joiner.on((char)' ').join((Iterable)parts);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultProjectDependencySpec that = (DefaultProjectDependencySpec)o;
        return ObjectUtils.equals((Object)this.projectPath, (Object)that.projectPath) && ObjectUtils.equals((Object)this.libraryName, (Object)that.libraryName);
    }

    public int hashCode() {
        int result2 = ObjectUtils.hashCode((Object)this.projectPath);
        result2 = 31 * result2 + ObjectUtils.hashCode((Object)this.libraryName);
        return result2;
    }

    public static class Builder
    implements ProjectDependencySpecBuilder {
        private String projectPath;
        private String libraryName;

        @Override
        public ProjectDependencySpecBuilder project(String path) {
            this.checkNotSet("project", this.projectPath);
            this.projectPath = path;
            return this;
        }

        @Override
        public ProjectDependencySpecBuilder library(String name) {
            this.checkNotSet("library", this.libraryName);
            this.libraryName = name;
            return this;
        }

        private void checkNotSet(String name, String value) {
            if (value != null) {
                throw new IllegalDependencyNotation(String.format("Cannot set '%s' multiple times for project dependency.", name));
            }
        }

        @Override
        public DependencySpec build() {
            this.validate();
            return new DefaultProjectDependencySpec(this.libraryName, this.projectPath);
        }

        private void validate() {
            if (this.projectPath == null && this.libraryName != null && this.libraryName.contains(":")) {
                throw new IllegalDependencyNotation(String.format("'%s' is not a valid library name. Did you mean to refer to a module instead?", this.libraryName));
            }
        }
    }
}

