/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.tasks;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.gradle.api.DefaultTask;
import org.gradle.api.Transformer;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.util.PropertiesUtils;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not worth caching")
public class PluginUnderTestMetadata
extends DefaultTask {
    public static final String IMPLEMENTATION_CLASSPATH_PROP_KEY = "implementation-classpath";
    public static final String METADATA_FILE_NAME = "plugin-under-test-metadata.properties";
    private final ConfigurableFileCollection pluginClasspath = this.getProject().files(new Object[0]);
    private final DirectoryProperty outputDirectory = this.getProject().getObjects().directoryProperty();

    @Classpath
    public ConfigurableFileCollection getPluginClasspath() {
        return this.pluginClasspath;
    }

    @OutputDirectory
    public DirectoryProperty getOutputDirectory() {
        return this.outputDirectory;
    }

    @TaskAction
    public void generate() {
        Properties properties = new Properties();
        if (!this.getPluginClasspath().isEmpty()) {
            properties.setProperty(IMPLEMENTATION_CLASSPATH_PROP_KEY, this.implementationClasspath());
        }
        File outputFile = new File(((Directory)this.getOutputDirectory().get()).getAsFile(), METADATA_FILE_NAME);
        this.saveProperties(properties, outputFile);
    }

    private String implementationClasspath() {
        StringBuilder implementationClasspath = new StringBuilder();
        Joiner.on((String)File.pathSeparator).appendTo(implementationClasspath, this.getPaths());
        return implementationClasspath.toString();
    }

    private void saveProperties(Properties properties, File outputFile) {
        try {
            PropertiesUtils.store(properties, outputFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Input
    protected List<String> getPaths() {
        return CollectionUtils.collect(this.getPluginClasspath(), new Transformer<String, File>(){

            @Override
            public String transform(File file) {
                return file.getAbsolutePath().replaceAll("\\\\", "/");
            }
        });
    }
}

