/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ignore;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.NotIgnored;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.IgnoredFileDescriptor;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.ignore.GitIgnoreChecker;
import git4idea.ignore.GitIgnoredFileContentProvider$WhenMappings;
import git4idea.ignore.GitIgnoredFileContentProviderKt;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J#\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\bH\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020\nH\u0002J:\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0#2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J\u0012\u0010%\u001a\u00020\b2\b\b\u0001\u0010&\u001a\u00020\bH\u0003J\u001e\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J6\u0010)\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010*\u001a\u00020+H\u0002J6\u0010,\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010*\u001a\u00020+H\u0002J\u0018\u0010-\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\nH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lgit4idea/ignore/GitIgnoredFileContentProvider;", "Lcom/intellij/openapi/vcs/changes/IgnoredFileContentProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "gitIgnoreChecker", "Lgit4idea/ignore/GitIgnoreChecker;", "buildIgnoreEntryContent", "", "ignoreEntryRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "ignoredFileDescriptor", "Lcom/intellij/openapi/vcs/changes/IgnoredFileDescriptor;", "buildIgnoreFileContent", "ignoreFileRoot", "ignoredFileProviders", "", "Lcom/intellij/openapi/vcs/changes/IgnoredFileProvider;", "(Lcom/intellij/openapi/vfs/VirtualFile;[Lcom/intellij/openapi/vcs/changes/IgnoredFileProvider;)Ljava/lang/String;", "buildIgnoreGroupDescription", "ignoredFileProvider", "buildUnignoreContent", "ignorePattern", "canCreateIgnoreFileInStateStoreDir", "", "getFileName", "getSupportedVcs", "Lcom/intellij/openapi/vcs/VcsKey;", "getUntrackedFiles", "", "Lcom/intellij/openapi/vcs/FilePath;", "ignoreFileVcsRoot", "ignoreBeansToRelativePaths", "", "iterable", "", "untrackedFiles", "prependCommentHashCharacterIfNeeded", "description", "shouldIgnoreByMask", "ignoredBean", "shouldIgnoreFile", "vcsContextFactory", "Lcom/intellij/openapi/vcs/actions/VcsContextFactory;", "shouldIgnoreUnderDir", "shouldNotConsiderInternalIgnoreFile", "intellij.vcs.git"})
public class GitIgnoredFileContentProvider
implements IgnoredFileContentProvider {
    private final GitIgnoreChecker gitIgnoreChecker;
    private final Project project;

    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = GitVcs.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)vcsKey, (String)"GitVcs.getKey()");
        return vcsKey;
    }

    @NotNull
    public String getFileName() {
        return ".gitignore";
    }

    @NotNull
    public String buildIgnoreFileContent(@NotNull VirtualFile ignoreFileRoot, @NotNull IgnoredFileProvider[] ignoredFileProviders) {
        Intrinsics.checkNotNullParameter((Object)ignoreFileRoot, (String)"ignoreFileRoot");
        Intrinsics.checkNotNullParameter((Object)ignoredFileProviders, (String)"ignoredFileProviders");
        if (!GitUtil.isUnderGit(ignoreFileRoot)) {
            return "";
        }
        VirtualFile virtualFile = VcsUtil.getVcsRootFor((Project)this.project, (VirtualFile)ignoreFileRoot);
        if (virtualFile == null) {
            return "";
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"VcsUtil.getVcsRootFor(pr\u2026oreFileRoot) ?: return \"\"");
        VirtualFile ignoreFileVcsRoot = virtualFile;
        StringBuilder content2 = new StringBuilder();
        String lineSeparator = System.lineSeparator();
        Set<FilePath> untrackedFiles = this.getUntrackedFiles(ignoreFileVcsRoot);
        if (untrackedFiles.isEmpty()) {
            return "";
        }
        for (IgnoredFileProvider provider : ignoredFileProviders) {
            String description;
            Set set = provider.getIgnoredFiles(this.project);
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"provider.getIgnoredFiles(project)");
            List<String> ignoredFiles = this.ignoreBeansToRelativePaths(set, ignoreFileVcsRoot, ignoreFileRoot, untrackedFiles);
            if (ignoredFiles.isEmpty()) continue;
            CharSequence charSequence = content2;
            if (charSequence.length() > 0) {
                content2.append(lineSeparator).append(lineSeparator);
            }
            Intrinsics.checkNotNullExpressionValue((Object)provider.getIgnoredGroupDescription(), (String)"provider.ignoredGroupDescription");
            CharSequence charSequence2 = description;
            if (!StringsKt.isBlank((CharSequence)charSequence2)) {
                content2.append(this.buildIgnoreGroupDescription(provider));
                content2.append(lineSeparator);
            }
            Iterable iterable = ignoredFiles;
            String string = lineSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator");
            content2.append(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null));
        }
        String string = content2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"content.toString()");
        return string;
    }

    private final Set<FilePath> getUntrackedFiles(VirtualFile ignoreFileVcsRoot) {
        try {
            GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(this.project).getRepositoryForRoot(ignoreFileVcsRoot);
            if (gitRepository == null) {
                return SetsKt.emptySet();
            }
            Intrinsics.checkNotNullExpressionValue((Object)gitRepository, (String)"GitRepositoryManager.get\u2026oot) ?: return emptySet()");
            GitRepository repo = gitRepository;
            Collection<FilePath> collection = repo.getUntrackedFilesHolder().retrieveUntrackedFilePaths();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"repo.untrackedFilesHolde\u2026rieveUntrackedFilePaths()");
            return CollectionsKt.toSet((Iterable)collection);
        }
        catch (VcsException e) {
            GitIgnoredFileContentProviderKt.access$getLOG$p().warn("Cannot get untracked files: ", (Throwable)e);
            return SetsKt.emptySet();
        }
    }

    private final List<String> ignoreBeansToRelativePaths(Iterable<? extends IgnoredFileDescriptor> iterable, VirtualFile ignoreFileVcsRoot, VirtualFile ignoreFileRoot, Set<? extends FilePath> untrackedFiles) {
        VcsContextFactory vcsContextFactory = VcsContextFactory.SERVICE.getInstance();
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence(iterable), (Function1)((Function1)new Function1<IgnoredFileDescriptor, Boolean>(this, untrackedFiles, ignoreFileRoot, ignoreFileVcsRoot, vcsContextFactory){
            final /* synthetic */ GitIgnoredFileContentProvider this$0;
            final /* synthetic */ Set $untrackedFiles;
            final /* synthetic */ VirtualFile $ignoreFileRoot;
            final /* synthetic */ VirtualFile $ignoreFileVcsRoot;
            final /* synthetic */ VcsContextFactory $vcsContextFactory;

            public final boolean invoke(@NotNull IgnoredFileDescriptor ignoredBean) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)ignoredBean, (String)"ignoredBean");
                switch (GitIgnoredFileContentProvider$WhenMappings.$EnumSwitchMapping$0[ignoredBean.getType().ordinal()]) {
                    case 1: {
                        VcsContextFactory vcsContextFactory = this.$vcsContextFactory;
                        Intrinsics.checkNotNullExpressionValue((Object)vcsContextFactory, (String)"vcsContextFactory");
                        bl = GitIgnoredFileContentProvider.access$shouldIgnoreUnderDir(this.this$0, ignoredBean, this.$untrackedFiles, this.$ignoreFileRoot, this.$ignoreFileVcsRoot, vcsContextFactory);
                        break;
                    }
                    case 2: {
                        VcsContextFactory vcsContextFactory = this.$vcsContextFactory;
                        Intrinsics.checkNotNullExpressionValue((Object)vcsContextFactory, (String)"vcsContextFactory");
                        bl = GitIgnoredFileContentProvider.access$shouldIgnoreFile(this.this$0, ignoredBean, this.$untrackedFiles, this.$ignoreFileRoot, this.$ignoreFileVcsRoot, vcsContextFactory);
                        break;
                    }
                    case 3: {
                        bl = GitIgnoredFileContentProvider.access$shouldIgnoreByMask(this.this$0, ignoredBean, this.$untrackedFiles);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return bl;
            }
            {
                this.this$0 = gitIgnoredFileContentProvider;
                this.$untrackedFiles = set;
                this.$ignoreFileRoot = virtualFile;
                this.$ignoreFileVcsRoot = virtualFile2;
                this.$vcsContextFactory = vcsContextFactory;
                super(1);
            }
        })), (Function1)((Function1)new Function1<IgnoredFileDescriptor, String>(this, ignoreFileRoot){
            final /* synthetic */ GitIgnoredFileContentProvider this$0;
            final /* synthetic */ VirtualFile $ignoreFileRoot;

            @NotNull
            public final String invoke(@NotNull IgnoredFileDescriptor ignoredBean) {
                String string;
                Intrinsics.checkNotNullParameter((Object)ignoredBean, (String)"ignoredBean");
                switch (GitIgnoredFileContentProvider$WhenMappings.$EnumSwitchMapping$1[ignoredBean.getType().ordinal()]) {
                    case 1: {
                        String string2 = ignoredBean.getMask();
                        string = string2;
                        Intrinsics.checkNotNull((Object)string2);
                        break;
                    }
                    case 2: {
                        string = this.this$0.buildIgnoreEntryContent(this.$ignoreFileRoot, ignoredBean);
                        break;
                    }
                    case 3: {
                        string = this.this$0.buildIgnoreEntryContent(this.$ignoreFileRoot, ignoredBean);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return string;
            }
            {
                this.this$0 = gitIgnoredFileContentProvider;
                this.$ignoreFileRoot = virtualFile;
                super(1);
            }
        })));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldIgnoreUnderDir(IgnoredFileDescriptor ignoredBean, Set<? extends FilePath> untrackedFiles, VirtualFile ignoreFileRoot, VirtualFile ignoreFileVcsRoot, VcsContextFactory vcsContextFactory) {
        FilePath it;
        String string = ignoredBean.getPath();
        if (string == null) return false;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ignoredBean.path ?: return false");
        String path = string;
        Path file = Paths.get(path, new String[0]);
        if (!Files.exists(file, new LinkOption[0])) return false;
        Iterable $this$any$iv = untrackedFiles;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (FilePath)element$iv;
            boolean bl = false;
        } while (!FileUtil.isAncestor((String)path, (String)it.getPath(), (boolean)true));
        boolean bl = true;
        if (!bl) return false;
        if (!FileUtil.isAncestor((String)ignoreFileRoot.getPath(), (String)path, (boolean)false)) return false;
        if (!Comparing.equal((Object)ignoreFileVcsRoot, (Object)VcsUtil.getVcsRootFor((Project)this.project, (FilePath)vcsContextFactory.createFilePath(path, true)))) return false;
        Path path2 = file;
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"file");
        if (!(this.gitIgnoreChecker.isIgnored(ignoreFileVcsRoot, path2) instanceof NotIgnored)) return false;
        if (!this.shouldNotConsiderInternalIgnoreFile(ignoredBean, ignoreFileRoot)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldIgnoreFile(IgnoredFileDescriptor ignoredBean, Set<? extends FilePath> untrackedFiles, VirtualFile ignoreFileRoot, VirtualFile ignoreFileVcsRoot, VcsContextFactory vcsContextFactory) {
        FilePath it;
        if (!FileUtil.exists((String)ignoredBean.getPath())) return false;
        Iterable $this$any$iv = untrackedFiles;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (FilePath)element$iv;
            boolean bl = false;
        } while (!ignoredBean.matchesFile(it));
        boolean bl = true;
        if (!bl) return false;
        String string = ignoreFileRoot.getPath();
        String string2 = ignoredBean.getPath();
        Intrinsics.checkNotNull((Object)string2);
        if (!FileUtil.isAncestor((String)string, (String)string2, (boolean)false)) return false;
        String string3 = ignoredBean.getPath();
        Intrinsics.checkNotNull((Object)string3);
        if (!Comparing.equal((Object)ignoreFileVcsRoot, (Object)VcsUtil.getVcsRootFor((Project)this.project, (FilePath)vcsContextFactory.createFilePath(string3, false)))) return false;
        if (!this.shouldNotConsiderInternalIgnoreFile(ignoredBean, ignoreFileRoot)) return false;
        return true;
    }

    private final boolean shouldIgnoreByMask(IgnoredFileDescriptor ignoredBean, Set<? extends FilePath> untrackedFiles) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = untrackedFiles;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FilePath it = (FilePath)element$iv;
                    boolean bl2 = false;
                    if (!ignoredBean.matchesFile(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean shouldNotConsiderInternalIgnoreFile(IgnoredFileDescriptor ignoredBean, VirtualFile ignoreFileRoot) {
        boolean insideDirectoryStore;
        String string = ignoredBean.getPath();
        boolean bl = insideDirectoryStore = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)".idea", (boolean)false, (int)2, null) : false;
        if (insideDirectoryStore) {
            Path path = ProjectKt.getStateStore((Project)this.project).getDirectoryStorePath();
            if (path == null) {
                String string2 = this.project.getProjectFilePath();
                if (string2 != null) {
                    String string3;
                    String it = string3 = string2;
                    boolean bl2 = false;
                    Path path2 = Paths.get(it, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Paths.get(it)");
                    path = path2.getParent();
                } else {
                    path = null;
                }
            }
            if (path == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"project.stateStore.direc\u2026.parent } ?: return false");
            Path directoryStoreOrProjectFileLocation = path;
            return FileUtil.isAncestor((String)((Object)directoryStoreOrProjectFileLocation).toString(), (String)FileUtil.toSystemDependentName((String)ignoreFileRoot.getPath()), (boolean)false);
        }
        return true;
    }

    @NotNull
    public String buildUnignoreContent(@NotNull String ignorePattern) {
        Intrinsics.checkNotNullParameter((Object)ignorePattern, (String)"ignorePattern");
        StringBuilder builder = new StringBuilder();
        builder.append(System.lineSeparator());
        builder.append('!').append(ignorePattern);
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    @NotNull
    public String buildIgnoreGroupDescription(@NotNull IgnoredFileProvider ignoredFileProvider) {
        Intrinsics.checkNotNullParameter((Object)ignoredFileProvider, (String)"ignoredFileProvider");
        String string = ignoredFileProvider.getIgnoredGroupDescription();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ignoredFileProvider.ignoredGroupDescription");
        return this.prependCommentHashCharacterIfNeeded(string);
    }

    @NotNull
    public String buildIgnoreEntryContent(@NotNull VirtualFile ignoreEntryRoot, @NotNull IgnoredFileDescriptor ignoredFileDescriptor) {
        Intrinsics.checkNotNullParameter((Object)ignoreEntryRoot, (String)"ignoreEntryRoot");
        Intrinsics.checkNotNullParameter((Object)ignoredFileDescriptor, (String)"ignoredFileDescriptor");
        String string = ignoreEntryRoot.getPath();
        String string2 = ignoredFileDescriptor.getPath();
        Intrinsics.checkNotNull((Object)string2);
        String string3 = FileUtil.getRelativePath((String)string, (String)string2, (char)'/');
        if (string3 == null) {
            string3 = "";
        }
        return "/" + string3;
    }

    @NlsContexts.DetailedDescription
    private final String prependCommentHashCharacterIfNeeded(@NlsContexts.DetailedDescription String description) {
        return StringsKt.startsWith$default((String)description, (String)"#", (boolean)false, (int)2, null) ? description : "# " + description;
    }

    public boolean canCreateIgnoreFileInStateStoreDir() {
        return false;
    }

    public GitIgnoredFileContentProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.gitIgnoreChecker = new GitIgnoreChecker();
    }

    public static final /* synthetic */ boolean access$shouldIgnoreUnderDir(GitIgnoredFileContentProvider $this, IgnoredFileDescriptor ignoredBean, Set untrackedFiles, VirtualFile ignoreFileRoot, VirtualFile ignoreFileVcsRoot, VcsContextFactory vcsContextFactory) {
        return $this.shouldIgnoreUnderDir(ignoredBean, untrackedFiles, ignoreFileRoot, ignoreFileVcsRoot, vcsContextFactory);
    }

    public static final /* synthetic */ boolean access$shouldIgnoreFile(GitIgnoredFileContentProvider $this, IgnoredFileDescriptor ignoredBean, Set untrackedFiles, VirtualFile ignoreFileRoot, VirtualFile ignoreFileVcsRoot, VcsContextFactory vcsContextFactory) {
        return $this.shouldIgnoreFile(ignoredBean, untrackedFiles, ignoreFileRoot, ignoreFileVcsRoot, vcsContextFactory);
    }

    public static final /* synthetic */ boolean access$shouldIgnoreByMask(GitIgnoredFileContentProvider $this, IgnoredFileDescriptor ignoredBean, Set untrackedFiles) {
        return $this.shouldIgnoreByMask(ignoredBean, untrackedFiles);
    }
}

