/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.ui.ChangeListViewerDialog;
import com.intellij.openapi.vcs.changes.ui.LoadingCommittedChangeListPanel;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.branch.GitBranchPair;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitMessageWithFilesDetector;
import git4idea.commands.GitStandardProgressAnalyzer;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitConflictResolver;
import git4idea.merge.GitMerger;
import git4idea.repo.GitRepository;
import git4idea.update.GitUpdateResult;
import git4idea.update.GitUpdater;
import git4idea.util.GitUntrackedFilesHelper;
import git4idea.util.LocalChangesWouldBeOverwrittenHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitMergeUpdater
extends GitUpdater {
    private static final Logger LOG = Logger.getInstance(GitMergeUpdater.class);
    @NotNull
    private final ChangeListManager myChangeListManager;
    @NotNull
    private final GitBranchPair myBranchPair;

    public GitMergeUpdater(@NotNull Project project, @NotNull Git git, @NotNull GitRepository repository, @NotNull GitBranchPair branchPair, @NotNull ProgressIndicator progressIndicator, @NotNull UpdatedFiles updatedFiles) {
        if (project == null) {
            GitMergeUpdater.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitMergeUpdater.$$$reportNull$$$0(1);
        }
        if (repository == null) {
            GitMergeUpdater.$$$reportNull$$$0(2);
        }
        if (branchPair == null) {
            GitMergeUpdater.$$$reportNull$$$0(3);
        }
        if (progressIndicator == null) {
            GitMergeUpdater.$$$reportNull$$$0(4);
        }
        if (updatedFiles == null) {
            GitMergeUpdater.$$$reportNull$$$0(5);
        }
        super(project, git, repository, progressIndicator, updatedFiles);
        this.myBranchPair = branchPair;
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
    }

    @Override
    @NotNull
    protected GitUpdateResult doUpdate() {
        LOG.info("doUpdate ");
        GitMerger merger = new GitMerger(this.myProject);
        MergeLineListener mergeLineListener = new MergeLineListener();
        GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector = new GitUntrackedFilesOverwrittenByOperationDetector(this.myRoot);
        String originalText = this.myProgressIndicator.getText();
        this.myProgressIndicator.setText(GitBundle.message("progress.text.merging.repository", GitUtil.mention(this.myRepository)));
        try {
            GitCommandResult result2 = this.myGit.merge(this.myRepository, this.myBranchPair.getTarget().getName(), Arrays.asList("--no-stat", "-v"), mergeLineListener, untrackedFilesDetector, GitStandardProgressAnalyzer.createListener(this.myProgressIndicator));
            this.myProgressIndicator.setText(originalText);
            return result2.success() ? GitUpdateResult.SUCCESS : this.handleMergeFailure(mergeLineListener, untrackedFilesDetector, merger, result2);
        }
        catch (ProcessCanceledException pce) {
            this.cancel();
            GitUpdateResult gitUpdateResult = GitUpdateResult.CANCEL;
            if (gitUpdateResult == null) {
                GitMergeUpdater.$$$reportNull$$$0(6);
            }
            return gitUpdateResult;
        }
    }

    @NotNull
    private GitUpdateResult handleMergeFailure(MergeLineListener mergeLineListener, GitMessageWithFilesDetector untrackedFilesWouldBeOverwrittenByMergeDetector, GitMerger merger, GitCommandResult commandResult) {
        MergeError error = mergeLineListener.getMergeError();
        LOG.info("merge error: " + error);
        if (error == MergeError.CONFLICT) {
            LOG.info("Conflict detected");
            boolean allMerged = new MyConflictResolver(this.myProject, this.myGit, merger, this.myRoot).merge();
            GitUpdateResult gitUpdateResult = allMerged ? GitUpdateResult.SUCCESS_WITH_RESOLVED_CONFLICTS : GitUpdateResult.INCOMPLETE;
            if (gitUpdateResult == null) {
                GitMergeUpdater.$$$reportNull$$$0(7);
            }
            return gitUpdateResult;
        }
        if (error == MergeError.LOCAL_CHANGES) {
            LOG.info("Local changes would be overwritten by merge");
            List<FilePath> paths = this.getFilesOverwrittenByMerge(mergeLineListener.getOutput());
            Collection<Change> changes = this.getLocalChangesFilteredByFiles(paths);
            UIUtil.invokeAndWaitIfNeeded(() -> {
                LoadingCommittedChangeListPanel panel2 = new LoadingCommittedChangeListPanel(this.myProject);
                panel2.setChanges(changes, null);
                panel2.setDescription(LocalChangesWouldBeOverwrittenHelper.getErrorNotificationDescription());
                ChangeListViewerDialog.showDialog((Project)this.myProject, null, (LoadingCommittedChangeListPanel)panel2);
            });
            GitUpdateResult gitUpdateResult = GitUpdateResult.ERROR;
            if (gitUpdateResult == null) {
                GitMergeUpdater.$$$reportNull$$$0(8);
            }
            return gitUpdateResult;
        }
        if (untrackedFilesWouldBeOverwrittenByMergeDetector.wasMessageDetected()) {
            LOG.info("handleMergeFailure: untracked files would be overwritten by merge");
            GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(this.myProject, this.myRoot, untrackedFilesWouldBeOverwrittenByMergeDetector.getRelativeFilePaths(), GitBundle.message("merge.operation.name", new Object[0]), null);
            GitUpdateResult gitUpdateResult = GitUpdateResult.ERROR;
            if (gitUpdateResult == null) {
                GitMergeUpdater.$$$reportNull$$$0(9);
            }
            return gitUpdateResult;
        }
        LOG.info("Unknown error: " + commandResult.getErrorOutputAsJoinedString());
        VcsNotifier.getInstance((Project)this.myProject).notifyError("git.merge.error", GitBundle.message("notification.title.error.merging", new Object[0]), commandResult.getErrorOutputAsHtmlString());
        GitUpdateResult gitUpdateResult = GitUpdateResult.ERROR;
        if (gitUpdateResult == null) {
            GitMergeUpdater.$$$reportNull$$$0(10);
        }
        return gitUpdateResult;
    }

    @Override
    public boolean isSaveNeeded() {
        try {
            if (GitUtil.hasLocalChanges(true, this.myProject, this.myRoot)) {
                return true;
            }
        }
        catch (VcsException e) {
            LOG.info("isSaveNeeded failed to check staging area", (Throwable)e);
            return true;
        }
        String currentBranch = this.myBranchPair.getSource().getName();
        String remoteBranch = this.myBranchPair.getTarget().getName();
        try {
            GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(this.myProject).getRepositoryForRoot(this.myRoot);
            if (repository == null) {
                LOG.error("Repository is null for root " + this.myRoot);
                return true;
            }
            Collection<String> remotelyChanged = GitUtil.getPathsDiffBetweenRefs(Git.getInstance(), repository, currentBranch, remoteBranch);
            List locallyChanged = this.myChangeListManager.getAffectedPaths();
            for (File localPath : locallyChanged) {
                if (!ContainerUtil.exists(remotelyChanged, remotelyChangedPath -> FileUtil.pathsEqual((String)localPath.getPath(), (String)remotelyChangedPath))) continue;
                return true;
            }
            return false;
        }
        catch (VcsException e) {
            LOG.info("failed to get remotely changed files for " + currentBranch + ".." + remoteBranch, (Throwable)e);
            return true;
        }
    }

    private void cancel() {
        GitLineHandler h2 = new GitLineHandler(this.myProject, this.myRoot, GitCommand.RESET);
        h2.addParameters("--merge");
        GitCommandResult result2 = Git.getInstance().runCommand(h2);
        if (!result2.success()) {
            LOG.info("cancel git reset --merge: " + result2.getErrorOutputAsJoinedString());
            VcsNotifier.getInstance((Project)this.myProject).notifyError("git.merge.reset.error", GitBundle.message("notification.title.couldn.t.reset.merge", new Object[0]), result2.getErrorOutputAsHtmlString());
        }
    }

    private List<FilePath> getFilesOverwrittenByMerge(@NotNull List<String> mergeOutput) {
        if (mergeOutput == null) {
            GitMergeUpdater.$$$reportNull$$$0(11);
        }
        ArrayList<FilePath> paths = new ArrayList<FilePath>();
        for (String line : mergeOutput) {
            if (StringUtil.isEmptyOrSpaces((String)line)) continue;
            if (line.contains("Please, commit your changes or stash them before you can merge")) break;
            line = line.trim();
            try {
                String path = this.myRoot.getPath() + "/" + GitUtil.unescapePath(line);
                File file = new File(path);
                if (!file.exists()) continue;
                paths.add(VcsUtil.getFilePath((File)file, (boolean)false));
            }
            catch (VcsException vcsException) {}
        }
        return paths;
    }

    private Collection<Change> getLocalChangesFilteredByFiles(List<FilePath> paths) {
        HashSet<Change> changes = new HashSet<Change>();
        for (Change change : this.myChangeListManager.getAllChanges()) {
            ContentRevision afterRevision = change.getAfterRevision();
            ContentRevision beforeRevision = change.getBeforeRevision();
            if ((afterRevision == null || !paths.contains(afterRevision.getFile())) && (beforeRevision == null || !paths.contains(beforeRevision.getFile()))) continue;
            changes.add(change);
        }
        return changes;
    }

    public String toString() {
        return "Merge updater";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchPair";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedFiles";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/update/GitMergeUpdater";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeOutput";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/update/GitMergeUpdater";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doUpdate";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "handleMergeFailure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFilesOverwrittenByMerge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyConflictResolver
    extends GitConflictResolver {
        private final GitMerger myMerger;
        private final VirtualFile myRoot;

        MyConflictResolver(Project project, @NotNull Git git, GitMerger merger, VirtualFile root) {
            if (git == null) {
                MyConflictResolver.$$$reportNull$$$0(0);
            }
            super(project, Collections.singleton(root), MyConflictResolver.makeParams(project));
            this.myMerger = merger;
            this.myRoot = root;
        }

        private static GitConflictResolver.Params makeParams(Project project) {
            GitConflictResolver.Params params = new GitConflictResolver.Params(project);
            params.setErrorNotificationTitle(GitBundle.message("merge.update.project.generic.error.title", new Object[0]));
            params.setMergeDescription(GitBundle.message("merge.update.project.conflict.merge.description.label", new Object[0]));
            return params;
        }

        @Override
        protected boolean proceedIfNothingToMerge() throws VcsException {
            this.myMerger.mergeCommit(this.myRoot);
            return true;
        }

        @Override
        protected boolean proceedAfterAllMerged() throws VcsException {
            this.myMerger.mergeCommit(this.myRoot);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "git", "git4idea/update/GitMergeUpdater$MyConflictResolver", "<init>"));
        }
    }

    private static class MergeLineListener
    implements GitLineHandlerListener {
        private MergeError myMergeError;
        private final List<String> myOutput = new ArrayList<String>();
        private boolean myLocalChangesError = false;

        private MergeLineListener() {
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            if (this.myLocalChangesError) {
                this.myOutput.add(line);
            } else if (line.contains("Automatic merge failed; fix conflicts and then commit the result")) {
                this.myMergeError = MergeError.CONFLICT;
            } else if (line.contains("Your local changes to the following files would be overwritten by merge")) {
                this.myMergeError = MergeError.LOCAL_CHANGES;
                this.myLocalChangesError = true;
            }
        }

        public MergeError getMergeError() {
            return this.myMergeError;
        }

        public List<String> getOutput() {
            return this.myOutput;
        }
    }

    private static enum MergeError {
        CONFLICT,
        LOCAL_CHANGES,
        OTHER;

    }
}

