/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConsoleLine;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class GitVcsConsoleWriter {
    private static final Logger LOG = Logger.getInstance(GitVcsConsoleWriter.class);
    private static final int MAX_CONSOLE_OUTPUT_SIZE = 10000;
    private final Project myProject;

    @NotNull
    public static GitVcsConsoleWriter getInstance(@NotNull Project project) {
        if (project == null) {
            GitVcsConsoleWriter.$$$reportNull$$$0(0);
        }
        GitVcsConsoleWriter gitVcsConsoleWriter = (GitVcsConsoleWriter)project.getService(GitVcsConsoleWriter.class);
        if (gitVcsConsoleWriter == null) {
            GitVcsConsoleWriter.$$$reportNull$$$0(1);
        }
        return gitVcsConsoleWriter;
    }

    public GitVcsConsoleWriter(@NotNull Project project) {
        if (project == null) {
            GitVcsConsoleWriter.$$$reportNull$$$0(2);
        }
        this.myProject = project;
    }

    public void showMessage(@NotNull @NlsSafe String message) {
        if (message == null) {
            GitVcsConsoleWriter.$$$reportNull$$$0(3);
        }
        this.showMessage(message, ConsoleViewContentType.NORMAL_OUTPUT);
    }

    public void showErrorMessage(@NotNull @NlsSafe String line) {
        if (line == null) {
            GitVcsConsoleWriter.$$$reportNull$$$0(4);
        }
        this.showMessage(line, ConsoleViewContentType.ERROR_OUTPUT);
    }

    public void showCommandLine(@NotNull @NlsSafe String cmdLine) {
        if (cmdLine == null) {
            GitVcsConsoleWriter.$$$reportNull$$$0(5);
        }
        SimpleDateFormat f = new SimpleDateFormat("HH:mm:ss.SSS");
        this.showMessage(f.format(new Date()) + ": " + cmdLine, ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    public void showMessage(@NotNull @NlsSafe String message, @NotNull ConsoleViewContentType contentType) {
        if (message == null) {
            GitVcsConsoleWriter.$$$reportNull$$$0(6);
        }
        if (contentType == null) {
            GitVcsConsoleWriter.$$$reportNull$$$0(7);
        }
        String shortMessage = StringUtil.shortenPathWithEllipsis((String)message, (int)10000);
        this.showMessage(VcsConsoleLine.create((String)shortMessage, (ConsoleViewContentType)contentType));
    }

    public void showMessage(@NotNull List<Pair<String, Key>> lineChunks) {
        if (lineChunks == null) {
            GitVcsConsoleWriter.$$$reportNull$$$0(8);
        }
        int totalLength = 0;
        for (Pair<String, Key> chunk : lineChunks) {
            totalLength += ((String)chunk.first).length();
        }
        int prefixEnd = 3000;
        int suffixStart = totalLength - 7000;
        boolean useEllipsis = (double)totalLength > 12000.0;
        int index = 0;
        ArrayList<Pair> messages = new ArrayList<Pair>();
        for (Pair<String, Key> chunk : lineChunks) {
            String message = (String)chunk.first;
            if (message.isEmpty()) continue;
            ConsoleViewContentType type = ConsoleViewContentType.getConsoleViewType((Key)((Key)chunk.second));
            if (useEllipsis) {
                TextRange range = new TextRange(index, index + message.length());
                TextRange range1 = range.intersection(new TextRange(0, prefixEnd));
                TextRange range2 = range.intersection(new TextRange(suffixStart, totalLength));
                if (range1 != null && !range1.isEmpty()) {
                    Object message1 = range1.shiftLeft(index).substring(message);
                    if (!range1.equals((Object)range)) {
                        message1 = (String)message1 + "...";
                    }
                    messages.add(Pair.create((Object)message1, (Object)type));
                }
                if (range2 != null && !range2.isEmpty()) {
                    String message2 = range2.shiftLeft(index).substring(message);
                    messages.add(Pair.create((Object)message2, (Object)type));
                }
            } else {
                messages.add(Pair.create((Object)message, (Object)type));
            }
            index += message.length();
        }
        this.showMessage(VcsConsoleLine.create(messages));
    }

    private void showMessage(@Nullable VcsConsoleLine line) {
        if (this.myProject.isDisposed()) {
            return;
        }
        ProjectLevelVcsManager.getInstance((Project)this.myProject).addMessageToConsoleWindow(line);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/util/GitVcsConsoleWriter";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineChunks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/util/GitVcsConsoleWriter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showMessage";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showErrorMessage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

