/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JComboBox;

public class JComboBoxView<T, A extends Enum<A>>
implements ActionListener {
    private final Supplier<List<T>> myList;
    private final Supplier<T> myGetFromModel;
    private final Consumer<T> mySet;
    private final JComboBox<T> myCombo;
    private final AspectModel<A> myObject;
    private final A myAspect;
    private final AspectObserver myAspectObserver = new AspectObserver();
    private boolean myIgnoreEvents;
    private final Supplier<T> myGetFromList;

    public JComboBoxView(JComboBox<T> combo, AspectModel<A> object, A aspect, Supplier<List<T>> list, Supplier<T> getFromModel, Consumer<T> set) {
        this(combo, object, aspect, list, getFromModel, set, getFromModel);
    }

    public JComboBoxView(JComboBox<T> combo, AspectModel<A> object, A aspect, Supplier<List<T>> list, Supplier<T> getFromModel, Consumer<T> set, Supplier<T> getFromList) {
        this.myList = list;
        this.myGetFromModel = getFromModel;
        this.mySet = set;
        this.myCombo = combo;
        this.myObject = object;
        this.myAspect = aspect;
        this.myGetFromList = getFromList;
    }

    public void bind() {
        this.myCombo.addActionListener(this);
        this.myObject.addDependency(this.myAspectObserver).onChange(this.myAspect, this::changed);
        this.changed();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object item = this.myCombo.getSelectedItem();
        if (item != null && !this.myIgnoreEvents && !Objects.equals(this.myGetFromModel.get(), item)) {
            this.mySet.accept(item);
        }
    }

    private void changed() {
        List<T> list = this.myList.get();
        T selected = this.myGetFromList.get();
        this.myIgnoreEvents = true;
        this.myCombo.removeAllItems();
        if (list.isEmpty()) {
            this.myCombo.addItem(null);
        } else {
            for (T t : list) {
                this.myCombo.addItem(t);
            }
        }
        this.myCombo.setSelectedItem(selected);
        this.myIgnoreEvents = false;
    }
}

