/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.FpsTimer;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.StopwatchTimer;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ResizingAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.adtui.model.updater.Updater;
import com.android.tools.idea.transport.poller.TransportEventPoller;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.NullMonitorStage;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.ProfilerMode;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioMonitorStage;
import com.android.tools.profilers.StudioProfiler;
import com.android.tools.profilers.cpu.CpuProfiler;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.customevent.CustomEventProfiler;
import com.android.tools.profilers.customevent.CustomEventProfilerStage;
import com.android.tools.profilers.energy.EnergyProfiler;
import com.android.tools.profilers.energy.EnergyProfilerStage;
import com.android.tools.profilers.event.EventProfiler;
import com.android.tools.profilers.memory.MainMemoryProfilerStage;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.network.NetworkProfiler;
import com.android.tools.profilers.network.NetworkProfilerStage;
import com.android.tools.profilers.sessions.SessionAspect;
import com.android.tools.profilers.sessions.SessionsManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import io.grpc.StatusRuntimeException;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class StudioProfilers
extends AspectModel<ProfilerAspect>
implements Updatable {
    public static final String DAEMON_DEVICE_DIR_PATH = "/data/local/tmp/perfd";
    @VisibleForTesting
    static final int AGENT_STATUS_MAX_RETRY_COUNT = 10;
    public static final int PROFILERS_UPDATE_RATE = 60;
    public static final long TRANSPORT_POLLER_INTERVAL_NS = TimeUnit.MILLISECONDS.toNanos(500L);
    @NotNull
    private final ProfilerClient myClient;
    private final StreamingTimeline myTimeline;
    private final List<StudioProfiler> myProfilers;
    @NotNull
    private final IdeProfilerServices myIdeServices;
    private Map<Common.Device, List<Common.Process>> myProcesses;
    private Map<Common.Device, Long> myDeviceToStreamIds;
    private Map<Long, Common.Stream> myStreamIdToStreams;
    @NotNull
    private final SessionsManager mySessionsManager;
    @Nullable
    private Common.Process myProcess;
    @NotNull
    private Common.AgentData myAgentData;
    @Nullable
    private String myPreferredDeviceName;
    @Nullable
    private String myPreferredProcessName;
    private Predicate<Common.Process> myPreferredProcessFilter;
    private Common.Device myDevice;
    @NotNull
    private Common.Session mySelectedSession;
    @NotNull
    private Common.Session myProfilingSession;
    @NotNull
    private Stage myStage;
    private Updater myUpdater;
    private AxisComponentModel myViewAxis;
    private long myRefreshDevices;
    private long myEventPollingInternvalNs;
    private final Map<Common.SessionMetaData.SessionType, Runnable> mySessionChangeListener;
    private boolean myAutoProfilingEnabled;
    public final Map<Long, Integer> mySessionIdToAgentStatusRetryMap;
    private TransportEventPoller myTransportPoller;

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(StudioProfilers.class);
        if (logger == null) {
            StudioProfilers.$$$reportNull$$$0(0);
        }
        return logger;
    }

    public StudioProfilers(@NotNull ProfilerClient client, @NotNull IdeProfilerServices ideServices) {
        if (client == null) {
            StudioProfilers.$$$reportNull$$$0(1);
        }
        if (ideServices == null) {
            StudioProfilers.$$$reportNull$$$0(2);
        }
        this(client, ideServices, (StopwatchTimer)new FpsTimer(60));
    }

    @VisibleForTesting
    public StudioProfilers(@NotNull ProfilerClient client, @NotNull IdeProfilerServices ideServices, @NotNull StopwatchTimer timer) {
        if (client == null) {
            StudioProfilers.$$$reportNull$$$0(3);
        }
        if (ideServices == null) {
            StudioProfilers.$$$reportNull$$$0(4);
        }
        if (timer == null) {
            StudioProfilers.$$$reportNull$$$0(5);
        }
        this.mySessionIdToAgentStatusRetryMap = new HashMap<Long, Integer>();
        this.myClient = client;
        this.myIdeServices = ideServices;
        this.myPreferredProcessName = null;
        this.myPreferredProcessFilter = null;
        this.myStage = new NullMonitorStage(this);
        this.mySessionsManager = new SessionsManager(this);
        this.mySessionChangeListener = new HashMap<Common.SessionMetaData.SessionType, Runnable>();
        this.myDeviceToStreamIds = new HashMap<Common.Device, Long>();
        this.myStreamIdToStreams = new HashMap<Long, Common.Stream>();
        this.myStage.enter();
        this.myUpdater = new Updater(timer);
        ImmutableList.Builder profilersBuilder = new ImmutableList.Builder();
        profilersBuilder.add((Object)new EventProfiler(this));
        if (this.myIdeServices.getFeatureConfig().isCustomEventVisualizationEnabled()) {
            profilersBuilder.add((Object)new CustomEventProfiler(this));
        }
        profilersBuilder.add((Object)new CpuProfiler(this));
        profilersBuilder.add((Object)new MemoryProfiler(this));
        profilersBuilder.add((Object)new NetworkProfiler(this));
        if (this.myIdeServices.getFeatureConfig().isEnergyProfilerEnabled()) {
            profilersBuilder.add((Object)new EnergyProfiler(this));
        }
        this.myProfilers = profilersBuilder.build();
        this.myTimeline = new StreamingTimeline(this.myUpdater);
        this.myProcesses = Maps.newHashMap();
        this.myDevice = null;
        this.myProcess = null;
        this.mySelectedSession = this.myProfilingSession = Common.Session.getDefaultInstance();
        this.myAgentData = Common.AgentData.getDefaultInstance();
        this.myTimeline.getSelectionRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, () -> {
            if (!this.myTimeline.getSelectionRange().isEmpty()) {
                this.myTimeline.setStreaming(false);
            }
        });
        this.registerSessionChangeListener(Common.SessionMetaData.SessionType.FULL, () -> {
            this.setStage(new StudioMonitorStage(this));
            if (SessionsManager.isSessionAlive(this.mySelectedSession)) {
                Transport.TimeResponse timeResponse = this.myClient.getTransportClient().getCurrentTime(Transport.TimeRequest.newBuilder().setStreamId(this.mySelectedSession.getStreamId()).build());
                this.myTimeline.reset(this.mySelectedSession.getStartTimestamp(), timeResponse.getTimestampNs());
                if (this.startupCpuProfilingStarted()) {
                    this.setStage(new CpuProfilerStage(this));
                } else if (this.startupMemoryProfilingStarted()) {
                    this.setStage(new MainMemoryProfilerStage(this));
                }
            } else {
                this.myTimeline.reset(this.mySelectedSession.getStartTimestamp(), this.mySelectedSession.getEndTimestamp());
                this.myTimeline.setIsPaused(true);
                this.myTimeline.setStreaming(false);
                this.myTimeline.getViewRange().set(this.mySessionsManager.getSessionPreferredViewRange(this.mySelectedSession));
            }
        });
        this.mySessionsManager.addDependency((AspectObserver)this).onChange((Enum)SessionAspect.SELECTED_SESSION, this::selectedSessionChanged).onChange((Enum)SessionAspect.PROFILING_SESSION, this::profilingSessionChanged);
        this.myViewAxis = new ResizingAxisComponentModel.Builder(this.myTimeline.getViewRange(), (BaseAxisFormatter)TimeAxisFormatter.DEFAULT).setGlobalRange(this.myTimeline.getDataRange()).build();
        this.myTransportPoller = new TransportEventPoller(this.myClient.getTransportClient(), Comparator.comparing(Common.Event::getTimestamp));
        this.myUpdater.register((Updatable)this);
    }

    public boolean isStopped() {
        return !this.myUpdater.isRunning();
    }

    public void stop() {
        if (this.isStopped()) {
            return;
        }
        this.myUpdater.stop();
        this.setProcess(null, null);
        this.changed(ProfilerAspect.STAGE);
    }

    @NotNull
    public TransportEventPoller getTransportPoller() {
        TransportEventPoller transportEventPoller = this.myTransportPoller;
        if (transportEventPoller == null) {
            StudioProfilers.$$$reportNull$$$0(6);
        }
        return transportEventPoller;
    }

    public Map<Common.Device, List<Common.Process>> getDeviceProcessMap() {
        return this.myProcesses;
    }

    public List<Common.Device> getDevices() {
        return Lists.newArrayList(this.myProcesses.keySet());
    }

    public void setPreferredProcess(@Nullable String deviceName, @Nullable String processName, @Nullable Predicate<Common.Process> processFilter) {
        this.myIdeServices.getFeatureTracker().trackAutoProfilingRequested();
        this.myPreferredDeviceName = deviceName;
        this.setPreferredProcessName(processName);
        this.myPreferredProcessFilter = processFilter;
        this.setAutoProfilingEnabled(true);
        this.changed(ProfilerAspect.PREFERRED_PROCESS);
    }

    public void setPreferredProcessName(@Nullable String processName) {
        this.myPreferredProcessName = processName;
    }

    @Nullable
    public String getPreferredProcessName() {
        return this.myPreferredProcessName;
    }

    public void setAutoProfilingEnabled(boolean enabled) {
        this.myAutoProfilingEnabled = enabled;
        if (!this.myIdeServices.getFeatureConfig().isUnifiedPipelineEnabled() && this.myAutoProfilingEnabled) {
            this.setProcess(this.findPreferredDevice(), null);
        }
    }

    @TestOnly
    public boolean getAutoProfilingEnabled() {
        return this.myAutoProfilingEnabled;
    }

    private List<Common.Device> getUpToDateDevices() {
        return StudioProfilers.getUpToDateDevices(this.myIdeServices.getFeatureConfig().isUnifiedPipelineEnabled(), this.myClient, this.myDeviceToStreamIds, this.myStreamIdToStreams);
    }

    @NotNull
    public static List<Common.Device> getUpToDateDevices(boolean isUnifiedPipelineEnabled, @NotNull ProfilerClient client, @Nullable Map<Common.Device, Long> deviceToStreamIds, @Nullable Map<Long, Common.Stream> streamIdToStreams) {
        if (client == null) {
            StudioProfilers.$$$reportNull$$$0(7);
        }
        LinkedList<Common.Device> devices = new LinkedList();
        if (isUnifiedPipelineEnabled) {
            Transport.GetEventGroupsRequest request = Transport.GetEventGroupsRequest.newBuilder().setStreamId(-1L).setKind(Common.Event.Kind.STREAM).build();
            Transport.GetEventGroupsResponse response = client.getTransportClient().getEventGroups(request);
            for (Transport.EventGroup group : response.getGroupsList()) {
                Common.Stream stream;
                boolean isStreamDead = group.getEvents(group.getEventsCount() - 1).getIsEnded();
                Common.Event connectedEvent = StudioProfilers.getLastMatchingEvent(group, e -> e.hasStream() && e.getStream().hasStreamConnected());
                if (connectedEvent == null || (stream = connectedEvent.getStream().getStreamConnected().getStream()).getType() != Common.Stream.Type.DEVICE) continue;
                if (isStreamDead) {
                    stream = stream.toBuilder().setDevice(stream.getDevice().toBuilder().setState(Common.Device.State.DISCONNECTED)).build();
                }
                if (deviceToStreamIds != null) {
                    deviceToStreamIds.putIfAbsent(stream.getDevice(), stream.getStreamId());
                }
                if (streamIdToStreams != null) {
                    streamIdToStreams.putIfAbsent(stream.getStreamId(), stream);
                }
                devices.add(stream.getDevice());
            }
        } else {
            Transport.GetDevicesResponse response = client.getTransportClient().getDevices(Transport.GetDevicesRequest.getDefaultInstance());
            devices = response.getDeviceList();
        }
        LinkedList<Common.Device> linkedList = devices;
        if (linkedList == null) {
            StudioProfilers.$$$reportNull$$$0(8);
        }
        return linkedList;
    }

    private void startProfileableDiscoveryIfApplicable(Collection<Common.Device> previousDevices, Collection<Common.Device> currentDevices) {
        if (!this.myIdeServices.getFeatureConfig().isProfileableInQrEnabled()) {
            return;
        }
        Sets.SetView newDevices = Sets.difference(StudioProfilers.filterOnlineDevices(currentDevices), StudioProfilers.filterOnlineDevices(previousDevices));
        for (Common.Device device : newDevices) {
            int level = device.getFeatureLevel();
            if (level != 29 && level != 30) continue;
            this.myClient.executeAsync(Commands.Command.newBuilder().setStreamId(this.myDeviceToStreamIds.get(device).longValue()).setType(Commands.Command.CommandType.DISCOVER_PROFILEABLE).build(), this.getIdeServices().getPoolExecutor());
        }
    }

    @NotNull
    public Common.Stream getStream(long streamId) {
        Common.Stream stream = this.myStreamIdToStreams.getOrDefault(streamId, Common.Stream.getDefaultInstance());
        if (stream == null) {
            StudioProfilers.$$$reportNull$$$0(9);
        }
        return stream;
    }

    public void update(long elapsedNs) {
        this.myEventPollingInternvalNs += elapsedNs;
        if (this.myEventPollingInternvalNs >= TRANSPORT_POLLER_INTERVAL_NS) {
            this.myTransportPoller.poll();
            this.myEventPollingInternvalNs = 0L;
        }
        this.myRefreshDevices += elapsedNs;
        if (this.myRefreshDevices < TimeUnit.SECONDS.toNanos(1L)) {
            return;
        }
        this.myRefreshDevices = 0L;
        try {
            HashMap<Common.Device, List<Common.Process>> newProcesses = new HashMap<Common.Device, List<Common.Process>>();
            List<Common.Device> devices = this.getUpToDateDevices();
            this.startProfileableDiscoveryIfApplicable(this.myProcesses.keySet(), devices);
            if (this.myIdeServices.getFeatureConfig().isUnifiedPipelineEnabled()) {
                for (Common.Device device : devices) {
                    Transport.GetEventGroupsRequest processRequest = Transport.GetEventGroupsRequest.newBuilder().setStreamId(this.myDeviceToStreamIds.get(device).longValue()).setKind(Common.Event.Kind.PROCESS).build();
                    Transport.GetEventGroupsResponse processResponse = this.myClient.getTransportClient().getEventGroups(processRequest);
                    ArrayList<Common.Process> processList = new ArrayList<Common.Process>();
                    int lastProcessId = this.myProcess == null ? 0 : this.myProcess.getPid();
                    for (Transport.EventGroup groupProcess : processResponse.getGroupsList()) {
                        boolean isProcessAlive = !groupProcess.getEvents(groupProcess.getEventsCount() - 1).getIsEnded();
                        Common.Event aliveEvent = StudioProfilers.getLastMatchingEvent(groupProcess, e -> e.hasProcess() && e.getProcess().hasProcessStarted());
                        if (aliveEvent == null) continue;
                        Common.Process process2 = aliveEvent.getProcess().getProcessStarted().getProcess();
                        if (!isProcessAlive && process2.getPid() != lastProcessId) continue;
                        if (!isProcessAlive) {
                            process2 = process2.toBuilder().setState(Common.Process.State.DEAD).build();
                        }
                        processList.add(process2);
                    }
                    newProcesses.put(device, processList);
                }
            } else {
                for (Common.Device device : devices) {
                    Transport.GetProcessesRequest request = Transport.GetProcessesRequest.newBuilder().setDeviceId(device.getDeviceId()).build();
                    Transport.GetProcessesResponse processes = this.myClient.getTransportClient().getProcesses(request);
                    int lastProcessId = this.myProcess == null ? 0 : this.myProcess.getPid();
                    List processList = processes.getProcessList().stream().filter(process -> process.getState() == Common.Process.State.ALIVE || process.getPid() == lastProcessId).collect(Collectors.toList());
                    newProcesses.put(device, processList);
                }
            }
            if (!newProcesses.equals(this.myProcesses)) {
                this.myProcesses = newProcesses;
                this.setProcess(this.findPreferredDevice(), null);
                this.changed(ProfilerAspect.PROCESSES);
            }
            this.mySessionsManager.update();
            if (SessionsManager.isSessionAlive(this.mySelectedSession)) {
                Common.AgentData agentData = this.getAgentData(this.mySelectedSession);
                int agentStatusRetryCount = this.mySessionIdToAgentStatusRetryMap.getOrDefault(this.mySelectedSession.getSessionId(), 0) + 1;
                if (agentData.getStatus() == Common.AgentData.Status.UNSPECIFIED && agentStatusRetryCount >= 10) {
                    agentData = Common.AgentData.newBuilder().setStatus(Common.AgentData.Status.UNATTACHABLE).build();
                }
                this.mySessionIdToAgentStatusRetryMap.put(this.mySelectedSession.getSessionId(), agentStatusRetryCount);
                if (!this.myAgentData.equals((Object)agentData)) {
                    if (this.myAgentData.getStatus() != Common.AgentData.Status.ATTACHED && agentData.getStatus() == Common.AgentData.Status.ATTACHED) {
                        this.getIdeServices().getFeatureTracker().trackAdvancedProfilingStarted();
                    }
                    this.myAgentData = agentData;
                    this.changed(ProfilerAspect.AGENT);
                }
            }
        }
        catch (StatusRuntimeException e2) {
            System.err.println("Cannot find profiler service, retrying...");
        }
    }

    private static Set<Common.Device> filterOnlineDevices(Collection<Common.Device> devices) {
        return devices.stream().filter(device -> device.getState().equals((Object)Common.Device.State.ONLINE)).collect(Collectors.toSet());
    }

    @Nullable
    private Common.Device findPreferredDevice() {
        Set<Common.Device> devices = this.myProcesses.keySet();
        Set<Common.Device> onlineDevices = StudioProfilers.filterOnlineDevices(devices);
        if (this.myAutoProfilingEnabled && this.myPreferredDeviceName != null) {
            for (Common.Device device : onlineDevices) {
                if (!this.myPreferredDeviceName.equals(StudioProfilers.buildDeviceName(device))) continue;
                return device;
            }
        }
        if (this.myDevice != null) {
            for (Common.Device device : devices) {
                if (this.myDevice.getDeviceId() != device.getDeviceId()) continue;
                return device;
            }
        }
        return null;
    }

    public void setMonitoringStage() {
        this.setStage(new StudioMonitorStage(this));
    }

    public void setProcess(@Nullable Common.Device device, @Nullable Common.Process process) {
        if (device != null) {
            this.myPreferredDeviceName = null;
            if (!device.getUnsupportedReason().isEmpty()) {
                this.setStage(new NullMonitorStage(this, device.getUnsupportedReason()));
            }
        }
        if (!Objects.equals(device, this.myDevice)) {
            this.mySessionsManager.endCurrentSession();
            this.myDevice = device;
            this.myIdeServices.getFeatureTracker().trackChangeDevice(this.myDevice);
        }
        List<Common.Process> processes = this.myProcesses.get(this.myDevice);
        if (process == null || processes == null || !processes.contains(process)) {
            process = this.getPreferredProcess(processes);
        } else {
            this.setAutoProfilingEnabled(false);
        }
        if (!Objects.equals(process, this.myProcess)) {
            this.mySessionsManager.endCurrentSession();
            this.myProcess = process;
            this.changed(ProfilerAspect.PROCESSES);
            this.myIdeServices.getFeatureTracker().trackChangeProcess(this.myProcess);
            if (this.myProcess != null && this.myProcess.getState() == Common.Process.State.ALIVE) {
                if (this.myIdeServices.getFeatureConfig().isUnifiedPipelineEnabled()) {
                    this.mySessionsManager.beginSession(this.myDeviceToStreamIds.get(this.myDevice), this.myDevice, this.myProcess);
                } else {
                    this.mySessionsManager.beginSession(this.myDevice, this.myProcess);
                }
            }
        }
    }

    public void registerSessionChangeListener(Common.SessionMetaData.SessionType sessionType, Runnable listener2) {
        this.mySessionChangeListener.put(sessionType, listener2);
    }

    private void selectedSessionChanged() {
        Common.Session newSession = this.mySessionsManager.getSelectedSession();
        if (this.mySelectedSession.getSessionId() == newSession.getSessionId() && SessionsManager.isSessionAlive(this.mySelectedSession) && !SessionsManager.isSessionAlive(newSession)) {
            this.mySelectedSession = newSession;
            this.myTimeline.setIsPaused(true);
            return;
        }
        this.mySelectedSession = newSession;
        this.myAgentData = this.getAgentData(this.mySelectedSession);
        if (Common.Session.getDefaultInstance().equals((Object)newSession)) {
            this.myTimeline.setIsPaused(true);
            this.setStage(new NullMonitorStage(this));
            return;
        }
        Common.SessionMetaData.SessionType sessionType = this.mySessionsManager.getSelectedSessionMetaData().getType();
        assert (this.mySessionChangeListener.containsKey(sessionType));
        this.mySessionChangeListener.get(sessionType).run();
        this.changed(ProfilerAspect.AGENT);
    }

    private void profilingSessionChanged() {
        Common.Session newSession = this.mySessionsManager.getProfilingSession();
        if (!Common.Session.getDefaultInstance().equals((Object)this.myProfilingSession)) {
            assert (SessionsManager.isSessionAlive(this.myProfilingSession));
            this.myProfilers.forEach(profiler -> profiler.stopProfiling(this.myProfilingSession));
        }
        this.myProfilingSession = newSession;
        if (!Common.Session.getDefaultInstance().equals((Object)this.myProfilingSession) && this.myDevice != null && this.myDevice.getDeviceId() == this.myProfilingSession.getStreamId()) {
            assert (SessionsManager.isSessionAlive(this.myProfilingSession));
            this.myProfilers.forEach(profiler -> profiler.startProfiling(this.myProfilingSession));
            this.myIdeServices.getFeatureTracker().trackProfilingStarted();
            if (this.getAgentData(this.myProfilingSession).getStatus() == Common.AgentData.Status.ATTACHED) {
                this.getIdeServices().getFeatureTracker().trackAdvancedProfilingStarted();
            }
        }
    }

    private boolean startupMemoryProfilingStarted() {
        List<Memory.MemoryNativeTrackingData> samples = MemoryProfiler.getNativeHeapStatusForSession(this.myClient, this.mySelectedSession, new Range(-9.223372036854776E18, 9.223372036854776E18));
        if (samples.isEmpty()) {
            return false;
        }
        Memory.MemoryNativeTrackingData last = samples.get(samples.size() - 1);
        return last.getStatus() == Memory.MemoryNativeTrackingData.Status.SUCCESS && last.getStartTime() <= this.mySelectedSession.getStartTimestamp();
    }

    private boolean startupCpuProfilingStarted() {
        Cpu.CpuTraceInfo lastTraceInfo;
        if (!this.getIdeServices().getFeatureConfig().isStartupCpuProfilingEnabled()) {
            return false;
        }
        List<Cpu.CpuTraceInfo> traceInfoList = CpuProfiler.getTraceInfoFromSession(this.myClient, this.mySelectedSession, this.myIdeServices.getFeatureConfig().isUnifiedPipelineEnabled());
        return !traceInfoList.isEmpty() && (lastTraceInfo = traceInfoList.get(traceInfoList.size() - 1)).getConfiguration().getInitiationType() == Cpu.TraceInitiationType.INITIATED_BY_STARTUP;
    }

    @Nullable
    private Common.Process getPreferredProcess(List<Common.Process> processes) {
        if (processes == null || processes.isEmpty()) {
            return null;
        }
        if (this.myAutoProfilingEnabled && this.myPreferredProcessName != null) {
            for (Common.Process process : processes) {
                if (!process.getName().equals(this.myPreferredProcessName) || process.getState() != Common.Process.State.ALIVE || this.myPreferredProcessFilter != null && !this.myPreferredProcessFilter.test(process)) continue;
                this.myIdeServices.getFeatureTracker().trackAutoProfilingSucceeded();
                this.myAutoProfilingEnabled = false;
                return process;
            }
        }
        if (this.myProcess != null) {
            for (Common.Process process : processes) {
                if (!StudioProfilers.isSameProcess(this.myProcess, process) || this.myProcess.getState() != process.getState() && (this.myProcess.getState() != Common.Process.State.ALIVE || process.getState() != Common.Process.State.DEAD)) continue;
                return process;
            }
        }
        return null;
    }

    @NotNull
    private Common.AgentData getAgentData(@NotNull Common.Session session) {
        if (session == null) {
            StudioProfilers.$$$reportNull$$$0(10);
        }
        Common.AgentData agentData = Common.AgentData.getDefaultInstance();
        if (Common.Session.getDefaultInstance().equals((Object)session)) {
            Common.AgentData agentData2 = agentData;
            if (agentData2 == null) {
                StudioProfilers.$$$reportNull$$$0(11);
            }
            return agentData2;
        }
        if (!this.myIdeServices.getFeatureConfig().isUnifiedPipelineEnabled()) {
            Transport.AgentStatusRequest statusRequest = Transport.AgentStatusRequest.newBuilder().setPid(session.getPid()).setDeviceId(session.getStreamId()).build();
            Common.AgentData agentData3 = this.myClient.getTransportClient().getAgentStatus(statusRequest);
            if (agentData3 == null) {
                StudioProfilers.$$$reportNull$$$0(12);
            }
            return agentData3;
        }
        Transport.GetEventGroupsRequest request = Transport.GetEventGroupsRequest.newBuilder().setKind(Common.Event.Kind.AGENT).setStreamId(session.getStreamId()).setPid(session.getPid()).build();
        Transport.GetEventGroupsResponse response = this.myClient.getTransportClient().getEventGroups(request);
        for (Transport.EventGroup group : response.getGroupsList()) {
            agentData = group.getEvents(group.getEventsCount() - 1).getAgentData();
        }
        Common.AgentData agentData4 = agentData;
        if (agentData4 == null) {
            StudioProfilers.$$$reportNull$$$0(13);
        }
        return agentData4;
    }

    private static boolean isSameProcess(@Nullable Common.Process process1, @Nullable Common.Process process2) {
        return process1 != null && process2 != null && process1.getPid() == process2.getPid() && process1.getName().equals(process2.getName()) && process1.getStartTimestampNs() == process2.getStartTimestampNs();
    }

    public List<Common.Process> getProcesses() {
        List<Common.Process> processes = this.myProcesses.get(this.myDevice);
        return processes == null ? ImmutableList.of() : processes;
    }

    @NotNull
    public Stage getStage() {
        Stage stage = this.myStage;
        if (stage == null) {
            StudioProfilers.$$$reportNull$$$0(14);
        }
        return stage;
    }

    @NotNull
    public ProfilerClient getClient() {
        ProfilerClient profilerClient = this.myClient;
        if (profilerClient == null) {
            StudioProfilers.$$$reportNull$$$0(15);
        }
        return profilerClient;
    }

    @NotNull
    public SessionsManager getSessionsManager() {
        SessionsManager sessionsManager = this.mySessionsManager;
        if (sessionsManager == null) {
            StudioProfilers.$$$reportNull$$$0(16);
        }
        return sessionsManager;
    }

    @NotNull
    public Common.Session getSession() {
        Common.Session session = this.mySelectedSession;
        if (session == null) {
            StudioProfilers.$$$reportNull$$$0(17);
        }
        return session;
    }

    @NotNull
    public String getSelectedAppName() {
        String name = "";
        if (!this.getSession().equals((Object)Common.Session.getDefaultInstance())) {
            name = this.mySessionsManager.getSelectedSessionMetaData().getSessionName();
        } else if (this.myProcess != null) {
            name = this.myProcess.getName();
        }
        String[] nameSplit = name.split(" \\(", 2);
        return nameSplit.length > 0 ? nameSplit[0] : "";
    }

    public void setStage(@NotNull Stage stage) {
        if (stage == null) {
            StudioProfilers.$$$reportNull$$$0(18);
        }
        this.myStage.exit();
        this.getTimeline().getSelectionRange().clear();
        this.myStage = stage;
        this.myStage.getStudioProfilers().getUpdater().reset();
        this.myStage.enter();
        this.changed(ProfilerAspect.STAGE);
    }

    @NotNull
    public StreamingTimeline getTimeline() {
        StreamingTimeline streamingTimeline = this.myTimeline;
        if (streamingTimeline == null) {
            StudioProfilers.$$$reportNull$$$0(19);
        }
        return streamingTimeline;
    }

    @Nullable
    public Common.Device getDevice() {
        return this.myDevice;
    }

    @Nullable
    public Common.Process getProcess() {
        return this.myProcess;
    }

    public boolean isAgentAttached() {
        return this.myAgentData.getStatus() == Common.AgentData.Status.ATTACHED;
    }

    @NotNull
    public Common.AgentData getAgentData() {
        Common.AgentData agentData = this.myAgentData;
        if (agentData == null) {
            StudioProfilers.$$$reportNull$$$0(20);
        }
        return agentData;
    }

    public List<StudioProfiler> getProfilers() {
        return this.myProfilers;
    }

    public ProfilerMode getMode() {
        return this.myStage.getProfilerMode();
    }

    public void modeChanged() {
        this.changed(ProfilerAspect.MODE);
    }

    @NotNull
    public IdeProfilerServices getIdeServices() {
        IdeProfilerServices ideProfilerServices = this.myIdeServices;
        if (ideProfilerServices == null) {
            StudioProfilers.$$$reportNull$$$0(21);
        }
        return ideProfilerServices;
    }

    public Updater getUpdater() {
        return this.myUpdater;
    }

    public AxisComponentModel getViewAxis() {
        return this.myViewAxis;
    }

    public List<Class<? extends Stage>> getDirectStages() {
        boolean isEnergyStageEnabled;
        boolean hasSession;
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        listBuilder.add(CpuProfilerStage.class);
        listBuilder.add(MainMemoryProfilerStage.class);
        listBuilder.add(NetworkProfilerStage.class);
        boolean bl = hasSession = this.mySelectedSession.getSessionId() != 0L;
        boolean bl2 = hasSession ? this.mySessionsManager.getSelectedSessionMetaData().getJvmtiEnabled() : (isEnergyStageEnabled = this.myDevice != null && this.myDevice.getFeatureLevel() >= 26);
        if (this.getIdeServices().getFeatureConfig().isEnergyProfilerEnabled() && isEnergyStageEnabled) {
            listBuilder.add(EnergyProfilerStage.class);
        }
        if (this.getIdeServices().getFeatureConfig().isCustomEventVisualizationEnabled()) {
            listBuilder.add(CustomEventProfilerStage.class);
        }
        return listBuilder.build();
    }

    @NotNull
    public Class<? extends Stage> getStageClass() {
        Class<?> clazz = ((Object)((Object)this.myStage)).getClass();
        if (clazz == null) {
            StudioProfilers.$$$reportNull$$$0(22);
        }
        return clazz;
    }

    public void setNewStage(Class<? extends Stage> clazz) {
        try {
            Constructor<? extends Stage> constructor = clazz.getConstructor(StudioProfilers.class);
            Stage stage = constructor.newInstance(new Object[]{this});
            this.setStage(stage);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    @NotNull
    public static String buildSessionName(@NotNull Common.Device device, @NotNull Common.Process process) {
        if (device == null) {
            StudioProfilers.$$$reportNull$$$0(23);
        }
        if (process == null) {
            StudioProfilers.$$$reportNull$$$0(24);
        }
        String string = String.format("%s (%s)", process.getName(), StudioProfilers.buildDeviceName(device));
        if (string == null) {
            StudioProfilers.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    public static String buildDeviceName(@NotNull Common.Device device) {
        if (device == null) {
            StudioProfilers.$$$reportNull$$$0(26);
        }
        StringBuilder deviceNameBuilder = new StringBuilder();
        String manufacturer = device.getManufacturer();
        String model = device.getModel();
        String serial = device.getSerial();
        String suffix = String.format("-%s", serial);
        if (model.endsWith(suffix)) {
            model = model.substring(0, model.length() - suffix.length());
        }
        if (!StringUtil.isEmpty((String)manufacturer)) {
            deviceNameBuilder.append(manufacturer);
            deviceNameBuilder.append(" ");
        }
        deviceNameBuilder.append(model);
        String string = deviceNameBuilder.toString();
        if (string == null) {
            StudioProfilers.$$$reportNull$$$0(27);
        }
        return string;
    }

    @Nullable
    private static Common.Event getLastMatchingEvent(@NotNull Transport.EventGroup group, @NotNull Predicate<Common.Event> predicate) {
        if (group == null) {
            StudioProfilers.$$$reportNull$$$0(28);
        }
        if (predicate == null) {
            StudioProfilers.$$$reportNull$$$0(29);
        }
        Common.Event matched = null;
        for (Common.Event event : group.getEventsList()) {
            if (!predicate.test(event)) continue;
            matched = event;
        }
        return matched;
    }

    public static Pair<Long, Long> computeImportedFileStartEndTimestampsNs(File file) {
        long rangeNs;
        long hash = Hashing.sha256().hashString((CharSequence)file.getAbsolutePath(), StandardCharsets.UTF_8).asLong();
        if (hash == Long.MAX_VALUE || hash == Long.MIN_VALUE || hash == -9223372036854775807L) {
            hash /= 2L;
        }
        if (hash < 0L) {
            hash = -hash;
        }
        if (hash >= Long.MAX_VALUE - (rangeNs = TimeUnit.MICROSECONDS.toNanos(1L))) {
            hash -= rangeNs;
        }
        return new Pair((Object)hash, (Object)(hash + rangeNs));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 18: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 18: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/StudioProfilers";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideServices";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 18: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/StudioProfilers";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransportPoller";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpToDateDevices";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStream";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAgentData";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getStage";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getClient";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionsManager";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSession";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeline";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeServices";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getStageClass";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSessionName";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDeviceName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getUpToDateDevices";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAgentData";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setStage";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "buildSessionName";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "buildDeviceName";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getLastMatchingEvent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 18: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

