/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.RangeSelectionComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.linechart.AbstractDurationDataRenderer;
import com.android.tools.adtui.chart.linechart.DurationDataRenderer;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.chart.linechart.LineChartCustomRenderer;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.chart.linechart.OverlayComponent;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.event.DelegateMouseEventHandler;
import com.android.tools.adtui.instructions.InstructionsPanel;
import com.android.tools.adtui.instructions.RenderInstruction;
import com.android.tools.adtui.instructions.TextInstruction;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuTraceInfo;
import com.android.tools.profilers.cpu.DetailedCpuUsage;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.UIUtilities;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

abstract class CpuUsageView
extends JBPanel {
    @NotNull
    protected final CpuProfilerStage myStage;
    @NotNull
    protected final RangeSelectionComponent myRangeSelectionComponent;
    @NotNull
    protected final OverlayComponent myOverlayComponent;
    @NotNull
    private final AspectObserver myObserver;

    private CpuUsageView(@NotNull CpuProfilerStage stage) {
        if (stage == null) {
            CpuUsageView.$$$reportNull$$$0(0);
        }
        super((LayoutManager)new TabularLayout("*", "*"));
        this.myStage = stage;
        this.myObserver = new AspectObserver();
        this.myRangeSelectionComponent = new RangeSelectionComponent(this.myStage.getRangeSelectionModel(), true);
        this.myRangeSelectionComponent.setCursorSetter(AdtUiUtils::setTooltipCursor);
        stage.getAspect().addDependency(this.myObserver).onChange((Enum)CpuProfilerAspect.CAPTURE_SELECTION, () -> this.myRangeSelectionComponent.requestFocus());
        this.myOverlayComponent = new OverlayComponent((Component)this.myRangeSelectionComponent);
        DelegateMouseEventHandler.delegateTo((Component)((Object)this)).installListenerOn((Component)this.myOverlayComponent).installMotionListenerOn((Component)this.myOverlayComponent);
        this.setBorder(ProfilerLayout.MONITOR_BORDER);
        this.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
    }

    @VisibleForTesting
    boolean shouldShowTooltipSeekComponent() {
        return this.myRangeSelectionComponent.shouldShowSeekComponent();
    }

    protected String formatCaptureLabel(@NotNull CpuTraceInfo info) {
        if (info == null) {
            CpuUsageView.$$$reportNull$$$0(1);
        }
        Range range = this.myStage.getTimeline().getDataRange();
        long min = (long)(info.getRange().getMin() - range.getMin());
        long max = (long)(info.getRange().getMax() - range.getMin());
        return String.format("%s - %s", TimeFormatter.getFullClockString((long)min), TimeFormatter.getFullClockString((long)max));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/cpu/CpuUsageView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "formatCaptureLabel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class ImportModeView
    extends CpuUsageView {
        ImportModeView(@NotNull CpuProfilerStage stage) {
            if (stage == null) {
                ImportModeView.$$$reportNull$$$0(0);
            }
            super(stage);
            this.add(this.createTimeAxisGuide(), new TabularLayout.Constraint(0, 0));
            this.add((Component)this.myOverlayComponent, new TabularLayout.Constraint(0, 0));
            this.add((Component)this.myRangeSelectionComponent, new TabularLayout.Constraint(0, 0));
            this.add(ImportModeView.createTipPanel(), new TabularLayout.Constraint(0, 0));
            this.add(this.createOverlayPanel(), new TabularLayout.Constraint(0, 0));
        }

        @NotNull
        private static JComponent createTipPanel() {
            JBPanel panel = new JBPanel((LayoutManager)new BorderLayout());
            panel.setOpaque(false);
            panel.setBackground(new Color(0, 0, 0, 0));
            InstructionsPanel infoMessage = new InstructionsPanel.Builder(new RenderInstruction[]{new TextInstruction(UIUtilities.getFontMetrics((JComponent)panel, (Font)ProfilerFonts.H3_FONT), "Cpu usage details unavailable")}).setColors(JBColor.foreground(), null).build();
            panel.add((Component)infoMessage);
            JBPanel jBPanel = panel;
            if (jBPanel == null) {
                ImportModeView.$$$reportNull$$$0(1);
            }
            return jBPanel;
        }

        @NotNull
        private JComponent createTimeAxisGuide() {
            final AxisComponent timeAxisGuide = new AxisComponent(this.myStage.getTimeAxisGuide(), AxisComponent.AxisOrientation.BOTTOM);
            timeAxisGuide.setShowAxisLine(false);
            timeAxisGuide.setShowLabels(false);
            timeAxisGuide.setHideTickAtMin(true);
            timeAxisGuide.setMarkerColor(ProfilerColors.CPU_AXIS_GUIDE_COLOR);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    timeAxisGuide.setMarkerLengths(this.getHeight(), 0);
                }
            });
            AxisComponent axisComponent = timeAxisGuide;
            if (axisComponent == null) {
                ImportModeView.$$$reportNull$$$0(2);
            }
            return axisComponent;
        }

        @NotNull
        private JComponent createOverlayPanel() {
            JBPanel overlayPanel = new JBPanel((LayoutManager)new TabularLayout("*", "*"));
            overlayPanel.setOpaque(false);
            LineChart lineChart = new LineChart(new ArrayList());
            DurationDataRenderer traceRenderer = new DurationDataRenderer.Builder(this.myStage.getTraceDurations(), ProfilerColors.CPU_CAPTURE_EVENT).setDurationBg(ProfilerColors.CPU_CAPTURE_BACKGROUND).setIcon(StudioIcons.Profiler.Toolbar.CAPTURE_CLOCK).setClickHander(traceInfo -> this.myStage.setAndSelectCapture(traceInfo.getTraceId())).build();
            this.myOverlayComponent.addDurationDataRenderer((AbstractDurationDataRenderer)traceRenderer);
            lineChart.addCustomRenderer((LineChartCustomRenderer)traceRenderer);
            overlayPanel.add((Component)lineChart, new TabularLayout.Constraint(0, 0));
            JBPanel jBPanel = overlayPanel;
            if (jBPanel == null) {
                ImportModeView.$$$reportNull$$$0(3);
            }
            return jBPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stage";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/CpuUsageView$ImportModeView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/CpuUsageView$ImportModeView";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTipPanel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTimeAxisGuide";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createOverlayPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class NormalModeView
    extends CpuUsageView {
        NormalModeView(@NotNull CpuProfilerStage stage) {
            if (stage == null) {
                NormalModeView.$$$reportNull$$$0(0);
            }
            super(stage);
            this.add(this.createAxisPanel(), new TabularLayout.Constraint(0, 0));
            this.add(this.createLegendPanel(), new TabularLayout.Constraint(0, 0));
            this.add((Component)this.myOverlayComponent, new TabularLayout.Constraint(0, 0));
            if (!stage.getStudioProfilers().getIdeServices().getFeatureConfig().isCpuCaptureStageEnabled()) {
                this.add((Component)this.myRangeSelectionComponent, new TabularLayout.Constraint(0, 0));
            }
            this.add(this.createLineChartPanel(), new TabularLayout.Constraint(0, 0));
        }

        @NotNull
        private JComponent createAxisPanel() {
            JBPanel axisPanel = new JBPanel((LayoutManager)new BorderLayout());
            axisPanel.setOpaque(false);
            AxisComponent leftAxis = new AxisComponent(this.myStage.getCpuUsageAxis(), AxisComponent.AxisOrientation.RIGHT);
            leftAxis.setShowAxisLine(false);
            leftAxis.setShowMax(true);
            leftAxis.setShowUnitAtMax(true);
            leftAxis.setHideTickAtMin(true);
            leftAxis.setMarkerLengths(ProfilerLayout.MARKER_LENGTH, ProfilerLayout.MARKER_LENGTH);
            leftAxis.setMargins(0, ProfilerLayout.Y_AXIS_TOP_MARGIN);
            axisPanel.add((Component)leftAxis, "West");
            AxisComponent rightAxis = new AxisComponent(this.myStage.getThreadCountAxis(), AxisComponent.AxisOrientation.LEFT);
            rightAxis.setShowAxisLine(false);
            rightAxis.setShowMax(true);
            rightAxis.setShowUnitAtMax(true);
            rightAxis.setHideTickAtMin(true);
            rightAxis.setMarkerLengths(ProfilerLayout.MARKER_LENGTH, ProfilerLayout.MARKER_LENGTH);
            rightAxis.setMargins(0, ProfilerLayout.Y_AXIS_TOP_MARGIN);
            axisPanel.add((Component)rightAxis, "East");
            JBPanel jBPanel = axisPanel;
            if (jBPanel == null) {
                NormalModeView.$$$reportNull$$$0(1);
            }
            return jBPanel;
        }

        @NotNull
        private JComponent createLineChartPanel() {
            JBPanel lineChartPanel = new JBPanel((LayoutManager)new BorderLayout());
            lineChartPanel.setOpaque(false);
            DetailedCpuUsage cpuUsage = this.myStage.getCpuUsage();
            LineChart lineChart = new LineChart((LineChartModel)cpuUsage);
            lineChart.configure(cpuUsage.getCpuSeries(), new LineConfig(ProfilerColors.CPU_USAGE).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX));
            lineChart.configure(cpuUsage.getOtherCpuSeries(), new LineConfig(ProfilerColors.CPU_OTHER_USAGE).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX));
            lineChart.configure(cpuUsage.getThreadsCountSeries(), new LineConfig(ProfilerColors.THREADS_COUNT).setStepped(true).setStroke((Stroke)LineConfig.DEFAULT_DASH_STROKE).setLegendIconType(LegendConfig.IconType.DASHED_LINE));
            lineChart.setRenderOffset(0, (int)LineConfig.DEFAULT_DASH_STROKE.getLineWidth() / 2);
            lineChartPanel.add((Component)lineChart, "Center");
            lineChart.setTopPadding(ProfilerLayout.Y_AXIS_TOP_MARGIN);
            lineChart.setFillEndGap(true);
            DurationDataRenderer traceRenderer = new DurationDataRenderer.Builder(this.myStage.getTraceDurations(), ProfilerColors.CPU_CAPTURE_EVENT).setDurationBg(ProfilerColors.CPU_CAPTURE_BACKGROUND).setIconMapper(info -> info.getDurationUs() != Long.MAX_VALUE ? StudioIcons.Profiler.Toolbar.CAPTURE_CLOCK : null).setLabelProvider(info -> info.getDurationUs() == Long.MAX_VALUE ? "In progress" : "").setLabelColors(ProfilerColors.CPU_DURATION_LABEL_BACKGROUND, Color.BLACK, Color.lightGray, Color.WHITE).setBackgroundClickable(this.myStage.getStudioProfilers().getIdeServices().getFeatureConfig().isCpuCaptureStageEnabled()).setClickHander(traceInfo -> {
                if (traceInfo.getDurationUs() != Long.MAX_VALUE) {
                    this.myStage.setAndSelectCapture(traceInfo.getTraceId());
                }
            }).build();
            traceRenderer.addCustomLineConfig(cpuUsage.getCpuSeries(), new LineConfig(ProfilerColors.CPU_USAGE_CAPTURED).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX));
            traceRenderer.addCustomLineConfig(cpuUsage.getOtherCpuSeries(), new LineConfig(ProfilerColors.CPU_OTHER_USAGE_CAPTURED).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX));
            traceRenderer.addCustomLineConfig(cpuUsage.getThreadsCountSeries(), new LineConfig(ProfilerColors.THREADS_COUNT_CAPTURED).setStepped(true).setStroke((Stroke)LineConfig.DEFAULT_DASH_STROKE).setLegendIconType(LegendConfig.IconType.DASHED_LINE));
            this.myOverlayComponent.addDurationDataRenderer((AbstractDurationDataRenderer)traceRenderer);
            lineChart.addCustomRenderer((LineChartCustomRenderer)traceRenderer);
            JBPanel jBPanel = lineChartPanel;
            if (jBPanel == null) {
                NormalModeView.$$$reportNull$$$0(2);
            }
            return jBPanel;
        }

        @NotNull
        private JComponent createLegendPanel() {
            JBPanel legendPanel = new JBPanel((LayoutManager)new BorderLayout());
            CpuProfilerStage.CpuStageLegends legends = this.myStage.getLegends();
            LegendComponent legend = new LegendComponent.Builder((LegendComponentModel)legends).setRightPadding(ProfilerLayout.PROFILER_LEGEND_RIGHT_PADDING).build();
            legend.setForeground(ProfilerColors.MONITORS_HEADER_TEXT);
            legend.configure((Legend)legends.getCpuLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.CPU_USAGE_CAPTURED));
            legend.configure((Legend)legends.getOthersLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.CPU_OTHER_USAGE_CAPTURED));
            legend.configure((Legend)legends.getThreadsLegend(), new LegendConfig(LegendConfig.IconType.DASHED_LINE, ProfilerColors.THREADS_COUNT_CAPTURED));
            JLabel label = new JLabel(this.myStage.getName());
            label.setBorder(ProfilerLayout.MONITOR_LABEL_PADDING);
            label.setVerticalAlignment(1);
            label.setForeground(ProfilerColors.MONITORS_HEADER_TEXT);
            legendPanel.setOpaque(false);
            legendPanel.add((Component)label, "West");
            legendPanel.add((Component)legend, "East");
            JBPanel jBPanel = legendPanel;
            if (jBPanel == null) {
                NormalModeView.$$$reportNull$$$0(3);
            }
            return jBPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stage";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/CpuUsageView$NormalModeView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/CpuUsageView$NormalModeView";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createAxisPanel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLineChartPanel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLegendPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

