/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.formatter.NumberFormatter;
import com.android.tools.profilers.cpu.systemtrace.RssMemoryTooltip;
import com.google.common.annotations.VisibleForTesting;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0014\u001a\u00020\u0003H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\f\u001a\u0004\b\u0013\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/profilers/cpu/RssMemoryTooltipView;", "Lcom/android/tools/adtui/TooltipView;", "parent", "Ljavax/swing/JComponent;", "tooltip", "Lcom/android/tools/profilers/cpu/systemtrace/RssMemoryTooltip;", "(Ljavax/swing/JComponent;Lcom/android/tools/profilers/cpu/systemtrace/RssMemoryTooltip;)V", "content", "Ljavax/swing/JPanel;", "descriptionLabel", "Ljavax/swing/JLabel;", "getDescriptionLabel$annotations", "()V", "getDescriptionLabel", "()Ljavax/swing/JLabel;", "getTooltip", "()Lcom/android/tools/profilers/cpu/systemtrace/RssMemoryTooltip;", "valueLabel", "getValueLabel$annotations", "getValueLabel", "createTooltip", "getDescriptionText", "", "counterName", "getTitle", "updateView", "", "intellij.android.profilers.ui"})
public final class RssMemoryTooltipView
extends TooltipView {
    private final JPanel content;
    @NotNull
    private final JLabel descriptionLabel;
    @NotNull
    private final JLabel valueLabel;
    @NotNull
    private final RssMemoryTooltip tooltip;

    @VisibleForTesting
    public static /* synthetic */ void getDescriptionLabel$annotations() {
    }

    @NotNull
    public final JLabel getDescriptionLabel() {
        return this.descriptionLabel;
    }

    @VisibleForTesting
    public static /* synthetic */ void getValueLabel$annotations() {
    }

    @NotNull
    public final JLabel getValueLabel() {
        return this.valueLabel;
    }

    @NotNull
    protected JComponent createTooltip() {
        return this.content;
    }

    private final void updateView() {
        this.descriptionLabel.setText("<html>" + this.getDescriptionText(this.tooltip.getCounterName()) + "</html>");
        String string = NumberFormatter.formatFileSize((long)this.tooltip.getActiveValueBytes());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"NumberFormatter.formatFi\u2026tooltip.activeValueBytes)");
        String rssValueText = string;
        this.valueLabel.setText(this.getTitle(this.tooltip.getCounterName()) + ": " + rssValueText);
    }

    private final String getTitle(String counterName) {
        String string;
        switch (counterName) {
            case "mem.rss": {
                string = "Total Resident Memory Utilization";
                break;
            }
            case "mem.rss.anon": {
                string = "Resident Memory Allocations";
                break;
            }
            case "mem.rss.file": {
                string = "Resident File Mapping Memory";
                break;
            }
            case "mem.rss.shmem": {
                string = "Resident Shared Memory";
                break;
            }
            default: {
                string = "Value";
            }
        }
        return string;
    }

    private final String getDescriptionText(String counterName) {
        String string;
        switch (counterName) {
            case "mem.rss": {
                string = "The total of all physical memory in use by the process,<br>including allocations, file mappings and shared memory.<br><br>/proc/&lt;pid&gt;/status reports this value as \"VmRSS\".";
                break;
            }
            case "mem.rss.anon": {
                string = "The amount of physical memory the process is using for normal<br>memory allocations (those backed by the swap file, and that<br>are not shared).<br><br>/proc/&lt;pid&gt;/status reports this value as \"RssAnon\".";
                break;
            }
            case "mem.rss.file": {
                string = "The amount of physical memory the process is using for file mappings -<br>that is, memory which is used for files that have been mapped into<br>a region of memory by the memory manager.<br><br>/proc/&lt;pid&gt;/status reports this value as \"RssFile\"";
                break;
            }
            case "mem.rss.shmem": {
                string = "The amount of physical memory the process is using for interprocess sharing.<br><br>/proc/&lt;pid&gt;/status reports this value as \"RssShmem\".";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    @NotNull
    public final RssMemoryTooltip getTooltip() {
        return this.tooltip;
    }

    public RssMemoryTooltipView(@NotNull JComponent parent, @NotNull RssMemoryTooltip tooltip2) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)((Object)tooltip2), (String)"tooltip");
        super(tooltip2.getTimeline());
        this.tooltip = tooltip2;
        this.content = new JPanel((LayoutManager)new TabularLayout("*").setVGap(12));
        JLabel jLabel = RssMemoryTooltipView.access$createTooltipLabel$s-1788842712();
        Intrinsics.checkNotNullExpressionValue((Object)jLabel, (String)"createTooltipLabel()");
        this.descriptionLabel = jLabel;
        JLabel jLabel2 = RssMemoryTooltipView.access$createTooltipLabel$s-1788842712();
        Intrinsics.checkNotNullExpressionValue((Object)jLabel2, (String)"createTooltipLabel()");
        this.valueLabel = jLabel2;
        this.content.add((Component)this.valueLabel, new TabularLayout.Constraint(0, 0, 0, 4, null));
        this.content.add((Component)this.descriptionLabel, new TabularLayout.Constraint(1, 0, 0, 4, null));
        this.tooltip.addDependency((AspectObserver)this).onChange((Enum)RssMemoryTooltip.Aspect.VALUE_CHANGED, new Runnable(){

            @Override
            public final void run() {
                this.updateView();
            }
        });
        this.updateView();
    }

    public static final /* synthetic */ JLabel access$createTooltipLabel$s-1788842712() {
        return TooltipView.createTooltipLabel();
    }
}

