/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import com.android.tools.adtui.StatLabel;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.ui.HideablePanel;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.analysis.CaptureNodeAnalysisModel;
import com.android.tools.profilers.cpu.analysis.CaptureNodeAnalysisStats;
import com.android.tools.profilers.cpu.analysis.CaptureNodeAnalysisSummaryTabModel;
import com.android.tools.profilers.cpu.analysis.CaptureNodeDetailTable;
import com.android.tools.profilers.cpu.analysis.CaptureNodeSummaryDetailsView;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisSummaryTabModel;
import com.android.tools.profilers.cpu.analysis.SummaryDetailsViewBase;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002R\u0013\u0010\u0007\u001a\u00020\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u00020\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/profilers/cpu/analysis/CaptureNodeSummaryDetailsView;", "Lcom/android/tools/profilers/cpu/analysis/SummaryDetailsViewBase;", "Lcom/android/tools/profilers/cpu/analysis/CaptureNodeAnalysisSummaryTabModel;", "profilersView", "Lcom/android/tools/profilers/StudioProfilersView;", "tabModel", "(Lcom/android/tools/profilers/StudioProfilersView;Lcom/android/tools/profilers/cpu/analysis/CaptureNodeAnalysisSummaryTabModel;)V", "dataTypeLabel", "Ljavax/swing/JLabel;", "getDataTypeLabel", "()Ljavax/swing/JLabel;", "timeRangeLabel", "getTimeRangeLabel", "buildAllOccurrencesSection", "Ljavax/swing/JComponent;", "model", "Lcom/android/tools/profilers/cpu/analysis/CaptureNodeAnalysisModel;", "buildSelectedNodeTable", "Ljavax/swing/JPanel;", "intellij.android.profilers.ui"})
public final class CaptureNodeSummaryDetailsView
extends SummaryDetailsViewBase<CaptureNodeAnalysisSummaryTabModel> {
    @NotNull
    private final JLabel timeRangeLabel;
    @NotNull
    private final JLabel dataTypeLabel;

    @VisibleForTesting
    @NotNull
    public final JLabel getTimeRangeLabel() {
        return this.timeRangeLabel;
    }

    @VisibleForTesting
    @NotNull
    public final JLabel getDataTypeLabel() {
        return this.dataTypeLabel;
    }

    /*
     * WARNING - void declaration
     */
    private final JPanel buildSelectedNodeTable() {
        String string;
        Object object;
        void $this$mapTo$iv$iv;
        JPanel jPanel;
        JPanel $this$apply = jPanel = new JPanel((LayoutManager)new TabularLayout("*").setVGap(8));
        boolean bl = false;
        List list = ((CaptureNodeAnalysisSummaryTabModel)this.getTabModel()).getDataSeries();
        Intrinsics.checkNotNullExpressionValue(list, (String)"tabModel.dataSeries");
        Iterable $this$map$iv = list;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CaptureNodeAnalysisModel captureNodeAnalysisModel = (CaptureNodeAnalysisModel)item$iv$iv;
            object = destination$iv$iv;
            boolean bl2 = false;
            void v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            CaptureNode captureNode = v1.getNode();
            object.add(captureNode);
        }
        List selectedNodes = (List)destination$iv$iv;
        String $i$f$map22 = string = "Selected event";
        object = $this$apply;
        boolean bl3 = false;
        $this$apply.setFont(ProfilerFonts.H3_FONT);
        $this$apply.setOpaque(false);
        Unit unit = Unit.INSTANCE;
        String string2 = string;
        ((Container)object).add((Component)new JLabel(string2), new TabularLayout.Constraint(0, 0, 0, 4, null));
        Range range = ((CaptureNodeAnalysisSummaryTabModel)this.getTabModel()).getCaptureRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"tabModel.captureRange");
        $this$apply.add((Component)new CaptureNodeDetailTable(selectedNodes, range, null, 0, 12, null).getComponent(), new TabularLayout.Constraint(1, 0, 0, 4, null));
        return jPanel;
    }

    /*
     * WARNING - void declaration
     */
    private final JComponent buildAllOccurrencesSection(CaptureNodeAnalysisModel model) {
        JPanel jPanel;
        void $this$apply;
        StatLabel statLabel;
        JPanel $this$apply2;
        JPanel jPanel2;
        CaptureNodeAnalysisStats captureNodeAnalysisStats = model.getAllOccurrenceStats();
        Intrinsics.checkNotNullExpressionValue((Object)captureNodeAnalysisStats, (String)"model.allOccurrenceStats");
        CaptureNodeAnalysisStats nodeStats = captureNodeAnalysisStats;
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        JComponent $this$apply3 = jPanel3;
        boolean bl = false;
        $this$apply3.setOpaque(false);
        JPanel jPanel4 = jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel5 = $this$apply3;
        boolean bl2 = false;
        $this$apply2.setOpaque(false);
        $this$apply2.setBorder(JBUI.Borders.customLine((Color)((Color)StudioColorsKt.getBorder()), (int)0, (int)0, (int)0, (int)1));
        long l = nodeStats.getCount();
        Font font = ProfilerFonts.H2_FONT;
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"ProfilerFonts.H2_FONT");
        Font font2 = ProfilerFonts.H4_FONT;
        Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"ProfilerFonts.H4_FONT");
        StatLabel statLabel2 = statLabel = new StatLabel(l, "Count", font, font2, null, null, 48, null);
        void var13_16 = $this$apply2;
        boolean bl3 = false;
        $this$apply.setOpaque(false);
        Unit unit = Unit.INSTANCE;
        var13_16.add((Component)statLabel);
        Unit unit2 = Unit.INSTANCE;
        jPanel5.add(jPanel2);
        buildAllOccurrencesSection.statsPanel.1.2 $fun$buildDurationLabel$2 = buildAllOccurrencesSection.statsPanel.1.2.INSTANCE;
        $this$apply3.add((Component)$fun$buildDurationLabel$2.invoke((long)nodeStats.getAverage(), "Average"));
        $this$apply3.add((Component)$fun$buildDurationLabel$2.invoke(nodeStats.getMax(), "Max"));
        $this$apply3.add((Component)$fun$buildDurationLabel$2.invoke(nodeStats.getMin(), "Min"));
        $this$apply3.add((Component)$fun$buildDurationLabel$2.invoke((long)nodeStats.getStandardDeviation(), "Std Dev"));
        JPanel statsPanel2 = jPanel3;
        JComponent $this$apply4 = $this$apply3 = new JLabel("Longest running occurrences (select row to navigate)");
        boolean bl4 = false;
        $this$apply4.setOpaque(false);
        $this$apply4.setFont(ProfilerFonts.H3_FONT);
        JComponent topOccurrencesLabel = $this$apply3;
        List<CaptureNode> list = model.getLongestRunningOccurrences(10);
        Intrinsics.checkNotNullExpressionValue(list, (String)"model.getLongestRunningOccurrences(10)");
        Range range = ((CaptureNodeAnalysisSummaryTabModel)this.getTabModel()).getCaptureRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"tabModel.captureRange");
        StudioProfilers studioProfilers = this.getProfilersView().getStudioProfilers();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"profilersView.studioProfilers");
        Stage stage = studioProfilers.getStage();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)stage), (String)"profilersView.studioProfilers.stage");
        Object t = stage.getTimeline();
        Intrinsics.checkNotNullExpressionValue(t, (String)"profilersView.studioProfilers.stage.timeline");
        CaptureNodeDetailTable topOccurrencesTable = new CaptureNodeDetailTable(list, range, t.getViewRange(), 0, 8, null);
        $this$apply2 = jPanel = new JPanel((LayoutManager)new TabularLayout("*", "Fit,Fit,Fit").setVGap(8));
        boolean bl5 = false;
        $this$apply2.setOpaque(false);
        $this$apply2.add((Component)statsPanel2, new TabularLayout.Constraint(0, 0, 0, 4, null));
        $this$apply2.add((Component)topOccurrencesLabel, new TabularLayout.Constraint(1, 0, 0, 4, null));
        $this$apply2.add((Component)topOccurrencesTable.getComponent(), new TabularLayout.Constraint(2, 0, 0, 4, null));
        JPanel panel = jPanel;
        $this$apply2 = jPanel = new HideablePanel(new HideablePanel.Builder("All Occurrences (" + nodeStats.getCount() + ")", (JComponent)panel).setPanelBorder((Border)JBUI.Borders.empty()).setContentBorder((Border)JBUI.Borders.empty((int)8, (int)0, (int)0, (int)0)));
        boolean bl6 = false;
        $this$apply2.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        return jPanel;
    }

    public CaptureNodeSummaryDetailsView(@NotNull StudioProfilersView profilersView, @NotNull CaptureNodeAnalysisSummaryTabModel tabModel) {
        Intrinsics.checkNotNullParameter((Object)((Object)profilersView), (String)"profilersView");
        Intrinsics.checkNotNullParameter((Object)tabModel, (String)"tabModel");
        super(profilersView, (CpuAnalysisSummaryTabModel)tabModel);
        this.timeRangeLabel = new JLabel();
        this.dataTypeLabel = new JLabel();
        Range range = tabModel.getSelectionRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"tabModel.selectionRange");
        Range range2 = range;
        this.timeRangeLabel.setText(this.formatTimeRangeAsString(range2));
        this.dataTypeLabel.setText(tabModel.getLabel());
        this.addRowToCommonSection("Time Range", this.timeRangeLabel);
        this.addRowToCommonSection("Data Type", this.dataTypeLabel);
        this.addSection(this.buildSelectedNodeTable());
        if (tabModel.getDataSeries().size() == 1) {
            Object t = tabModel.getDataSeries().get(0);
            Intrinsics.checkNotNullExpressionValue(t, (String)"tabModel.dataSeries[0]");
            this.addSection(this.buildAllOccurrencesSection((CaptureNodeAnalysisModel)t));
        }
    }
}

