/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.systemtrace;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.LazyDataSeries;
import com.android.tools.profilers.cpu.systemtrace.CpuSystemTraceData;
import com.android.tools.profilers.cpu.systemtrace.CpuThreadSliceInfo;
import javax.swing.DefaultListModel;
import org.jetbrains.annotations.NotNull;

public class CpuKernelModel
extends DefaultListModel<CpuState> {
    @NotNull
    private final CpuProfilerStage myStage;
    @NotNull
    private final Range myRange;
    @NotNull
    private final AspectObserver myAspectObserver;

    public CpuKernelModel(@NotNull Range range, @NotNull CpuProfilerStage stage) {
        if (range == null) {
            CpuKernelModel.$$$reportNull$$$0(0);
        }
        if (stage == null) {
            CpuKernelModel.$$$reportNull$$$0(1);
        }
        this.myRange = range;
        this.myStage = stage;
        this.myAspectObserver = new AspectObserver();
        this.myStage.getAspect().addDependency(this.myAspectObserver).onChange((Enum)CpuProfilerAspect.CAPTURE_SELECTION, this::captureStateChanged);
        range.addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, this::contentsChanged);
    }

    private void captureStateChanged() {
        this.removeAllElements();
        CpuCapture capture = this.myStage.getCapture();
        if (capture != null && capture.getSystemTraceData() != null) {
            CpuSystemTraceData systemTraceData = capture.getSystemTraceData();
            int count2 = systemTraceData.getCpuCount();
            for (int i = 0; i < count2; ++i) {
                this.addElement(new CpuState(i, systemTraceData));
            }
        }
        this.contentsChanged();
    }

    private void contentsChanged() {
        this.fireContentsChanged(this, 0, this.getSize());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "range";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "stage";
                break;
            }
        }
        objectArray[1] = "com/android/tools/profilers/cpu/systemtrace/CpuKernelModel";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public class CpuState {
        private final int myCpuId;
        @NotNull
        private final DataSeries<CpuThreadSliceInfo> myCpuStateDataSeries;
        @NotNull
        private final StateChartModel<CpuThreadSliceInfo> myModel;

        public CpuState(@NotNull int cpuId, CpuSystemTraceData systemTraceData) {
            if (systemTraceData == null) {
                CpuState.$$$reportNull$$$0(0);
            }
            this.myCpuId = cpuId;
            this.myModel = new StateChartModel();
            this.myCpuStateDataSeries = new LazyDataSeries<CpuThreadSliceInfo>(() -> systemTraceData.getCpuThreadSliceInfoStates(this.myCpuId));
            this.myModel.addSeries(new RangedSeries(CpuKernelModel.this.myRange, this.myCpuStateDataSeries));
        }

        public int getCpuId() {
            return this.myCpuId;
        }

        @NotNull
        public DataSeries<CpuThreadSliceInfo> getSeries() {
            DataSeries<CpuThreadSliceInfo> dataSeries = this.myCpuStateDataSeries;
            if (dataSeries == null) {
                CpuState.$$$reportNull$$$0(1);
            }
            return dataSeries;
        }

        @NotNull
        public StateChartModel<CpuThreadSliceInfo> getModel() {
            StateChartModel<CpuThreadSliceInfo> stateChartModel = this.myModel;
            if (stateChartModel == null) {
                CpuState.$$$reportNull$$$0(2);
            }
            return stateChartModel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "systemTraceData";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/systemtrace/CpuKernelModel$CpuState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/systemtrace/CpuKernelModel$CpuState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSeries";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

