/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.energy.EnergyDuration;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public final class LegacyEnergyEventsCountDataSeries
implements DataSeries<Long> {
    @NotNull
    private final RangedSeries<Common.Event> myDelegateSeries;
    @NotNull
    private final Predicate<EnergyDuration.Kind> myKindsFilter;

    public LegacyEnergyEventsCountDataSeries(@NotNull RangedSeries<Common.Event> delegateSeries, @NotNull Predicate<EnergyDuration.Kind> kindFilter) {
        if (delegateSeries == null) {
            LegacyEnergyEventsCountDataSeries.$$$reportNull$$$0(0);
        }
        if (kindFilter == null) {
            LegacyEnergyEventsCountDataSeries.$$$reportNull$$$0(1);
        }
        this.myDelegateSeries = delegateSeries;
        this.myKindsFilter = kindFilter;
    }

    public List<SeriesData<Long>> getDataForRange(Range range) {
        List sourceData = this.myDelegateSeries.getSeries();
        long position = (long)range.getMax();
        HashSet<Long> activeEventGroups = new HashSet<Long>();
        for (SeriesData eventData : sourceData) {
            if (!this.myKindsFilter.test(EnergyDuration.Kind.from(((Common.Event)eventData.value).getEnergyEvent()))) continue;
            if (eventData.x > position) break;
            if (!((Common.Event)eventData.value).getIsEnded()) {
                activeEventGroups.add(((Common.Event)eventData.value).getGroupId());
                continue;
            }
            activeEventGroups.remove(((Common.Event)eventData.value).getGroupId());
        }
        return Collections.singletonList(new SeriesData(position, (Object)activeEventGroups.size()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "delegateSeries";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "kindFilter";
                break;
            }
        }
        objectArray[1] = "com/android/tools/profilers/energy/LegacyEnergyEventsCountDataSeries";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

