/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.NetworkProfiler;
import com.android.tools.profiler.proto.NetworkServiceGrpc;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class NetworkOpenConnectionsDataSeries
implements DataSeries<Long> {
    @NotNull
    private NetworkServiceGrpc.NetworkServiceBlockingStub myClient;
    private final Common.Session mySession;

    public NetworkOpenConnectionsDataSeries(@NotNull NetworkServiceGrpc.NetworkServiceBlockingStub client, @NotNull Common.Session session) {
        if (client == null) {
            NetworkOpenConnectionsDataSeries.$$$reportNull$$$0(0);
        }
        if (session == null) {
            NetworkOpenConnectionsDataSeries.$$$reportNull$$$0(1);
        }
        this.myClient = client;
        this.mySession = session;
    }

    public List<SeriesData<Long>> getDataForRange(@NotNull Range timeCurrentRangeUs) {
        if (timeCurrentRangeUs == null) {
            NetworkOpenConnectionsDataSeries.$$$reportNull$$$0(2);
        }
        ArrayList<SeriesData<Long>> seriesData = new ArrayList<SeriesData<Long>>();
        long bufferNs = TimeUnit.SECONDS.toNanos(1L);
        NetworkProfiler.NetworkDataRequest.Builder dataRequestBuilder = NetworkProfiler.NetworkDataRequest.newBuilder().setSession(this.mySession).setType(NetworkProfiler.NetworkDataRequest.Type.CONNECTIONS).setStartTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMin()) - bufferNs).setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMax()) + bufferNs);
        NetworkProfiler.NetworkDataResponse response = this.myClient.getData(dataRequestBuilder.build());
        for (NetworkProfiler.NetworkProfilerData data : response.getDataList()) {
            long xTimestamp = TimeUnit.NANOSECONDS.toMicros(data.getEndTimestamp());
            NetworkProfiler.ConnectionData connectionData = data.getConnectionData();
            seriesData.add((SeriesData<Long>)new SeriesData(xTimestamp, (Object)connectionData.getConnectionNumber()));
        }
        return seriesData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeCurrentRangeUs";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/network/NetworkOpenConnectionsDataSeries";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getDataForRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

