/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.gdpr.ConsentConfigurable;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.StatisticsBundle;
import com.intellij.internal.statistic.eventLog.EventLogFile;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class OpenEventLogFileAction
extends DumbAwareAction {
    private final String myRecorderId;

    public OpenEventLogFileAction(String recorderId) {
        super(StatisticsBundle.message((String)"stats.open.0.event.log", (Object[])new Object[]{recorderId}), ActionsBundle.message((String)"group.OpenEventLogFileAction.description", (Object[])new Object[0]), AllIcons.FileTypes.Text);
        this.myRecorderId = recorderId;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile logVFile;
        Project project;
        if (e == null) {
            OpenEventLogFileAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        EventLogFile logFile = StatisticsEventLogProviderUtil.getEventLogProvider((String)this.myRecorderId).getActiveLogFile();
        VirtualFile virtualFile = logVFile = logFile != null ? LocalFileSystem.getInstance().refreshAndFindFileByIoFile(logFile.getFile()) : null;
        if (logVFile == null) {
            this.showNotification(project, NotificationType.WARNING, StatisticsBundle.message((String)"stats.there.is.no.active.event.log", (Object[])new Object[0]));
            return;
        }
        FileEditorManager.getInstance((Project)project).openFile(logVFile, true);
    }

    protected void showNotification(@NotNull Project project, @NotNull NotificationType type, @NotNull String message) {
        if (project == null) {
            OpenEventLogFileAction.$$$reportNull$$$0(1);
        }
        if (type == null) {
            OpenEventLogFileAction.$$$reportNull$$$0(2);
        }
        if (message == null) {
            OpenEventLogFileAction.$$$reportNull$$$0(3);
        }
        String title = StatisticsBundle.message((String)"stats.feature.usage.statistics", (Object[])new Object[0]);
        new Notification("FeatureUsageStatistics", title, message, type).addAction((AnAction)NotificationAction.createSimple((String)StatisticsBundle.message((String)"stats.enable.data.sharing", (Object[])new Object[0]), () -> new SingleConfigurableEditor(project, (Configurable)new ConsentConfigurable()).show())).notify(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/devkit/actions/OpenEventLogFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showNotification";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

