/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.inspectors.common.api;

import com.google.common.collect.ImmutableMap;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceSignatureConverter {
    private static final Map<PsiType, Character> PRIMITIVE_TYPES = new ImmutableMap.Builder().put((Object)PsiType.BYTE, (Object)Character.valueOf('B')).put((Object)PsiType.CHAR, (Object)Character.valueOf('C')).put((Object)PsiType.DOUBLE, (Object)Character.valueOf('D')).put((Object)PsiType.FLOAT, (Object)Character.valueOf('F')).put((Object)PsiType.INT, (Object)Character.valueOf('I')).put((Object)PsiType.LONG, (Object)Character.valueOf('J')).put((Object)PsiType.SHORT, (Object)Character.valueOf('S')).put((Object)PsiType.BOOLEAN, (Object)Character.valueOf('Z')).put((Object)PsiType.VOID, (Object)Character.valueOf('V')).build();

    @Nullable
    private static String convertToString(@NotNull PsiType psiType) {
        if (psiType == null) {
            TraceSignatureConverter.$$$reportNull$$$0(0);
        }
        if (psiType instanceof PsiArrayType) {
            return "[" + TraceSignatureConverter.convertToString(((PsiArrayType)psiType).getComponentType());
        }
        if (psiType instanceof PsiPrimitiveType) {
            return String.valueOf(PRIMITIVE_TYPES.get(psiType));
        }
        if (psiType instanceof PsiClassType) {
            return "L" + psiType.getCanonicalText().replaceAll("\\.", "/") + ";";
        }
        return null;
    }

    @NotNull
    public static String getTraceSignature(@NotNull PsiMethod method) {
        if (method == null) {
            TraceSignatureConverter.$$$reportNull$$$0(1);
        }
        StringBuilder signature = new StringBuilder("(");
        for (PsiType type : method.getSignature(PsiSubstitutor.EMPTY).getParameterTypes()) {
            String converted = TraceSignatureConverter.convertToString(TypeConversionUtil.erasure((PsiType)type));
            signature.append(converted);
        }
        signature.append(")");
        PsiType returnType = method.getReturnType();
        if (returnType != null) {
            String converted = TraceSignatureConverter.convertToString(TypeConversionUtil.erasure((PsiType)returnType));
            signature.append(converted);
        }
        String string = signature.toString();
        if (string == null) {
            TraceSignatureConverter.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/inspectors/common/api/TraceSignatureConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/inspectors/common/api/TraceSignatureConverter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraceSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertToString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTraceSignature";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

