/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.phaser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhaseKt;
import org.jetbrains.kotlin.backend.common.phaser.NamedCompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.PhaseConfig;
import org.jetbrains.kotlin.backend.common.phaser.PhaserState;
import org.jetbrains.kotlin.backend.common.phaser.SameTypeCompilerPhase;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u0003*\u0004\b\u0002\u0010\u00042\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00040\u0005B)\u0012\"\u0010\u0006\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00050\u0007\u00a2\u0006\u0002\u0010\tJ,\u0010\u0013\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0015\u0012\u000e\u0012\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u00160\u00140\u00072\u0006\u0010\u0017\u001a\u00020\u0015H\u0016J3\u0010\u0018\u001a\u00028\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00010\u001c2\u0006\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001fR-\u0010\u0006\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR4\u0010\f\u001a\"\u0012\u001e\u0012\u001c\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\u000f0\u000ej\n\u0012\u0006\u0012\u0004\u0018\u00010\b`\u00100\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/backend/common/phaser/CompositePhase;", "Context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "Input", "Output", "Lorg/jetbrains/kotlin/backend/common/phaser/CompilerPhase;", "phases", "", "", "(Ljava/util/List;)V", "getPhases", "()Ljava/util/List;", "stickyPostconditions", "", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/backend/common/phaser/Checker;", "getStickyPostconditions", "()Ljava/util/Set;", "getNamedSubphases", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/backend/common/phaser/NamedCompilerPhase;", "startDepth", "invoke", "phaseConfig", "Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfig;", "phaserState", "Lorg/jetbrains/kotlin/backend/common/phaser/PhaserState;", "context", "input", "(Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfig;Lorg/jetbrains/kotlin/backend/common/phaser/PhaserState;Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Ljava/lang/Object;)Ljava/lang/Object;", "ir.backend.common"})
final class CompositePhase<Context extends CommonBackendContext, Input, Output>
implements CompilerPhase<Context, Input, Output> {
    @NotNull
    private final List<CompilerPhase<Context, Object, Object>> phases;

    public CompositePhase(@NotNull List<? extends CompilerPhase<? super Context, Object, Object>> phases) {
        Intrinsics.checkNotNullParameter(phases, "phases");
        this.phases = phases;
    }

    @NotNull
    public final List<CompilerPhase<Context, Object, Object>> getPhases() {
        return this.phases;
    }

    @Override
    public Output invoke(@NotNull PhaseConfig phaseConfig, @NotNull PhaserState<Input> phaserState, @NotNull Context context2, Input input) {
        Intrinsics.checkNotNullParameter(phaseConfig, "phaseConfig");
        Intrinsics.checkNotNullParameter(phaserState, "phaserState");
        Intrinsics.checkNotNullParameter(context2, "context");
        PhaserState<Object> currentState = phaserState;
        Object result2 = CollectionsKt.first(this.phases).invoke(phaseConfig, currentState, context2, input);
        for (Pair pair : CollectionsKt.zip((Iterable)this.phases, CollectionsKt.drop((Iterable)this.phases, 1))) {
            CompilerPhase previous = (CompilerPhase)pair.component1();
            CompilerPhase next = (CompilerPhase)pair.component2();
            if (!(next instanceof SameTypeCompilerPhase)) {
                currentState = CompilerPhaseKt.changeType(currentState);
            }
            currentState.getStickyPostconditions().addAll(previous.getStickyPostconditions());
            result2 = next.invoke(phaseConfig, currentState, context2, result2);
        }
        return (Output)result2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Pair<Integer, NamedCompilerPhase<Context, ?>>> getNamedSubphases(int startDepth) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.phases;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            CompilerPhase it = (CompilerPhase)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getNamedSubphases(startDepth);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public Set<Function1<Object, Unit>> getStickyPostconditions() {
        return CollectionsKt.last(this.phases).getStickyPostconditions();
    }
}

