/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.actions;

import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.ide.actions.CreateTemplateInPackageAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Consumer;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericDomValue;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.actions.DevkitActionsUtil;
import org.jetbrains.idea.devkit.actions.NewMessageBundleAction;
import org.jetbrains.idea.devkit.actions.NewMessageBundleActionKt;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.idea.devkit.util.PsiUtil;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J#\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\r\u001a\u00020\bH\u0014J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J.\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0014\u0010\u0015\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u0018H\u0016\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/idea/devkit/actions/NewMessageBundleAction;", "Lcom/intellij/ide/actions/CreateElementActionBase;", "Lcom/intellij/openapi/actionSystem/UpdateInBackground;", "()V", "create", "", "Lcom/intellij/psi/PsiElement;", "newName", "", "directory", "Lcom/intellij/psi/PsiDirectory;", "(Ljava/lang/String;Lcom/intellij/psi/PsiDirectory;)[Lcom/intellij/psi/PsiElement;", "getActionName", "getErrorTitle", "getOrCreateResourcesRoot", "module", "Lcom/intellij/openapi/module/Module;", "invokeDialog", "", "project", "Lcom/intellij/openapi/project/Project;", "elementsConsumer", "Ljava/util/function/Consumer;", "isAvailable", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "startInWriteAction", "intellij.devkit"})
public final class NewMessageBundleAction
extends CreateElementActionBase
implements UpdateInBackground {
    protected void invokeDialog(@NotNull Project project, @NotNull PsiDirectory directory, @NotNull java.util.function.Consumer<? super PsiElement[]> elementsConsumer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter(elementsConsumer, (String)"elementsConsumer");
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)directory));
        if (module == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"ModuleUtilCore.findModul\u2026ment(directory) ?: return");
        Module module2 = module;
        String string = module2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"module.name");
        if (StringsKt.endsWith$default((String)string, (String)".impl", (boolean)false, (int)2, null)) {
            ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
            String string2 = module2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"module.name");
            if (moduleManager.findModuleByName(StringsKt.removeSuffix((String)string2, (CharSequence)".impl")) != null) {
                Messages.showErrorDialog((Project)project, (String)DevKitBundle.message("action.DevKit.NewMessageBundle.error.message.do.not.put.bundle.to.impl.module", new Object[0]), (String)this.getErrorTitle());
                return;
            }
        }
        CreateElementActionBase.MyInputValidator validator = new CreateElementActionBase.MyInputValidator((CreateElementActionBase)this, project, directory);
        String defaultName = NewMessageBundleActionKt.generateDefaultBundleName(module2);
        String result = Messages.showInputDialog((Project)project, (String)DevKitBundle.message("action.DevKit.NewMessageBundle.label.bundle.name", new Object[0]), (String)DevKitBundle.message("action.DevKit.NewMessageBundle.title.create.new.message.bundle", new Object[0]), null, (String)defaultName, (InputValidator)((InputValidator)validator));
        if (result != null) {
            PsiElement[] psiElementArray = validator.getCreatedElements();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"validator.createdElements");
            elementsConsumer.accept((PsiElement[])psiElementArray);
        }
    }

    @NotNull
    protected PsiElement[] create(@NotNull String newName, @NotNull PsiDirectory directory) {
        PsiDirectory resourcesRoot;
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        PsiClass bundleClass = DevkitActionsUtil.createSingleClass(newName, "MessageBundle.java", directory);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)directory));
        if (module == null) {
            return new PsiElement[0];
        }
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"ModuleUtilCore.findModul\u2026y) ?: return emptyArray()");
        Module module2 = module;
        XmlFile pluginXml = PluginModuleType.getPluginXml(module2);
        if (pluginXml != null) {
            DescriptorUtil.patchPluginXml(new DescriptorUtil.Patcher(module2, newName){
                final /* synthetic */ Module $module;
                final /* synthetic */ String $newName;

                public final void patchPluginXml(XmlFile xmlFile, PsiClass psiClass) {
                    DomFileElement fileElement = DomManager.getDomManager((Project)this.$module.getProject()).getFileElement(xmlFile, IdeaPlugin.class);
                    if (fileElement != null) {
                        DomElement domElement = fileElement.getRootElement();
                        Intrinsics.checkNotNullExpressionValue((Object)domElement, (String)"fileElement.rootElement");
                        GenericDomValue<String> genericDomValue = ((IdeaPlugin)domElement).getResourceBundle();
                        Intrinsics.checkNotNullExpressionValue(genericDomValue, (String)"fileElement.rootElement.resourceBundle");
                        GenericDomValue<String> resourceBundle = genericDomValue;
                        if (!resourceBundle.exists()) {
                            resourceBundle.setValue((Object)("messages." + this.$newName));
                        }
                    }
                }
                {
                    this.$module = module;
                    this.$newName = string;
                }
            }, bundleClass, pluginXml);
        }
        if ((resourcesRoot = this.getOrCreateResourcesRoot(module2)) == null) {
            PsiElement[] psiElementArray = new PsiElement[1];
            PsiClass psiClass = bundleClass;
            Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"bundleClass");
            psiElementArray[0] = (PsiElement)psiClass;
            return psiElementArray;
        }
        boolean $i$f$runWriteAction = false;
        Object object = ApplicationManager.getApplication().runWriteAction(new Computable(resourcesRoot, newName){
            final /* synthetic */ PsiDirectory $resourcesRoot$inlined;
            final /* synthetic */ String $newName$inlined;
            {
                this.$resourcesRoot$inlined = psiDirectory;
                this.$newName$inlined = string;
            }

            public final T compute() {
                boolean bl = false;
                String messagesDirName = "messages";
                PsiDirectory psiDirectory = this.$resourcesRoot$inlined.findSubdirectory(messagesDirName);
                if (psiDirectory == null) {
                    psiDirectory = this.$resourcesRoot$inlined.createSubdirectory(messagesDirName);
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiDirectory, (String)"resourcesRoot.findSubdir\u2026irectory(messagesDirName)");
                PsiDirectory messagesDir = psiDirectory;
                return (T)messagesDir.createFile(this.$newName$inlined + ".properties");
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runWriteAction {\n      v\u2026ewName.properties\")\n    }");
        PsiFile propertiesFile = (PsiFile)object;
        PsiElement[] psiElementArray = new PsiElement[2];
        PsiClass psiClass = bundleClass;
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"bundleClass");
        psiElementArray[0] = (PsiElement)psiClass;
        psiElementArray[1] = (PsiElement)propertiesFile;
        return psiElementArray;
    }

    private final PsiDirectory getOrCreateResourcesRoot(Module module) {
        Function1 $fun$reportError$1 = new Function1(module){
            final /* synthetic */ Module $module;

            @Nullable
            public final Void invoke(@Nls @NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Notification notification = new Notification("DevKit Errors", DevKitBundle.message("action.DevKit.NewMessageBundle.notification.title.cannot.create.resources.root.for.properties.file", new Object[0]), DevKitBundle.message("action.DevKit.NewMessageBundle.notification.content.cannot.create.resources.root.for.properties.file", message), NotificationType.ERROR);
                Notifications.Bus.notify((Notification)notification, (Project)this.$module.getProject());
                return null;
            }
            {
                this.$module = module;
                super(1);
            }
        };
        var $fun$createResourcesRoot$2 = new Function0<VirtualFile>(this, module, $fun$reportError$1){
            final /* synthetic */ NewMessageBundleAction this$0;
            final /* synthetic */ Module $module;
            final /* synthetic */ getOrCreateResourcesRoot.1 $reportError$1;

            @Nullable
            public final VirtualFile invoke() {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)this.$module);
                Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
                Object[] objectArray = moduleRootManager.getContentRoots();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ModuleRootManager.getInstance(module).contentRoots");
                VirtualFile virtualFile = (VirtualFile)ArraysKt.singleOrNull((Object[])objectArray);
                if (virtualFile == null) {
                    String string = DevKitBundle.message("action.DevKit.NewMessageBundle.error.message.multiple.content.roots.for.module", this.$module.getName());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"ac\u2026for.module\", module.name)");
                    return (VirtualFile)this.$reportError$1.invoke(string);
                }
                VirtualFile contentRoot = virtualFile;
                String resourcesDirName = "resources";
                if (contentRoot.findChild(resourcesDirName) != null) {
                    String string = DevKitBundle.message("action.DevKit.NewMessageBundle.error.message.folder.already.exists", resourcesDirName, contentRoot.getPath());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"ac\u2026irName, contentRoot.path)");
                    return (VirtualFile)this.$reportError$1.invoke(string);
                }
                if (ProjectFileIndex.getInstance((Project)this.$module.getProject()).isInSource(contentRoot)) {
                    String string = DevKitBundle.message("action.DevKit.NewMessageBundle.error.message.under.sources.root", contentRoot.getPath());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"ac\u2026.root\", contentRoot.path)");
                    return (VirtualFile)this.$reportError$1.invoke(string);
                }
                boolean $i$f$runWriteAction = false;
                return (VirtualFile)ApplicationManager.getApplication().runWriteAction(new Computable(this, contentRoot, resourcesDirName){
                    final /* synthetic */ getOrCreateResourcesRoot.2 this$0;
                    final /* synthetic */ VirtualFile $contentRoot$inlined;
                    final /* synthetic */ String $resourcesDirName$inlined;
                    {
                        this.this$0 = var1_1;
                        this.$contentRoot$inlined = virtualFile;
                        this.$resourcesDirName$inlined = string;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final T compute() {
                        void var2_2;
                        boolean bl = false;
                        VirtualFile virtualFile = this.$contentRoot$inlined.createChildDirectory((Object)((Object)this.this$0.this$0), this.$resourcesDirName$inlined);
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"contentRoot.createChildD\u2026y(this, resourcesDirName)");
                        VirtualFile resourcesDir = virtualFile;
                        ModuleRootModificationUtil.updateModel((Module)this.this$0.$module, (Consumer)new Consumer(resourcesDir){
                            final /* synthetic */ VirtualFile $resourcesDir;
                            {
                                this.$resourcesDir = virtualFile;
                            }

                            public final void consume(ModifiableRootModel it) {
                                ModifiableRootModel modifiableRootModel = it;
                                Intrinsics.checkNotNullExpressionValue((Object)modifiableRootModel, (String)"it");
                                Object[] objectArray = modifiableRootModel.getContentEntries();
                                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"it.contentEntries");
                                ((ContentEntry)ArraysKt.single((Object[])objectArray)).addSourceFolder(this.$resourcesDir, (JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
                            }
                        });
                        return var2_2;
                    }
                });
            }
            {
                this.this$0 = newMessageBundleAction;
                this.$module = module;
                this.$reportError$1 = var3_3;
                super(0);
            }
        };
        List list = ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ModuleRootManager.getIns\u2026esourceRootType.RESOURCE)");
        VirtualFile virtualFile = (VirtualFile)CollectionsKt.firstOrNull((List)list);
        if (virtualFile == null) {
            virtualFile = $fun$createResourcesRoot$2.invoke();
        }
        if (virtualFile == null) {
            return null;
        }
        VirtualFile resourcesRoot = virtualFile;
        return PsiManager.getInstance((Project)module.getProject()).findDirectory(resourcesRoot);
    }

    protected boolean isAvailable(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!super.isAvailable(dataContext)) {
            return false;
        }
        if (!PsiUtil.isIdeaProject((Project)dataContext.getData(CommonDataKeys.PROJECT))) {
            return false;
        }
        return CreateTemplateInPackageAction.isAvailable((DataContext)dataContext, (Set)JavaModuleSourceRootTypes.SOURCES, (Predicate)isAvailable.1.INSTANCE);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    protected String getErrorTitle() {
        String string = DevKitBundle.message("action.DevKit.NewMessageBundle.error.title.cannot.create.new.message.bundle", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"ac\u2026eate.new.message.bundle\")");
        return string;
    }

    @NotNull
    protected String getActionName(@NotNull PsiDirectory directory, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        String string = DevKitBundle.message("action.DevKit.NewMessageBundle.action.name.create.new.message.bundle", newName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"ac\u2026message.bundle\", newName)");
        return string;
    }
}

