/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.actions.updateFromSources;

import com.intellij.CommonBundle;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.task.ProjectTaskManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.PathsList;
import com.intellij.util.Restarter;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.actions.updateFromSources.UpdateFromSourcesDialog;
import org.jetbrains.idea.devkit.actions.updateFromSources.UpdateFromSourcesSettings;
import org.jetbrains.idea.devkit.actions.updateFromSources.UpdateFromSourcesSettingsKt;
import org.jetbrains.idea.devkit.actions.updateFromSources.UpdateFromSourcesSettingsState;
import org.jetbrains.idea.devkit.actions.updateFromSources.UpdateIdeFromSourcesAction;
import org.jetbrains.idea.devkit.actions.updateFromSources.UpdateIdeFromSourcesActionKt;
import org.jetbrains.idea.devkit.util.PsiUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0011\b\u0010\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\f\u001a\u00020\rH\u0002JF\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00052\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u001aH\u0002J#\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u001d2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u001fJ#\u0010 \u001a\u00020\b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\u001d2\u0006\u0010\"\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010#J@\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\u0005H\u0002J+\u0010(\u001a\u00020\b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\u001d2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010)J+\u0010*\u001a\u00020\b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\u001d2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010)J \u0010+\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010,\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010-\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/idea/devkit/actions/updateFromSources/UpdateIdeFromSourcesAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/actionSystem/UpdateInBackground;", "forceShowSettings", "", "(Z)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "backupImportantFilesIfNeeded", "workIdeHome", "", "backupDirPath", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "checkIdeHome", "createScriptJavaParameters", "Lcom/intellij/execution/configurations/JavaParameters;", "project", "Lcom/intellij/openapi/project/Project;", "deployDir", "distRelativePath", "buildEnabledPluginsOnly", "bundledPluginDirsToSkip", "", "nonBundledPluginDirsToInclude", "generateUpdateCommand", "", "builtDistPath", "(Ljava/lang/String;Ljava/lang/String;)[Ljava/lang/String;", "restartWithCommand", "command", "deployDirPath", "([Ljava/lang/String;Ljava/lang/String;)V", "runUpdateScript", "params", "backupDir", "restartAutomatically", "scheduleRestart", "([Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "showRestartNotification", "startCopyingFiles", "update", "updatePlugins", "intellij.devkit"})
public class UpdateIdeFromSourcesAction
extends AnAction
implements DumbAware,
UpdateInBackground {
    private final boolean forceShowSettings;

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        boolean buildEnabledPluginsOnly;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        if (this.forceShowSettings || UpdateFromSourcesSettings.Companion.getState().getShowSettings()) {
            String oldWorkIdePath = UpdateFromSourcesSettingsKt.getActualIdePath(UpdateFromSourcesSettings.Companion.getState());
            boolean ok = new UpdateFromSourcesDialog(project2, this.forceShowSettings).showAndGet();
            if (!ok) {
                return;
            }
            UpdateFromSourcesSettingsState updatedState = UpdateFromSourcesSettings.Companion.getState();
            if (Intrinsics.areEqual((Object)oldWorkIdePath, (Object)UpdateFromSourcesSettingsKt.getActualIdePath(updatedState)) ^ true) {
                updatedState.getWorkIdePathsHistory().remove(oldWorkIdePath);
                updatedState.getWorkIdePathsHistory().remove(UpdateFromSourcesSettingsKt.getActualIdePath(updatedState));
                updatedState.getWorkIdePathsHistory().add(0, UpdateFromSourcesSettingsKt.getActualIdePath(updatedState));
                updatedState.getWorkIdePathsHistory().add(0, oldWorkIdePath);
            }
        }
        var $fun$error$1 = new Function1<String, Unit>(project2){
            final /* synthetic */ Project $project;

            public final void invoke(@NlsContexts.DialogMessage @NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Messages.showErrorDialog((Project)this.$project, (String)message, (String)CommonBundle.getErrorTitle());
            }
            {
                this.$project = project;
                super(1);
            }
        };
        UpdateFromSourcesSettingsState state = UpdateFromSourcesSettings.Companion.getState();
        String string = project2.getBasePath();
        if (string == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.basePath ?: return");
        String devIdeaHome = string;
        String workIdeHome = UpdateFromSourcesSettingsKt.getActualIdePath(state);
        boolean restartAutomatically = state.getRestartAutomatically();
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isRestartCapable() && FileUtil.pathsEqual((String)workIdeHome, (String)PathManager.getHomePath())) {
            String string2 = DevKitBundle.message("action.UpdateIdeFromSourcesAction.error.ide.cannot.restart", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DevKitBundle.message(\"ac\u2026rror.ide.cannot.restart\")");
            $fun$error$1.invoke(string2);
            return;
        }
        String notIdeHomeMessage = this.checkIdeHome(workIdeHome);
        if (notIdeHomeMessage != null) {
            String string3 = DevKitBundle.message("action.UpdateIdeFromSourcesAction.error.work.home.not.valid.ide.home", workIdeHome, notIdeHomeMessage);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"DevKitBundle.message(\"ac\u2026eHome, notIdeHomeMessage)");
            $fun$error$1.invoke(string3);
            return;
        }
        if (FileUtil.isAncestor((String)workIdeHome, (String)PathManager.getConfigPath(), (boolean)false)) {
            String string4 = DevKitBundle.message("action.UpdateIdeFromSourcesAction.error.config.or.system.directory.under.home", workIdeHome, "idea.config.path");
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"DevKitBundle.message(\"ac\u2026ger.PROPERTY_CONFIG_PATH)");
            $fun$error$1.invoke(string4);
            return;
        }
        if (FileUtil.isAncestor((String)workIdeHome, (String)PathManager.getSystemPath(), (boolean)false)) {
            String string5 = DevKitBundle.message("action.UpdateIdeFromSourcesAction.error.config.or.system.directory.under.home", workIdeHome, "idea.system.path");
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"DevKitBundle.message(\"ac\u2026ger.PROPERTY_SYSTEM_PATH)");
            $fun$error$1.invoke(string5);
            return;
        }
        List bundledPluginDirsToSkip = null;
        List nonBundledPluginDirsToInclude = null;
        boolean bl = buildEnabledPluginsOnly = !state.getBuildDisabledPlugins();
        if (buildEnabledPluginsOnly) {
            IdeaPluginDescriptor[] $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable $this$filterTo$iv$iv;
            Object item$iv2;
            void $this$mapTo$iv;
            Object object;
            Collection collection;
            Iterable $this$mapTo$iv$iv2;
            Iterable $this$map$iv2;
            Iterator $this$filterTo$iv$iv2;
            Iterable $this$filter$iv;
            LinkedHashSet pluginDirectoriesToSkip = new LinkedHashSet(state.getPluginDirectoriesForDisabledPlugins());
            List list = PluginManagerCore.getLoadedPlugins();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"PluginManagerCore.getLoadedPlugins()");
            pluginDirectoriesToSkip.removeAll(SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)actionPerformed.2.INSTANCE), (Function1)actionPerformed.3.INSTANCE), (Function1)actionPerformed.4.INSTANCE), (Function1)actionPerformed.5.INSTANCE)));
            IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManagerCore.getPlugins();
            Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptorArray, (String)"PluginManagerCore.getPlugins()");
            IdeaPluginDescriptor[] ideaPluginDescriptorArray2 = ideaPluginDescriptorArray;
            boolean $i$f$filter = false;
            void var15_17 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv2) {
                void it = element$iv$iv;
                boolean bl2 = false;
                void v10 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"it");
                if (!(v10.isBundled() && !it.isEnabled())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                IdeaPluginDescriptor ideaPluginDescriptor = (IdeaPluginDescriptor)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                void v11 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"it");
                object = v11.getPluginPath();
                collection.add(object);
            }
            $this$map$iv2 = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$mapTo$iv$iv2 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv2.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                Path it = (Path)element$iv$iv;
                boolean bl4 = false;
                Path path = it;
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it");
                if (!PathKt.isDirectory((Path)path)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$mapTo2 = false;
            for (Object item$iv2 : $this$mapTo$iv) {
                void it;
                Path $i$f$filterTo2 = (Path)item$iv2;
                collection = pluginDirectoriesToSkip;
                boolean bl5 = false;
                void v13 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"it");
                object = PathsKt.getName((Path)v13);
                collection.add(object);
            }
            List list2 = CollectionsKt.toMutableList((Collection)pluginDirectoriesToSkip);
            state.setPluginDirectoriesForDisabledPlugins(list2);
            bundledPluginDirsToSkip = list2;
            IdeaPluginDescriptor[] ideaPluginDescriptorArray3 = PluginManagerCore.getPlugins();
            Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptorArray3, (String)"PluginManagerCore.getPlugins()");
            Object $this$filter$iv2 = ideaPluginDescriptorArray3;
            boolean $i$f$filter2 = false;
            item$iv2 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                void it = element$iv$iv;
                boolean bl6 = false;
                void v15 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"it");
                if (!(!v15.isBundled() && it.isEnabled())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv2;
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo3 = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv = iterator2.next();
                IdeaPluginDescriptor bl4 = (IdeaPluginDescriptor)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl7 = false;
                void v16 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"it");
                object = v16.getPluginPath();
                collection.add(object);
            }
            $this$map$iv = (List)destination$iv$iv2;
            $i$f$filter2 = false;
            $this$mapTo$iv$iv = $this$filter$iv2;
            destination$iv$iv2 = new ArrayList();
            $i$f$filterTo3 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Path it = (Path)element$iv$iv;
                boolean bl8 = false;
                Path path = it;
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it");
                if (!PathKt.isDirectory((Path)path)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv2;
            $i$f$map2 = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo3 = false;
            iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object item$iv$iv = iterator2.next();
                Path it = (Path)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl9 = false;
                Path path = it;
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it");
                object = PathsKt.getName((Path)path);
                collection.add(object);
            }
            nonBundledPluginDirsToInclude = (List)destination$iv$iv2;
        } else {
            bundledPluginDirsToSkip = CollectionsKt.emptyList();
            nonBundledPluginDirsToInclude = CollectionsKt.emptyList();
        }
        String deployDir = devIdeaHome + "/out/deploy";
        String distRelativePath = "dist";
        String backupDir = devIdeaHome + "/out/backup-before-update-from-sources";
        JavaParameters javaParameters = this.createScriptJavaParameters(project2, deployDir, distRelativePath, buildEnabledPluginsOnly, bundledPluginDirsToSkip, nonBundledPluginDirsToInclude);
        if (javaParameters == null) {
            return;
        }
        JavaParameters params = javaParameters;
        ProjectTaskManager.getInstance((Project)project2).buildAllModules().onSuccess(new Consumer(this, params, project2, workIdeHome, deployDir, distRelativePath, backupDir, restartAutomatically){
            final /* synthetic */ UpdateIdeFromSourcesAction this$0;
            final /* synthetic */ JavaParameters $params;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $workIdeHome;
            final /* synthetic */ String $deployDir;
            final /* synthetic */ String $distRelativePath;
            final /* synthetic */ String $backupDir;
            final /* synthetic */ boolean $restartAutomatically;

            public final void accept(ProjectTaskManager.Result it) {
                ProjectTaskManager.Result result = it;
                Intrinsics.checkNotNullExpressionValue((Object)result, (String)"it");
                if (!result.isAborted() && !it.hasErrors()) {
                    UpdateIdeFromSourcesAction.access$runUpdateScript(this.this$0, this.$params, this.$project, this.$workIdeHome, this.$deployDir, this.$distRelativePath, this.$backupDir, this.$restartAutomatically);
                }
            }
            {
                this.this$0 = updateIdeFromSourcesAction;
                this.$params = javaParameters;
                this.$project = project;
                this.$workIdeHome = string;
                this.$deployDir = string2;
                this.$distRelativePath = string3;
                this.$backupDir = string4;
                this.$restartAutomatically = bl;
            }
        });
    }

    private final String checkIdeHome(String workIdeHome) {
        File homeDir = new File(workIdeHome);
        if (!homeDir.exists()) {
            return null;
        }
        if (homeDir.isFile()) {
            return DevKitBundle.message("action.UpdateIdeFromSourcesAction.error.work.home.not.valid.ide.home.not.directory", new Object[0]);
        }
        String buildTxt = SystemInfo.isMac ? "Resources/build.txt" : "build.txt";
        for (String name : CollectionsKt.listOf((Object[])new String[]{"bin", buildTxt})) {
            if (new File(homeDir, name).exists()) continue;
            return DevKitBundle.message("action.UpdateIdeFromSourcesAction.error.work.home.not.valid.ide.home.not.exists", name);
        }
        return null;
    }

    private final void runUpdateScript(JavaParameters params, Project project, String workIdeHome, String deployDirPath, String distRelativePath, String backupDir, boolean restartAutomatically) {
        String builtDistPath = deployDirPath + "/" + distRelativePath;
        new Task.Backgroundable(this, workIdeHome, backupDir, builtDistPath, params, project, deployDirPath, restartAutomatically, project, DevKitBundle.message("action.UpdateIdeFromSourcesAction.task.title", new Object[0]), true){
            final /* synthetic */ UpdateIdeFromSourcesAction this$0;
            final /* synthetic */ String $workIdeHome;
            final /* synthetic */ String $backupDir;
            final /* synthetic */ String $builtDistPath;
            final /* synthetic */ JavaParameters $params;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $deployDirPath;
            final /* synthetic */ boolean $restartAutomatically;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setText(DevKitBundle.message("action.UpdateIdeFromSourcesAction.update.progress.text", new Object[0]));
                UpdateIdeFromSourcesAction.access$backupImportantFilesIfNeeded(this.this$0, this.$workIdeHome, this.$backupDir, indicator);
                indicator.setText2(DevKitBundle.message("action.UpdateIdeFromSourcesAction.update.progress.delete", this.$builtDistPath));
                FileUtil.delete((File)new File(this.$builtDistPath));
                indicator.setText2(DevKitBundle.message("action.UpdateIdeFromSourcesAction.update.progress.start.script", "UltimateUpdateFromSourcesBuildTarget"));
                GeneralCommandLine generalCommandLine = this.$params.toCommandLine();
                Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"params.toCommandLine()");
                GeneralCommandLine commandLine = generalCommandLine;
                commandLine.setRedirectErrorStream(true);
                OSProcessHandler scriptHandler = new OSProcessHandler(commandLine);
                List<T> output = Collections.synchronizedList((List)new ArrayList<E>());
                scriptHandler.addProcessListener((ProcessListener)new ProcessAdapter(this, output, indicator){
                    final /* synthetic */ runUpdateScript.1 this$0;
                    final /* synthetic */ List $output;
                    final /* synthetic */ ProgressIndicator $indicator;

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                        this.$output.add(event.getText());
                        if (Intrinsics.areEqual(outputType, (Object)ProcessOutputTypes.STDOUT)) {
                            this.$indicator.setText2(event.getText());
                        }
                    }

                    public void processTerminated(@NotNull ProcessEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        if (this.$indicator.isCanceled()) {
                            return;
                        }
                        if (event.getExitCode() != 0) {
                            NotificationGroup notificationGroup2 = UpdateIdeFromSourcesActionKt.access$getNotificationGroup$p();
                            String string = DevKitBundle.message("action.UpdateIdeFromSourcesAction.task.failed.title", new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"ac\u2026ction.task.failed.title\")");
                            String string2 = DevKitBundle.message("action.UpdateIdeFromSourcesAction.task.failed.content", event.getExitCode());
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DevKitBundle.message(\"ac\u2026          event.exitCode)");
                            notificationGroup2.createNotification(string, string2, NotificationType.ERROR).addAction((AnAction)NotificationAction.createSimple((String)DevKitBundle.message("action.UpdateIdeFromSourcesAction.notification.action.view.output", new Object[0]), (Runnable)new Runnable(this){
                                final /* synthetic */ runUpdateScript.run.1 this$0;

                                public final void run() {
                                    FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.this$0.this$0.$project);
                                    List list = this.this$0.$output;
                                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"output");
                                    fileEditorManager.openFile((VirtualFile)new LightVirtualFile("output.txt", (CharSequence)CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"", null, null, (int)0, null, null, (int)62, null)), true);
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            })).addAction((AnAction)NotificationAction.createSimple((String)DevKitBundle.message("action.UpdateIdeFromSourcesAction.notification.action.view.debug.log", new Object[0]), (Runnable)new Runnable(this){
                                final /* synthetic */ runUpdateScript.run.1 this$0;

                                public final void run() {
                                    VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.this$0.this$0.$deployDirPath + "/log/debug.log");
                                    if (virtualFile == null) {
                                        return;
                                    }
                                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"LocalFileSystem.getInsta\u2026\") ?: return@createSimple");
                                    VirtualFile logFile = virtualFile;
                                    logFile.refresh(true, false);
                                    FileEditorManager.getInstance((Project)this.this$0.this$0.$project).openFile(logFile, true);
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            })).notify(this.this$0.$project);
                            return;
                        }
                        if (!FileUtil.pathsEqual((String)this.this$0.$workIdeHome, (String)PathManager.getHomePath())) {
                            UpdateIdeFromSourcesAction.access$startCopyingFiles(this.this$0.this$0, this.this$0.$builtDistPath, this.this$0.$workIdeHome, this.this$0.$project);
                            return;
                        }
                        String[] command = UpdateIdeFromSourcesAction.access$generateUpdateCommand(this.this$0.this$0, this.this$0.$builtDistPath, this.this$0.$workIdeHome);
                        if (this.this$0.$restartAutomatically) {
                            ApplicationManager.getApplication().invokeLater(new Runnable(this, command){
                                final /* synthetic */ runUpdateScript.run.1 this$0;
                                final /* synthetic */ String[] $command;

                                public final void run() {
                                    UpdateIdeFromSourcesAction.access$scheduleRestart(this.this$0.this$0.this$0, this.$command, this.this$0.this$0.$deployDirPath, this.this$0.this$0.$project);
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$command = stringArray;
                                }
                            });
                        } else {
                            UpdateIdeFromSourcesAction.access$showRestartNotification(this.this$0.this$0, command, this.this$0.$deployDirPath, this.this$0.$project);
                        }
                    }
                    {
                        this.this$0 = this$0;
                        this.$output = $captured_local_variable$1;
                        this.$indicator = $captured_local_variable$2;
                    }
                });
                scriptHandler.startNotify();
                while (!scriptHandler.isProcessTerminated()) {
                    scriptHandler.waitFor(300L);
                    indicator.checkCanceled();
                }
            }
            {
                this.this$0 = this$0;
                this.$workIdeHome = $captured_local_variable$1;
                this.$backupDir = $captured_local_variable$2;
                this.$builtDistPath = $captured_local_variable$3;
                this.$params = $captured_local_variable$4;
                this.$project = $captured_local_variable$5;
                this.$deployDirPath = $captured_local_variable$6;
                this.$restartAutomatically = $captured_local_variable$7;
                super($super_call_param$8, $super_call_param$9, $super_call_param$10);
            }
        }.queue();
    }

    private final void showRestartNotification(String[] command, String deployDirPath, Project project) {
        NotificationGroup notificationGroup2 = UpdateIdeFromSourcesActionKt.access$getNotificationGroup$p();
        String string = DevKitBundle.message("action.UpdateIdeFromSourcesAction.task.success.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"ac\u2026tion.task.success.title\")");
        String string2 = DevKitBundle.message("action.UpdateIdeFromSourcesAction.task.success.content", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DevKitBundle.message(\"ac\u2026on.task.success.content\")");
        notificationGroup2.createNotification(string, string2, NotificationType.INFORMATION).setListener(new NotificationListener(this, command, deployDirPath){
            final /* synthetic */ UpdateIdeFromSourcesAction this$0;
            final /* synthetic */ String[] $command;
            final /* synthetic */ String $deployDirPath;

            public final void hyperlinkUpdate(@NotNull Notification $noName_0, @NotNull HyperlinkEvent $noName_1) {
                Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"<anonymous parameter 1>");
                UpdateIdeFromSourcesAction.access$restartWithCommand(this.this$0, this.$command, this.$deployDirPath);
            }
            {
                this.this$0 = updateIdeFromSourcesAction;
                this.$command = stringArray;
                this.$deployDirPath = string;
            }
        }).notify(project);
    }

    private final void scheduleRestart(String[] command, String deployDirPath, Project project) {
        new Task.Modal(this, command, deployDirPath, project, project, DevKitBundle.message("action.UpdateIdeFromSourcesAction.task.success.title", new Object[0]), true){
            final /* synthetic */ UpdateIdeFromSourcesAction this$0;
            final /* synthetic */ String[] $command;
            final /* synthetic */ String $deployDirPath;
            final /* synthetic */ Project $project;

            /*
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setIndeterminate(false);
                int progress = 0;
                int n = 10;
                int n2 = 1;
                while (n >= n2) {
                    void i;
                    indicator.setText(DevKitBundle.message("action.UpdateIdeFromSourcesAction.progress.text.new.installation.prepared.ide.will.restart", (int)i));
                    int n3 = 10;
                    int n4 = 0;
                    while (n4 < n3) {
                        int n5;
                        int it = n5 = n4++;
                        boolean bl = false;
                        int n6 = progress;
                        progress = n6 + 1;
                        indicator.setFraction(0.01 * (double)n6);
                        indicator.checkCanceled();
                        TimeoutUtil.sleep((long)100L);
                    }
                    --i;
                }
                UpdateIdeFromSourcesAction.access$restartWithCommand(this.this$0, this.$command, this.$deployDirPath);
            }

            public void onCancel() {
                UpdateIdeFromSourcesAction.access$showRestartNotification(this.this$0, this.$command, this.$deployDirPath, this.$project);
            }
            {
                this.this$0 = this$0;
                this.$command = $captured_local_variable$1;
                this.$deployDirPath = $captured_local_variable$2;
                this.$project = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        }.setCancelText(DevKitBundle.message("action.UpdateIdeFromSourcesAction.button.postpone", new Object[0])).queue();
    }

    /*
     * WARNING - void declaration
     */
    private final void backupImportantFilesIfNeeded(String workIdeHome, String backupDirPath, ProgressIndicator indicator) {
        File[] $this$forEach$iv;
        boolean $i$f$forEach;
        void it;
        Iterator $this$filterTo$iv$iv;
        boolean $i$f$filterTo;
        Collection destination$iv$iv;
        Iterable $this$filter$iv;
        boolean $i$f$filter;
        File backupDir = new File(backupDirPath);
        if (backupDir.exists()) {
            UpdateIdeFromSourcesActionKt.access$getLOG$p().debug(backupDir + " already exists, skipping backup");
            return;
        }
        UpdateIdeFromSourcesActionKt.access$getLOG$p().debug("Backing up files from " + workIdeHome + " to " + backupDir);
        indicator.setText2(DevKitBundle.message("action.UpdateIdeFromSourcesAction.backup.progress.text", new Object[0]));
        FileUtil.createDirectory((File)backupDir);
        File[] fileArray = new File(workIdeHome, "bin").listFiles();
        if (fileArray != null) {
            File[] fileArray2 = fileArray;
            $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                it = element$iv$iv;
                boolean bl = false;
                Set set = UpdateIdeFromSourcesActionKt.access$getSafeToDeleteFilesInBin$p();
                void v2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
                if (!(!set.contains(v2.getName()) && !UpdateIdeFromSourcesActionKt.access$getSafeToDeleteExtensions$p().contains(FilesKt.getExtension((File)it)))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it2 = (File)element$iv;
                boolean bl = false;
                File file = it2;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
                FileUtil.copy((File)it2, (File)new File(backupDir, "bin/" + file.getName()));
            }
        }
        File[] fileArray3 = new File(workIdeHome).listFiles();
        if (fileArray3 != null) {
            $this$forEach$iv = fileArray3;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                it = element$iv$iv;
                boolean bl = false;
                Set set = UpdateIdeFromSourcesActionKt.access$getSafeToDeleteFilesInHome$p();
                void v6 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"it");
                if (!(!set.contains(v6.getName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it3 = (File)element$iv;
                boolean bl = false;
                File file = it3;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
                FileUtil.copyFileOrDir((File)it3, (File)new File(backupDir, file.getName()));
            }
        }
    }

    private final void startCopyingFiles(String builtDistPath, String workIdeHome, Project project) {
        new Task.Backgroundable(workIdeHome, builtDistPath, project, project, DevKitBundle.message("action.UpdateIdeFromSourcesAction.task.title", new Object[0]), true){
            final /* synthetic */ String $workIdeHome;
            final /* synthetic */ String $builtDistPath;
            final /* synthetic */ Project $project;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setText(DevKitBundle.message("action.UpdateIdeFromSourcesAction.copy.progress.text", new Object[0]));
                indicator.setText2(DevKitBundle.message("action.UpdateIdeFromSourcesAction.copy.delete.old.files.text", new Object[0]));
                FileUtil.delete((File)new File(this.$workIdeHome));
                indicator.checkCanceled();
                indicator.setText2(DevKitBundle.message("action.UpdateIdeFromSourcesAction.copy.copy.new.files.text", new Object[0]));
                FileUtil.copyDir((File)new File(this.$builtDistPath), (File)new File(this.$workIdeHome));
                indicator.checkCanceled();
                new Notification("Update from Sources", DevKitBundle.message("action.UpdateIdeFromSourcesAction.notification.title", new Object[0]), DevKitBundle.message("action.UpdateIdeFromSourcesAction.notification.content", this.$workIdeHome), NotificationType.INFORMATION).notify(this.$project);
            }
            {
                this.$workIdeHome = $captured_local_variable$0;
                this.$builtDistPath = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        }.queue();
    }

    private final String[] generateUpdateCommand(String builtDistPath, String workIdeHome) {
        if (SystemInfo.isWindows) {
            File restartLogFile = new File(PathManager.getLogPath(), "update-from-sources.log");
            File file = FileUtil.createTempFile((String)"update", (String)".cmd", (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"FileUtil.createTempFile(\"update\", \".cmd\", false)");
            File updateScript = file;
            String workHomePath = new File(workIdeHome).getAbsolutePath();
            FileUtil.writeToFile((File)updateScript, (String)StringsKt.trimIndent((String)("\n        @echo off\n        SET count=20\n        SET time_to_wait=1\n        :DELETE_DIR\n        RMDIR /Q /S \"" + workHomePath + "\"\n        IF EXIST \"" + workHomePath + "\" (\n          IF %count% GEQ 0 (\n            ECHO \"" + workHomePath + "\" still exists, wait %time_to_wait%s and try delete again\n            SET /A time_to_wait=%time_to_wait%+1\n            PING 127.0.0.1 -n %time_to_wait% >NUL\n            SET /A count=%count%-1\n            ECHO %count% attempts remain\n            GOTO DELETE_DIR\n          )\n          ECHO Failed to delete \"" + workHomePath + "\", IDE wasn't updated. You may delete it manually and copy files from \"" + new File(builtDistPath).getAbsolutePath() + "\" by hand  \n          GOTO CLEANUP_AND_EXIT \n        )\n        \n        XCOPY \"" + new File(builtDistPath).getAbsolutePath() + "\" \"" + workHomePath + "\"\\ /Q /E /Y\n        :CLEANUP_AND_EXIT\n        START /b \"\" cmd /c DEL /Q /F \"" + updateScript.getAbsolutePath() + "\" & EXIT /b\n      ")));
            String[] stringArray = new String[5];
            stringArray[0] = "cmd";
            stringArray[1] = "/c";
            String string = updateScript.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"updateScript.absolutePath");
            stringArray[2] = string;
            stringArray[3] = ">" + restartLogFile.getAbsolutePath();
            stringArray[4] = "2>&1";
            return stringArray;
        }
        Object[] command = new String[]{"rm -rf \"" + workIdeHome + "\"/*", "cp -R \"" + builtDistPath + "\"/* \"" + workIdeHome + "\""};
        return new String[]{"/bin/sh", "-c", ArraysKt.joinToString$default((Object[])command, (CharSequence)" && ", null, null, (int)0, null, null, (int)62, null)};
    }

    private final void restartWithCommand(String[] command, String deployDirPath) {
        this.updatePlugins(deployDirPath);
        Restarter.doNotLockInstallFolderOnRestart();
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.application.impl.ApplicationImpl");
        }
        ((ApplicationImpl)application).restart(7, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void updatePlugins(String deployDirPath) {
        IdeaPluginDescriptor $this$mapNotNullTo$iv$iv;
        void $this$associateByTo$iv$iv;
        Object object;
        Path pluginsXml;
        Path path = Paths.get(deployDirPath, new String[0]);
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
        BuildNumber buildNumber = applicationInfo.getBuild();
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"ApplicationInfo.getInstance().build");
        Path pluginsDir = path.resolve("artifacts/" + buildNumber.getProductCode() + "-plugins");
        Path path2 = pluginsXml = pluginsDir.resolve("plugins.xml");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"pluginsXml");
        if (!PathKt.isFile((Path)path2)) {
            UpdateIdeFromSourcesActionKt.access$getLOG$p().warn("Cannot read non-bundled plugins from " + pluginsXml + ", they won't be updated");
            return;
        }
        try {
            object = PathKt.inputStream((Path)pluginsXml);
            Throwable throwable = null;
            try {
                Object it = (InputStream)object;
                boolean bl = false;
                it = MarketplaceRequests.Companion.parsePluginList((InputStream)it);
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = it;
        }
        catch (Exception e) {
            UpdateIdeFromSourcesActionKt.access$getLOG$p().error("Failed to parse " + pluginsXml, (Throwable)e);
            return;
        }
        Object plugins = object;
        List list = PluginManagerCore.getLoadedPlugins();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"PluginManagerCore.getLoadedPlugins()");
        Sequence $this$associateBy$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)updatePlugins.existingCustomPlugins.1.INSTANCE);
        boolean $i$f$associateBy = false;
        Sequence bl = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            IdeaPluginDescriptor ideaPluginDescriptor = (IdeaPluginDescriptor)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl2 = false;
            void v5 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"it");
            PluginId pluginId = v5.getPluginId();
            Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"it.pluginId");
            String string = pluginId.getIdString();
            map.put(string, element$iv$iv);
        }
        Map existingCustomPlugins2 = destination$iv$iv;
        UpdateIdeFromSourcesActionKt.access$getLOG$p().debug("Existing custom plugins: " + existingCustomPlugins2);
        Iterable $this$mapNotNull$iv = (Iterable)plugins;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Pair pair2;
            Pair pair3;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl3 = false;
            PluginNode node = (PluginNode)element$iv$iv;
            boolean bl4 = false;
            PluginId pluginId = node.getPluginId();
            Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"node.pluginId");
            if ((IdeaPluginDescriptor)existingCustomPlugins2.get(pluginId.getIdString()) != null) {
                IdeaPluginDescriptor ideaPluginDescriptor;
                IdeaPluginDescriptor it = ideaPluginDescriptor;
                boolean bl5 = false;
                pair3 = TuplesKt.to((Object)it, (Object)node);
            } else {
                pair3 = pair2 = null;
            }
            if (pair2 == null) continue;
            Pair it$iv$iv = pair = pair2;
            boolean bl6 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List pluginsToUpdate = (List)destination$iv$iv2;
        for (Pair pair : pluginsToUpdate) {
            void existing;
            $this$mapNotNullTo$iv$iv = (IdeaPluginDescriptor)pair.component1();
            PluginNode update = (PluginNode)pair.component2();
            Path pluginFile = pluginsDir.resolve(update.getDownloadUrl());
            UpdateIdeFromSourcesActionKt.access$getLOG$p().debug("Adding update command: " + existing.getPluginPath() + " to " + pluginFile);
            PluginInstaller.installAfterRestart((Path)pluginFile, (boolean)false, (Path)existing.getPluginPath(), (IdeaPluginDescriptor)((IdeaPluginDescriptor)update));
        }
    }

    private final JavaParameters createScriptJavaParameters(Project project, String deployDir, String distRelativePath, boolean buildEnabledPluginsOnly, List<String> bundledPluginDirsToSkip, List<String> nonBundledPluginDirsToInclude) {
        Collection collection;
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
        Sdk sdk = projectRootManager.getProjectSdk();
        if (sdk == null) {
            UpdateIdeFromSourcesActionKt.access$getLOG$p().warn("Project SDK is not defined");
            return null;
        }
        JavaParameters params = new JavaParameters();
        params.setUseClasspathJar(true);
        params.setDefaultCharset(project);
        params.setJdk(sdk);
        params.setMainClass("UltimateUpdateFromSourcesBuildTarget");
        params.getProgramParametersList().add("--classpath");
        String buildScriptsModuleName = "intellij.idea.ultimate.build";
        Module buildScriptsModule = ModuleManager.getInstance((Project)project).findModuleByName(buildScriptsModuleName);
        if (buildScriptsModule == null) {
            UpdateIdeFromSourcesActionKt.access$getLOG$p().warn("Build scripts module " + buildScriptsModuleName + " is not found in the project");
            return null;
        }
        OrderRootsEnumerator orderRootsEnumerator = OrderEnumerator.orderEntries((Module)buildScriptsModule).recursively().withoutSdk().runtimeOnly().productionOnly().classes();
        Intrinsics.checkNotNullExpressionValue((Object)orderRootsEnumerator, (String)"OrderEnumerator.orderEnt\u2026roductionOnly().classes()");
        PathsList pathsList = orderRootsEnumerator.getPathsList();
        Intrinsics.checkNotNullExpressionValue((Object)pathsList, (String)"OrderEnumerator.orderEnt\u2026nly().classes().pathsList");
        List list = pathsList.getPathList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"OrderEnumerator.orderEnt\u2026sses().pathsList.pathList");
        List classpath = list;
        params.getClassPath().addAll(classpath);
        params.getVMParametersList().add("-Dintellij.build.generate.bin.and.runtime.for.unpacked.dist=true");
        params.getVMParametersList().add("-Dintellij.build.bundled.jre.prefix=jbrsdk-");
        if (buildEnabledPluginsOnly) {
            Collection collection2;
            collection = bundledPluginDirsToSkip;
            if (!collection.isEmpty()) {
                params.getVMParametersList().add("-Dintellij.build.bundled.plugin.dirs.to.skip=" + CollectionsKt.joinToString$default((Iterable)bundledPluginDirsToSkip, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            }
            String nonBundled = !(collection2 = (Collection)nonBundledPluginDirsToInclude).isEmpty() ? CollectionsKt.joinToString$default((Iterable)nonBundledPluginDirsToInclude, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) : "none";
            params.getVMParametersList().add("-Dintellij.build.non.bundled.plugin.dirs.to.include=" + nonBundled);
        }
        if (!buildEnabledPluginsOnly || !(collection = (Collection)nonBundledPluginDirsToInclude).isEmpty()) {
            params.getVMParametersList().add("-Dintellij.build.local.plugins.repository=true");
        }
        params.getVMParametersList().add("-Dintellij.build.output.root=" + deployDir);
        params.getVMParametersList().add("-DdistOutputRelativePath=" + distRelativePath);
        return params;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(project != null && PsiUtil.isIdeaProject(project));
    }

    @JvmOverloads
    public UpdateIdeFromSourcesAction(boolean forceShowSettings) {
        super(forceShowSettings ? DevKitBundle.message("action.UpdateIdeFromSourcesAction.update.show.settings.text", new Object[0]) : DevKitBundle.message("action.UpdateIdeFromSourcesAction.update.text", new Object[0]), DevKitBundle.message("action.UpdateIdeFromSourcesAction.update.description", new Object[0]), null);
        this.forceShowSettings = forceShowSettings;
    }

    public /* synthetic */ UpdateIdeFromSourcesAction(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @JvmOverloads
    public UpdateIdeFromSourcesAction() {
        this(false, 1, null);
    }

    public static final /* synthetic */ void access$runUpdateScript(UpdateIdeFromSourcesAction $this, JavaParameters params, Project project, String workIdeHome, String deployDirPath, String distRelativePath, String backupDir, boolean restartAutomatically) {
        $this.runUpdateScript(params, project, workIdeHome, deployDirPath, distRelativePath, backupDir, restartAutomatically);
    }

    public static final /* synthetic */ void access$backupImportantFilesIfNeeded(UpdateIdeFromSourcesAction $this, String workIdeHome, String backupDirPath, ProgressIndicator indicator) {
        $this.backupImportantFilesIfNeeded(workIdeHome, backupDirPath, indicator);
    }

    public static final /* synthetic */ void access$startCopyingFiles(UpdateIdeFromSourcesAction $this, String builtDistPath, String workIdeHome, Project project) {
        $this.startCopyingFiles(builtDistPath, workIdeHome, project);
    }

    public static final /* synthetic */ String[] access$generateUpdateCommand(UpdateIdeFromSourcesAction $this, String builtDistPath, String workIdeHome) {
        return $this.generateUpdateCommand(builtDistPath, workIdeHome);
    }

    public static final /* synthetic */ void access$scheduleRestart(UpdateIdeFromSourcesAction $this, String[] command, String deployDirPath, Project project) {
        $this.scheduleRestart(command, deployDirPath, project);
    }

    public static final /* synthetic */ void access$showRestartNotification(UpdateIdeFromSourcesAction $this, String[] command, String deployDirPath, Project project) {
        $this.showRestartNotification(command, deployDirPath, project);
    }

    public static final /* synthetic */ void access$restartWithCommand(UpdateIdeFromSourcesAction $this, String[] command, String deployDirPath) {
        $this.restartWithCommand(command, deployDirPath);
    }
}

