/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.commit;

import com.intellij.dvcs.push.PrePushHandler;
import com.intellij.dvcs.push.PushInfo;
import com.intellij.dvcs.push.PushSpec;
import com.intellij.dvcs.push.PushTarget;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.PathKt;
import com.intellij.vcs.log.VcsFullCommitDetails;
import git4idea.config.GitSharedSettings;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.commit.KotlinPluginPrePushHandler;
import org.jetbrains.idea.devkit.util.PsiUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0006H\u0002J\u0014\u0010\u0013\u001a\u00020\u0006*\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\f\u0010\u0016\u001a\u00020\u0006*\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/idea/devkit/commit/KotlinPluginPrePushHandler;", "Lcom/intellij/dvcs/push/PrePushHandler;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "breaksKotlinPluginMessageRules", "", "commit", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "getPresentableName", "", "handle", "Lcom/intellij/dvcs/push/PrePushHandler$Result;", "pushDetails", "", "Lcom/intellij/dvcs/push/PushInfo;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "handlerIsApplicable", "hasCommitsToEdit", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "isTargetBranchProtected", "Companion", "intellij.devkit"})
public final class KotlinPluginPrePushHandler
implements PrePushHandler {
    private final Project project;
    private static final String HANDLER_ENABLED_KEY = "kotlin.commit.message.validation.enabled";
    private static final String KOTLIN_PLUGIN_PATH = "plugins/kotlin/";
    private static final Set<String> pathsToIgnore;
    private static final Set<String> fileExtensionsNotToTrack;
    private static final Regex commitMessageRegex;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public String getPresentableName() {
        String string = DevKitBundle.message("push.commit.handler.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"push.commit.handler.name\")");
        return string;
    }

    @NotNull
    public PrePushHandler.Result handle(@NotNull List<PushInfo> pushDetails, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter(pushDetails, (String)"pushDetails");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        if (!this.handlerIsApplicable()) {
            return PrePushHandler.Result.OK;
        }
        for (PushInfo details : pushDetails) {
            if (!this.isTargetBranchProtected(details)) continue;
            ModalityState modalityState = indicator.getModalityState();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"indicator.modalityState");
            if (!this.hasCommitsToEdit(details, modalityState)) continue;
            return PrePushHandler.Result.ABORT_AND_CLOSE;
        }
        return PrePushHandler.Result.OK;
    }

    private final boolean isTargetBranchProtected(PushInfo $this$isTargetBranchProtected) {
        PushSpec pushSpec = $this$isTargetBranchProtected.getPushSpec();
        Intrinsics.checkNotNullExpressionValue((Object)pushSpec, (String)"pushSpec");
        PushTarget pushTarget = pushSpec.getTarget();
        Intrinsics.checkNotNullExpressionValue((Object)pushTarget, (String)"pushSpec.target");
        String string = pushTarget.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pushSpec.target.presentation");
        String targetBranchName = string;
        return GitSharedSettings.getInstance((Project)this.project).isBranchProtected(targetBranchName);
    }

    private final boolean hasCommitsToEdit(PushInfo $this$hasCommitsToEdit, ModalityState modalityState) {
        List list = $this$hasCommitsToEdit.getCommits();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"commits");
        List commitsToWarnAbout2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<VcsFullCommitDetails, Boolean>(this){

            public final boolean invoke(@NotNull VcsFullCommitDetails p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return KotlinPluginPrePushHandler.access$breaksKotlinPluginMessageRules((KotlinPluginPrePushHandler)this.receiver, p1);
            }
        })), (Function1)hasCommitsToEdit.commitsToWarnAbout.2.INSTANCE));
        if (commitsToWarnAbout2.isEmpty()) {
            return false;
        }
        String commitsInfo2 = CollectionsKt.joinToString$default((Iterable)commitsToWarnAbout2, (CharSequence)"<br/>", null, null, (int)0, null, (Function1)hasCommitsToEdit.commitsInfo.1.INSTANCE, (int)30, null);
        boolean commitAsIs2 = (Boolean)KotlinPluginPrePushHandler.Companion.invokeAndWait(modalityState, (Function0)new Function0<Boolean>(commitsInfo2){
            final /* synthetic */ String $commitsInfo;

            public final boolean invoke() {
                String string = DevKitBundle.message("push.commit.message.lacks.issue.reference.title", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"pu\u2026s.issue.reference.title\")");
                String string2 = DevKitBundle.message("push.commit.message.lacks.issue.reference.body", this.$commitsInfo);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DevKitBundle.message(\"pu\u2026rence.body\", commitsInfo)");
                MessageDialogBuilder.YesNo yesNo = MessageDialogBuilder.Companion.yesNo(string, string2);
                String string3 = DevKitBundle.message("push.commit.message.lacks.issue.reference.commit", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"DevKitBundle.message(\"pu\u2026.issue.reference.commit\")");
                MessageDialogBuilder.YesNo yesNo2 = (MessageDialogBuilder.YesNo)yesNo.yesText(string3);
                String string4 = DevKitBundle.message("push.commit.message.lacks.issue.reference.edit", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"DevKitBundle.message(\"pu\u2026ks.issue.reference.edit\")");
                return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)yesNo2.noText(string4)).asWarning()).ask(null);
            }
            {
                this.$commitsInfo = string;
                super(0);
            }
        });
        return !commitAsIs2;
    }

    private final boolean handlerIsApplicable() {
        return Registry.is((String)HANDLER_ENABLED_KEY, (boolean)true) && PsiUtil.isIdeaProject(this.project);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean breaksKotlinPluginMessageRules(VcsFullCommitDetails commit) {
        void $this$mapNotNullTo$iv$iv;
        Collection collection = commit.getChanges();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"commit.changes");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile virtualFile;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Change it = (Change)element$iv$iv;
            boolean bl2 = false;
            Change change = it;
            Intrinsics.checkNotNullExpressionValue((Object)change, (String)"it");
            VirtualFile virtualFile2 = change.getVirtualFile();
            if (virtualFile2 == null) continue;
            VirtualFile it$iv$iv = virtualFile = virtualFile2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List changedFiles = (List)destination$iv$iv;
        if (!Companion.containKotlinPluginSources$intellij_devkit(changedFiles)) return false;
        String string = commit.getFullMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"commit.fullMessage");
        if (Companion.commitMessageIsCorrect$intellij_devkit(string)) return false;
        return true;
    }

    public KotlinPluginPrePushHandler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    static {
        Companion = new Companion(null);
        pathsToIgnore = SetsKt.setOf((Object[])new String[]{"/test/", "/testData/", "/fleet/plugins/kotlin/"});
        fileExtensionsNotToTrack = SetsKt.setOf((Object[])new String[]{"iml", "md"});
        commitMessageRegex = new Regex(".*KTIJ-\\d+.*", RegexOption.DOT_MATCHES_ALL);
    }

    public static final /* synthetic */ boolean access$breaksKotlinPluginMessageRules(KotlinPluginPrePushHandler $this, VcsFullCommitDetails commit) {
        return $this.breaksKotlinPluginMessageRules(commit);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u000eJ\u001b\u0010\u000f\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0000\u00a2\u0006\u0002\b\u0013J)\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/idea/devkit/commit/KotlinPluginPrePushHandler$Companion;", "", "()V", "HANDLER_ENABLED_KEY", "", "KOTLIN_PLUGIN_PATH", "commitMessageRegex", "Lkotlin/text/Regex;", "fileExtensionsNotToTrack", "", "pathsToIgnore", "commitMessageIsCorrect", "", "message", "commitMessageIsCorrect$intellij_devkit", "containKotlinPluginSources", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "containKotlinPluginSources$intellij_devkit", "invokeAndWait", "T", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "computable", "Lkotlin/Function0;", "(Lcom/intellij/openapi/application/ModalityState;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.devkit"})
    public static final class Companion {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean containKotlinPluginSources$intellij_devkit(@NotNull Collection<? extends VirtualFile> files) {
            boolean bl;
            Intrinsics.checkNotNullParameter(files, (String)"files");
            Sequence $this$any$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)files), (Function1)containKotlinPluginSources.1.INSTANCE);
            boolean $i$f$any = false;
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                Path path = (Path)element$iv;
                boolean bl2 = false;
                Path path2 = path;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
                String siPath = PathKt.getSystemIndependentPath((Path)path2);
                if (!fileExtensionsNotToTrack.contains(PathsKt.getExtension((Path)path)) && StringsKt.contains$default((CharSequence)siPath, (CharSequence)KotlinPluginPrePushHandler.KOTLIN_PLUGIN_PATH, (boolean)false, (int)2, null)) {
                    String it;
                    Iterable $this$none$iv = pathsToIgnore;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        return true;
                    }
                    Iterator iterator2 = $this$none$iv.iterator();
                    do {
                        if (!iterator2.hasNext()) return true;
                        Object element$iv2 = iterator2.next();
                        it = (String)element$iv2;
                        boolean bl3 = false;
                    } while (!StringsKt.contains$default((CharSequence)siPath, (CharSequence)it, (boolean)false, (int)2, null));
                    boolean bl4 = false;
                    if (bl4) {
                        return true;
                    }
                }
                bl = false;
            } while (!bl);
            return true;
        }

        public final boolean commitMessageIsCorrect$intellij_devkit(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            CharSequence charSequence = message;
            Regex regex = commitMessageRegex;
            return regex.matches(charSequence);
        }

        private final <T> T invokeAndWait(ModalityState modalityState, Function0<? extends T> computable) {
            AtomicReference ref = new AtomicReference();
            ApplicationManager.getApplication().invokeAndWait(new Runnable(ref, computable){
                final /* synthetic */ AtomicReference $ref;
                final /* synthetic */ Function0 $computable;

                public final void run() {
                    this.$ref.set(this.$computable.invoke());
                }
                {
                    this.$ref = atomicReference;
                    this.$computable = function0;
                }
            }, modalityState);
            return (T)ref.get();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

