/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Action;
import org.jetbrains.idea.devkit.dom.ActionOrGroup;
import org.jetbrains.idea.devkit.dom.Group;
import org.jetbrains.idea.devkit.dom.index.IdeaPluginRegistrationIndex;
import org.jetbrains.idea.devkit.util.DescriptorI18nUtil;

public class ActionOrGroupResolveConverter
extends ResolvingConverter<ActionOrGroup> {
    @NotNull
    public Collection<? extends ActionOrGroup> getVariants(ConvertContext context) {
        ArrayList variants = new ArrayList();
        HashSet processedVariants = new HashSet();
        ActionOrGroupResolveConverter.processScopes(context, (Processor<GlobalSearchScope>)((Processor)scope -> {
            IdeaPluginRegistrationIndex.processAllActionOrGroup(context.getProject(), scope, (Processor<? super ActionOrGroup>)((Processor)actionOrGroup -> {
                if (this.isRelevant((ActionOrGroup)actionOrGroup) && processedVariants.add(ActionOrGroupResolveConverter.getName(actionOrGroup))) {
                    variants.add(actionOrGroup);
                }
                return true;
            }));
            return true;
        }));
        ArrayList arrayList = variants;
        if (arrayList == null) {
            ActionOrGroupResolveConverter.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Nullable
    public PsiElement getPsiElement(@Nullable ActionOrGroup resolvedValue) {
        if (resolvedValue == null) {
            return null;
        }
        DomTarget target = DomTarget.getTarget((DomElement)resolvedValue);
        return target == null ? super.getPsiElement((Object)resolvedValue) : PomService.convertToPsi((PsiTarget)target);
    }

    @Nullable
    public ActionOrGroup fromString(@Nullable @NonNls String value, ConvertContext context) {
        if (StringUtil.isEmptyOrSpaces((String)value)) {
            return null;
        }
        Project project = context.getProject();
        Ref result = Ref.create();
        ActionOrGroupResolveConverter.processScopes(context, (Processor<GlobalSearchScope>)((Processor)scope -> IdeaPluginRegistrationIndex.processActionOrGroup(project, value, scope, (Processor<? super ActionOrGroup>)((Processor)actionOrGroup -> {
            if (this.isRelevant((ActionOrGroup)actionOrGroup)) {
                result.set(actionOrGroup);
                return false;
            }
            return true;
        }))));
        return (ActionOrGroup)result.get();
    }

    @Nullable
    public String toString(@Nullable ActionOrGroup actionGroup, ConvertContext context) {
        return actionGroup == null ? null : ActionOrGroupResolveConverter.getName(actionGroup);
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return DevKitBundle.message("plugin.xml.convert.action.or.group.cannot.resolve", this.getResultTypes(), s);
    }

    @Nullable
    public LookupElement createLookupElement(ActionOrGroup actionOrGroup) {
        PsiElement psiElement = this.getPsiElement(actionOrGroup);
        String name = StringUtil.notNullize((String)ActionOrGroupResolveConverter.getName(actionOrGroup), (String)DevKitBundle.message("plugin.xml.convert.action.or.group.invalid.name", new Object[0]));
        LookupElementBuilder builder = psiElement == null ? LookupElementBuilder.create((String)name) : LookupElementBuilder.create((Object)psiElement, (String)name);
        builder.putUserData(ActionOrGroupLookupRenderer.ACTION_OR_GROUP_KEY, (Object)actionOrGroup);
        return builder.withRenderer((LookupElementRenderer)ActionOrGroupLookupRenderer.INSTANCE);
    }

    protected boolean isRelevant(ActionOrGroup actionOrGroup) {
        return true;
    }

    @Nls
    protected String getResultTypes() {
        return DevKitBundle.message("plugin.xml.convert.action.or.group.type.action.or.group", new Object[0]);
    }

    private static void processScopes(ConvertContext context, Processor<GlobalSearchScope> processor) {
        Project project = context.getProject();
        Module module = context.getModule();
        if (module == null) {
            GlobalSearchScope projectScope = GlobalSearchScopesCore.projectProductionScope((Project)project).union((SearchScope)ProjectScope.getLibrariesScope((Project)project));
            processor.process((Object)projectScope);
            return;
        }
        ModuleUtilCore.visitMeAndDependentModules((Module)module, module1 -> processor.process((Object)module1.getModuleRuntimeScope(false)));
    }

    @Nullable
    private static String getName(@NotNull ActionOrGroup actionOrGroup) {
        if (actionOrGroup == null) {
            ActionOrGroupResolveConverter.$$$reportNull$$$0(1);
        }
        return actionOrGroup.getId().getStringValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/dom/impl/ActionOrGroupResolveConverter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionOrGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/dom/impl/ActionOrGroupResolveConverter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ActionOrGroupLookupRenderer
    extends LookupElementRenderer<LookupElement> {
        private static final ActionOrGroupLookupRenderer INSTANCE = new ActionOrGroupLookupRenderer();
        private static final Key<ActionOrGroup> ACTION_OR_GROUP_KEY = Key.create((String)"ACTION_OR_GROUP_KEY");

        private ActionOrGroupLookupRenderer() {
        }

        public void renderElement(LookupElement element, LookupElementPresentation presentation) {
            String description2;
            presentation.setItemText(element.getLookupString());
            ActionOrGroup actionOrGroup = (ActionOrGroup)element.getUserData(ACTION_OR_GROUP_KEY);
            assert (actionOrGroup != null);
            presentation.setItemTextUnderlined(actionOrGroup.getPopup().getValue() == Boolean.TRUE);
            presentation.setIcon(ElementPresentationManager.getIcon((Object)actionOrGroup));
            NullableLazyValue propertiesFile = NullableLazyValue.lazyNullable(() -> DescriptorI18nUtil.findBundlePropertiesFile(actionOrGroup));
            String text = ActionOrGroupLookupRenderer.getLocalizedText(actionOrGroup, ActionOrGroup.TextType.TEXT, (NullableLazyValue<PropertiesFile>)propertiesFile);
            if (StringUtil.isNotEmpty((String)text)) {
                String withoutMnemonic = StringUtil.replace((String)text, (String)"_", (String)"");
                presentation.setTailText(" \"" + withoutMnemonic + "\"", true);
            }
            if (StringUtil.isNotEmpty((String)(description2 = ActionOrGroupLookupRenderer.getLocalizedText(actionOrGroup, ActionOrGroup.TextType.DESCRIPTION, (NullableLazyValue<PropertiesFile>)propertiesFile)))) {
                presentation.setTypeText(description2);
            }
        }

        @Nullable
        private static String getLocalizedText(ActionOrGroup actionOrGroup, ActionOrGroup.TextType text, NullableLazyValue<PropertiesFile> propertiesFile) {
            String plain = text.getDomValue(actionOrGroup).getStringValue();
            if (StringUtil.isNotEmpty((String)plain)) {
                return plain;
            }
            PropertiesFile bundleFile = (PropertiesFile)propertiesFile.getValue();
            if (bundleFile == null) {
                return null;
            }
            Property property = (Property)ObjectUtils.tryCast((Object)bundleFile.findPropertyByKey(text.getMessageKey(actionOrGroup)), Property.class);
            return property != null ? property.getValue() : null;
        }
    }

    public static class OnlyGroups
    extends ActionOrGroupResolveConverter {
        @Override
        protected boolean isRelevant(ActionOrGroup actionOrGroup) {
            return actionOrGroup instanceof Group;
        }

        @Override
        protected String getResultTypes() {
            return DevKitBundle.message("plugin.xml.convert.action.or.group.type.group", new Object[0]);
        }
    }

    public static class OnlyActions
    extends ActionOrGroupResolveConverter {
        @Override
        protected boolean isRelevant(ActionOrGroup actionOrGroup) {
            return actionOrGroup instanceof Action;
        }

        @Override
        protected String getResultTypes() {
            return DevKitBundle.message("plugin.xml.convert.action.or.group.type.action", new Object[0]);
        }
    }
}

