/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInsight.references;

import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.jvm.JvmMethod;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public abstract class BaseJunitAnnotationReference
extends PsiReferenceBase<PsiLanguageInjectionHost> {
    public BaseJunitAnnotationReference(PsiLanguageInjectionHost element) {
        super((PsiElement)element, false);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            BaseJunitAnnotationReference.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiMethod) {
            return this.handleElementRename(((PsiMethod)element).getName());
        }
        return super.bindToElement(element);
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        String methodName;
        String className;
        if (newElementName == null) {
            BaseJunitAnnotationReference.$$$reportNull$$$0(1);
        }
        boolean selfClassReference = (className = StringUtil.getPackageName((String)(methodName = this.getValue()), (char)'#')).isEmpty() || ClassUtil.findPsiClass((PsiManager)((PsiLanguageInjectionHost)this.getElement()).getManager(), (String)className, null, (boolean)false, (GlobalSearchScope)((PsiLanguageInjectionHost)this.getElement()).getResolveScope()) == null;
        return super.handleElementRename((String)(selfClassReference ? newElementName : className + "#" + newElementName));
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        String className;
        UExpression myLiteral;
        if (element == null) {
            BaseJunitAnnotationReference.$$$reportNull$$$0(2);
        }
        if ((myLiteral = (UExpression)UastContextKt.toUElement((PsiElement)this.getElement(), UExpression.class)) == null) {
            return false;
        }
        UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)element, UMethod.class);
        if (uMethod == null) {
            return false;
        }
        PsiMethod method = uMethod.getJavaPsi();
        String methodName = (String)myLiteral.evaluate();
        if (methodName == null) {
            return false;
        }
        String shortName = StringUtil.getShortName((String)methodName, (char)'#');
        if (!shortName.equals(method.getName())) {
            return false;
        }
        PsiClass methodClass = method.getContainingClass();
        if (methodClass == null) {
            return false;
        }
        if (method.hasModifierProperty("static") && !(className = StringUtil.getPackageName((String)methodName, (char)'#')).isEmpty()) {
            return className.equals(ClassUtil.getJVMClassName((PsiClass)methodClass));
        }
        PsiClass psiClazz = null;
        UClass literalClazz = (UClass)UastUtils.getParentOfType((UElement)myLiteral, UClass.class);
        if (literalClazz != null) {
            psiClazz = literalClazz.getPsi();
        }
        if (psiClazz == null) {
            return false;
        }
        return InheritanceUtil.isInheritorOrSelf((PsiClass)psiClazz, (PsiClass)methodClass, (boolean)true) || InheritanceUtil.isInheritorOrSelf((PsiClass)methodClass, (PsiClass)psiClazz, (boolean)true);
    }

    @Nullable
    public PsiElement resolve() {
        PsiClass aClass;
        UExpression myLiteral = (UExpression)UastContextKt.toUElement((PsiElement)this.getElement(), UExpression.class);
        if (myLiteral == null) {
            return null;
        }
        PsiClass psiClazz = null;
        UClass literalClazz = (UClass)UastUtils.getParentOfType((UElement)myLiteral, UClass.class);
        if (literalClazz != null) {
            psiClazz = literalClazz.getPsi();
        }
        UMethod literalMethod = (UMethod)UastUtils.getParentOfType((UElement)myLiteral, UMethod.class);
        if (psiClazz == null) {
            return null;
        }
        String methodName = (String)myLiteral.evaluate();
        if (methodName == null) {
            return null;
        }
        String className = StringUtil.getPackageName((String)methodName, (char)'#');
        if (!className.isEmpty() && (aClass = ClassUtil.findPsiClass((PsiManager)psiClazz.getManager(), (String)className, null, (boolean)false, (GlobalSearchScope)psiClazz.getResolveScope())) != null) {
            psiClazz = aClass;
            methodName = StringUtil.getShortName((String)methodName, (char)'#');
        }
        String finalMethodName = methodName;
        PsiMethod[] clazzMethods = psiClazz.findMethodsByName(methodName, true);
        SmartList methodsInner = new SmartList();
        if (clazzMethods.length == 0) {
            PsiClass[] classes;
            for (PsiClass cl : classes = psiClazz.getInnerClasses()) {
                JvmMethod[] name = cl.findMethodsByName(finalMethodName);
                if (name.length <= 0) continue;
                methodsInner.addAll(Arrays.asList(name));
            }
            if (methodsInner.size() > 0) {
                clazzMethods = (PsiMethod[])methodsInner.stream().filter(jm -> jm instanceof PsiMethod).map(jm -> (PsiMethod)jm).toArray(PsiMethod[]::new);
            }
        }
        if (clazzMethods.length == 0 && (psiClazz.isInterface() || PsiUtil.isAbstractClass((PsiClass)psiClazz))) {
            PsiElementResolveResult neededMethod = (PsiElementResolveResult)ClassInheritorsSearch.search((PsiClass)psiClazz, (SearchScope)psiClazz.getResolveScope(), (boolean)false).mapping(aClazz -> {
                PsiMethod[] methods = aClazz.findMethodsByName(finalMethodName, false);
                return this.filteredMethod(methods, literalClazz, literalMethod);
            }).filtering(method -> method != null).mapping(method -> new PsiElementResolveResult((PsiElement)method)).findFirst();
            if (neededMethod == null) {
                return null;
            }
            return neededMethod.getElement();
        }
        return this.filteredMethod(clazzMethods, literalClazz, literalMethod);
    }

    @Nullable
    private PsiMethod filteredMethod(PsiMethod[] clazzMethods, UClass uClass, UMethod uMethod) {
        return Arrays.stream(clazzMethods).filter(method -> this.hasNoStaticProblem((PsiMethod)method, uClass, uMethod)).findFirst().orElse(clazzMethods.length == 0 ? null : clazzMethods[0]);
    }

    public Object @NotNull [] getVariants() {
        UExpression myLiteral = (UExpression)UastContextKt.toUElement((PsiElement)this.getElement(), UExpression.class);
        ArrayList<LookupElement> list = new ArrayList<LookupElement>();
        if (myLiteral == null) {
            Object[] objectArray = list.toArray();
            if (objectArray == null) {
                BaseJunitAnnotationReference.$$$reportNull$$$0(3);
            }
            return objectArray;
        }
        UClass topLevelClass = (UClass)UastUtils.getParentOfType((UElement)myLiteral, UClass.class);
        if (topLevelClass != null) {
            PsiMethod[] methods;
            UMethod current = (UMethod)UastUtils.getParentOfType((UElement)myLiteral, UMethod.class);
            PsiClass psiTopLevelClass = topLevelClass.getJavaPsi();
            for (PsiMethod method : methods = psiTopLevelClass.getAllMethods()) {
                PsiClass aClass = method.getContainingClass();
                if (aClass == null || "java.lang.Object".equals(aClass.getQualifiedName()) || current != null && method.getName().equals(current.getName()) || current != null && !this.hasNoStaticProblem(method, topLevelClass, current)) continue;
                LookupElementBuilder builder = LookupElementBuilder.create((PsiNamedElement)method);
                list.add(builder.withAutoCompletionPolicy(AutoCompletionPolicy.SETTINGS_DEPENDENT));
            }
        }
        Object[] objectArray = list.toArray();
        if (objectArray == null) {
            BaseJunitAnnotationReference.$$$reportNull$$$0(4);
        }
        return objectArray;
    }

    protected abstract boolean hasNoStaticProblem(@NotNull PsiMethod var1, @NotNull UClass var2, @Nullable UMethod var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/junit/codeInsight/references/BaseJunitAnnotationReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/junit/codeInsight/references/BaseJunitAnnotationReference";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

