/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.build.events.MessageEvent;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.importing.ProjectResolverPolicy;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.service.project.PerformanceTrace;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemSyncActionsCollector;
import com.intellij.openapi.externalSystem.statistics.Phase;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemDebugEnvironment;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.gradle.api.ProjectConfigurationException;
import org.gradle.tooling.BuildActionFailureException;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.BuildModel;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.target.TargetBuildLauncher;
import org.jetbrains.plugins.gradle.issue.DeprecatedGradleVersionIssue;
import org.jetbrains.plugins.gradle.model.Build;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.DefaultExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalProjectPreview;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.ModelsHolder;
import org.jetbrains.plugins.gradle.model.Project;
import org.jetbrains.plugins.gradle.model.ProjectImportAction;
import org.jetbrains.plugins.gradle.model.ProjectImportActionWithCustomSerializer;
import org.jetbrains.plugins.gradle.model.ProjectImportModelProvider;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.model.data.CompositeBuildData;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.remote.impl.GradleLibraryNamesMixer;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.BaseProjectImportErrorHandler;
import org.jetbrains.plugins.gradle.service.project.BaseResolverExtension;
import org.jetbrains.plugins.gradle.service.project.BuildActionRunner;
import org.jetbrains.plugins.gradle.service.project.DefaultProjectResolverContext;
import org.jetbrains.plugins.gradle.service.project.GradleBuildSrcProjectsResolver;
import org.jetbrains.plugins.gradle.service.project.GradleImportCustomizer;
import org.jetbrains.plugins.gradle.service.project.GradlePartialResolverPolicy;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.GradleTargetPathsConverter;
import org.jetbrains.plugins.gradle.service.project.LibraryDataNodeSubstitutor;
import org.jetbrains.plugins.gradle.service.project.ModifiableGradleProjectModelImpl;
import org.jetbrains.plugins.gradle.service.project.ProjectModelContributor;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.service.project.ToolingModelsProviderImpl;
import org.jetbrains.plugins.gradle.service.project.TracedProjectResolverExtension;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleBuildParticipant;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleProjectResolver
implements ExternalSystemProjectResolver<GradleExecutionSettings> {
    private static final Logger LOG = Logger.getInstance(GradleProjectResolver.class);
    @NotNull
    private final GradleExecutionHelper myHelper;
    private final GradleLibraryNamesMixer myLibraryNamesMixer;
    private final MultiMap<ExternalSystemTaskId, CancellationTokenSource> myCancellationMap;
    public static final Key<Map<String, Pair<DataNode<GradleSourceSetData>, ExternalSourceSet>>> RESOLVED_SOURCE_SETS = Key.create((String)"resolvedSourceSets");
    public static final Key<Map<String, Pair<String, ExternalSystemSourceType>>> MODULES_OUTPUTS = Key.create((String)"moduleOutputsMap");
    public static final Key<MultiMap<ExternalSystemSourceType, String>> GRADLE_OUTPUTS = Key.create((String)"gradleOutputs");
    public static final Key<Map<String, String>> CONFIGURATION_ARTIFACTS = Key.create((String)"gradleArtifactsMap");
    private static final Key<File> GRADLE_HOME_DIR = Key.create((String)"gradleHomeDir");

    public GradleProjectResolver() {
        this(new GradleExecutionHelper());
    }

    public GradleProjectResolver(@NotNull GradleExecutionHelper helper) {
        if (helper == null) {
            GradleProjectResolver.$$$reportNull$$$0(0);
        }
        this.myLibraryNamesMixer = new GradleLibraryNamesMixer();
        this.myCancellationMap = MultiMap.createConcurrent();
        this.myHelper = helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DataNode<ProjectData> resolveProjectInfo(@NotNull ExternalSystemTaskId syncTaskId, @NotNull String projectPath, boolean isPreviewMode, @Nullable GradleExecutionSettings settings2, @Nullable ProjectResolverPolicy resolverPolicy, @NotNull ExternalSystemTaskNotificationListener listener2) throws ExternalSystemException, IllegalArgumentException, IllegalStateException {
        if (syncTaskId == null) {
            GradleProjectResolver.$$$reportNull$$$0(1);
        }
        if (projectPath == null) {
            GradleProjectResolver.$$$reportNull$$$0(2);
        }
        if (listener2 == null) {
            GradleProjectResolver.$$$reportNull$$$0(3);
        }
        GradlePartialResolverPolicy gradleResolverPolicy = null;
        if (resolverPolicy != null) {
            if (resolverPolicy instanceof GradlePartialResolverPolicy) {
                gradleResolverPolicy = (GradlePartialResolverPolicy)resolverPolicy;
            } else {
                throw new ExternalSystemException("Unsupported project resolver policy: " + resolverPolicy.getClass().getName());
            }
        }
        if (isPreviewMode) {
            String projectName = new File(projectPath).getName();
            ProjectData projectData = new ProjectData(GradleConstants.SYSTEM_ID, projectName, projectPath, projectPath);
            DataNode projectDataNode = new DataNode(ProjectKeys.PROJECT, (Object)projectData, null);
            String ideProjectPath = settings2 == null ? null : settings2.getIdeProjectPath();
            String mainModuleFileDirectoryPath = ideProjectPath == null ? projectPath : ideProjectPath;
            projectDataNode.createChild(ProjectKeys.MODULE, (Object)new ModuleData(projectName, GradleConstants.SYSTEM_ID, GradleProjectResolverUtil.getDefaultModuleTypeId(), projectName, mainModuleFileDirectoryPath, projectPath)).createChild(ProjectKeys.CONTENT_ROOT, (Object)new ContentRootData(GradleConstants.SYSTEM_ID, projectPath));
            return projectDataNode;
        }
        DefaultProjectResolverContext resolverContext = new DefaultProjectResolverContext(syncTaskId, projectPath, settings2, listener2, gradleResolverPolicy, false);
        CancellationTokenSource cancellationTokenSource = resolverContext.getCancellationTokenSource();
        this.myCancellationMap.putValue((Object)resolverContext.getExternalSystemTaskId(), (Object)cancellationTokenSource);
        long activityId = resolverContext.getExternalSystemTaskId().getId();
        ExternalSystemSyncActionsCollector.logSyncStarted(null, (long)activityId);
        try {
            if (settings2 != null) {
                this.myHelper.ensureInstalledWrapper(syncTaskId, projectPath, settings2, listener2, cancellationTokenSource.token());
            }
            Predicate<GradleProjectResolverExtension> extensionsFilter = gradleResolverPolicy != null ? gradleResolverPolicy.getExtensionsFilter() : null;
            GradleProjectResolverExtension projectResolverChain = GradleProjectResolver.createProjectResolverChain(resolverContext, extensionsFilter);
            DataNode<ProjectData> projectDataNode = this.myHelper.execute(projectPath, settings2, syncTaskId, listener2, cancellationTokenSource, this.getProjectDataFunction(resolverContext, projectResolverChain, false));
            File gradleUserHome2 = (File)resolverContext.getUserData(GRADLE_HOME_DIR);
            new GradleBuildSrcProjectsResolver(this, resolverContext, gradleUserHome2, settings2, listener2, syncTaskId, projectResolverChain).discoverAndAppendTo(projectDataNode);
            DataNode<ProjectData> dataNode = projectDataNode;
            return dataNode;
        }
        finally {
            this.myCancellationMap.remove((Object)resolverContext.getExternalSystemTaskId(), (Object)cancellationTokenSource);
        }
    }

    @NotNull
    Function<ProjectConnection, DataNode<ProjectData>> getProjectDataFunction(DefaultProjectResolverContext resolverContext, GradleProjectResolverExtension projectResolverChain, boolean isBuildSrcProject) {
        return new ProjectConnectionDataNodeFunction(resolverContext, projectResolverChain, isBuildSrcProject);
    }

    @NotNull
    GradleExecutionHelper getHelper() {
        GradleExecutionHelper gradleExecutionHelper = this.myHelper;
        if (gradleExecutionHelper == null) {
            GradleProjectResolver.$$$reportNull$$$0(4);
        }
        return gradleExecutionHelper;
    }

    public boolean cancelTask(@NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener2) {
        if (id == null) {
            GradleProjectResolver.$$$reportNull$$$0(5);
        }
        if (listener2 == null) {
            GradleProjectResolver.$$$reportNull$$$0(6);
        }
        for (CancellationTokenSource cancellationTokenSource : this.myCancellationMap.get((Object)id)) {
            cancellationTokenSource.cancel();
        }
        return true;
    }

    /*
     * Loose catch block
     */
    @NotNull
    private DataNode<ProjectData> doResolveProjectInfo(@NotNull DefaultProjectResolverContext resolverCtx, @NotNull GradleProjectResolverExtension projectResolverChain, boolean isBuildSrcProject) throws IllegalArgumentException, IllegalStateException {
        ProjectImportAction.AllModels allModels;
        if (resolverCtx == null) {
            GradleProjectResolver.$$$reportNull$$$0(7);
        }
        if (projectResolverChain == null) {
            GradleProjectResolver.$$$reportNull$$$0(8);
        }
        long activityId = resolverCtx.getExternalSystemTaskId().getId();
        PerformanceTrace performanceTrace = new PerformanceTrace();
        performanceTrace.setId(activityId);
        TracedProjectResolverExtension tracedResolverChain = new TracedProjectResolverExtension(projectResolverChain, performanceTrace);
        BuildEnvironment buildEnvironment = GradleExecutionHelper.getBuildEnvironment(resolverCtx);
        GradleVersion gradleVersion2 = null;
        boolean useCustomSerialization = Registry.is((String)"gradle.tooling.custom.serializer", (boolean)true);
        boolean isCompositeBuildsSupported = false;
        if (buildEnvironment != null) {
            gradleVersion2 = GradleVersion.version((String)buildEnvironment.getGradle().getGradleVersion());
            isCompositeBuildsSupported = gradleVersion2.compareTo(GradleVersion.version((String)"3.1")) >= 0;
            resolverCtx.setBuildEnvironment(buildEnvironment);
            if (!GradleProjectResolver.isCustomSerializationSupported(resolverCtx, gradleVersion2, isCompositeBuildsSupported)) {
                useCustomSerialization = false;
            }
        }
        ProjectImportActionWithCustomSerializer projectImportAction = useCustomSerialization ? new ProjectImportActionWithCustomSerializer(resolverCtx.isPreviewMode(), isCompositeBuildsSupported) : new ProjectImportAction(resolverCtx.isPreviewMode(), isCompositeBuildsSupported);
        boolean useParallelModelsFetch = Registry.is((String)"gradle.tooling.models.parallel.fetch", (boolean)false);
        projectImportAction.setParallelModelsFetch(useParallelModelsFetch);
        GradleExecutionSettings executionSettings = resolverCtx.getSettings();
        if (executionSettings == null) {
            executionSettings = new GradleExecutionSettings(null, null, DistributionType.BUNDLED, false);
        }
        GradleProjectResolver.configureExecutionArgumentsAndVmOptions(executionSettings, resolverCtx, isBuildSrcProject);
        HashSet toolingExtensionClasses = new HashSet();
        for (GradleProjectResolverExtension resolverExtension = tracedResolverChain; resolverExtension != null; resolverExtension = resolverExtension.getNext()) {
            resolverExtension.setProjectResolverContext(resolverCtx);
            resolverExtension.preImportCheck();
            projectImportAction.addTargetTypes(resolverExtension.getTargetTypes());
            try {
                ProjectImportModelProvider projectsLoadedModelProvider;
                ProjectImportModelProvider modelProvider = resolverExtension.getModelProvider();
                if (modelProvider != null) {
                    projectImportAction.addProjectImportModelProvider(modelProvider);
                }
                if ((projectsLoadedModelProvider = resolverExtension.getProjectsLoadedModelProvider()) != null) {
                    projectImportAction.addProjectImportModelProvider(projectsLoadedModelProvider, true);
                }
            }
            catch (Throwable t) {
                LOG.warn(t);
            }
            try {
                toolingExtensionClasses.addAll(resolverExtension.getToolingExtensionsClasses());
                continue;
            }
            catch (Throwable t) {
                LOG.warn(t);
            }
        }
        GradleExecutionHelper.attachTargetPathMapperInitScript(executionSettings);
        File initScript = GradleExecutionHelper.generateInitScript(isBuildSrcProject, toolingExtensionClasses);
        if (initScript != null) {
            executionSettings.withArguments(new String[]{"--init-script", initScript.getAbsolutePath()});
        }
        BuildActionRunner buildActionRunner = new BuildActionRunner(resolverCtx, (ProjectImportAction)projectImportAction, executionSettings, this.myHelper);
        resolverCtx.checkCancelled();
        long startTime = System.currentTimeMillis();
        Activity activity = StartUpMeasurer.startActivity((String)"project data obtaining", (ActivityCategory)ActivityCategory.GRADLE_IMPORT);
        ExternalSystemSyncActionsCollector.logPhaseStarted(null, (long)activityId, (Phase)Phase.GRADLE_CALL);
        int errorsCount = 0;
        CountDownLatch buildFinishWaiter = new CountDownLatch(1);
        try {
            allModels = buildActionRunner.fetchModels(models -> {
                for (GradleProjectResolverExtension resolver = tracedResolverChain; resolver != null; resolver = resolver.getNext()) {
                    resolver.projectsLoaded((ModelsHolder<BuildModel, ProjectModel>)models);
                }
            }, exception -> {
                try {
                    for (GradleProjectResolverExtension resolver = tracedResolverChain; resolver != null; resolver = resolver.getNext()) {
                        resolver.buildFinished((GradleConnectionException)((Object)((Object)((Object)((Object)exception)))));
                    }
                }
                finally {
                    buildFinishWaiter.countDown();
                }
            });
            if (gradleVersion2 != null && DeprecatedGradleVersionIssue.isDeprecated(gradleVersion2)) {
                resolverCtx.report(MessageEvent.Kind.WARNING, new DeprecatedGradleVersionIssue(gradleVersion2, resolverCtx.getProjectPath()));
            }
            performanceTrace.addTrace(allModels.getPerformanceTrace());
        }
        catch (Throwable t) {
            try {
                buildFinishWaiter.countDown();
                ++errorsCount;
                throw t;
            }
            catch (Throwable throwable) {
                ProgressIndicatorUtils.awaitWithCheckCanceled((CountDownLatch)buildFinishWaiter);
                activity.end();
                long timeInMs = System.currentTimeMillis() - startTime;
                performanceTrace.logPerformance("Gradle data obtained", timeInMs);
                ExternalSystemSyncActionsCollector.logPhaseFinished(null, (long)activityId, (Phase)Phase.GRADLE_CALL, (long)timeInMs, (int)errorsCount);
                LOG.debug(String.format("Gradle data obtained in %d ms", timeInMs));
                throw throwable;
            }
        }
        ProgressIndicatorUtils.awaitWithCheckCanceled((CountDownLatch)buildFinishWaiter);
        activity.end();
        long timeInMs = System.currentTimeMillis() - startTime;
        performanceTrace.logPerformance("Gradle data obtained", timeInMs);
        ExternalSystemSyncActionsCollector.logPhaseFinished(null, (long)activityId, (Phase)Phase.GRADLE_CALL, (long)timeInMs, (int)errorsCount);
        LOG.debug(String.format("Gradle data obtained in %d ms", timeInMs));
        resolverCtx.checkCancelled();
        if (useCustomSerialization) {
            assert (gradleVersion2 != null);
            allModels.initToolingSerializer();
        }
        allModels.setBuildEnvironment(buildEnvironment);
        long startDataConversionTime = System.currentTimeMillis();
        int resolversErrorsCount = 0;
        GradleTargetPathsConverter pathsConverter = new GradleTargetPathsConverter(executionSettings);
        pathsConverter.mayBeApplyTo(allModels);
        DataNode<ProjectData> dataNode = this.convertData(allModels, executionSettings, resolverCtx, gradleVersion2, tracedResolverChain, performanceTrace, isBuildSrcProject, useCustomSerialization);
        pathsConverter.close();
        long timeConversionInMs = System.currentTimeMillis() - startDataConversionTime;
        performanceTrace.logPerformance("Gradle project data processed", timeConversionInMs);
        LOG.debug(String.format("Project data resolved in %d ms", timeConversionInMs));
        ExternalSystemSyncActionsCollector.logPhaseFinished(null, (long)activityId, (Phase)Phase.PROJECT_RESOLVERS, (long)timeConversionInMs, (int)resolversErrorsCount);
        DataNode<ProjectData> dataNode2 = dataNode;
        if (dataNode2 == null) {
            GradleProjectResolver.$$$reportNull$$$0(9);
        }
        return dataNode2;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            pathsConverter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        ++resolversErrorsCount;
                        throw t;
                    }
                }
                catch (Throwable throwable3) {
                    long timeConversionInMs2 = System.currentTimeMillis() - startDataConversionTime;
                    performanceTrace.logPerformance("Gradle project data processed", timeConversionInMs2);
                    LOG.debug(String.format("Project data resolved in %d ms", timeConversionInMs2));
                    ExternalSystemSyncActionsCollector.logPhaseFinished(null, (long)activityId, (Phase)Phase.PROJECT_RESOLVERS, (long)timeConversionInMs2, (int)resolversErrorsCount);
                    throw throwable3;
                }
            }
        }
    }

    @NotNull
    private DataNode<ProjectData> convertData(@NotNull ProjectImportAction.AllModels allModels, @NotNull GradleExecutionSettings executionSettings, @NotNull DefaultProjectResolverContext resolverCtx, @Nullable GradleVersion gradleVersion2, @NotNull GradleProjectResolverExtension tracedResolverChain, @NotNull PerformanceTrace performanceTrace, boolean isBuildSrcProject, boolean useCustomSerialization) {
        IdeaModule ideaModule;
        DataNode moduleDataNode;
        if (allModels == null) {
            GradleProjectResolver.$$$reportNull$$$0(10);
        }
        if (executionSettings == null) {
            GradleProjectResolver.$$$reportNull$$$0(11);
        }
        if (resolverCtx == null) {
            GradleProjectResolver.$$$reportNull$$$0(12);
        }
        if (tracedResolverChain == null) {
            GradleProjectResolver.$$$reportNull$$$0(13);
        }
        if (performanceTrace == null) {
            GradleProjectResolver.$$$reportNull$$$0(14);
        }
        Activity activity = StartUpMeasurer.startActivity((String)"project data converting", (ActivityCategory)ActivityCategory.GRADLE_IMPORT);
        long activityId = resolverCtx.getExternalSystemTaskId().getId();
        ExternalSystemSyncActionsCollector.logPhaseStarted(null, (long)activityId, (Phase)Phase.PROJECT_RESOLVERS);
        GradleProjectResolver.extractExternalProjectModels(allModels, resolverCtx, useCustomSerialization);
        String projectName = allModels.getMainBuild().getName();
        ModifiableGradleProjectModelImpl modifiableGradleProjectModel = new ModifiableGradleProjectModelImpl(projectName, resolverCtx.getProjectPath());
        ToolingModelsProviderImpl modelsProvider = new ToolingModelsProviderImpl(allModels);
        ProjectModelContributor.EP_NAME.forEachExtensionSafe(extension -> {
            resolverCtx.checkCancelled();
            long starResolveTime = System.currentTimeMillis();
            extension.accept(modifiableGradleProjectModel, modelsProvider, resolverCtx);
            long resolveTimeInMs = System.currentTimeMillis() - starResolveTime;
            performanceTrace.logPerformance("Project model contributed by " + extension.getClass().getSimpleName(), resolveTimeInMs);
            LOG.debug(String.format("Project model contributed by `" + extension.getClass().getSimpleName() + "` in %d ms", resolveTimeInMs));
        });
        DataNode<ProjectData> projectDataNode = modifiableGradleProjectModel.buildDataNodeGraph();
        DataNode performanceTraceNode = new DataNode(PerformanceTrace.TRACE_NODE_KEY, (Object)performanceTrace, projectDataNode);
        projectDataNode.addChild(performanceTraceNode);
        DomainObjectSet gradleModules = Collections.emptySet();
        IdeaProject ideaProject = (IdeaProject)allModels.getModel(IdeaProject.class);
        if (ideaProject != null) {
            tracedResolverChain.populateProjectExtraModels(ideaProject, projectDataNode);
            gradleModules = ideaProject.getModules();
            if (gradleModules == null || gradleModules.isEmpty()) {
                throw new IllegalStateException("No modules found for the target project: " + ideaProject);
            }
        }
        Collection<IdeaModule> includedModules = GradleProjectResolver.exposeCompositeBuild(allModels, resolverCtx, projectDataNode);
        HashMap<String, Pair<DataNode<ModuleData>, IdeaModule>> moduleMap = new HashMap<String, Pair<DataNode<ModuleData>, IdeaModule>>();
        HashMap sourceSetsMap = new HashMap();
        projectDataNode.putUserData(RESOLVED_SOURCE_SETS, sourceSetsMap);
        Map moduleOutputsMap = CollectionFactory.createFilePathMap();
        projectDataNode.putUserData(MODULES_OUTPUTS, (Object)moduleOutputsMap);
        Map artifactsMap = CollectionFactory.createFilePathMap();
        projectDataNode.putUserData(CONFIGURATION_ARTIFACTS, (Object)artifactsMap);
        for (Object gradleModule : ContainerUtil.concat((Iterable)gradleModules, includedModules)) {
            String moduleName;
            if (gradleModule == null) continue;
            resolverCtx.checkCancelled();
            if (ExternalSystemDebugEnvironment.DEBUG_ORPHAN_MODULES_PROCESSING) {
                LOG.info(String.format("Importing module data: %s", gradleModule));
            }
            if ((moduleName = gradleModule.getName()) == null) {
                throw new IllegalStateException("Module with undefined name detected: " + (IdeaModule)gradleModule);
            }
            moduleDataNode = tracedResolverChain.createModule((IdeaModule)gradleModule, projectDataNode);
            if (moduleDataNode == null) continue;
            String mainModuleId = GradleProjectResolverUtil.getModuleId(resolverCtx, (IdeaModule)gradleModule);
            if (moduleMap.containsKey(mainModuleId)) {
                throw new IllegalStateException("Duplicate modules names detected: " + (IdeaModule)gradleModule);
            }
            moduleMap.put(mainModuleId, (Pair<DataNode<ModuleData>, IdeaModule>)Pair.create((Object)moduleDataNode, (Object)gradleModule));
        }
        executionSettings.getExecutionWorkspace().setModuleIdIndex(moduleMap);
        File gradleHomeDir = null;
        for (Pair pair : moduleMap.values()) {
            BuildScriptClasspathModel buildScriptClasspathModel;
            moduleDataNode = (DataNode)pair.first;
            ideaModule = (IdeaModule)pair.second;
            if (gradleHomeDir == null && (buildScriptClasspathModel = resolverCtx.getExtraProject(ideaModule, BuildScriptClasspathModel.class)) != null) {
                gradleHomeDir = buildScriptClasspathModel.getGradleHomeDir();
            }
            tracedResolverChain.populateModuleContentRoots(ideaModule, (DataNode<ModuleData>)moduleDataNode);
            tracedResolverChain.populateModuleCompileOutputSettings(ideaModule, (DataNode<ModuleData>)moduleDataNode);
            if (!isBuildSrcProject) {
                tracedResolverChain.populateModuleTasks(ideaModule, (DataNode<ModuleData>)moduleDataNode, projectDataNode);
            }
            SmartList modules = new SmartList();
            modules.add(moduleDataNode);
            modules.addAll(ExternalSystemApiUtil.findAll((DataNode)moduleDataNode, GradleSourceSetData.KEY));
            ExternalSystemSourceType[] sourceTypes = new ExternalSystemSourceType[]{ExternalSystemSourceType.SOURCE, ExternalSystemSourceType.RESOURCE, ExternalSystemSourceType.TEST, ExternalSystemSourceType.TEST_RESOURCE};
            for (DataNode module : modules) {
                ModuleData moduleData = (ModuleData)module.getData();
                for (ExternalSystemSourceType sourceType : sourceTypes) {
                    String path = moduleData.getCompileOutputPath(sourceType);
                    if (path == null) continue;
                    moduleOutputsMap.put(path, Pair.create((Object)moduleData.getId(), (Object)sourceType));
                }
                if (!(moduleData instanceof GradleSourceSetData)) continue;
                for (File artifactFile : moduleData.getArtifacts()) {
                    artifactsMap.put(ExternalSystemApiUtil.toCanonicalPath((String)artifactFile.getPath()), moduleData.getId());
                }
            }
        }
        if (gradleHomeDir == null && executionSettings.getGradleHome() != null) {
            gradleHomeDir = new File(executionSettings.getGradleHome());
        }
        resolverCtx.putUserData(GRADLE_HOME_DIR, gradleHomeDir);
        for (Pair pair : moduleMap.values()) {
            moduleDataNode = (DataNode)pair.first;
            ideaModule = (IdeaModule)pair.second;
            tracedResolverChain.populateModuleDependencies(ideaModule, (DataNode<ModuleData>)moduleDataNode, projectDataNode);
            tracedResolverChain.populateModuleExtraModels(ideaModule, (DataNode<ModuleData>)moduleDataNode);
        }
        GradleProjectResolver.mergeSourceSetContentRoots(moduleMap, resolverCtx);
        if (resolverCtx.isResolveModulePerSourceSet()) {
            GradleProjectResolver.mergeLibraryAndModuleDependencyData(resolverCtx, projectDataNode, resolverCtx.getGradleUserHome(), gradleHomeDir, gradleVersion2);
        }
        for (GradleProjectResolverExtension resolver = tracedResolverChain; resolver != null; resolver = resolver.getNext()) {
            resolver.resolveFinished(projectDataNode);
        }
        projectDataNode.putUserData(RESOLVED_SOURCE_SETS, null);
        projectDataNode.putUserData(MODULES_OUTPUTS, null);
        projectDataNode.putUserData(CONFIGURATION_ARTIFACTS, null);
        Collection libraries = ExternalSystemApiUtil.getChildren(projectDataNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.LIBRARY);
        this.myLibraryNamesMixer.mixNames(libraries);
        activity.end();
        DataNode<ProjectData> dataNode = projectDataNode;
        if (dataNode == null) {
            GradleProjectResolver.$$$reportNull$$$0(15);
        }
        return dataNode;
    }

    private static boolean isCustomSerializationSupported(@NotNull DefaultProjectResolverContext resolverCtx, GradleVersion gradleVersion2, boolean isCompositeBuildsSupported) {
        if (resolverCtx == null) {
            GradleProjectResolver.$$$reportNull$$$0(16);
        }
        return isCompositeBuildsSupported || resolverCtx.getConnection().newBuild() instanceof TargetBuildLauncher || gradleVersion2.getBaseVersion().compareTo(GradleVersion.version((String)"3.0")) >= 0;
    }

    private static void configureExecutionArgumentsAndVmOptions(@NotNull GradleExecutionSettings executionSettings, @NotNull DefaultProjectResolverContext resolverCtx, boolean isBuildSrcProject) {
        if (executionSettings == null) {
            GradleProjectResolver.$$$reportNull$$$0(17);
        }
        if (resolverCtx == null) {
            GradleProjectResolver.$$$reportNull$$$0(18);
        }
        executionSettings.withArgument("-Didea.sync.active=true");
        if (resolverCtx.isResolveModulePerSourceSet()) {
            executionSettings.withArgument("-Didea.resolveSourceSetDependencies=true");
        }
        if (!isBuildSrcProject) {
            for (GradleBuildParticipant buildParticipant : executionSettings.getExecutionWorkspace().getBuildParticipants()) {
                executionSettings.withArguments(new String[]{"--include-build", buildParticipant.getProjectPath()});
            }
        }
        GradleImportCustomizer importCustomizer = GradleImportCustomizer.get();
        GradleProjectResolverUtil.createProjectResolvers(resolverCtx).forEachOrdered(extension -> {
            if (importCustomizer == null || importCustomizer.useExtraJvmArgs()) {
                ParametersList parametersList = new ParametersList();
                for (Pair<String, String> jvmArg : extension.getExtraJvmArgs()) {
                    parametersList.addProperty((String)jvmArg.first, (String)jvmArg.second);
                }
                executionSettings.withVmOptions(parametersList.getParameters());
            }
            executionSettings.withArguments(extension.getExtraCommandLineArgs());
        });
    }

    @NotNull
    private static Collection<IdeaModule> exposeCompositeBuild(ProjectImportAction.AllModels allModels, DefaultProjectResolverContext resolverCtx, DataNode<ProjectData> projectDataNode) {
        if (resolverCtx.getSettings() != null && !resolverCtx.getSettings().getExecutionWorkspace().getBuildParticipants().isEmpty()) {
            List<IdeaModule> list2 = Collections.emptyList();
            if (list2 == null) {
                GradleProjectResolver.$$$reportNull$$$0(19);
            }
            return list2;
        }
        SmartList gradleIncludedModules = new SmartList();
        List includedBuilds = allModels.getIncludedBuilds();
        if (!includedBuilds.isEmpty()) {
            ProjectData projectData = (ProjectData)projectDataNode.getData();
            CompositeBuildData compositeBuildData = new CompositeBuildData(projectData.getLinkedExternalProjectPath());
            for (Build build : includedBuilds) {
                if (build.getProjects().isEmpty()) continue;
                IdeaProject ideaProject = (IdeaProject)allModels.getModel((BuildModel)build, IdeaProject.class);
                if (ideaProject != null) {
                    gradleIncludedModules.addAll(ideaProject.getModules());
                }
                String rootProjectName = build.getName();
                BuildParticipant buildParticipant = new BuildParticipant();
                String projectPath = ExternalSystemApiUtil.toCanonicalPath((String)build.getBuildIdentifier().getRootDir().getPath());
                buildParticipant.setRootProjectName(rootProjectName);
                buildParticipant.setRootPath(projectPath);
                if (ideaProject != null) {
                    for (IdeaModule module : ideaProject.getModules()) {
                        String modulePath = ExternalSystemApiUtil.toCanonicalPath((String)module.getGradleProject().getProjectDirectory().getPath());
                        buildParticipant.getProjects().add(modulePath);
                    }
                }
                compositeBuildData.getCompositeParticipants().add(buildParticipant);
            }
            projectDataNode.createChild(CompositeBuildData.KEY, (Object)compositeBuildData);
        }
        SmartList smartList = gradleIncludedModules;
        if (smartList == null) {
            GradleProjectResolver.$$$reportNull$$$0(20);
        }
        return smartList;
    }

    private static void mergeLibraryAndModuleDependencyData(@NotNull ProjectResolverContext context, @NotNull DataNode<ProjectData> projectDataNode, @NotNull File gradleUserHomeDir, @Nullable File gradleHomeDir, @Nullable GradleVersion gradleVersion2) {
        if (context == null) {
            GradleProjectResolver.$$$reportNull$$$0(21);
        }
        if (projectDataNode == null) {
            GradleProjectResolver.$$$reportNull$$$0(22);
        }
        if (gradleUserHomeDir == null) {
            GradleProjectResolver.$$$reportNull$$$0(23);
        }
        Map sourceSetMap = (Map)projectDataNode.getUserData(RESOLVED_SOURCE_SETS);
        assert (sourceSetMap != null);
        Map moduleOutputsMap = (Map)projectDataNode.getUserData(MODULES_OUTPUTS);
        assert (moduleOutputsMap != null);
        Map artifactsMap = (Map)projectDataNode.getUserData(CONFIGURATION_ARTIFACTS);
        assert (artifactsMap != null);
        Collection libraryDependencies = ExternalSystemApiUtil.findAllRecursively(projectDataNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.LIBRARY_DEPENDENCY);
        LibraryDataNodeSubstitutor librarySubstitutor = new LibraryDataNodeSubstitutor(context, gradleUserHomeDir, gradleHomeDir, gradleVersion2, sourceSetMap, moduleOutputsMap, artifactsMap);
        for (DataNode libraryDependencyDataNode : libraryDependencies) {
            librarySubstitutor.run((DataNode<LibraryDependencyData>)libraryDependencyDataNode);
        }
    }

    private static void extractExternalProjectModels(@NotNull ProjectImportAction.AllModels models, @NotNull ProjectResolverContext resolverCtx, boolean useCustomSerialization) {
        if (models == null) {
            GradleProjectResolver.$$$reportNull$$$0(24);
        }
        if (resolverCtx == null) {
            GradleProjectResolver.$$$reportNull$$$0(25);
        }
        resolverCtx.setModels(models);
        Class modelClazz = resolverCtx.isPreviewMode() ? ExternalProjectPreview.class : ExternalProject.class;
        ExternalProject externalRootProject = (ExternalProject)models.getModel(modelClazz);
        if (externalRootProject == null) {
            return;
        }
        DefaultExternalProject wrappedExternalRootProject = useCustomSerialization ? (DefaultExternalProject)externalRootProject : new DefaultExternalProject(externalRootProject);
        models.addModel((Object)wrappedExternalRootProject, ExternalProject.class);
        Map<String, DefaultExternalProject> externalProjectsMap = GradleProjectResolver.createExternalProjectsMap(wrappedExternalRootProject);
        Collection projects2 = models.getMainBuild().getProjects();
        for (Project project : projects2) {
            ExternalProject externalProject = (ExternalProject)externalProjectsMap.get(project.getProjectIdentifier().getProjectPath());
            if (externalProject == null) continue;
            models.addModel((Object)externalProject, ExternalProject.class, (ProjectModel)project);
        }
        for (Build includedBuild : models.getIncludedBuilds()) {
            ExternalProject externalIncludedRootProject = (ExternalProject)models.getModel((BuildModel)includedBuild, modelClazz);
            if (externalIncludedRootProject == null) continue;
            DefaultExternalProject wrappedExternalIncludedRootProject = useCustomSerialization ? (DefaultExternalProject)externalIncludedRootProject : new DefaultExternalProject(externalIncludedRootProject);
            wrappedExternalRootProject.getChildProjects().put(wrappedExternalIncludedRootProject.getName(), wrappedExternalIncludedRootProject);
            Map<String, DefaultExternalProject> externalIncludedProjectsMap = GradleProjectResolver.createExternalProjectsMap(wrappedExternalIncludedRootProject);
            for (ProjectModel project : includedBuild.getProjects()) {
                ExternalProject externalProject = (ExternalProject)externalIncludedProjectsMap.get(project.getProjectIdentifier().getProjectPath());
                if (externalProject == null) continue;
                models.addModel((Object)externalProject, ExternalProject.class, project);
            }
        }
    }

    @NotNull
    private static Map<String, DefaultExternalProject> createExternalProjectsMap(@Nullable DefaultExternalProject rootExternalProject) {
        DefaultExternalProject externalProject;
        HashMap<String, DefaultExternalProject> externalProjectMap = new HashMap<String, DefaultExternalProject>();
        if (rootExternalProject == null) {
            HashMap<String, DefaultExternalProject> hashMap = externalProjectMap;
            if (hashMap == null) {
                GradleProjectResolver.$$$reportNull$$$0(26);
            }
            return hashMap;
        }
        ArrayDeque<Object> queue = new ArrayDeque<Object>();
        queue.add(rootExternalProject);
        while ((externalProject = (DefaultExternalProject)queue.pollFirst()) != null) {
            queue.addAll(externalProject.getChildProjects().values());
            externalProjectMap.put(externalProject.getQName(), externalProject);
        }
        HashMap<String, DefaultExternalProject> hashMap = externalProjectMap;
        if (hashMap == null) {
            GradleProjectResolver.$$$reportNull$$$0(27);
        }
        return hashMap;
    }

    private static void mergeSourceSetContentRoots(@NotNull Map<String, Pair<DataNode<ModuleData>, IdeaModule>> moduleMap, @NotNull ProjectResolverContext resolverCtx) {
        DataNode moduleNode;
        if (moduleMap == null) {
            GradleProjectResolver.$$$reportNull$$$0(28);
        }
        if (resolverCtx == null) {
            GradleProjectResolver.$$$reportNull$$$0(29);
        }
        Factory counterFactory = () -> new Counter();
        HashMap<String, Counter> weightMap = new HashMap<String, Counter>();
        for (Pair<DataNode<ModuleData>, IdeaModule> pair : moduleMap.values()) {
            moduleNode = (DataNode)pair.first;
            for (DataNode contentRootNode : ExternalSystemApiUtil.findAll((DataNode)moduleNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.CONTENT_ROOT)) {
                for (File file = new File(((ContentRootData)contentRootNode.getData()).getRootPath()); file != null; file = file.getParentFile()) {
                    ((Counter)ContainerUtil.getOrCreate(weightMap, (Object)file.getPath(), (Factory)counterFactory)).increment();
                }
            }
            for (DataNode sourceSetNode : ExternalSystemApiUtil.findAll((DataNode)moduleNode, GradleSourceSetData.KEY)) {
                HashSet<String> set = new HashSet<String>();
                for (DataNode contentRootNode : ExternalSystemApiUtil.findAll((DataNode)sourceSetNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.CONTENT_ROOT)) {
                    for (File file = new File(((ContentRootData)contentRootNode.getData()).getRootPath()); file != null; file = file.getParentFile()) {
                        set.add(file.getPath());
                    }
                }
                for (String path : set) {
                    ((Counter)ContainerUtil.getOrCreate(weightMap, (Object)path, (Factory)counterFactory)).increment();
                }
            }
        }
        for (Pair<DataNode<ModuleData>, IdeaModule> pair : moduleMap.values()) {
            moduleNode = (DataNode)pair.first;
            ExternalProject externalProject = resolverCtx.getExtraProject((IdeaModule)pair.second, ExternalProject.class);
            if (externalProject == null) continue;
            GradleProjectResolver.mergeModuleContentRoots(weightMap, externalProject, (DataNode<? extends ModuleData>)moduleNode);
            for (DataNode sourceSetNode : ExternalSystemApiUtil.findAll((DataNode)moduleNode, GradleSourceSetData.KEY)) {
                GradleProjectResolver.mergeModuleContentRoots(weightMap, externalProject, (DataNode<? extends ModuleData>)sourceSetNode);
            }
        }
    }

    private static void mergeModuleContentRoots(@NotNull Map<String, Counter> weightMap, @NotNull ExternalProject externalProject, @NotNull DataNode<? extends ModuleData> moduleNode) {
        if (weightMap == null) {
            GradleProjectResolver.$$$reportNull$$$0(30);
        }
        if (externalProject == null) {
            GradleProjectResolver.$$$reportNull$$$0(31);
        }
        if (moduleNode == null) {
            GradleProjectResolver.$$$reportNull$$$0(32);
        }
        File buildDir = externalProject.getBuildDir();
        MultiMap sourceSetRoots = MultiMap.create();
        Collection contentRootNodes = ExternalSystemApiUtil.findAll(moduleNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.CONTENT_ROOT);
        if (contentRootNodes.size() <= 1) {
            return;
        }
        for (DataNode contentRootNode : contentRootNodes) {
            File root = new File(((ContentRootData)contentRootNode.getData()).getRootPath());
            if (FileUtil.isAncestor((File)buildDir, (File)root, (boolean)true)) continue;
            while (weightMap.containsKey(root.getParent()) && weightMap.get((Object)root.getParent()).count <= 1) {
                root = root.getParentFile();
            }
            ContentRootData mergedContentRoot = null;
            String rootPath = ExternalSystemApiUtil.toCanonicalPath((String)root.getPath());
            HashSet paths = new HashSet(sourceSetRoots.keySet());
            for (String path : paths) {
                if (FileUtil.isAncestor((String)rootPath, (String)path, (boolean)true)) {
                    Collection values = sourceSetRoots.remove((Object)path);
                    if (values != null) {
                        sourceSetRoots.putValues((Object)rootPath, values);
                    }
                } else if (FileUtil.isAncestor((String)path, (String)rootPath, (boolean)false)) {
                    Collection contentRoots = sourceSetRoots.get((Object)path);
                    for (ContentRootData rootData : contentRoots) {
                        if (!StringUtil.equals((CharSequence)rootData.getRootPath(), (CharSequence)path)) continue;
                        mergedContentRoot = rootData;
                        break;
                    }
                    if (mergedContentRoot != null) break;
                    mergedContentRoot = (ContentRootData)contentRoots.iterator().next();
                    break;
                }
                if (sourceSetRoots.size() != 1) continue;
                break;
            }
            if (mergedContentRoot == null) {
                mergedContentRoot = new ContentRootData(GradleConstants.SYSTEM_ID, root.getPath());
                sourceSetRoots.putValue((Object)mergedContentRoot.getRootPath(), (Object)mergedContentRoot);
            }
            for (ExternalSystemSourceType externalSystemSourceType : ExternalSystemSourceType.values()) {
                ContentRootData rootData;
                rootData = ((ContentRootData)contentRootNode.getData()).getPaths(externalSystemSourceType).iterator();
                while (rootData.hasNext()) {
                    ContentRootData.SourceRoot sourceRoot = (ContentRootData.SourceRoot)rootData.next();
                    mergedContentRoot.storePath(externalSystemSourceType, sourceRoot.getPath(), sourceRoot.getPackagePrefix());
                }
            }
            contentRootNode.clear(true);
        }
        for (Map.Entry entry : sourceSetRoots.entrySet()) {
            String rootPath = (String)entry.getKey();
            ContentRootData ideContentRoot = new ContentRootData(GradleConstants.SYSTEM_ID, rootPath);
            for (ContentRootData rootData : (Collection)entry.getValue()) {
                for (ExternalSystemSourceType externalSystemSourceType : ExternalSystemSourceType.values()) {
                    Collection roots = rootData.getPaths(externalSystemSourceType);
                    for (ContentRootData.SourceRoot sourceRoot : roots) {
                        ideContentRoot.storePath(externalSystemSourceType, sourceRoot.getPath(), sourceRoot.getPackagePrefix());
                    }
                }
            }
            moduleNode.createChild(ProjectKeys.CONTENT_ROOT, (Object)ideContentRoot);
        }
    }

    private static Throwable extractCause(Throwable e) {
        if (e instanceof BuildActionFailureException) {
            return GradleProjectResolver.extractCause(e.getCause());
        }
        Class<?> exceptionClass = e.getClass();
        if (exceptionClass.getName().equals(ProjectConfigurationException.class.getName())) {
            try {
                List causes = (List)exceptionClass.getMethod("getCauses", new Class[0]).invoke((Object)e, new Object[0]);
                return (Throwable)causes.get(0);
            }
            catch (Throwable ignore) {
                return e;
            }
        }
        return e;
    }

    @ApiStatus.Experimental
    public static GradleProjectResolverExtension createProjectResolverChain() {
        return GradleProjectResolver.createProjectResolverChain(null, null);
    }

    @NotNull
    private static GradleProjectResolverExtension createProjectResolverChain(@Nullable DefaultProjectResolverContext resolverContext, @Nullable Predicate<? super GradleProjectResolverExtension> extensionsFilter) {
        GradleProjectResolverExtension firstResolver;
        Stream<Object> extensions = GradleProjectResolverUtil.createProjectResolvers(resolverContext);
        if (extensionsFilter != null) {
            extensions = extensions.filter(extensionsFilter.or(BaseResolverExtension.class::isInstance));
        }
        ArrayDeque deque = new ArrayDeque();
        extensions.forEachOrdered(extension -> {
            GradleProjectResolverExtension previous = (GradleProjectResolverExtension)deque.peekLast();
            if (previous != null) {
                previous.setNext((GradleProjectResolverExtension)extension);
                if (previous.getNext() != extension) {
                    throw new AssertionError((Object)("Illegal next resolver got, current resolver class is " + previous.getClass().getName()));
                }
            }
            deque.add(extension);
        });
        GradleProjectResolverExtension resolverExtension = firstResolver = (GradleProjectResolverExtension)deque.peekFirst();
        assert (resolverExtension != null);
        while (resolverExtension.getNext() != null) {
            resolverExtension = resolverExtension.getNext();
        }
        if (!(resolverExtension instanceof BaseResolverExtension)) {
            throw new AssertionError((Object)("Illegal last resolver got of class " + resolverExtension.getClass().getName()));
        }
        AbstractProjectResolverExtension chainWrapper = new AbstractProjectResolverExtension(){

            @Override
            @NotNull
            public ExternalSystemException getUserFriendlyError(@Nullable BuildEnvironment buildEnvironment, @NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
                if (error == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (projectPath == null) {
                    1.$$$reportNull$$$0(1);
                }
                ExternalSystemException friendlyError = super.getUserFriendlyError(buildEnvironment, error, projectPath, buildFilePath);
                ExternalSystemException externalSystemException = new BaseProjectImportErrorHandler().checkErrorsWithoutQuickFixes(buildEnvironment, error, projectPath, buildFilePath, friendlyError);
                if (externalSystemException == null) {
                    1.$$$reportNull$$$0(2);
                }
                return externalSystemException;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "error";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "projectPath";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getUserFriendlyError";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getUserFriendlyError";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        chainWrapper.setNext(firstResolver);
        AbstractProjectResolverExtension abstractProjectResolverExtension = chainWrapper;
        if (abstractProjectResolverExtension == null) {
            GradleProjectResolver.$$$reportNull$$$0(33);
        }
        return abstractProjectResolverExtension;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: 
            case 15: 
            case 19: 
            case 20: 
            case 26: 
            case 27: 
            case 33: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: 
            case 15: 
            case 19: 
            case 20: 
            case 26: 
            case 27: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncTaskId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: 
            case 9: 
            case 15: 
            case 19: 
            case 20: 
            case 26: 
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 7: 
            case 12: 
            case 16: 
            case 18: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolverCtx";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectResolverChain";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allModels";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionSettings";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracedResolverChain";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "performanceTrace";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDataNode";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleUserHomeDir";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleMap";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "weightMap";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProject";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelper";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveProjectInfo";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "convertData";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "exposeCompositeBuild";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createExternalProjectsMap";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectResolverChain";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveProjectInfo";
                break;
            }
            case 4: 
            case 9: 
            case 15: 
            case 19: 
            case 20: 
            case 26: 
            case 27: 
            case 33: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "cancelTask";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doResolveProjectInfo";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "convertData";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isCustomSerializationSupported";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "configureExecutionArgumentsAndVmOptions";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "mergeLibraryAndModuleDependencyData";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "extractExternalProjectModels";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "mergeSourceSetContentRoots";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "mergeModuleContentRoots";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 9: 
            case 15: 
            case 19: 
            case 20: 
            case 26: 
            case 27: 
            case 33: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private final class ProjectConnectionDataNodeFunction
    implements Function<ProjectConnection, DataNode<ProjectData>> {
        @NotNull
        private final GradleProjectResolverExtension myProjectResolverChain;
        private final boolean myIsBuildSrcProject;
        private final DefaultProjectResolverContext myResolverContext;

        private ProjectConnectionDataNodeFunction(@NotNull DefaultProjectResolverContext resolverContext, GradleProjectResolverExtension projectResolverChain, boolean isBuildSrcProject) {
            if (resolverContext == null) {
                ProjectConnectionDataNodeFunction.$$$reportNull$$$0(0);
            }
            if (projectResolverChain == null) {
                ProjectConnectionDataNodeFunction.$$$reportNull$$$0(1);
            }
            this.myResolverContext = resolverContext;
            this.myProjectResolverChain = projectResolverChain;
            this.myIsBuildSrcProject = isBuildSrcProject;
        }

        public DataNode<ProjectData> fun(ProjectConnection connection) {
            long activityId = this.myResolverContext.getExternalSystemTaskId().getId();
            try {
                GradleProjectResolver.this.myCancellationMap.putValue((Object)this.myResolverContext.getExternalSystemTaskId(), (Object)this.myResolverContext.getCancellationTokenSource());
                this.myResolverContext.setConnection(connection);
                DataNode<ProjectData> dataNode = GradleProjectResolver.this.doResolveProjectInfo(this.myResolverContext, this.myProjectResolverChain, this.myIsBuildSrcProject);
                return dataNode;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (RuntimeException e) {
                LOG.info("Gradle project resolve error", (Throwable)e);
                ExternalSystemException esException = (ExternalSystemException)((Object)ExceptionUtil.findCause((Throwable)e, ExternalSystemException.class));
                if (esException != null && esException != e) {
                    LOG.info("\nCaused by: " + esException.getOriginalReason());
                }
                ExternalSystemSyncActionsCollector.logError(null, (long)activityId, (Throwable)GradleProjectResolver.extractCause(e));
                ExternalSystemSyncActionsCollector.logSyncFinished(null, (long)activityId, (boolean)false);
                throw this.myProjectResolverChain.getUserFriendlyError(this.myResolverContext.getBuildEnvironment(), e, this.myResolverContext.getProjectPath(), null);
            }
            finally {
                GradleProjectResolver.this.myCancellationMap.remove((Object)this.myResolverContext.getExternalSystemTaskId(), (Object)this.myResolverContext.getCancellationTokenSource());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resolverContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "projectResolverChain";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver$ProjectConnectionDataNodeFunction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Counter {
        int count;

        private Counter() {
        }

        void increment() {
            ++this.count;
        }

        public String toString() {
            return String.valueOf(this.count);
        }
    }
}

