/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.io.usethesource.capsule.util.iterator;

import java.util.NoSuchElementException;
import org.gradle.internal.impldep.io.usethesource.capsule.util.iterator.SupplierIterator;

public class ArrayKeyValueSupplierIterator<K, V>
implements SupplierIterator<K, V> {
    final Object[] values;
    final int end;
    int currentIndex;
    V currentValue;

    public ArrayKeyValueSupplierIterator(Object[] values, int start, int end) {
        assert (start <= end && end <= values.length);
        assert ((end - start) % 2 == 0);
        this.values = values;
        this.end = end;
        this.currentIndex = start;
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex < this.end;
    }

    @Override
    public K next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Object currentKey = this.values[this.currentIndex++];
        this.currentValue = this.values[this.currentIndex++];
        return (K)currentKey;
    }

    @Override
    public V get() {
        return this.currentValue;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static <K, V> ArrayKeyValueSupplierIterator<K, V> of(Object[] array) {
        return new ArrayKeyValueSupplierIterator<K, V>(array, 0, array.length);
    }

    public static <K, V> ArrayKeyValueSupplierIterator<K, V> of(Object[] array, int start, int length) {
        return new ArrayKeyValueSupplierIterator<K, V>(array, start, start + length);
    }
}

