/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.osgi.repo;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.osgi.core.BundleCapability;
import org.gradle.internal.impldep.org.apache.ivy.osgi.core.BundleInfo;
import org.gradle.internal.impldep.org.apache.ivy.osgi.core.BundleInfoAdapter;
import org.gradle.internal.impldep.org.apache.ivy.osgi.core.ExecutionEnvironmentProfileProvider;
import org.gradle.internal.impldep.org.apache.ivy.osgi.core.OSGiManifestParser;
import org.gradle.internal.impldep.org.apache.ivy.util.Message;

public class RepoDescriptor {
    private final Map moduleByCapbilities = new HashMap();
    private final Set modules = new HashSet();
    private final ExecutionEnvironmentProfileProvider profileProvider;
    private final URI baseUri;

    public RepoDescriptor(URI baseUri, ExecutionEnvironmentProfileProvider profileProvider) {
        this.baseUri = baseUri;
        this.profileProvider = profileProvider;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public Set getModules() {
        return this.modules;
    }

    public Map getModuleByCapbilities() {
        return this.moduleByCapbilities;
    }

    public Set findModule(String requirement, String value) {
        Map modules = (Map)this.moduleByCapbilities.get(requirement);
        if (modules == null) {
            return null;
        }
        return (Set)modules.get(value);
    }

    public Set getCapabilityValues(String capabilityName) {
        Map modules = (Map)this.moduleByCapbilities.get(capabilityName);
        if (modules == null) {
            return null;
        }
        return modules.keySet();
    }

    public void add(String type, String value, ModuleDescriptor md) {
        HashSet<ModuleDescriptor> bundleReferences;
        this.modules.add(md);
        HashMap<String, HashSet<ModuleDescriptor>> map = (HashMap<String, HashSet<ModuleDescriptor>>)this.moduleByCapbilities.get(type);
        if (map == null) {
            map = new HashMap<String, HashSet<ModuleDescriptor>>();
            this.moduleByCapbilities.put(type, map);
        }
        if ((bundleReferences = (HashSet<ModuleDescriptor>)map.get(value)) == null) {
            bundleReferences = new HashSet<ModuleDescriptor>();
            map.put(value, bundleReferences);
        }
        if (!bundleReferences.add(md)) {
            Message.debug("Duplicate module in the repo " + this.baseUri + " for " + type + " " + value + ": " + md.getModuleRevisionId());
        }
    }

    public void addBundle(BundleInfo bundleInfo) {
        DefaultModuleDescriptor md = BundleInfoAdapter.toModuleDescriptor(OSGiManifestParser.getInstance(), this.baseUri, bundleInfo, this.profileProvider);
        this.add("bundle", bundleInfo.getSymbolicName(), md);
        Iterator itCapability = bundleInfo.getCapabilities().iterator();
        while (itCapability.hasNext()) {
            BundleCapability capability = (BundleCapability)itCapability.next();
            this.add(capability.getType(), capability.getName(), md);
        }
    }

    public String toString() {
        return this.modules.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.modules == null ? 0 : ((Object)this.modules).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepoDescriptor other = (RepoDescriptor)obj;
        return !(this.modules == null ? other.modules != null : !((Object)this.modules).equals(other.modules));
    }
}

