/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.visiting;

import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.filters.visiting.MethodVisitingFilter;
import com.intellij.rt.coverage.instrumentation.kotlin.KotlinUtils;
import org.jetbrains.coverage.gnu.trove.TIntHashSet;
import org.jetbrains.coverage.gnu.trove.TIntProcedure;
import org.jetbrains.coverage.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Label;

public class DeprecatedMethodFilter
extends MethodVisitingFilter {
    private boolean myShouldIgnoreMethod = false;
    private TIntHashSet myMethodLines;

    public boolean isApplicable(Instrumenter context, int access, String name, String desc, String signature, String[] exceptions) {
        return KotlinUtils.isKotlinClass(context);
    }

    public void visitLineNumber(int line, Label start) {
        if (this.myShouldIgnoreMethod && this.myContext.getLineData(line) == null) {
            if (this.myMethodLines == null) {
                this.myMethodLines = new TIntHashSet();
            }
            this.myMethodLines.add(line);
        }
        super.visitLineNumber(line, start);
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        AnnotationVisitor av = super.visitAnnotation(descriptor, visible);
        if (!"Lkotlin/Deprecated;".equals(descriptor)) {
            return av;
        }
        return new AnnotationVisitor(589824, av){

            public void visitEnum(String name, String descriptor, String value) {
                super.visitEnum(name, descriptor, value);
                if (!"Lkotlin/DeprecationLevel;".equals(descriptor)) {
                    return;
                }
                DeprecatedMethodFilter.this.myShouldIgnoreMethod = DeprecatedMethodFilter.this.myShouldIgnoreMethod | ("ERROR".equals(value) || "HIDDEN".equals(value));
            }
        };
    }

    public void visitEnd() {
        super.visitEnd();
        if (!this.myShouldIgnoreMethod || this.myMethodLines == null) {
            return;
        }
        this.myMethodLines.forEach(new TIntProcedure(){

            public boolean execute(int line) {
                DeprecatedMethodFilter.this.myContext.removeLine(line);
                return true;
            }
        });
    }
}

