/*
 * Decompiled with CFR 0.152.
 */
package com.android.draw9patch.ui;

import com.android.draw9patch.ui.MainFrame;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

class ImageTransferHandler
extends TransferHandler {
    private final MainFrame mainFrame;

    ImageTransferHandler(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    @Override
    public boolean importData(JComponent component, Transferable transferable) {
        try {
            for (DataFlavor flavor : transferable.getTransferDataFlavors()) {
                if (flavor.isFlavorJavaFileListType()) {
                    Object data = transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    File file = (File)((List)data).get(0);
                    this.mainFrame.open(file).execute();
                    return true;
                }
                if (!flavor.isFlavorTextType() || flavor.getRepresentationClass() != String.class) continue;
                String mime = flavor.getMimeType();
                DataFlavor flave = new DataFlavor(mime);
                Object data = transferable.getTransferData(flave);
                String path2 = ImageTransferHandler.convertPath(data.toString());
                this.mainFrame.open(new File(path2)).execute();
                return true;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (MalformedURLException e10) {
            e10.printStackTrace();
        }
        catch (IOException e11) {
            e11.printStackTrace();
        }
        catch (Exception e12) {
            e12.printStackTrace();
        }
        return false;
    }

    private static String convertPath(String path2) {
        if (path2.startsWith("file://")) {
            path2 = path2.substring("file://".length());
        }
        if (path2.indexOf(10) != -1) {
            path2 = path2.substring(0, path2.indexOf(10));
        }
        if (path2.indexOf(13) != -1) {
            path2 = path2.substring(0, path2.indexOf(13));
        }
        return path2;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        boolean isCopySupported;
        boolean bl2 = isCopySupported = (1 & support.getSourceDropActions()) == 1;
        if (!isCopySupported) {
            return false;
        }
        for (DataFlavor flavor : support.getDataFlavors()) {
            if (!flavor.isFlavorJavaFileListType() && !flavor.isFlavorTextType()) continue;
            support.setDropAction(1);
            return true;
        }
        return false;
    }
}

